/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.spec.schema;

import edu.psu.swe.scim.spec.schema.AttributeContainer;
import edu.psu.swe.scim.spec.schema.Meta;
import edu.psu.swe.scim.spec.validator.Urn;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="schema")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Schema
implements AttributeContainer {
    private static final Logger LOG = LoggerFactory.getLogger(Schema.class);
    public static final String RESOURCE_NAME = "Schema";
    public static final String SCHEMA_URI = "urn:ietf:params:scim:schemas:core:2.0:Schema";
    @Urn
    @NotNull
    @Size(min=1, max=65535)
    @XmlElement
    String id;
    @XmlElement
    String name;
    @XmlElement
    String description;
    @Size(min=1, max=65535)
    @XmlElement
    @XmlElementWrapper(name="attributes")
    List<Attribute> attributes;
    Map<String, Attribute> attributeNamesMap = new HashMap<String, Attribute>();
    @XmlElement
    Meta meta;

    @Override
    public List<Attribute> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributeNamesMap.clear();
        for (Attribute attribute : attributes) {
            String name = attribute.getName();
            if (name == null) {
                LOG.warn("Attribute name was null, skipping name indexing");
                continue;
            }
            this.attributeNamesMap.put(name.toLowerCase(), attribute);
        }
        this.attributes = attributes;
    }

    @Override
    public Attribute getAttribute(String name) {
        if (name == null) {
            return null;
        }
        return this.attributeNamesMap.get(name.toLowerCase());
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Schema)) {
            return false;
        }
        Schema other = (Schema)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<Attribute> this$attributes = this.getAttributes();
        List<Attribute> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        Map<String, Attribute> this$attributeNamesMap = this.attributeNamesMap;
        Map<String, Attribute> other$attributeNamesMap = other.attributeNamesMap;
        if (this$attributeNamesMap == null ? other$attributeNamesMap != null : !((Object)this$attributeNamesMap).equals(other$attributeNamesMap)) {
            return false;
        }
        Meta this$meta = this.getMeta();
        Meta other$meta = other.getMeta();
        return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Schema;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<Attribute> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        Map<String, Attribute> $attributeNamesMap = this.attributeNamesMap;
        result = result * 59 + ($attributeNamesMap == null ? 43 : ((Object)$attributeNamesMap).hashCode());
        Meta $meta = this.getMeta();
        result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
        return result;
    }

    public String toString() {
        return "Schema(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", attributes=" + this.getAttributes() + ", attributeNamesMap=" + this.attributeNamesMap + ", meta=" + this.getMeta() + ")";
    }

    @XmlType(name="attribute")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class Attribute
    implements AttributeContainer {
        @XmlElement
        @Pattern(regexp="\\p{Alpha}(-|_|\\p{Alnum})*")
        String name;
        @XmlElement
        Type type;
        @XmlElement
        List<Attribute> subAttributes;
        Map<String, Attribute> subAttributeNamesMap = new HashMap<String, Attribute>();
        @XmlElement
        boolean multiValued;
        @XmlElement
        String description;
        @XmlElement
        boolean required;
        @XmlElement
        Set<String> canonicalValues;
        @XmlElement
        boolean caseExact;
        @XmlElement
        Mutability mutability;
        @XmlElement
        Returned returned;
        @XmlElement
        Uniqueness uniqueness;
        @XmlElement
        List<String> referenceTypes;
        Field field;
        private boolean scimResourceIdReference;

        @Override
        public List<Attribute> getAttributes() {
            return Collections.unmodifiableList(this.subAttributes);
        }

        public void setSubAttributes(List<Attribute> attributes, AddAction action) {
            if (action.equals((Object)AddAction.REPLACE)) {
                this.subAttributeNamesMap.clear();
            }
            for (Attribute attribute : attributes) {
                String name = attribute.getName();
                if (name == null) {
                    LOG.warn("Attribute name was null, skipping name indexing");
                    continue;
                }
                this.subAttributeNamesMap.put(name.toLowerCase(), attribute);
            }
            if (action.equals((Object)AddAction.REPLACE)) {
                this.subAttributes = attributes;
            } else {
                if (this.subAttributes == null) {
                    this.subAttributes = new ArrayList<Attribute>();
                }
                this.subAttributes.addAll(attributes);
            }
        }

        @Override
        public Attribute getAttribute(String name) {
            if (name == null) {
                return null;
            }
            return this.subAttributeNamesMap.get(name.toLowerCase());
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        public List<Attribute> getSubAttributes() {
            return this.subAttributes;
        }

        public boolean isMultiValued() {
            return this.multiValued;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isRequired() {
            return this.required;
        }

        public Set<String> getCanonicalValues() {
            return this.canonicalValues;
        }

        public boolean isCaseExact() {
            return this.caseExact;
        }

        public Mutability getMutability() {
            return this.mutability;
        }

        public Returned getReturned() {
            return this.returned;
        }

        public Uniqueness getUniqueness() {
            return this.uniqueness;
        }

        public List<String> getReferenceTypes() {
            return this.referenceTypes;
        }

        public Field getField() {
            return this.field;
        }

        public boolean isScimResourceIdReference() {
            return this.scimResourceIdReference;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public void setSubAttributes(List<Attribute> subAttributes) {
            this.subAttributes = subAttributes;
        }

        public void setMultiValued(boolean multiValued) {
            this.multiValued = multiValued;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        public void setCanonicalValues(Set<String> canonicalValues) {
            this.canonicalValues = canonicalValues;
        }

        public void setCaseExact(boolean caseExact) {
            this.caseExact = caseExact;
        }

        public void setMutability(Mutability mutability) {
            this.mutability = mutability;
        }

        public void setReturned(Returned returned) {
            this.returned = returned;
        }

        public void setUniqueness(Uniqueness uniqueness) {
            this.uniqueness = uniqueness;
        }

        public void setReferenceTypes(List<String> referenceTypes) {
            this.referenceTypes = referenceTypes;
        }

        public void setField(Field field) {
            this.field = field;
        }

        public void setScimResourceIdReference(boolean scimResourceIdReference) {
            this.scimResourceIdReference = scimResourceIdReference;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Attribute)) {
                return false;
            }
            Attribute other = (Attribute)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Type this$type = this.getType();
            Type other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            List<Attribute> this$subAttributes = this.getSubAttributes();
            List<Attribute> other$subAttributes = other.getSubAttributes();
            if (this$subAttributes == null ? other$subAttributes != null : !((Object)this$subAttributes).equals(other$subAttributes)) {
                return false;
            }
            Map<String, Attribute> this$subAttributeNamesMap = this.subAttributeNamesMap;
            Map<String, Attribute> other$subAttributeNamesMap = other.subAttributeNamesMap;
            if (this$subAttributeNamesMap == null ? other$subAttributeNamesMap != null : !((Object)this$subAttributeNamesMap).equals(other$subAttributeNamesMap)) {
                return false;
            }
            if (this.isMultiValued() != other.isMultiValued()) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            if (this.isRequired() != other.isRequired()) {
                return false;
            }
            Set<String> this$canonicalValues = this.getCanonicalValues();
            Set<String> other$canonicalValues = other.getCanonicalValues();
            if (this$canonicalValues == null ? other$canonicalValues != null : !((Object)this$canonicalValues).equals(other$canonicalValues)) {
                return false;
            }
            if (this.isCaseExact() != other.isCaseExact()) {
                return false;
            }
            Mutability this$mutability = this.getMutability();
            Mutability other$mutability = other.getMutability();
            if (this$mutability == null ? other$mutability != null : !((Object)((Object)this$mutability)).equals((Object)other$mutability)) {
                return false;
            }
            Returned this$returned = this.getReturned();
            Returned other$returned = other.getReturned();
            if (this$returned == null ? other$returned != null : !((Object)((Object)this$returned)).equals((Object)other$returned)) {
                return false;
            }
            Uniqueness this$uniqueness = this.getUniqueness();
            Uniqueness other$uniqueness = other.getUniqueness();
            if (this$uniqueness == null ? other$uniqueness != null : !((Object)((Object)this$uniqueness)).equals((Object)other$uniqueness)) {
                return false;
            }
            List<String> this$referenceTypes = this.getReferenceTypes();
            List<String> other$referenceTypes = other.getReferenceTypes();
            if (this$referenceTypes == null ? other$referenceTypes != null : !((Object)this$referenceTypes).equals(other$referenceTypes)) {
                return false;
            }
            Field this$field = this.getField();
            Field other$field = other.getField();
            if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
                return false;
            }
            return this.isScimResourceIdReference() == other.isScimResourceIdReference();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Attribute;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            List<Attribute> $subAttributes = this.getSubAttributes();
            result = result * 59 + ($subAttributes == null ? 43 : ((Object)$subAttributes).hashCode());
            Map<String, Attribute> $subAttributeNamesMap = this.subAttributeNamesMap;
            result = result * 59 + ($subAttributeNamesMap == null ? 43 : ((Object)$subAttributeNamesMap).hashCode());
            result = result * 59 + (this.isMultiValued() ? 79 : 97);
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            result = result * 59 + (this.isRequired() ? 79 : 97);
            Set<String> $canonicalValues = this.getCanonicalValues();
            result = result * 59 + ($canonicalValues == null ? 43 : ((Object)$canonicalValues).hashCode());
            result = result * 59 + (this.isCaseExact() ? 79 : 97);
            Mutability $mutability = this.getMutability();
            result = result * 59 + ($mutability == null ? 43 : ((Object)((Object)$mutability)).hashCode());
            Returned $returned = this.getReturned();
            result = result * 59 + ($returned == null ? 43 : ((Object)((Object)$returned)).hashCode());
            Uniqueness $uniqueness = this.getUniqueness();
            result = result * 59 + ($uniqueness == null ? 43 : ((Object)((Object)$uniqueness)).hashCode());
            List<String> $referenceTypes = this.getReferenceTypes();
            result = result * 59 + ($referenceTypes == null ? 43 : ((Object)$referenceTypes).hashCode());
            Field $field = this.getField();
            result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
            result = result * 59 + (this.isScimResourceIdReference() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "Schema.Attribute(name=" + this.getName() + ", type=" + (Object)((Object)this.getType()) + ", subAttributes=" + this.getSubAttributes() + ", subAttributeNamesMap=" + this.subAttributeNamesMap + ", multiValued=" + this.isMultiValued() + ", description=" + this.getDescription() + ", required=" + this.isRequired() + ", canonicalValues=" + this.getCanonicalValues() + ", caseExact=" + this.isCaseExact() + ", mutability=" + (Object)((Object)this.getMutability()) + ", returned=" + (Object)((Object)this.getReturned()) + ", uniqueness=" + (Object)((Object)this.getUniqueness()) + ", referenceTypes=" + this.getReferenceTypes() + ", field=" + this.getField() + ", scimResourceIdReference=" + this.isScimResourceIdReference() + ")";
        }

        public static enum AddAction {
            REPLACE,
            APPEND;

        }

        public static enum Uniqueness {
            GLOBAL,
            NONE,
            SERVER;

        }

        @XmlEnum(value=String.class)
        public static enum Type {
            BINARY,
            BOOLEAN,
            COMPLEX,
            DATE_TIME,
            DECIMAL,
            INTEGER,
            REFERENCE,
            STRING;

        }

        public static enum Returned {
            ALWAYS,
            DEFAULT,
            NEVER,
            REQUEST;

        }

        public static enum Mutability {
            IMMUTABLE,
            READ_ONLY,
            READ_WRITE,
            WRITE_ONLY;

        }
    }
}

