/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client;

import io.github.jeremylong.openvulnerability.client.PagedDataSource;
import java.time.ZonedDateTime;
import java.util.Iterator;

public class RecordDataSource<T>
implements AutoCloseable,
Iterator<T> {
    private final PagedDataSource<T> source;
    private Iterator<T> current;

    public RecordDataSource(PagedDataSource<T> source) {
        this.source = source;
    }

    @Override
    public void close() throws Exception {
        this.source.close();
    }

    public ZonedDateTime getLastUpdated() {
        return this.source.getLastUpdated();
    }

    public int getLastStatusCode() {
        return this.source.getLastStatusCode();
    }

    @Override
    public boolean hasNext() {
        return this.source.hasNext() || this.current != null && this.current.hasNext();
    }

    @Override
    public T next() {
        Object collection;
        if ((this.current == null || !this.current.hasNext()) && this.source.hasNext() && (collection = this.source.next()) != null) {
            this.current = collection.iterator();
        }
        if (this.current.hasNext()) {
            return this.current.next();
        }
        return null;
    }
}

