/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.hc.client5.http.cache.HttpCacheCASOperation;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.HttpCacheStorage;
import org.apache.hc.client5.http.cache.HttpCacheStorageEntry;
import org.apache.hc.client5.http.cache.ResourceIOException;
import org.apache.hc.client5.http.impl.cache.HttpByteArrayCacheEntrySerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForcedDiskCacheStorage
implements HttpCacheStorage {
    private final Path storageDirectory;
    private final Duration timeToLive;
    private final HttpByteArrayCacheEntrySerializer serializer;
    public static final Duration DEFAULT_TTL = Duration.ofHours(20L);
    private static final Logger LOG = LoggerFactory.getLogger(ForcedDiskCacheStorage.class);

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Constructor may legitimately throw exception")
    public ForcedDiskCacheStorage(String storagePath) throws IOException {
        this(storagePath, DEFAULT_TTL);
    }

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Constructor may legitimately throw exception")
    public ForcedDiskCacheStorage(String storagePath, Duration timeToLive) throws IOException {
        this.storageDirectory = Paths.get(storagePath, new String[0]);
        this.timeToLive = timeToLive;
        this.serializer = new HttpByteArrayCacheEntrySerializer();
        Files.createDirectories(this.storageDirectory, new FileAttribute[0]);
    }

    public void putEntry(String key, HttpCacheEntry entry) throws ResourceIOException {
        Path filePath = this.storageDirectory.resolve(this.sanitizeKey(key));
        HttpCacheStorageEntry storageEntry = new HttpCacheStorageEntry(key, entry);
        byte[] serialized = this.serializer.serialize(storageEntry);
        try {
            Files.write(filePath, serialized, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ResourceIOException("Failed to write cache entry", (Throwable)e);
        }
    }

    public HttpCacheEntry getEntry(String key) throws ResourceIOException {
        Path filePath = this.storageDirectory.resolve(this.sanitizeKey(key));
        if (!Files.exists(filePath, new LinkOption[0])) {
            LOG.debug("Cache miss `{}`", (Object)filePath.getFileName());
            return null;
        }
        try {
            byte[] data = Files.readAllBytes(filePath);
            HttpCacheStorageEntry entry = this.serializer.deserialize(data);
            if (this.isFresh(entry.getContent())) {
                LOG.debug("Cache hit `{}`", (Object)filePath.getFileName());
                return entry.getContent();
            }
            LOG.debug("Cache entry stale `{}`", (Object)filePath.getFileName());
            this.removeEntry(key);
            return null;
        }
        catch (IOException e) {
            LOG.debug("Failed to read cache entry: " + e.getMessage());
            return null;
        }
    }

    public void removeEntry(String key) throws ResourceIOException {
        Path filePath = this.storageDirectory.resolve(this.sanitizeKey(key));
        try {
            Files.deleteIfExists(filePath);
        }
        catch (IOException e) {
            throw new ResourceIOException("Failed to delete cache entry", (Throwable)e);
        }
    }

    public void updateEntry(String key, HttpCacheCASOperation casOperation) throws ResourceIOException {
        HttpCacheEntry existing = this.getEntry(key);
        HttpCacheEntry updated = casOperation.execute(existing);
        if (updated != null) {
            this.putEntry(key, updated);
        } else {
            this.removeEntry(key);
        }
    }

    public Map<String, HttpCacheEntry> getEntries(Collection<String> keys) throws ResourceIOException {
        HashMap<String, HttpCacheEntry> entries = new HashMap<String, HttpCacheEntry>();
        for (String key : keys) {
            HttpCacheEntry entry = this.getEntry(key);
            if (entry == null) continue;
            entries.put(key, entry);
        }
        return entries;
    }

    private boolean isFresh(HttpCacheEntry entry) {
        return entry.getRequestInstant().plus(this.timeToLive).isAfter(Instant.now());
    }

    private String sanitizeKey(String key) {
        return key.replaceAll("[^a-zA-Z0-9._-]", "_");
    }
}

