/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client.nvd;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.jeremylong.openvulnerability.client.nvd.CvssV2Data;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"source", "type", "cvssData", "baseSeverity", "exploitabilityScore", "impactScore", "acInsufInfo", "obtainAllPrivilege", "obtainUserPrivilege", "obtainOtherPrivilege", "userInteractionRequired"})
@NullMarked
public class CvssV2
implements Serializable {
    private static final long serialVersionUID = 7595837336051753457L;
    @JsonProperty(value="source")
    private String source;
    @JsonProperty(value="type")
    private Type type;
    @JsonProperty(value="cvssData")
    private CvssV2Data cvssData;
    @JsonProperty(value="baseSeverity")
    private @Nullable String baseSeverity;
    @JsonProperty(value="exploitabilityScore")
    @JsonPropertyDescription(value="CVSS subscore.")
    private @Nullable Double exploitabilityScore;
    @JsonProperty(value="impactScore")
    @JsonPropertyDescription(value="CVSS subscore.")
    private @Nullable Double impactScore;
    @JsonProperty(value="acInsufInfo")
    private @Nullable Boolean acInsufInfo;
    @JsonProperty(value="obtainAllPrivilege")
    private @Nullable Boolean obtainAllPrivilege;
    @JsonProperty(value="obtainUserPrivilege")
    private @Nullable Boolean obtainUserPrivilege;
    @JsonProperty(value="obtainOtherPrivilege")
    private @Nullable Boolean obtainOtherPrivilege;
    @JsonProperty(value="userInteractionRequired")
    private @Nullable Boolean userInteractionRequired;

    @JsonCreator
    public CvssV2(@JsonProperty(value="source") String source, @JsonProperty(value="type") Type type, @JsonProperty(value="cvssData") CvssV2Data cvssData) {
        this.source = source;
        this.type = type;
        this.cvssData = cvssData;
    }

    public CvssV2(String source, Type type, CvssV2Data cvssData, @Nullable String baseSeverity, @Nullable Double exploitabilityScore, @Nullable Double impactScore, @Nullable Boolean acInsufInfo, @Nullable Boolean obtainAllPrivilege, @Nullable Boolean obtainUserPrivilege, @Nullable Boolean obtainOtherPrivilege, @Nullable Boolean userInteractionRequired) {
        this(source, type, cvssData);
        this.baseSeverity = baseSeverity;
        this.exploitabilityScore = exploitabilityScore;
        this.impactScore = impactScore;
        this.acInsufInfo = acInsufInfo;
        this.obtainAllPrivilege = obtainAllPrivilege;
        this.obtainUserPrivilege = obtainUserPrivilege;
        this.obtainOtherPrivilege = obtainOtherPrivilege;
        this.userInteractionRequired = userInteractionRequired;
    }

    @JsonProperty(value="source")
    public String getSource() {
        return this.source;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="cvssData")
    public CvssV2Data getCvssData() {
        return this.cvssData;
    }

    @JsonProperty(value="baseSeverity")
    public @Nullable String getBaseSeverity() {
        return this.baseSeverity;
    }

    @JsonProperty(value="exploitabilityScore")
    public @Nullable Double getExploitabilityScore() {
        return this.exploitabilityScore;
    }

    @JsonProperty(value="impactScore")
    public @Nullable Double getImpactScore() {
        return this.impactScore;
    }

    @JsonProperty(value="acInsufInfo")
    public @Nullable Boolean getAcInsufInfo() {
        return this.acInsufInfo;
    }

    @JsonProperty(value="obtainAllPrivilege")
    public @Nullable Boolean getObtainAllPrivilege() {
        return this.obtainAllPrivilege;
    }

    @JsonProperty(value="obtainUserPrivilege")
    public @Nullable Boolean getObtainUserPrivilege() {
        return this.obtainUserPrivilege;
    }

    @JsonProperty(value="obtainOtherPrivilege")
    public @Nullable Boolean getObtainOtherPrivilege() {
        return this.obtainOtherPrivilege;
    }

    @JsonProperty(value="userInteractionRequired")
    public @Nullable Boolean getUserInteractionRequired() {
        return this.userInteractionRequired;
    }

    public String toString() {
        return this.cvssData.getVectorString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CvssV2 cvssV2 = (CvssV2)o;
        return Objects.equals(this.source, cvssV2.source) && this.type == cvssV2.type && Objects.equals(this.cvssData, cvssV2.cvssData) && Objects.equals(this.baseSeverity, cvssV2.baseSeverity) && Objects.equals(this.exploitabilityScore, cvssV2.exploitabilityScore) && Objects.equals(this.impactScore, cvssV2.impactScore) && Objects.equals(this.acInsufInfo, cvssV2.acInsufInfo) && Objects.equals(this.obtainAllPrivilege, cvssV2.obtainAllPrivilege) && Objects.equals(this.obtainUserPrivilege, cvssV2.obtainUserPrivilege) && Objects.equals(this.obtainOtherPrivilege, cvssV2.obtainOtherPrivilege) && Objects.equals(this.userInteractionRequired, cvssV2.userInteractionRequired);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.source, this.type, this.cvssData, this.baseSeverity, this.exploitabilityScore, this.impactScore, this.acInsufInfo, this.obtainAllPrivilege, this.obtainUserPrivilege, this.obtainOtherPrivilege, this.userInteractionRequired});
    }

    public static enum Type {
        PRIMARY("Primary"),
        SECONDARY("Secondary");

        private static final Map<String, Type> CONSTANTS;
        private final String value;

        private Type(String value) {
            this.value = value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

