/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.cli;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.internal.CompositeConfig;
import io.gitlab.arturbosch.detekt.api.internal.DisabledAutoCorrectConfig;
import io.gitlab.arturbosch.detekt.api.internal.FailFastConfig;
import io.gitlab.arturbosch.detekt.api.internal.PathFilters;
import io.gitlab.arturbosch.detekt.api.internal.YamlConfig;
import io.gitlab.arturbosch.detekt.cli.ClasspathResourceConverter;
import io.gitlab.arturbosch.detekt.cli.CliArgs;
import io.gitlab.arturbosch.detekt.cli.ConfigurationsKt;
import io.gitlab.arturbosch.detekt.cli.MultipleClasspathResourceConverter;
import io.gitlab.arturbosch.detekt.cli.MultipleExistingPathConverter;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b*\u00020\t\u001a\f\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\t\u001a\u0010\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b*\u00020\t\u001a\u0010\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\t\u001a9\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00120\b\"\u0004\b\u0000\u0010\u0012*\u0004\u0018\u00010\u00012\u001d\u0010\u0013\u001a\u0019\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00120\b0\u0014\u00a2\u0006\u0002\b\u0015H\u0002\u001a\n\u0010\u0016\u001a\u00020\u0003*\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"DEFAULT_CONFIG", "", "loadDefaultConfig", "Lio/gitlab/arturbosch/detekt/api/Config;", "parsePathConfig", "configPath", "parseResourceConfig", "createClasspath", "", "Lio/gitlab/arturbosch/detekt/cli/CliArgs;", "createFilters", "Lio/gitlab/arturbosch/detekt/api/internal/PathFilters;", "createPlugins", "Ljava/nio/file/Path;", "extractUris", "", "Ljava/net/URI;", "letIfNonEmpty", "T", "init", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "loadConfiguration", "detekt-cli"})
public final class ConfigurationsKt {
    @NotNull
    public static final String DEFAULT_CONFIG = "default-detekt-config.yml";

    @Nullable
    public static final PathFilters createFilters(@NotNull CliArgs $this$createFilters) {
        Intrinsics.checkParameterIsNotNull((Object)$this$createFilters, (String)"$this$createFilters");
        return PathFilters.Companion.of($this$createFilters.getIncludes(), $this$createFilters.getExcludes());
    }

    @NotNull
    public static final List<Path> createPlugins(@NotNull CliArgs $this$createPlugins) {
        Intrinsics.checkParameterIsNotNull((Object)$this$createPlugins, (String)"$this$createPlugins");
        return ConfigurationsKt.letIfNonEmpty($this$createPlugins.getPlugins(), createPlugins.1.INSTANCE);
    }

    @NotNull
    public static final List<String> createClasspath(@NotNull CliArgs $this$createClasspath) {
        Intrinsics.checkParameterIsNotNull((Object)$this$createClasspath, (String)"$this$createClasspath");
        return ConfigurationsKt.letIfNonEmpty($this$createClasspath.getClasspath(), createClasspath.1.INSTANCE);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final <T> List<T> letIfNonEmpty(@Nullable String $this$letIfNonEmpty, Function1<? super String, ? extends List<? extends T>> init) {
        List list;
        if ($this$letIfNonEmpty != null) {
            CharSequence charSequence = $this$letIfNonEmpty;
            boolean bl = false;
            if (!(charSequence.length() == 0)) {
                list = (List)init.invoke((Object)$this$letIfNonEmpty);
                return list;
            }
        }
        boolean bl = false;
        list = CollectionsKt.emptyList();
        return list;
    }

    @NotNull
    public static final Config loadConfiguration(@NotNull CliArgs $this$loadConfiguration) {
        Config config;
        Config config2;
        Intrinsics.checkParameterIsNotNull((Object)$this$loadConfiguration, (String)"$this$loadConfiguration");
        CharSequence charSequence = $this$loadConfiguration.getConfig();
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            String string = $this$loadConfiguration.getConfig();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            config2 = ConfigurationsKt.parsePathConfig(string);
        } else {
            charSequence = $this$loadConfiguration.getConfigResource();
            bl = false;
            bl2 = false;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                String string = $this$loadConfiguration.getConfigResource();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                config2 = ConfigurationsKt.parseResourceConfig(string);
            } else {
                config2 = null;
            }
        }
        Config declaredConfig = config2;
        Config defaultConfig = null;
        if ($this$loadConfiguration.getBuildUponDefaultConfig()) {
            defaultConfig = ConfigurationsKt.loadDefaultConfig();
            Config config3 = declaredConfig;
            if (config3 == null) {
                config3 = defaultConfig;
            }
            declaredConfig = (Config)new CompositeConfig(config3, defaultConfig);
        }
        if ($this$loadConfiguration.getFailFast()) {
            Config config4;
            Config initializedDefaultConfig;
            Config config5 = defaultConfig;
            if (config5 == null) {
                config5 = initializedDefaultConfig = ConfigurationsKt.loadDefaultConfig();
            }
            if ((config4 = declaredConfig) == null) {
                config4 = initializedDefaultConfig;
            }
            declaredConfig = (Config)new FailFastConfig(config4, initializedDefaultConfig);
        }
        if (!$this$loadConfiguration.getAutoCorrect()) {
            Config config6 = declaredConfig;
            if (config6 == null) {
                config6 = ConfigurationsKt.loadDefaultConfig();
            }
            declaredConfig = (Config)new DisabledAutoCorrectConfig(config6);
        }
        if ((config = declaredConfig) == null) {
            config = ConfigurationsKt.loadDefaultConfig();
        }
        return config;
    }

    /*
     * WARNING - void declaration
     */
    private static final Config parseResourceConfig(String configPath) {
        Config config;
        Object urls = new MultipleClasspathResourceConverter().convert(configPath);
        if (urls.size() == 1) {
            config = YamlConfig.Companion.loadResource((URL)urls.get(0));
        } else {
            Sequence $this$reduce$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)urls)), (Function1)parseResourceConfig.1.INSTANCE);
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw (Throwable)new UnsupportedOperationException("Empty sequence can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void config2;
                Config config3 = (Config)iterator$iv.next();
                Config composite = (Config)accumulator$iv;
                boolean bl = false;
                accumulator$iv = new CompositeConfig((Config)config2, composite);
            }
            config = (Config)accumulator$iv;
        }
        return config;
    }

    /*
     * WARNING - void declaration
     */
    private static final Config parsePathConfig(String configPath) {
        Config config;
        Object paths = new MultipleExistingPathConverter().convert(configPath);
        if (paths.size() == 1) {
            config = YamlConfig.Companion.load((Path)paths.get(0));
        } else {
            Sequence $this$reduce$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)paths)), (Function1)parsePathConfig.1.INSTANCE);
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw (Throwable)new UnsupportedOperationException("Empty sequence can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void config2;
                Config config3 = (Config)iterator$iv.next();
                Config composite = (Config)accumulator$iv;
                boolean bl = false;
                accumulator$iv = new CompositeConfig((Config)config2, composite);
            }
            config = (Config)accumulator$iv;
        }
        return config;
    }

    @NotNull
    public static final Config loadDefaultConfig() {
        return YamlConfig.Companion.loadResource(new ClasspathResourceConverter().convert(DEFAULT_CONFIG));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<URI> extractUris(@NotNull CliArgs $this$extractUris) {
        List list;
        List list2;
        Object object;
        Iterable destination$iv$iv;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$this$extractUris, (String)"$this$extractUris");
        String string = $this$extractUris.getConfig();
        if (string != null) {
            void $this$mapTo$iv$iv;
            String string2 = string;
            boolean bl2 = false;
            bl = false;
            String it = string2;
            boolean bl3 = false;
            Iterable $this$map$iv = (Iterable)new MultipleExistingPathConverter().convert(it);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p1;
                Path path = (Path)item$iv$iv;
                object = destination$iv$iv;
                boolean bl4 = false;
                URI uRI = p1.toUri();
                object.add(uRI);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List pathUris = list2;
        String string3 = $this$extractUris.getConfigResource();
        if (string3 != null) {
            void $this$mapTo$iv$iv;
            String string4 = string3;
            bl = false;
            boolean bl5 = false;
            String it = string4;
            boolean bl6 = false;
            Iterable $this$map$iv = (Iterable)new MultipleClasspathResourceConverter().convert(it);
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p1;
                object = (URL)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl7 = false;
                URI uRI = p1.toURI();
                collection.add(uRI);
            }
            list = (List)destination$iv$iv2;
        } else {
            list = CollectionsKt.emptyList();
        }
        List resourceUris = list;
        return CollectionsKt.plus((Collection)resourceUris, (Iterable)pathUris);
    }
}

