/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.baseline;

import io.gitlab.arturbosch.detekt.core.JunkKt;
import io.gitlab.arturbosch.detekt.core.baseline.BaselineFormat;
import java.nio.file.Path;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B)\u0012\u0010\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u000b\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005H\u00c6\u0003J\u0013\u0010\f\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005H\u00c6\u0003J\u0012\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0004j\u0002`\u0010J1\u0010\u0011\u001a\u00020\u00002\u0012\b\u0002\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u00052\u0012\b\u0002\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0004H\u00d6\u0001R\u001b\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0018"}, d2={"Lio/gitlab/arturbosch/detekt/core/baseline/Baseline;", "", "manuallySuppressedIssues", "", "", "Lio/gitlab/arturbosch/detekt/core/baseline/FindingsIdList;", "currentIssues", "(Ljava/util/Set;Ljava/util/Set;)V", "getCurrentIssues", "()Ljava/util/Set;", "getManuallySuppressedIssues", "component1", "component2", "contains", "", "id", "Lio/gitlab/arturbosch/detekt/core/baseline/FindingId;", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "detekt-core"})
public final class Baseline {
    @NotNull
    private final Set<String> manuallySuppressedIssues;
    @NotNull
    private final Set<String> currentIssues;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final boolean contains(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.currentIssues.contains(id) || this.manuallySuppressedIssues.contains(id);
    }

    @NotNull
    public final Set<String> getManuallySuppressedIssues() {
        return this.manuallySuppressedIssues;
    }

    @NotNull
    public final Set<String> getCurrentIssues() {
        return this.currentIssues;
    }

    public Baseline(@NotNull Set<String> manuallySuppressedIssues, @NotNull Set<String> currentIssues) {
        Intrinsics.checkNotNullParameter(manuallySuppressedIssues, (String)"manuallySuppressedIssues");
        Intrinsics.checkNotNullParameter(currentIssues, (String)"currentIssues");
        this.manuallySuppressedIssues = manuallySuppressedIssues;
        this.currentIssues = currentIssues;
    }

    @NotNull
    public final Set<String> component1() {
        return this.manuallySuppressedIssues;
    }

    @NotNull
    public final Set<String> component2() {
        return this.currentIssues;
    }

    @NotNull
    public final Baseline copy(@NotNull Set<String> manuallySuppressedIssues, @NotNull Set<String> currentIssues) {
        Intrinsics.checkNotNullParameter(manuallySuppressedIssues, (String)"manuallySuppressedIssues");
        Intrinsics.checkNotNullParameter(currentIssues, (String)"currentIssues");
        return new Baseline(manuallySuppressedIssues, currentIssues);
    }

    public static /* synthetic */ Baseline copy$default(Baseline baseline, Set set, Set set2, int n, Object object) {
        if ((n & 1) != 0) {
            set = baseline.manuallySuppressedIssues;
        }
        if ((n & 2) != 0) {
            set2 = baseline.currentIssues;
        }
        return baseline.copy(set, set2);
    }

    @NotNull
    public String toString() {
        return "Baseline(manuallySuppressedIssues=" + this.manuallySuppressedIssues + ", currentIssues=" + this.currentIssues + ")";
    }

    public int hashCode() {
        Set<String> set = this.manuallySuppressedIssues;
        Set<String> set2 = this.currentIssues;
        return (set != null ? ((Object)set).hashCode() : 0) * 31 + (set2 != null ? ((Object)set2).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Baseline)) break block3;
                Baseline baseline = (Baseline)object;
                if (!Intrinsics.areEqual(this.manuallySuppressedIssues, baseline.manuallySuppressedIssues) || !Intrinsics.areEqual(this.currentIssues, baseline.currentIssues)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/core/baseline/Baseline$Companion;", "", "()V", "load", "Lio/gitlab/arturbosch/detekt/core/baseline/Baseline;", "baselineFile", "Ljava/nio/file/Path;", "detekt-core"})
    public static final class Companion {
        @NotNull
        public final Baseline load(@NotNull Path baselineFile) {
            Intrinsics.checkNotNullParameter((Object)baselineFile, (String)"baselineFile");
            boolean bl = JunkKt.exists(baselineFile);
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Baseline file does not exist.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = JunkKt.isFile(baselineFile);
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Baseline file is not a regular file.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return new BaselineFormat().read(baselineFile);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

