/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.baseline;

import io.github.detekt.tooling.internal.NotApiButProbablyUsedByUsers;
import io.gitlab.arturbosch.detekt.core.baseline.Baseline;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\r\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J \u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0016J(\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/gitlab/arturbosch/detekt/core/baseline/BaselineHandler;", "Lorg/xml/sax/helpers/DefaultHandler;", "()V", "content", "", "current", "currentIssues", "", "manuallySuppressedIssues", "characters", "", "ch", "", "start", "", "length", "createBaseline", "Lio/gitlab/arturbosch/detekt/core/baseline/Baseline;", "createBaseline$detekt_core", "endElement", "uri", "localName", "qName", "startElement", "attributes", "Lorg/xml/sax/Attributes;", "Companion", "detekt-core"})
public final class BaselineHandler
extends DefaultHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String current;
    @NotNull
    private String content = "";
    @NotNull
    private final Set<String> currentIssues;
    @NotNull
    private final Set<String> manuallySuppressedIssues;
    @NotNull
    private static final String BLACKLIST = "Blacklist";
    @NotNull
    private static final String WHITELIST = "Whitelist";

    public BaselineHandler() {
        boolean bl = false;
        this.currentIssues = new LinkedHashSet();
        bl = false;
        this.manuallySuppressedIssues = new LinkedHashSet();
    }

    @NotNull
    public final Baseline createBaseline$detekt_core() {
        return new Baseline(this.manuallySuppressedIssues, this.currentIssues);
    }

    @Override
    public void startElement(@NotNull String uri, @NotNull String localName, @NotNull String qName, @NotNull Attributes attributes) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
        Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        switch (qName) {
            case "ManuallySuppressedIssues": 
            case "Blacklist": {
                this.current = "ManuallySuppressedIssues";
                break;
            }
            case "CurrentIssues": 
            case "Whitelist": {
                this.current = "CurrentIssues";
                break;
            }
            case "ID": {
                this.content = "";
            }
        }
    }

    @Override
    public void endElement(@NotNull String uri, @NotNull String localName, @NotNull String qName) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
        Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
        switch (qName) {
            case "ID": {
                CharSequence charSequence = this.content;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)charSequence);
                bl = false;
                boolean bl3 = false;
                if (!bl2) {
                    boolean bl4 = false;
                    String string = "The content of the ID element must not be empty";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                String string = this.current;
                if (Intrinsics.areEqual((Object)string, (Object)"ManuallySuppressedIssues")) {
                    this.manuallySuppressedIssues.add(this.content);
                } else if (Intrinsics.areEqual((Object)string, (Object)"CurrentIssues")) {
                    this.currentIssues.add(this.content);
                }
                this.content = "";
                break;
            }
            case "CurrentIssues": 
            case "ManuallySuppressedIssues": {
            }
        }
    }

    @Override
    public void characters(@NotNull char[] ch, int start, int length) {
        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
        if (this.current != null) {
            BaselineHandler baselineHandler = this;
            boolean bl = false;
            baselineHandler.content = Intrinsics.stringPlus((String)baselineHandler.content, (Object)new String(ch, start, length));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u0016\u0010\u0006\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u00a8\u0006\b"}, d2={"Lio/gitlab/arturbosch/detekt/core/baseline/BaselineHandler$Companion;", "", "()V", "BLACKLIST", "", "getBLACKLIST$annotations", "WHITELIST", "getWHITELIST$annotations", "detekt-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotApiButProbablyUsedByUsers
        private static /* synthetic */ void getBLACKLIST$annotations() {
        }

        @NotApiButProbablyUsedByUsers
        private static /* synthetic */ void getWHITELIST$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

