/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.config;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Notification;
import io.gitlab.arturbosch.detekt.api.internal.CommaSeparatedPattern;
import io.gitlab.arturbosch.detekt.api.internal.SimpleNotification;
import io.gitlab.arturbosch.detekt.core.config.ValidatableConfiguration;
import io.gitlab.arturbosch.detekt.core.config.ValidationSettings;
import io.gitlab.arturbosch.detekt.core.config.YamlConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0000\u001a \u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0000\u001a&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u001a,\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\" \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"DEFAULT_PROPERTY_EXCLUDES", "", "getDEFAULT_PROPERTY_EXCLUDES", "()Ljava/lang/String;", "DEPRECATED_PROPERTIES", "", "Lkotlin/Pair;", "Lkotlin/text/Regex;", "nestedConfigurationExpected", "Lio/gitlab/arturbosch/detekt/api/Notification;", "prop", "propertyDoesNotExists", "propertyIsDeprecated", "deprecationDescription", "reportAsError", "", "unexpectedNestedConfiguration", "validateConfig", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "baseline", "settings", "Lio/gitlab/arturbosch/detekt/core/config/ValidationSettings;", "excludePatterns", "", "detekt-core"})
public final class ValidatableConfigurationKt {
    @NotNull
    private static final String DEFAULT_PROPERTY_EXCLUDES;
    @NotNull
    private static final List<Pair<Regex, String>> DEPRECATED_PROPERTIES;

    @NotNull
    public static final String getDEFAULT_PROPERTY_EXCLUDES() {
        return DEFAULT_PROPERTY_EXCLUDES;
    }

    @NotNull
    public static final List<Notification> validateConfig(@NotNull Config config, @NotNull Config baseline, @NotNull Set<Regex> excludePatterns) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)baseline, (String)"baseline");
        Intrinsics.checkNotNullParameter(excludePatterns, (String)"excludePatterns");
        return ValidatableConfigurationKt.validateConfig(config, baseline, new ValidationSettings((Boolean)config.subConfig("config").valueOrDefault("warningsAsErrors", (Object)false), excludePatterns));
    }

    public static /* synthetic */ List validateConfig$default(Config config, Config config2, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            set = new CommaSeparatedPattern(DEFAULT_PROPERTY_EXCLUDES, null, 2, null).mapToRegex();
        }
        return ValidatableConfigurationKt.validateConfig(config, config2, set);
    }

    @NotNull
    public static final List<Notification> validateConfig(@NotNull Config config, @NotNull Config baseline, @NotNull ValidationSettings settings2) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)baseline, (String)"baseline");
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        boolean bl = !Intrinsics.areEqual((Object)baseline, (Object)Config.Companion.getEmpty());
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Cannot validate configuration based on an empty baseline config.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = baseline instanceof YamlConfig;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String yamlConfigClass = Reflection.getOrCreateKotlinClass(YamlConfig.class).getSimpleName();
            String actualClass = baseline.getClass().getSimpleName();
            String string = "Only supported baseline config is the " + yamlConfigClass + ". Actual type is " + actualClass;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (Intrinsics.areEqual((Object)config, (Object)Config.Companion.getEmpty())) {
            return CollectionsKt.emptyList();
        }
        ValidationSettings validationSettings = settings2;
        boolean warningsAsErrors = validationSettings.component1();
        Set<Regex> excludePatterns = validationSettings.component2();
        boolean bl6 = false;
        List notifications = new ArrayList();
        Config config2 = config;
        if (config2 instanceof YamlConfig) {
            ValidatableConfigurationKt.validateConfig$testKeys(excludePatterns, notifications, warningsAsErrors, ((YamlConfig)config).getProperties(), ((YamlConfig)baseline).getProperties(), null);
        } else if (config2 instanceof ValidatableConfiguration) {
            notifications.addAll((Collection)((ValidatableConfiguration)config).validate(baseline, excludePatterns));
        } else {
            String string = "Unsupported config type for validation: '" + Reflection.getOrCreateKotlinClass(config.getClass()) + "'.";
            boolean bl7 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return notifications;
    }

    @NotNull
    public static final Notification propertyDoesNotExists(@NotNull String prop) {
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        return (Notification)new SimpleNotification("Property '" + prop + "' is misspelled or does not exist.", null, 2, null);
    }

    @NotNull
    public static final Notification nestedConfigurationExpected(@NotNull String prop) {
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        return (Notification)new SimpleNotification("Nested config expected for '" + prop + "'.", null, 2, null);
    }

    @NotNull
    public static final Notification unexpectedNestedConfiguration(@NotNull String prop) {
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        return (Notification)new SimpleNotification("Unexpected nested config for '" + prop + "'.", null, 2, null);
    }

    @NotNull
    public static final Notification propertyIsDeprecated(@NotNull String prop, @NotNull String deprecationDescription, boolean reportAsError) {
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        Intrinsics.checkNotNullParameter((Object)deprecationDescription, (String)"deprecationDescription");
        return (Notification)new SimpleNotification("Property '" + prop + "' is deprecated. " + deprecationDescription + '.', reportAsError ? Notification.Level.Error : Notification.Level.Warning);
    }

    private static final void validateConfig$testKeys(Set<Regex> excludePatterns, List<Notification> notifications, boolean warningsAsErrors, Map<String, ? extends Object> current, Map<String, ? extends Object> base, String parentPath) {
        for (String prop : current.keySet()) {
            boolean isExcluded;
            boolean $i$f$any;
            Object $this$any$iv;
            String deprecationWarning;
            Object object;
            boolean bl;
            Map<String, ? extends Object> map;
            String propertyPath;
            block10: {
                boolean bl2;
                Object v0;
                block9: {
                    propertyPath = Intrinsics.stringPlus((String)(parentPath == null ? "" : Intrinsics.stringPlus((String)parentPath, (Object)">")), (Object)prop);
                    Iterable iterable = DEPRECATED_PROPERTIES;
                    boolean bl3 = false;
                    map = iterable;
                    bl = false;
                    object = map.iterator();
                    while (object.hasNext()) {
                        Object t = object.next();
                        Pair $dstr$regex$_u24__u24 = (Pair)t;
                        boolean bl4 = false;
                        Regex regex = (Regex)$dstr$regex$_u24__u24.component1();
                        if (!regex.matches((CharSequence)propertyPath)) continue;
                        v0 = t;
                        break block9;
                    }
                    v0 = null;
                }
                Pair pair = v0;
                deprecationWarning = pair == null ? null : (String)pair.getSecond();
                $this$any$iv = excludePatterns;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    map = $this$any$iv.iterator();
                    while (map.hasNext()) {
                        Object element$iv = map.next();
                        Regex it = (Regex)element$iv;
                        boolean bl5 = false;
                        if (!it.matches((CharSequence)propertyPath)) continue;
                        bl2 = true;
                        break block10;
                    }
                    bl2 = isExcluded = false;
                }
            }
            if (deprecationWarning != null) {
                notifications.add(ValidatableConfigurationKt.propertyIsDeprecated(propertyPath, deprecationWarning, warningsAsErrors));
            }
            if (deprecationWarning != null || isExcluded) continue;
            $this$any$iv = base;
            $i$f$any = false;
            map = $this$any$iv;
            bl = false;
            if (!map.containsKey(prop)) {
                notifications.add(ValidatableConfigurationKt.propertyDoesNotExists(propertyPath));
            }
            Map next = ($i$f$any = current.get(prop)) instanceof Map ? (Map)$i$f$any : null;
            map = base.get(prop);
            Map nextBase = map instanceof Map ? (Map)map : null;
            if (next == null && nextBase != null) {
                notifications.add(ValidatableConfigurationKt.nestedConfigurationExpected(propertyPath));
                continue;
            }
            map = base;
            bl = false;
            object = map;
            boolean bl6 = false;
            if (object.containsKey(prop) && next != null && nextBase == null) {
                notifications.add(ValidatableConfigurationKt.unexpectedNestedConfiguration(propertyPath));
                continue;
            }
            if (next == null || nextBase == null) continue;
            ValidatableConfigurationKt.validateConfig$testKeys(excludePatterns, notifications, warningsAsErrors, next, nextBase, propertyPath);
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Object[] objectArray = new String[]{".*>.*>excludes", ".*>.*>includes", ".*>.*>active", ".*>.*>autoCorrect", ".*>severity", ".*>.*>severity", "build>weights.*"};
        DEFAULT_PROPERTY_EXCLUDES = CollectionsKt.joinToString$default((Iterable)SetsKt.setOf((Object[])objectArray), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        objectArray = new Pair[]{TuplesKt.to((Object)"complexity>LongParameterList>threshold", (Object)"Use 'functionThreshold' and 'constructorThreshold' instead"), TuplesKt.to((Object)"empty-blocks>EmptyFunctionBlock>ignoreOverriddenFunctions", (Object)"Use 'ignoreOverridden' instead"), TuplesKt.to((Object)"naming>FunctionParameterNaming>ignoreOverriddenFunctions", (Object)"Use 'ignoreOverridden' instead"), TuplesKt.to((Object)"naming>MemberNameEqualsClassName>ignoreOverriddenFunction", (Object)"Use 'ignoreOverridden' instead")};
        Iterable $this$map$iv = SetsKt.setOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $dstr$first$second;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String first = (String)$dstr$first$second.component1();
            String second = (String)$dstr$first$second.component2();
            String string = first;
            boolean bl2 = false;
            Pair pair2 = TuplesKt.to((Object)new Regex(string), (Object)second);
            collection.add(pair2);
        }
        DEPRECATED_PROPERTIES = (List)var3_3;
    }
}

