/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.util;

import java.time.Duration;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bJ'\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u000f\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0013\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u00060\tj\u0002`\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/gitlab/arturbosch/detekt/core/util/PerformanceMonitor;", "", "()V", "finished", "", "Lio/gitlab/arturbosch/detekt/core/util/PerformanceMonitor$Entry;", "started", "", "Lio/gitlab/arturbosch/detekt/core/util/PerformanceMonitor$Phase;", "", "Lio/gitlab/arturbosch/detekt/core/util/StartMillis;", "allFinished", "", "finish", "", "phase", "measure", "R", "block", "Lkotlin/Function0;", "(Lio/gitlab/arturbosch/detekt/core/util/PerformanceMonitor$Phase;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "start", "Entry", "Phase", "detekt-core"})
public final class PerformanceMonitor {
    @NotNull
    private final List<Entry> finished = new LinkedList();
    @NotNull
    private final Map<Phase, Long> started = new EnumMap(Phase.class);

    @NotNull
    public final List<Entry> allFinished() {
        return this.finished;
    }

    public final void start(@NotNull Phase phase) {
        Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
        Map<Phase, Long> map = this.started;
        Long l = System.currentTimeMillis();
        boolean bl = false;
        map.put(phase, l);
    }

    public final void finish(@NotNull Phase phase) {
        Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
        Long l = this.started.get((Object)phase);
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (l == null) {
            boolean bl4 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long start = ((Number)l).longValue();
        long end = System.currentTimeMillis();
        Duration duration = Duration.ofMillis(end - start);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(end - start)");
        this.finished.add(new Entry(phase, duration));
    }

    public final <R> R measure(@NotNull Phase phase, @NotNull Function0<? extends R> block) {
        Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.start(phase);
        Object result2 = block.invoke();
        this.finish(phase);
        return (R)result2;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lio/gitlab/arturbosch/detekt/core/util/PerformanceMonitor$Phase;", "", "(Ljava/lang/String;I)V", "LoadConfig", "CreateSettings", "ValidateConfig", "Parsing", "Binding", "LoadingExtensions", "Analyzer", "Reporting", "detekt-core"})
    public static final class Phase
    extends Enum<Phase> {
        public static final /* enum */ Phase LoadConfig = new Phase();
        public static final /* enum */ Phase CreateSettings = new Phase();
        public static final /* enum */ Phase ValidateConfig = new Phase();
        public static final /* enum */ Phase Parsing = new Phase();
        public static final /* enum */ Phase Binding = new Phase();
        public static final /* enum */ Phase LoadingExtensions = new Phase();
        public static final /* enum */ Phase Analyzer = new Phase();
        public static final /* enum */ Phase Reporting = new Phase();
        private static final /* synthetic */ Phase[] $VALUES;

        public static Phase[] values() {
            return (Phase[])$VALUES.clone();
        }

        public static Phase valueOf(String value) {
            return Enum.valueOf(Phase.class, value);
        }

        static {
            $VALUES = phaseArray = new Phase[]{Phase.LoadConfig, Phase.CreateSettings, Phase.ValidateConfig, Phase.Parsing, Phase.Binding, Phase.LoadingExtensions, Phase.Analyzer, Phase.Reporting};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/core/util/PerformanceMonitor$Entry;", "", "phase", "Lio/gitlab/arturbosch/detekt/core/util/PerformanceMonitor$Phase;", "duration", "Ljava/time/Duration;", "(Lio/gitlab/arturbosch/detekt/core/util/PerformanceMonitor$Phase;Ljava/time/Duration;)V", "getDuration", "()Ljava/time/Duration;", "getPhase", "()Lio/gitlab/arturbosch/detekt/core/util/PerformanceMonitor$Phase;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "detekt-core"})
    public static final class Entry {
        @NotNull
        private final Phase phase;
        @NotNull
        private final Duration duration;

        public Entry(@NotNull Phase phase, @NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
            Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
            this.phase = phase;
            this.duration = duration;
        }

        @NotNull
        public final Phase getPhase() {
            return this.phase;
        }

        @NotNull
        public final Duration getDuration() {
            return this.duration;
        }

        @NotNull
        public final Phase component1() {
            return this.phase;
        }

        @NotNull
        public final Duration component2() {
            return this.duration;
        }

        @NotNull
        public final Entry copy(@NotNull Phase phase, @NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
            Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
            return new Entry(phase, duration);
        }

        public static /* synthetic */ Entry copy$default(Entry entry, Phase phase, Duration duration, int n, Object object) {
            if ((n & 1) != 0) {
                phase = entry.phase;
            }
            if ((n & 2) != 0) {
                duration = entry.duration;
            }
            return entry.copy(phase, duration);
        }

        @NotNull
        public String toString() {
            return "Entry(phase=" + (Object)((Object)this.phase) + ", duration=" + this.duration + ')';
        }

        public int hashCode() {
            int result2 = this.phase.hashCode();
            result2 = result2 * 31 + this.duration.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)other;
            if (this.phase != entry.phase) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.duration, (Object)entry.duration);
        }
    }
}

