/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.style.ForbiddenComment;
import io.gitlab.arturbosch.detekt.rules.style.ForbiddenComment$visitKtFile$;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocSection;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u000eH\u0002J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(H\u0016R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR!\u0010\r\u001a\u00020\u000e8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\f\u0012\u0004\b\u000f\u0010\b\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R'\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00188BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\f\u0012\u0004\b\u0019\u0010\b\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006*"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenComment;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "allowedPatterns", "Lkotlin/text/Regex;", "getAllowedPatterns$annotations", "()V", "getAllowedPatterns", "()Lkotlin/text/Regex;", "allowedPatterns$delegate", "Lkotlin/properties/ReadOnlyProperty;", "customMessage", "", "getCustomMessage$annotations", "getCustomMessage", "()Ljava/lang/String;", "customMessage$delegate", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "values", "", "getValues$annotations", "getValues", "()Ljava/util/List;", "values$delegate", "checkForbiddenComment", "", "text", "comment", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "getErrorMessage", "value", "visitComment", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiComment;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "detekt-rules-style"})
public final class ForbiddenComment
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty values$delegate;
    @NotNull
    private final ReadOnlyProperty allowedPatterns$delegate;
    @NotNull
    private final ReadOnlyProperty customMessage$delegate;
    @NotNull
    public static final String DEFAULT_ERROR_MESSAGE = "This comment contains '%s' that has been defined as forbidden in detekt.";

    public ForbiddenComment(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Flags a forbidden comment.", Debt.Companion.getTEN_MINS());
        Object[] objectArray = new String[]{"FIXME:", "STOPSHIP:", "TODO:"};
        this.values$delegate = ConfigPropertyKt.config((Object)CollectionsKt.listOf((Object[])objectArray));
        this.allowedPatterns$delegate = ConfigPropertyKt.config((Object)"", (Function1)allowedPatterns.2.INSTANCE);
        this.customMessage$delegate = ConfigPropertyKt.config((Object)"");
    }

    public /* synthetic */ ForbiddenComment(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<String> getValues() {
        return (List)this.values$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="forbidden comment strings")
    private static /* synthetic */ void getValues$annotations() {
    }

    private final Regex getAllowedPatterns() {
        return (Regex)this.allowedPatterns$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="ignores comments which match the specified regular expression. For example `Ticket|Task`.")
    private static /* synthetic */ void getAllowedPatterns$annotations() {
    }

    private final String getCustomMessage() {
        return (String)this.customMessage$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @Configuration(description="error message which overrides the default one")
    private static /* synthetic */ void getCustomMessage$annotations() {
    }

    public void visitComment(@NotNull PsiComment comment) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        super.visitComment(comment);
        String text = comment.getText();
        Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
        this.checkForbiddenComment(text, (PsiElement)comment);
    }

    /*
     * WARNING - void declaration
     */
    public void visitKtFile(@NotNull KtFile file) {
        void $this$forEachDescendantOfType$iv$iv$iv$iv;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super.visitKtFile(file);
        PsiElement $this$collectDescendantsOfType_u24default$iv = (PsiElement)file;
        Function1 predicate$iv = visitKtFile$$inlined$collectDescendantsOfType$default$1.INSTANCE;
        boolean $i$f$collectDescendantsOfType = false;
        PsiElement $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType_u24default$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        PsiElement psiElement = $this$collectDescendantsOfType$iv$iv;
        Collection to$iv$iv$iv = new ArrayList();
        boolean $i$f$collectDescendantsOfTypeTo = false;
        void var10_14 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Function1 action$iv$iv$iv$iv = (Function1)new Function1<KDocSection, Unit>(predicate$iv, to$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KDocSection) {
                    this.$action.invoke((Object)element);
                }
            }
        });
        Iterable $this$forEach$iv = (List)to$iv$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KDocSection comment = (KDocSection)element$iv;
            boolean bl = false;
            String text = comment.getContent();
            this.checkForbiddenComment(text, (PsiElement)comment);
        }
    }

    private final void checkForbiddenComment(String text, PsiElement comment) {
        if (((CharSequence)this.getAllowedPatterns().getPattern()).length() > 0 && this.getAllowedPatterns().containsMatchIn((CharSequence)text)) {
            return;
        }
        Iterable $this$forEach$iv = this.getValues();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (!StringsKt.contains((CharSequence)text, (CharSequence)it, (boolean)true)) continue;
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)comment, (int)0, (int)2, null), this.getErrorMessage(it), null, null, 24, null));
        }
    }

    private final String getErrorMessage(String value) {
        String string;
        String it = string = this.getCustomMessage();
        boolean bl = false;
        String string2 = !(((CharSequence)it).length() == 0) ? string : null;
        if (string2 == null) {
            String string3 = DEFAULT_ERROR_MESSAGE;
            Object[] objectArray = new Object[]{value};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
        }
        return string2;
    }

    public ForbiddenComment() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ForbiddenComment.class, "values", "getValues()Ljava/util/List;", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ForbiddenComment.class, "allowedPatterns", "getAllowedPatterns()Lkotlin/text/Regex;", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ForbiddenComment.class, "customMessage", "getCustomMessage()Ljava/lang/String;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenComment$Companion;", "", "()V", "DEFAULT_ERROR_MESSAGE", "", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

