/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\f\u0010\u0019\u001a\u00020\u0006*\u00020\u0018H\u0002J\f\u0010\u001a\u001a\u00020\u0006*\u00020\u0018H\u0002J\f\u0010\u001b\u001a\u00020\u0006*\u00020\u0018H\u0002J\f\u0010\u001c\u001a\u00020\u0006*\u00020\u0018H\u0002R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR!\u0010\r\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\f\u0012\u0004\b\u000e\u0010\b\u001a\u0004\b\u000f\u0010\nR\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenVoid;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "ignoreOverridden", "", "getIgnoreOverridden$annotations", "()V", "getIgnoreOverridden", "()Z", "ignoreOverridden$delegate", "Lkotlin/properties/ReadOnlyProperty;", "ignoreUsageInGenerics", "getIgnoreUsageInGenerics$annotations", "getIgnoreUsageInGenerics", "ignoreUsageInGenerics$delegate", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitTypeReference", "", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "isGenericArgument", "isParameterTypeOfFunction", "isPartOfOverriddenSignature", "isPartOfReturnTypeOfFunction", "Companion", "detekt-rules-style"})
public final class ForbiddenVoid
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty ignoreOverridden$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreUsageInGenerics$delegate;
    @NotNull
    private static final FqName VOID_FQ_NAME;

    public ForbiddenVoid(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "`Unit` should be used instead of `Void`.", Debt.Companion.getFIVE_MINS());
        this.ignoreOverridden$delegate = ConfigPropertyKt.config((Object)false);
        this.ignoreUsageInGenerics$delegate = ConfigPropertyKt.config((Object)false);
    }

    public /* synthetic */ ForbiddenVoid(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getIgnoreOverridden() {
        return (Boolean)this.ignoreOverridden$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="ignores void types in signatures of overridden functions")
    private static /* synthetic */ void getIgnoreOverridden$annotations() {
    }

    private final boolean getIgnoreUsageInGenerics() {
        return (Boolean)this.ignoreUsageInGenerics$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="ignore void types as generic arguments")
    private static /* synthetic */ void getIgnoreUsageInGenerics$annotations() {
    }

    public void visitTypeReference(@NotNull KtTypeReference typeReference) {
        Intrinsics.checkNotNullParameter((Object)typeReference, (String)"typeReference");
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        KotlinType kotlinType = BindingContextUtilsKt.getAbbreviatedTypeOrType((KtTypeReference)typeReference, (BindingContext)this.getBindingContext());
        if (kotlinType == null) {
            return;
        }
        KotlinType kotlinType2 = kotlinType;
        if (Intrinsics.areEqual((Object)TypeUtilsKt.fqNameOrNull((KotlinType)kotlinType2), (Object)VOID_FQ_NAME)) {
            if (this.getIgnoreOverridden() && this.isPartOfOverriddenSignature(typeReference)) {
                return;
            }
            if (this.getIgnoreUsageInGenerics() && this.isGenericArgument(typeReference)) {
                return;
            }
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)typeReference), (int)0, (int)2, null), "'Void' should be replaced with 'Unit'.", null, null, 24, null));
        }
        super.visitTypeReference(typeReference);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPartOfOverriddenSignature(KtTypeReference $this$isPartOfOverriddenSignature) {
        if (!this.isPartOfReturnTypeOfFunction($this$isPartOfOverriddenSignature)) {
            if (!this.isParameterTypeOfFunction($this$isPartOfOverriddenSignature)) return false;
        }
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$isPartOfOverriddenSignature;
        boolean $i$f$getStrictParentOfType = false;
        KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtNamedFunction.class, (boolean)true);
        if (ktNamedFunction == null) return false;
        if (!KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)ktNamedFunction))) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isPartOfReturnTypeOfFunction(KtTypeReference $this$isPartOfReturnTypeOfFunction) {
        boolean bl;
        KtTypeReference ktTypeReference;
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$isPartOfReturnTypeOfFunction;
        boolean $i$f$getStrictParentOfType = false;
        KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtNamedFunction.class, (boolean)true);
        if (ktNamedFunction != null && (ktTypeReference = ktNamedFunction.getTypeReference()) != null) {
            void $this$anyDescendantOfType$iv;
            PsiElement psiElement = (PsiElement)ktTypeReference;
            Function1 predicate$iv = (Function1)new Function1<KtTypeReference, Boolean>($this$isPartOfReturnTypeOfFunction){
                final /* synthetic */ KtTypeReference $this_isPartOfReturnTypeOfFunction;
                {
                    this.$this_isPartOfReturnTypeOfFunction = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull KtTypeReference it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it, (Object)this.$this_isPartOfReturnTypeOfFunction);
                }
            };
            boolean $i$f$anyDescendantOfType = false;
            void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
            boolean $i$f$findDescendantOfType = false;
            void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
            boolean $i$f$findDescendantOfType2 = false;
            Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
            $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Ref.ObjectRef $result;
                {
                    this.$predicate = $predicate;
                    this.$result = $result;
                }

                public void visitElement(@NotNull PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (element instanceof KtTypeReference && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                        this.$result.element = element;
                        this.stopWalking();
                        return;
                    }
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                }
            });
            bl = (PsiElement)result$iv$iv$iv.element != null;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isParameterTypeOfFunction(KtTypeReference $this$isParameterTypeOfFunction) {
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$isParameterTypeOfFunction;
        boolean $i$f$getStrictParentOfType = false;
        return PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtParameter.class, (boolean)true) != null;
    }

    private final boolean isGenericArgument(KtTypeReference $this$isGenericArgument) {
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$isGenericArgument;
        boolean $i$f$getStrictParentOfType = false;
        return PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtTypeArgumentList.class, (boolean)true) != null;
    }

    public ForbiddenVoid() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ForbiddenVoid.class, "ignoreOverridden", "getIgnoreOverridden()Z", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ForbiddenVoid.class, "ignoreUsageInGenerics", "getIgnoreUsageInGenerics()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        VOID_FQ_NAME = new FqName("java.lang.Void");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenVoid$Companion;", "", "()V", "VOID_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

