/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.style.UnnecessaryInnerClass$visitCallExpression$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\bH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\b2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0012H\u0002J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0007H\u0016J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u00102\u0006\u0010-\u001a\u00020.H\u0016R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006/"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryInnerClass;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "candidateClassToParentClasses", "", "Lorg/jetbrains/kotlin/psi/KtClass;", "", "classChain", "Lkotlin/collections/ArrayDeque;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "checkForOuterUsage", "", "expressionsToResolve", "Lorg/jetbrains/kotlin/psi/KtElement;", "findParentClasses", "ktClass", "findResolvedContainingClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "ktElement", "visit", "root", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitBinaryExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitClass", "klass", "visitDotQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "visitIfExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "detekt-rules-style"})
public final class UnnecessaryInnerClass
extends Rule {
    @NotNull
    private final Map<KtClass, List<KtClass>> candidateClassToParentClasses;
    @NotNull
    private final ArrayDeque<KtClass> classChain;
    @NotNull
    private final Issue issue;

    public UnnecessaryInnerClass(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.candidateClassToParentClasses = new LinkedHashMap();
        this.classChain = new ArrayDeque();
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "The 'inner' qualifier is unnecessary.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UnnecessaryInnerClass(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visit(@NotNull KtFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        super.visit(root);
    }

    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        this.classChain.add((Object)klass);
        if (klass.isInner()) {
            this.candidateClassToParentClasses.put(klass, this.findParentClasses(klass));
        }
        super.visitClass(klass);
        if (klass.isInner() && this.candidateClassToParentClasses.containsKey(klass)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)klass), (int)0, (int)2, null), "Class '" + klass.getName() + "' does not require `inner` keyword.", null, null, 24, null));
            this.candidateClassToParentClasses.remove(klass);
        }
        UtilsKt.pop((List)((List)this.classChain));
    }

    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        super.visitProperty(property);
        this.checkForOuterUsage(CollectionsKt.listOfNotNull((Object)property.getInitializer()));
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        super.visitNamedFunction(function);
        this.checkForOuterUsage(CollectionsKt.listOfNotNull((Object)function.getInitializer()));
    }

    /*
     * WARNING - void declaration
     */
    public void visitCallExpression(@NotNull KtCallExpression expression) {
        void $this$forEachDescendantOfType$iv$iv$iv$iv;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitCallExpression(expression);
        PsiElement $this$collectDescendantsOfType_u24default$iv = (PsiElement)expression;
        Function1 predicate$iv = visitCallExpression$$inlined$collectDescendantsOfType$default$1.INSTANCE;
        boolean $i$f$collectDescendantsOfType = false;
        PsiElement $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType_u24default$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        PsiElement psiElement = $this$collectDescendantsOfType$iv$iv;
        Collection to$iv$iv$iv = new ArrayList();
        boolean $i$f$collectDescendantsOfTypeTo = false;
        void var10_10 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Function1 action$iv$iv$iv$iv = (Function1)new Function1<KtReferenceExpression, Unit>(predicate$iv, to$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtReferenceExpression) {
                    this.$action.invoke((Object)element);
                }
            }
        });
        this.checkForOuterUsage(CollectionsKt.plus((Collection)((List)to$iv$iv$iv), (Object)expression));
    }

    public void visitParameter(@NotNull KtParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        super.visitParameter(parameter);
        this.checkForOuterUsage(CollectionsKt.listOfNotNull((Object)parameter.getDefaultValue()));
    }

    public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitBinaryExpression(expression);
        Object[] objectArray = new KtExpression[]{expression.getLeft(), expression.getRight()};
        this.checkForOuterUsage(CollectionsKt.listOfNotNull((Object[])objectArray));
    }

    public void visitIfExpression(@NotNull KtIfExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitIfExpression(expression);
        KtExpression ktExpression = expression.getCondition();
        this.checkForOuterUsage(CollectionsKt.listOfNotNull((Object)(ktExpression instanceof KtReferenceExpression ? (KtReferenceExpression)ktExpression : null)));
    }

    public void visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitDotQualifiedExpression(expression);
        this.checkForOuterUsage(CollectionsKt.listOf((Object)expression.getReceiverExpression()));
    }

    private final List<KtClass> findParentClasses(KtClass ktClass) {
        ArrayList<KtClass> arrayList;
        ArrayList<KtClass> $this$findParentClasses_u24lambda_u2d0 = arrayList = new ArrayList<KtClass>();
        boolean bl = false;
        KtClass containingClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)ktClass));
        while (containingClass != null) {
            $this$findParentClasses_u24lambda_u2d0.add(containingClass);
            containingClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)containingClass));
        }
        return arrayList;
    }

    private final void checkForOuterUsage(List<? extends KtElement> expressionsToResolve) {
        KtClass ktClass = (KtClass)UtilsKt.peek((List)((List)this.classChain));
        if (ktClass == null) {
            return;
        }
        KtClass currentClass = ktClass;
        List<KtClass> list = this.candidateClassToParentClasses.get(currentClass);
        if (list == null) {
            return;
        }
        List<KtClass> parentClasses = list;
        Iterable $this$forEach$iv = expressionsToResolve;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int index;
            int n;
            block6: {
                KtElement ktElement = (KtElement)element$iv;
                boolean bl = false;
                ClassId resolvedContainingClassId = this.findResolvedContainingClassId(ktElement);
                List<KtClass> $this$indexOfFirst$iv = parentClasses;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<KtClass> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    KtClass item$iv;
                    KtClass it = item$iv = iterator.next();
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it.getClassId(), (Object)resolvedContainingClassId)) {
                        n = index$iv;
                        break block6;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            if ((index = n) < 0) continue;
            this.candidateClassToParentClasses.remove(currentClass);
            Iterable $this$forEach$iv2 = parentClasses.subList(0, index);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KtClass it = (KtClass)element$iv2;
                boolean bl = false;
                this.candidateClassToParentClasses.remove(it);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ClassId findResolvedContainingClassId(KtElement ktElement) {
        ClassifierDescriptor classifierDescriptor;
        void $this$safeAs$iv;
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)ktElement, (BindingContext)this.getBindingContext());
        if (resolvedCall == null) return null;
        CallableDescriptor callableDescriptor = resolvedCall.getResultingDescriptor();
        if (callableDescriptor == null) return null;
        DeclarationDescriptor declarationDescriptor = callableDescriptor.getContainingDeclaration();
        if (declarationDescriptor == null) return null;
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
        boolean $i$f$safeAs = false;
        Object v0 = $this$safeAs$iv;
        if (!(v0 instanceof ClassifierDescriptor)) {
            v0 = null;
        }
        if ((classifierDescriptor = (ClassifierDescriptor)v0) == null) return null;
        ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)classifierDescriptor);
        return classId;
    }

    public UnnecessaryInnerClass() {
        this(null, 1, null);
    }
}

