/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ClaimsMutator;
import io.jsonwebtoken.Header;
import io.jsonwebtoken.JweHeader;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.impl.DefaultClaims;
import io.jsonwebtoken.impl.DefaultHeader;
import io.jsonwebtoken.impl.DefaultJweHeader;
import io.jsonwebtoken.impl.DefaultJweHeaderBuilder;
import io.jsonwebtoken.impl.DefaultJwsHeader;
import io.jsonwebtoken.impl.DefaultJwtHeaderBuilder;
import io.jsonwebtoken.impl.DefaultMutableJweHeader;
import io.jsonwebtoken.impl.DefaultProtectedHeader;
import io.jsonwebtoken.impl.DelegateAudienceCollection;
import io.jsonwebtoken.impl.DelegatingClaimsMutator;
import io.jsonwebtoken.impl.ParameterMap;
import io.jsonwebtoken.impl.Payload;
import io.jsonwebtoken.impl.io.Base64UrlStreamEncoder;
import io.jsonwebtoken.impl.io.ByteBase64UrlStreamEncoder;
import io.jsonwebtoken.impl.io.CountingInputStream;
import io.jsonwebtoken.impl.io.EncodingOutputStream;
import io.jsonwebtoken.impl.io.NamedSerializer;
import io.jsonwebtoken.impl.io.Streams;
import io.jsonwebtoken.impl.io.UncloseableInputStream;
import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.lang.Function;
import io.jsonwebtoken.impl.lang.Functions;
import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.impl.lang.Services;
import io.jsonwebtoken.impl.security.DefaultAeadRequest;
import io.jsonwebtoken.impl.security.DefaultAeadResult;
import io.jsonwebtoken.impl.security.DefaultKeyRequest;
import io.jsonwebtoken.impl.security.DefaultSecureRequest;
import io.jsonwebtoken.impl.security.Pbes2HsAkwAlgorithm;
import io.jsonwebtoken.impl.security.ProviderKey;
import io.jsonwebtoken.impl.security.StandardSecureDigestAlgorithms;
import io.jsonwebtoken.io.CompressionAlgorithm;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.io.Encoder;
import io.jsonwebtoken.io.Serializer;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.NestedCollection;
import io.jsonwebtoken.lang.Objects;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.AeadAlgorithm;
import io.jsonwebtoken.security.AeadRequest;
import io.jsonwebtoken.security.AeadResult;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.KeyAlgorithm;
import io.jsonwebtoken.security.KeyRequest;
import io.jsonwebtoken.security.KeyResult;
import io.jsonwebtoken.security.Password;
import io.jsonwebtoken.security.SecureDigestAlgorithm;
import io.jsonwebtoken.security.SecureRequest;
import io.jsonwebtoken.security.SecurityException;
import io.jsonwebtoken.security.SignatureException;
import io.jsonwebtoken.security.UnsupportedKeyException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class DefaultJwtBuilder
implements JwtBuilder {
    private static final String PUB_KEY_SIGN_MSG = "PublicKeys may not be used to create digital signatures. PrivateKeys are used to sign, and PublicKeys are used to verify.";
    private static final String PRIV_KEY_ENC_MSG = "PrivateKeys may not be used to encrypt data. PublicKeys are used to encrypt, and PrivateKeys are used to decrypt.";
    protected Provider provider;
    protected SecureRandom secureRandom;
    private final DefaultBuilderHeader headerBuilder;
    private final DefaultBuilderClaims claimsBuilder;
    private Payload payload = Payload.EMPTY;
    private SecureDigestAlgorithm<Key, ?> sigAlg = Jwts.SIG.NONE;
    private Function<SecureRequest<InputStream, Key>, byte[]> signFunction;
    private AeadAlgorithm enc;
    private KeyAlgorithm<Key, ?> keyAlg;
    private Function<KeyRequest<Key>, KeyResult> keyAlgFunction;
    private Key key;
    private Serializer<Map<String, ?>> serializer;
    protected Encoder<OutputStream, OutputStream> encoder = Base64UrlStreamEncoder.INSTANCE;
    private boolean encodePayload = true;
    protected CompressionAlgorithm compressionAlgorithm;

    public DefaultJwtBuilder() {
        this.headerBuilder = new DefaultBuilderHeader(this);
        this.claimsBuilder = new DefaultBuilderClaims(this);
    }

    public JwtBuilder.BuilderHeader header() {
        return this.headerBuilder;
    }

    public JwtBuilder.BuilderClaims claims() {
        return this.claimsBuilder;
    }

    public JwtBuilder provider(Provider provider) {
        this.provider = provider;
        return this;
    }

    public JwtBuilder random(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
        return this;
    }

    public JwtBuilder serializeToJsonWith(Serializer<Map<String, ?>> serializer) {
        return this.json(serializer);
    }

    public JwtBuilder json(Serializer<Map<String, ?>> serializer) {
        this.serializer = (Serializer)Assert.notNull(serializer, (String)"JSON Serializer cannot be null.");
        return this;
    }

    public JwtBuilder base64UrlEncodeWith(Encoder<byte[], String> encoder) {
        return this.b64Url(new ByteBase64UrlStreamEncoder(encoder));
    }

    public JwtBuilder b64Url(Encoder<OutputStream, OutputStream> encoder) {
        Assert.notNull(encoder, (String)"encoder cannot be null.");
        this.encoder = encoder;
        return this;
    }

    public JwtBuilder encodePayload(boolean b64) {
        this.encodePayload = b64;
        String critParamId = DefaultProtectedHeader.CRIT.getId();
        String b64Id = DefaultJwsHeader.B64.getId();
        LinkedHashSet crit = (LinkedHashSet)this.headerBuilder.get(DefaultProtectedHeader.CRIT);
        crit = new LinkedHashSet(Collections.nullSafe((Set)crit));
        crit.remove(b64Id);
        return (JwtBuilder)((JwtBuilder.BuilderHeader)((JwtBuilder.BuilderHeader)this.header().delete((Object)b64Id)).add((Object)critParamId, crit)).and();
    }

    public JwtBuilder setHeader(Map<String, ?> map) {
        return (JwtBuilder)((JwtBuilder.BuilderHeader)((JwtBuilder.BuilderHeader)this.header().empty()).add(map)).and();
    }

    public JwtBuilder setHeaderParams(Map<String, ?> params) {
        return (JwtBuilder)((JwtBuilder.BuilderHeader)this.header().add(params)).and();
    }

    public JwtBuilder setHeaderParam(String name, Object value) {
        return (JwtBuilder)((JwtBuilder.BuilderHeader)this.header().add((Object)name, value)).and();
    }

    protected static <K extends Key> SecureDigestAlgorithm<K, ?> forSigningKey(K key) {
        Assert.notNull(key, (String)"Key cannot be null.");
        SecureDigestAlgorithm<K, ?> alg = StandardSecureDigestAlgorithms.findBySigningKey(key);
        if (alg == null) {
            String msg = "Unable to determine a suitable MAC or Signature algorithm for the specified key using available heuristics: either the key size is too weak be used with available algorithms, or the key size is unavailable (e.g. if using a PKCS11 or HSM (Hardware Security Module) key store). If you are using a PKCS11 or HSM keystore, consider using the JwtBuilder.signWith(Key, SecureDigestAlgorithm) method instead.";
            throw new UnsupportedKeyException(msg);
        }
        return alg;
    }

    public JwtBuilder signWith(Key key) throws InvalidKeyException {
        Assert.notNull((Object)key, (String)"Key argument cannot be null.");
        SecureDigestAlgorithm<Key, ?> alg = DefaultJwtBuilder.forSigningKey(key);
        return this.signWith(key, alg);
    }

    public <K extends Key> JwtBuilder signWith(K key, SecureDigestAlgorithm<? super K, ?> alg) throws InvalidKeyException {
        Assert.notNull(key, (String)"Key argument cannot be null.");
        if (key instanceof PublicKey) {
            throw new IllegalArgumentException(PUB_KEY_SIGN_MSG);
        }
        Assert.notNull(alg, (String)"SignatureAlgorithm cannot be null.");
        String id = (String)Assert.hasText((CharSequence)alg.getId(), (String)"SignatureAlgorithm id cannot be null or empty.");
        if (Jwts.SIG.NONE.getId().equalsIgnoreCase(id)) {
            String msg = "The 'none' JWS algorithm cannot be used to sign JWTs.";
            throw new IllegalArgumentException(msg);
        }
        this.key = key;
        this.sigAlg = alg;
        this.signFunction = Functions.wrap(new Function<SecureRequest<InputStream, Key>, byte[]>(){

            @Override
            public byte[] apply(SecureRequest<InputStream, Key> request) {
                return DefaultJwtBuilder.this.sigAlg.digest(request);
            }
        }, SignatureException.class, "Unable to compute %s signature.", id);
        return this;
    }

    public JwtBuilder signWith(Key key, SignatureAlgorithm alg) throws InvalidKeyException {
        Assert.notNull((Object)alg, (String)"SignatureAlgorithm cannot be null.");
        alg.assertValidSigningKey(key);
        return this.signWith(key, (SecureDigestAlgorithm)Jwts.SIG.get().forKey((Object)alg.getValue()));
    }

    public JwtBuilder signWith(SignatureAlgorithm alg, byte[] secretKeyBytes) throws InvalidKeyException {
        Assert.notNull((Object)alg, (String)"SignatureAlgorithm cannot be null.");
        Assert.notEmpty((byte[])secretKeyBytes, (String)"secret key byte array cannot be null or empty.");
        Assert.isTrue((boolean)alg.isHmac(), (String)"Key bytes may only be specified for HMAC signatures.  If using RSA or Elliptic Curve, use the signWith(SignatureAlgorithm, Key) method instead.");
        SecretKeySpec key = new SecretKeySpec(secretKeyBytes, alg.getJcaName());
        return this.signWith(key, alg);
    }

    public JwtBuilder signWith(SignatureAlgorithm alg, String base64EncodedSecretKey) throws InvalidKeyException {
        Assert.hasText((CharSequence)base64EncodedSecretKey, (String)"base64-encoded secret key cannot be null or empty.");
        Assert.isTrue((boolean)alg.isHmac(), (String)"Base64-encoded key bytes may only be specified for HMAC signatures.  If using RSA or Elliptic Curve, use the signWith(SignatureAlgorithm, Key) method instead.");
        byte[] bytes = (byte[])Decoders.BASE64.decode((Object)base64EncodedSecretKey);
        return this.signWith(alg, bytes);
    }

    public JwtBuilder signWith(SignatureAlgorithm alg, Key key) {
        return this.signWith(key, alg);
    }

    public JwtBuilder encryptWith(SecretKey key, AeadAlgorithm enc) {
        if (key instanceof Password) {
            return this.encryptWith((Password)key, new Pbes2HsAkwAlgorithm(enc.getKeyBitLength()), enc);
        }
        return this.encryptWith(key, Jwts.KEY.DIRECT, enc);
    }

    public <K extends Key> JwtBuilder encryptWith(K key, KeyAlgorithm<? super K, ?> keyAlg, AeadAlgorithm enc) {
        this.enc = (AeadAlgorithm)Assert.notNull((Object)enc, (String)"Encryption algorithm cannot be null.");
        Assert.hasText((CharSequence)enc.getId(), (String)"Encryption algorithm id cannot be null or empty.");
        Assert.notNull(key, (String)"Encryption key cannot be null.");
        if (key instanceof PrivateKey) {
            throw new IllegalArgumentException(PRIV_KEY_ENC_MSG);
        }
        Assert.notNull(keyAlg, (String)"KeyAlgorithm cannot be null.");
        String algId = (String)Assert.hasText((CharSequence)keyAlg.getId(), (String)"KeyAlgorithm id cannot be null or empty.");
        this.key = key;
        final KeyAlgorithm<Key, ?> alg = this.keyAlg = keyAlg;
        String cekMsg = "Unable to obtain content encryption key from key management algorithm '%s'.";
        this.keyAlgFunction = Functions.wrap(new Function<KeyRequest<Key>, KeyResult>(){

            @Override
            public KeyResult apply(KeyRequest<Key> request) {
                return alg.getEncryptionKey(request);
            }
        }, SecurityException.class, "Unable to obtain content encryption key from key management algorithm '%s'.", algId);
        return this;
    }

    public JwtBuilder compressWith(CompressionAlgorithm alg) {
        Assert.notNull((Object)alg, (String)"CompressionAlgorithm cannot be null");
        Assert.hasText((CharSequence)alg.getId(), (String)"CompressionAlgorithm id cannot be null or empty.");
        this.compressionAlgorithm = alg;
        return (JwtBuilder)((JwtBuilder.BuilderHeader)this.header().delete((Object)DefaultHeader.COMPRESSION_ALGORITHM.getId())).and();
    }

    public JwtBuilder setPayload(String payload) {
        return this.content(payload);
    }

    public JwtBuilder content(String content) {
        if (Strings.hasText((String)content)) {
            this.payload = new Payload(content, null);
        }
        return this;
    }

    public JwtBuilder content(byte[] content) {
        if (!Bytes.isEmpty(content)) {
            this.payload = new Payload(content, null);
        }
        return this;
    }

    public JwtBuilder content(InputStream in) {
        if (in != null) {
            this.payload = new Payload(in, null);
        }
        return this;
    }

    public JwtBuilder content(byte[] content, String cty) {
        Assert.notEmpty((byte[])content, (String)"content byte array cannot be null or empty.");
        Assert.hasText((CharSequence)cty, (String)"Content Type String cannot be null or empty.");
        this.payload = new Payload(content, cty);
        return (JwtBuilder)((JwtBuilder.BuilderHeader)this.header().delete((Object)DefaultHeader.CONTENT_TYPE.getId())).and();
    }

    public JwtBuilder content(String content, String cty) throws IllegalArgumentException {
        Assert.hasText((CharSequence)content, (String)"Content string cannot be null or empty.");
        Assert.hasText((CharSequence)cty, (String)"ContentType string cannot be null or empty.");
        this.payload = new Payload(content, cty);
        return (JwtBuilder)((JwtBuilder.BuilderHeader)this.header().delete((Object)DefaultHeader.CONTENT_TYPE.getId())).and();
    }

    public JwtBuilder content(InputStream in, String cty) throws IllegalArgumentException {
        Assert.notNull((Object)in, (String)"Payload InputStream cannot be null.");
        Assert.hasText((CharSequence)cty, (String)"ContentType string cannot be null or empty.");
        this.payload = new Payload(in, cty);
        return (JwtBuilder)((JwtBuilder.BuilderHeader)this.header().delete((Object)DefaultHeader.CONTENT_TYPE.getId())).and();
    }

    public JwtBuilder setClaims(Map<String, ?> claims) {
        Assert.notNull(claims, (String)"Claims map cannot be null.");
        return (JwtBuilder)((JwtBuilder.BuilderClaims)((JwtBuilder.BuilderClaims)this.claims().empty()).add(claims)).and();
    }

    public JwtBuilder addClaims(Map<String, ?> claims) {
        return this.claims(claims);
    }

    public JwtBuilder claims(Map<String, ?> claims) {
        return (JwtBuilder)((JwtBuilder.BuilderClaims)this.claims().add(claims)).and();
    }

    public JwtBuilder claim(String name, Object value) {
        return (JwtBuilder)((JwtBuilder.BuilderClaims)this.claims().add((Object)name, value)).and();
    }

    public JwtBuilder setIssuer(String iss) {
        return this.issuer(iss);
    }

    public JwtBuilder issuer(String iss) {
        return (JwtBuilder)((JwtBuilder.BuilderClaims)this.claims().issuer(iss)).and();
    }

    public JwtBuilder setSubject(String sub) {
        return this.subject(sub);
    }

    public JwtBuilder subject(String sub) {
        return (JwtBuilder)((JwtBuilder.BuilderClaims)this.claims().subject(sub)).and();
    }

    public JwtBuilder setAudience(String aud) {
        return (JwtBuilder)((JwtBuilder.BuilderClaims)this.claims().setAudience(aud)).and();
    }

    public ClaimsMutator.AudienceCollection<JwtBuilder> audience() {
        return new DelegateAudienceCollection<JwtBuilder>(this, this.claims().audience());
    }

    public JwtBuilder setExpiration(Date exp) {
        return this.expiration(exp);
    }

    public JwtBuilder expiration(Date exp) {
        return (JwtBuilder)((JwtBuilder.BuilderClaims)this.claims().expiration(exp)).and();
    }

    public JwtBuilder setNotBefore(Date nbf) {
        return this.notBefore(nbf);
    }

    public JwtBuilder notBefore(Date nbf) {
        return (JwtBuilder)((JwtBuilder.BuilderClaims)this.claims().notBefore(nbf)).and();
    }

    public JwtBuilder setIssuedAt(Date iat) {
        return this.issuedAt(iat);
    }

    public JwtBuilder issuedAt(Date iat) {
        return (JwtBuilder)((JwtBuilder.BuilderClaims)this.claims().issuedAt(iat)).and();
    }

    public JwtBuilder setId(String jti) {
        return this.id(jti);
    }

    public JwtBuilder id(String jti) {
        return (JwtBuilder)((JwtBuilder.BuilderClaims)this.claims().id(jti)).and();
    }

    private void assertPayloadEncoding(String type) {
        if (!this.encodePayload) {
            String msg = "Payload encoding may not be disabled for " + type + "s, only JWSs.";
            throw new IllegalArgumentException(msg);
        }
    }

    public String compact() {
        boolean jwe;
        boolean bl = jwe = this.enc != null;
        if (jwe && this.signFunction != null) {
            String msg = "Both 'signWith' and 'encryptWith' cannot be specified. Choose either one.";
            throw new IllegalStateException(msg);
        }
        Payload payload = (Payload)Assert.stateNotNull((Object)this.payload, (String)"Payload instance null, internal error");
        Claims claims = this.claimsBuilder.build();
        if (jwe && payload.isEmpty() && Collections.isEmpty((Map)claims)) {
            String msg = "Encrypted JWTs must have either 'claims' or non-empty 'content'.";
            throw new IllegalStateException(msg);
        }
        if (!payload.isEmpty() && !Collections.isEmpty((Map)claims)) {
            throw new IllegalStateException("Both 'content' and 'claims' cannot be specified. Choose either one.");
        }
        if (this.serializer == null) {
            this.json(Services.loadFirst(Serializer.class));
        }
        if (!Collections.isEmpty((Map)claims)) {
            payload = new Payload(claims);
        }
        if (this.compressionAlgorithm != null && !payload.isEmpty()) {
            payload.setZip(this.compressionAlgorithm);
            this.headerBuilder.put(DefaultHeader.COMPRESSION_ALGORITHM.getId(), this.compressionAlgorithm.getId());
        }
        if (Strings.hasText((String)payload.getContentType())) {
            this.headerBuilder.contentType(payload.getContentType());
        }
        Provider keyProvider = ProviderKey.getProvider(this.key, this.provider);
        Key key = ProviderKey.getKey(this.key);
        if (jwe) {
            return this.encrypt(payload, key, keyProvider);
        }
        if (key != null) {
            return this.sign(payload, key, keyProvider);
        }
        return this.unprotected(payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAndClose(String name, Map<String, ?> map, OutputStream out) {
        try {
            NamedSerializer named = new NamedSerializer(name, this.serializer);
            named.serialize(map, out);
        }
        catch (Throwable throwable) {
            Objects.nullSafeClose((Closeable[])new Closeable[]{out});
            throw throwable;
        }
        Objects.nullSafeClose((Closeable[])new Closeable[]{out});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeAndClose(String name, Payload payload, OutputStream out) {
        out = payload.compress(out);
        if (payload.isClaims()) {
            this.writeAndClose(name, (Map<String, ?>)payload.getRequiredClaims(), out);
            return;
        }
        try {
            InputStream in = payload.toInputStream();
            Streams.copy(in, out, new byte[4096], "Unable to copy payload.");
        }
        catch (Throwable throwable) {
            Objects.nullSafeClose((Closeable[])new Closeable[]{out});
            throw throwable;
        }
        Objects.nullSafeClose((Closeable[])new Closeable[]{out});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sign(Payload payload, Key key, Provider provider) {
        byte[] signature;
        InputStream signingInput;
        Assert.stateNotNull((Object)key, (String)"Key is required.");
        Assert.stateNotNull(this.sigAlg, (String)"SignatureAlgorithm is required.");
        Assert.stateNotNull(this.signFunction, (String)"Signature Algorithm function cannot be null.");
        Assert.stateNotNull((Object)payload, (String)"Payload argument cannot be null.");
        ByteArrayOutputStream jws = new ByteArrayOutputStream(4096);
        this.headerBuilder.add(DefaultHeader.ALGORITHM.getId(), this.sigAlg.getId());
        if (!this.encodePayload) {
            String id = DefaultJwsHeader.B64.getId();
            ((JwtBuilder.BuilderHeader)((NestedCollection)this.headerBuilder.critical().add((Object)id)).and()).add((Object)id, (Object)false);
        }
        JwsHeader header = (JwsHeader)Assert.isInstanceOf(JwsHeader.class, (Object)this.headerBuilder.build());
        this.encodeAndWrite("JWS Protected Header", (Map<String, ?>)header, (OutputStream)jws);
        jws.write(46);
        InputStream payloadStream = null;
        if (this.encodePayload) {
            this.encodeAndWrite("JWS Payload", payload, (OutputStream)jws);
            signingInput = new ByteArrayInputStream(jws.toByteArray());
        } else {
            ByteArrayInputStream prefixStream = new ByteArrayInputStream(jws.toByteArray());
            if (payload.isClaims() || payload.isCompressed()) {
                ByteArrayOutputStream claimsOut = new ByteArrayOutputStream(8192);
                this.writeAndClose("JWS Unencoded Payload", payload, (OutputStream)claimsOut);
                payloadStream = new ByteArrayInputStream(claimsOut.toByteArray());
            } else {
                payloadStream = (InputStream)Assert.stateNotNull((Object)payload.toInputStream(), (String)"Payload InputStream cannot be null.");
            }
            if (!payload.isClaims()) {
                payloadStream = new CountingInputStream(payloadStream);
            }
            if (payloadStream.markSupported()) {
                payloadStream.mark(0);
            }
            signingInput = new SequenceInputStream(prefixStream, new UncloseableInputStream(payloadStream));
        }
        try {
            DefaultSecureRequest<ByteArrayInputStream, Key> request = new DefaultSecureRequest<ByteArrayInputStream, Key>((ByteArrayInputStream)signingInput, provider, this.secureRandom, key);
            signature = this.signFunction.apply(request);
            if (!this.encodePayload) {
                if (!payload.isCompressed() && (payload.isClaims() || payload.isString())) {
                    Streams.copy(payloadStream, jws, new byte[8192], "Unable to copy attached Payload InputStream.");
                }
                if (payloadStream instanceof CountingInputStream && ((CountingInputStream)payloadStream).getCount() <= 0L) {
                    String msg = "'b64' Unencoded payload option has been specified, but payload is empty.";
                    throw new IllegalStateException(msg);
                }
            }
        }
        catch (Throwable throwable) {
            Streams.reset(payloadStream);
            throw throwable;
        }
        Streams.reset(payloadStream);
        jws.write(46);
        this.encodeAndWrite("JWS Signature", signature, (OutputStream)jws);
        return Strings.utf8((byte[])jws.toByteArray());
    }

    private String unprotected(Payload content) {
        Assert.stateNotNull((Object)content, (String)"Content argument cannot be null.");
        this.assertPayloadEncoding("unprotected JWT");
        this.headerBuilder.add(DefaultHeader.ALGORITHM.getId(), Jwts.SIG.NONE.getId());
        ByteArrayOutputStream jwt = new ByteArrayOutputStream(512);
        Header header = this.headerBuilder.build();
        this.encodeAndWrite("JWT Header", (Map<String, ?>)header, (OutputStream)jwt);
        jwt.write(46);
        this.encodeAndWrite("JWT Payload", content, (OutputStream)jwt);
        jwt.write(46);
        return Strings.ascii((byte[])jwt.toByteArray());
    }

    private void encrypt(final AeadRequest req, final AeadResult res) throws SecurityException {
        Function<Object, Object> fn = Functions.wrap(new Function<Object, Object>(){

            @Override
            public Object apply(Object o) {
                DefaultJwtBuilder.this.enc.encrypt(req, res);
                return null;
            }
        }, SecurityException.class, "%s encryption failed.", this.enc.getId());
        fn.apply(null);
    }

    private String encrypt(Payload content, Key key, Provider keyProvider) {
        InputStream plaintext;
        Assert.stateNotNull((Object)content, (String)"Payload argument cannot be null.");
        Assert.stateNotNull((Object)key, (String)"Key is required.");
        Assert.stateNotNull((Object)this.enc, (String)"Encryption algorithm is required.");
        Assert.stateNotNull(this.keyAlg, (String)"KeyAlgorithm is required.");
        Assert.stateNotNull(this.keyAlgFunction, (String)"KeyAlgorithm function cannot be null.");
        this.assertPayloadEncoding("JWE");
        if (content.isClaims()) {
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            this.writeAndClose("JWE Claims", content, (OutputStream)out);
            plaintext = new ByteArrayInputStream(out.toByteArray());
        } else {
            plaintext = content.toInputStream();
        }
        DefaultMutableJweHeader delegate = new DefaultMutableJweHeader(this.headerBuilder);
        DefaultKeyRequest<Key> keyRequest = new DefaultKeyRequest<Key>(key, keyProvider, this.secureRandom, delegate, this.enc);
        KeyResult keyResult = this.keyAlgFunction.apply(keyRequest);
        Assert.stateNotNull((Object)keyResult, (String)"KeyAlgorithm must return a KeyResult.");
        SecretKey cek = (SecretKey)Assert.notNull((Object)keyResult.getKey(), (String)"KeyResult must return a content encryption key.");
        byte[] encryptedCek = (byte[])Assert.notNull((Object)keyResult.getPayload(), (String)"KeyResult must return an encrypted key byte array, even if empty.");
        this.headerBuilder.add(DefaultHeader.ALGORITHM.getId(), this.keyAlg.getId());
        this.headerBuilder.put(DefaultJweHeader.ENCRYPTION_ALGORITHM.getId(), this.enc.getId());
        JweHeader header = (JweHeader)Assert.isInstanceOf(JweHeader.class, (Object)this.headerBuilder.build(), (String)"Invalid header created: ");
        ByteArrayOutputStream jwe = new ByteArrayOutputStream(8192);
        this.encodeAndWrite("JWE Protected Header", (Map<String, ?>)header, (OutputStream)jwe);
        ByteArrayInputStream aad = Streams.of(jwe.toByteArray());
        ByteArrayOutputStream ciphertextOut = new ByteArrayOutputStream(8192);
        DefaultAeadRequest req = new DefaultAeadRequest(plaintext, null, this.secureRandom, cek, aad);
        DefaultAeadResult res = new DefaultAeadResult(ciphertextOut);
        this.encrypt(req, res);
        byte[] iv = Assert.notEmpty((byte[])res.getIv(), (String)"Encryption result must have a non-empty initialization vector.");
        byte[] tag = Assert.notEmpty((byte[])res.getDigest(), (String)"Encryption result must have a non-empty authentication tag.");
        byte[] ciphertext = Assert.notEmpty((byte[])ciphertextOut.toByteArray(), (String)"Encryption result must have non-empty ciphertext.");
        jwe.write(46);
        this.encodeAndWrite("JWE Encrypted CEK", encryptedCek, (OutputStream)jwe);
        jwe.write(46);
        this.encodeAndWrite("JWE Initialization Vector", iv, (OutputStream)jwe);
        jwe.write(46);
        this.encodeAndWrite("JWE Ciphertext", ciphertext, (OutputStream)jwe);
        jwe.write(46);
        this.encodeAndWrite("JWE AAD Tag", tag, (OutputStream)jwe);
        return Strings.utf8((byte[])jwe.toByteArray());
    }

    private OutputStream encode(OutputStream out, String name) {
        out = (OutputStream)this.encoder.encode((Object)out);
        return new EncodingOutputStream(out, "base64url", name);
    }

    private void encodeAndWrite(String name, Map<String, ?> map, OutputStream out) {
        out = this.encode(out, name);
        this.writeAndClose(name, map, out);
    }

    private void encodeAndWrite(String name, Payload payload, OutputStream out) {
        out = this.encode(out, name);
        this.writeAndClose(name, payload, out);
    }

    private void encodeAndWrite(String name, byte[] data, OutputStream out) {
        out = this.encode(out, name);
        Streams.writeAndClose(out, data, "Unable to write bytes");
    }

    private static class DefaultBuilderHeader
    extends DefaultJweHeaderBuilder<JwtBuilder.BuilderHeader>
    implements JwtBuilder.BuilderHeader {
        private final JwtBuilder builder;

        private DefaultBuilderHeader(JwtBuilder builder) {
            this.builder = (JwtBuilder)Assert.notNull((Object)builder, (String)"JwtBuilder cannot be null.");
        }

        public JwtBuilder and() {
            return this.builder;
        }

        private <T> T get(Parameter<T> param) {
            return ((ParameterMap)this.DELEGATE).get(param);
        }

        private Header build() {
            return new DefaultJwtHeaderBuilder(this).build();
        }
    }

    private static class DefaultBuilderClaims
    extends DelegatingClaimsMutator<JwtBuilder.BuilderClaims>
    implements JwtBuilder.BuilderClaims {
        private final JwtBuilder builder;

        private DefaultBuilderClaims(JwtBuilder builder) {
            this.builder = builder;
        }

        public JwtBuilder and() {
            return this.builder;
        }

        private Claims build() {
            return new DefaultClaims((ParameterMap)this.DELEGATE);
        }
    }
}

