/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.matcher;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.bytebuddy.description.ByteCodeElement;
import net.bytebuddy.description.ModifierReviewable;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.annotation.AnnotatedCodeElement;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.description.type.generic.GenericTypeDescription;
import net.bytebuddy.description.type.generic.GenericTypeList;
import net.bytebuddy.matcher.AnnotationTypeMatcher;
import net.bytebuddy.matcher.BooleanMatcher;
import net.bytebuddy.matcher.ClassLoaderHierarchyMatcher;
import net.bytebuddy.matcher.ClassLoaderParentMatcher;
import net.bytebuddy.matcher.CollectionItemMatcher;
import net.bytebuddy.matcher.CollectionOneToOneMatcher;
import net.bytebuddy.matcher.CollectionRawTypeMatcher;
import net.bytebuddy.matcher.CollectionSizeMatcher;
import net.bytebuddy.matcher.DeclaringAnnotationMatcher;
import net.bytebuddy.matcher.DeclaringFieldMatcher;
import net.bytebuddy.matcher.DeclaringMethodMatcher;
import net.bytebuddy.matcher.DeclaringTypeMatcher;
import net.bytebuddy.matcher.DefinedShapeMatcher;
import net.bytebuddy.matcher.DescriptorMatcher;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.EqualityMatcher;
import net.bytebuddy.matcher.FailSafeMatcher;
import net.bytebuddy.matcher.FieldTypeMatcher;
import net.bytebuddy.matcher.InheritedAnnotationMatcher;
import net.bytebuddy.matcher.MethodExceptionTypeMatcher;
import net.bytebuddy.matcher.MethodParameterTypeMatcher;
import net.bytebuddy.matcher.MethodParameterTypesMatcher;
import net.bytebuddy.matcher.MethodParametersMatcher;
import net.bytebuddy.matcher.MethodReturnTypeMatcher;
import net.bytebuddy.matcher.MethodSortMatcher;
import net.bytebuddy.matcher.ModifierMatcher;
import net.bytebuddy.matcher.NameMatcher;
import net.bytebuddy.matcher.NegatingMatcher;
import net.bytebuddy.matcher.NullMatcher;
import net.bytebuddy.matcher.RawTypeMatcher;
import net.bytebuddy.matcher.StringMatcher;
import net.bytebuddy.matcher.SubTypeMatcher;
import net.bytebuddy.matcher.SuperTypeMatcher;
import net.bytebuddy.matcher.TokenMatcher;
import net.bytebuddy.matcher.TypeSortMatcher;
import net.bytebuddy.matcher.VisibilityMatcher;
import net.bytebuddy.utility.ByteBuddyCommons;

public final class ElementMatchers {
    private static final ClassLoader BOOTSTRAP_CLASSLOADER = null;

    private ElementMatchers() {
        throw new UnsupportedOperationException();
    }

    public static <T> ElementMatcher.Junction<T> failSafe(ElementMatcher<? super T> elementMatcher) {
        return new FailSafeMatcher<T>(elementMatcher, false);
    }

    public static <T> ElementMatcher.Junction<T> is(Object value) {
        return value == null ? new NullMatcher() : new EqualityMatcher(value);
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> is(Field field) {
        return ElementMatchers.definedField(ElementMatchers.is(new FieldDescription.ForLoadedField(ByteBuddyCommons.nonNull(field))));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> definedField(ElementMatcher<? super FieldDescription.InDefinedShape> matcher) {
        return new DefinedShapeMatcher(ByteBuddyCommons.nonNull(matcher));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> representedBy(FieldDescription.Token fieldToken) {
        return ElementMatchers.fieldRepresentedBy(ElementMatchers.is(ByteBuddyCommons.nonNull(fieldToken)));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> fieldRepresentedBy(ElementMatcher<? super FieldDescription.Token> matcher) {
        return new TokenMatcher(ByteBuddyCommons.nonNull(matcher));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> is(Method method) {
        return ElementMatchers.definedMethod(ElementMatchers.is(new MethodDescription.ForLoadedMethod(ByteBuddyCommons.nonNull(method))));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> is(Constructor<?> constructor) {
        return ElementMatchers.definedMethod(ElementMatchers.is(new MethodDescription.ForLoadedConstructor(ByteBuddyCommons.nonNull(constructor))));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> definedMethod(ElementMatcher<? super MethodDescription.InDefinedShape> matcher) {
        return new DefinedShapeMatcher(ByteBuddyCommons.nonNull(matcher));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> methodRepresentedBy(ElementMatcher<? super MethodDescription.Token> matcher) {
        return new TokenMatcher(ByteBuddyCommons.nonNull(matcher));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> representedBy(MethodDescription.Token methodToken) {
        return ElementMatchers.methodRepresentedBy(ElementMatchers.is(ByteBuddyCommons.nonNull(methodToken)));
    }

    public static <T extends ParameterDescription> ElementMatcher.Junction<T> definedParameter(ElementMatcher<? super ParameterDescription.InDefinedShape> matcher) {
        return new DefinedShapeMatcher(ByteBuddyCommons.nonNull(matcher));
    }

    public static <T extends ParameterDescription> ElementMatcher.Junction<T> parameterRepresentedBy(ElementMatcher<? super ParameterDescription.Token> matcher) {
        return new TokenMatcher(ByteBuddyCommons.nonNull(matcher));
    }

    public static <T extends ParameterDescription> ElementMatcher.Junction<T> representedBy(ParameterDescription.Token parameterToken) {
        return ElementMatchers.parameterRepresentedBy(ElementMatchers.is(ByteBuddyCommons.nonNull(parameterToken)));
    }

    public static <T extends ParameterDescription> ElementMatcher.Junction<T> hasType(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.hasGenericType(ElementMatchers.rawType(ByteBuddyCommons.nonNull(matcher)));
    }

    public static <T extends ParameterDescription> ElementMatcher.Junction<T> hasGenericType(ElementMatcher<? super GenericTypeDescription> matcher) {
        return new MethodParameterTypeMatcher(ByteBuddyCommons.nonNull(matcher));
    }

    public static <T extends GenericTypeDescription> ElementMatcher.Junction<T> is(Type type) {
        return ElementMatchers.is(GenericTypeDescription.Sort.describe(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends AnnotationDescription> ElementMatcher.Junction<T> is(Annotation annotation) {
        return ElementMatchers.is(AnnotationDescription.ForLoadedAnnotation.of(ByteBuddyCommons.nonNull(annotation)));
    }

    public static <T> ElementMatcher.Junction<T> not(ElementMatcher<? super T> matcher) {
        return new NegatingMatcher<T>(ByteBuddyCommons.nonNull(matcher));
    }

    public static <T> ElementMatcher.Junction<T> any() {
        return new BooleanMatcher(true);
    }

    public static <T> ElementMatcher.Junction<T> none() {
        return new BooleanMatcher(false);
    }

    public static <T> ElementMatcher.Junction<T> anyOf(Object ... value) {
        return ElementMatchers.anyOf(Arrays.asList(ByteBuddyCommons.nonNull(value)));
    }

    public static <T> ElementMatcher.Junction<T> anyOf(Iterable<?> values) {
        ElementMatcher.Junction<T> matcher = ElementMatchers.none();
        for (Object value : values) {
            matcher = matcher.or(ElementMatchers.is(value));
        }
        return matcher;
    }

    public static <T extends GenericTypeDescription> ElementMatcher.Junction<T> anyOf(Type ... value) {
        return ElementMatchers.anyOf(new GenericTypeList.ForLoadedType(ByteBuddyCommons.nonNull(value)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> anyOf(Constructor<?> ... value) {
        return ElementMatchers.definedMethod(ElementMatchers.anyOf(new MethodList.ForLoadedType(ByteBuddyCommons.nonNull(value), new Method[0])));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> anyOf(Method ... value) {
        return ElementMatchers.definedMethod(ElementMatchers.anyOf(new MethodList.ForLoadedType(new Constructor[0], ByteBuddyCommons.nonNull(value))));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> anyOf(Field ... value) {
        return ElementMatchers.definedField(ElementMatchers.anyOf(new FieldList.ForLoadedField(ByteBuddyCommons.nonNull(value))));
    }

    public static <T extends AnnotationDescription> ElementMatcher.Junction<T> anyOf(Annotation ... value) {
        return ElementMatchers.anyOf(new AnnotationList.ForLoadedAnnotation(ByteBuddyCommons.nonNull(value)));
    }

    public static <T> ElementMatcher.Junction<T> noneOf(Object ... value) {
        return ElementMatchers.noneOf(Arrays.asList(value));
    }

    public static <T> ElementMatcher.Junction<T> noneOf(Iterable<?> values) {
        ElementMatcher.Junction<T> matcher = ElementMatchers.any();
        for (Object value : values) {
            matcher = matcher.and(ElementMatchers.not(ElementMatchers.is(value)));
        }
        return matcher;
    }

    public static <T extends GenericTypeDescription> ElementMatcher.Junction<T> noneOf(Type ... value) {
        return ElementMatchers.noneOf(new GenericTypeList.ForLoadedType(ByteBuddyCommons.nonNull(value)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> noneOf(Constructor<?> ... value) {
        return ElementMatchers.definedMethod(ElementMatchers.noneOf(new MethodList.ForLoadedType(ByteBuddyCommons.nonNull(value), new Method[0])));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> noneOf(Method ... value) {
        return ElementMatchers.definedMethod(ElementMatchers.noneOf(new MethodList.ForLoadedType(new Constructor[0], ByteBuddyCommons.nonNull(value))));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> noneOf(Field ... value) {
        return ElementMatchers.definedField(ElementMatchers.noneOf(new FieldList.ForLoadedField(ByteBuddyCommons.nonNull(value))));
    }

    public static <T extends AnnotationDescription> ElementMatcher.Junction<T> noneOf(Annotation ... value) {
        return ElementMatchers.noneOf(new AnnotationList.ForLoadedAnnotation(ByteBuddyCommons.nonNull(value)));
    }

    public static <T> ElementMatcher.Junction<Iterable<? extends T>> whereAny(ElementMatcher<? super T> matcher) {
        return new CollectionItemMatcher<T>(matcher);
    }

    public static <T> ElementMatcher.Junction<Iterable<? extends T>> whereNone(ElementMatcher<? super T> matcher) {
        return ElementMatchers.not(ElementMatchers.whereAny(matcher));
    }

    public static <T extends GenericTypeDescription> ElementMatcher.Junction<T> rawType(Class<?> type) {
        return ElementMatchers.rawType(ElementMatchers.is(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends GenericTypeDescription> ElementMatcher.Junction<T> rawType(TypeDescription typeDescription) {
        return ElementMatchers.rawType(ElementMatchers.is(ByteBuddyCommons.nonNull(typeDescription)));
    }

    public static <T extends GenericTypeDescription> ElementMatcher.Junction<T> rawType(ElementMatcher<? super TypeDescription> matcher) {
        return new RawTypeMatcher(ByteBuddyCommons.nonNull(matcher));
    }

    public static <T extends Iterable<? extends GenericTypeDescription>> ElementMatcher.Junction<T> rawTypes(Class<?> ... type) {
        return ElementMatchers.rawTypes(new TypeList.ForLoadedType(type));
    }

    public static <T extends Iterable<? extends GenericTypeDescription>> ElementMatcher.Junction<T> rawTypes(TypeDescription ... typeDescription) {
        return ElementMatchers.rawTypes(Arrays.asList(typeDescription));
    }

    public static <T extends Iterable<? extends GenericTypeDescription>> ElementMatcher.Junction<T> rawTypes(Iterable<? extends TypeDescription> typeDescriptions) {
        LinkedList<ElementMatcher.Junction<T>> typeMatchers = new LinkedList<ElementMatcher.Junction<T>>();
        for (GenericTypeDescription genericTypeDescription : typeDescriptions) {
            typeMatchers.add(ElementMatchers.is(ByteBuddyCommons.nonNull(genericTypeDescription)));
        }
        return ElementMatchers.rawTypes(new CollectionOneToOneMatcher(typeMatchers));
    }

    public static <T extends Iterable<? extends GenericTypeDescription>> ElementMatcher.Junction<T> rawTypes(ElementMatcher<? super Iterable<? extends TypeDescription>> matcher) {
        return new CollectionRawTypeMatcher(matcher);
    }

    public static <T extends GenericTypeDescription> ElementMatcher<T> isVariable(String symbol) {
        return ElementMatchers.isVariable(ElementMatchers.named(ByteBuddyCommons.nonNull(symbol)));
    }

    public static <T extends GenericTypeDescription> ElementMatcher<T> isVariable(ElementMatcher<? super NamedElement> matcher) {
        return new TypeSortMatcher(ElementMatchers.anyOf(new Object[]{GenericTypeDescription.Sort.VARIABLE, GenericTypeDescription.Sort.VARIABLE_DETACHED, GenericTypeDescription.Sort.VARIABLE_SYMBOLIC})).and(matcher);
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> named(String name) {
        return new NameMatcher(new StringMatcher(ByteBuddyCommons.nonNull(name), StringMatcher.Mode.EQUALS_FULLY));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> namedIgnoreCase(String name) {
        return new NameMatcher(new StringMatcher(ByteBuddyCommons.nonNull(name), StringMatcher.Mode.EQUALS_FULLY_IGNORE_CASE));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameStartsWith(String prefix) {
        return new NameMatcher(new StringMatcher(ByteBuddyCommons.nonNull(prefix), StringMatcher.Mode.STARTS_WITH));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameStartsWithIgnoreCase(String prefix) {
        return new NameMatcher(new StringMatcher(ByteBuddyCommons.nonNull(prefix), StringMatcher.Mode.STARTS_WITH_IGNORE_CASE));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameEndsWith(String suffix) {
        return new NameMatcher(new StringMatcher(ByteBuddyCommons.nonNull(suffix), StringMatcher.Mode.ENDS_WITH));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameEndsWithIgnoreCase(String suffix) {
        return new NameMatcher(new StringMatcher(ByteBuddyCommons.nonNull(suffix), StringMatcher.Mode.ENDS_WITH_IGNORE_CASE));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameContains(String infix) {
        return new NameMatcher(new StringMatcher(ByteBuddyCommons.nonNull(infix), StringMatcher.Mode.CONTAINS));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameContainsIgnoreCase(String infix) {
        return new NameMatcher(new StringMatcher(ByteBuddyCommons.nonNull(infix), StringMatcher.Mode.CONTAINS_IGNORE_CASE));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameMatches(String regex) {
        return new NameMatcher(new StringMatcher(ByteBuddyCommons.nonNull(regex), StringMatcher.Mode.MATCHES));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> hasDescriptor(String descriptor) {
        return new DescriptorMatcher(new StringMatcher(ByteBuddyCommons.nonNull(descriptor), StringMatcher.Mode.EQUALS_FULLY));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isDeclaredBy(Class<?> type) {
        return ElementMatchers.isDeclaredBy(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isDeclaredBy(TypeDescription type) {
        return ElementMatchers.isDeclaredBy(ElementMatchers.is(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isDeclaredBy(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.isDeclaredByGeneric(ElementMatchers.rawType(ByteBuddyCommons.nonNull(matcher)));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isDeclaredByGeneric(Type type) {
        return ElementMatchers.isDeclaredByGeneric(GenericTypeDescription.Sort.describe(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isDeclaredByGeneric(GenericTypeDescription type) {
        return ElementMatchers.isDeclaredByGeneric(ElementMatchers.is(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isDeclaredByGeneric(ElementMatcher<? super GenericTypeDescription> matcher) {
        return new DeclaringTypeMatcher(ByteBuddyCommons.nonNull(matcher));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isVisibleTo(Class<?> type) {
        return ElementMatchers.isVisibleTo(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isVisibleTo(TypeDescription typeDescription) {
        return new VisibilityMatcher(ByteBuddyCommons.nonNull(typeDescription));
    }

    public static <T extends ModifierReviewable> ElementMatcher.Junction<T> isAbstract() {
        return new ModifierMatcher(ModifierMatcher.Mode.ABSTRACT);
    }

    public static <T extends AnnotatedCodeElement> ElementMatcher.Junction<T> isAnnotatedWith(Class<? extends Annotation> type) {
        return ElementMatchers.isAnnotatedWith(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends AnnotatedCodeElement> ElementMatcher.Junction<T> isAnnotatedWith(TypeDescription typeDescription) {
        return ElementMatchers.isAnnotatedWith(ElementMatchers.is(typeDescription));
    }

    public static <T extends AnnotatedCodeElement> ElementMatcher.Junction<T> isAnnotatedWith(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.declaresAnnotation(new AnnotationTypeMatcher(ByteBuddyCommons.nonNull(matcher)));
    }

    public static <T extends AnnotatedCodeElement> ElementMatcher.Junction<T> declaresAnnotation(ElementMatcher<? super AnnotationDescription> matcher) {
        return new DeclaringAnnotationMatcher(new CollectionItemMatcher<AnnotationDescription>(ByteBuddyCommons.nonNull(matcher)));
    }

    public static <T extends ModifierReviewable> ElementMatcher.Junction<T> isPublic() {
        return new ModifierMatcher(ModifierMatcher.Mode.PUBLIC);
    }

    public static <T extends ModifierReviewable> ElementMatcher.Junction<T> isProtected() {
        return new ModifierMatcher(ModifierMatcher.Mode.PROTECTED);
    }

    public static <T extends ModifierReviewable> ElementMatcher.Junction<T> isPackagePrivate() {
        return ElementMatchers.not(ElementMatchers.isPublic().or(ElementMatchers.<T>isProtected()).or(ElementMatchers.<T>isPrivate()));
    }

    public static <T extends ModifierReviewable> ElementMatcher.Junction<T> isPrivate() {
        return new ModifierMatcher(ModifierMatcher.Mode.PRIVATE);
    }

    public static <T extends ModifierReviewable> ElementMatcher.Junction<T> isFinal() {
        return new ModifierMatcher(ModifierMatcher.Mode.FINAL);
    }

    public static <T extends ModifierReviewable> ElementMatcher.Junction<T> isStatic() {
        return new ModifierMatcher(ModifierMatcher.Mode.STATIC);
    }

    public static <T extends ModifierReviewable> ElementMatcher.Junction<T> isSynthetic() {
        return new ModifierMatcher(ModifierMatcher.Mode.SYNTHETIC);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isSynchronized() {
        return new ModifierMatcher(ModifierMatcher.Mode.SYNCHRONIZED);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isNative() {
        return new ModifierMatcher(ModifierMatcher.Mode.NATIVE);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isStrict() {
        return new ModifierMatcher(ModifierMatcher.Mode.STRICT);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isVarArgs() {
        return new ModifierMatcher(ModifierMatcher.Mode.VAR_ARGS);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isBridge() {
        return new ModifierMatcher(ModifierMatcher.Mode.BRIDGE);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> returnsGeneric(Type type) {
        return ElementMatchers.returnsGeneric(GenericTypeDescription.Sort.describe(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> returnsGeneric(GenericTypeDescription typeDescription) {
        return ElementMatchers.returnsGeneric(ElementMatchers.is(ByteBuddyCommons.nonNull(typeDescription)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> returns(Class<?> type) {
        return ElementMatchers.returnsGeneric(ElementMatchers.rawType(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> returns(TypeDescription typeDescription) {
        return ElementMatchers.returns(ElementMatchers.is(ByteBuddyCommons.nonNull(typeDescription)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> returns(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.returnsGeneric(ElementMatchers.rawType(ByteBuddyCommons.nonNull(matcher)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> returnsGeneric(ElementMatcher<? super GenericTypeDescription> matcher) {
        return new MethodReturnTypeMatcher(ByteBuddyCommons.nonNull(matcher));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesGenericArguments(Type ... type) {
        return ElementMatchers.takesGenericArguments(new GenericTypeList.ForLoadedType(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesGenericArguments(GenericTypeDescription ... typeDescription) {
        return ElementMatchers.takesGenericArguments(Arrays.asList(ByteBuddyCommons.nonNull(typeDescription)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesGenericArguments(List<? extends GenericTypeDescription> typeDescriptions) {
        LinkedList<ElementMatcher.Junction<T>> typeMatchers = new LinkedList<ElementMatcher.Junction<T>>();
        for (GenericTypeDescription genericTypeDescription : typeDescriptions) {
            typeMatchers.add(ElementMatchers.is(ByteBuddyCommons.nonNull(genericTypeDescription)));
        }
        return ElementMatchers.takesGenericArguments(new CollectionOneToOneMatcher(typeMatchers));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesGenericArguments(ElementMatcher<? super Iterable<? extends GenericTypeDescription>> matchers) {
        return new MethodParametersMatcher(new MethodParameterTypesMatcher(ByteBuddyCommons.nonNull(matchers)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesArguments(Class<?> ... type) {
        return ElementMatchers.takesGenericArguments(ElementMatchers.rawTypes(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesArguments(TypeDescription ... typeDescription) {
        return ElementMatchers.takesGenericArguments(ElementMatchers.rawTypes(ByteBuddyCommons.nonNull(typeDescription)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesArguments(Iterable<? extends TypeDescription> typeDescriptions) {
        LinkedList<ElementMatcher.Junction<T>> typeMatchers = new LinkedList<ElementMatcher.Junction<T>>();
        for (TypeDescription typeDescription : typeDescriptions) {
            typeMatchers.add(ElementMatchers.rawType(ByteBuddyCommons.nonNull(typeDescription)));
        }
        return ElementMatchers.takesGenericArguments(new CollectionOneToOneMatcher(typeMatchers));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesArguments(int length) {
        return new MethodParametersMatcher(new CollectionSizeMatcher(length));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> hasParameters(ElementMatcher<? super Iterable<? extends ParameterDescription>> matcher) {
        return new MethodParametersMatcher(ByteBuddyCommons.nonNull(matcher));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> canThrow(Class<? extends Throwable> exceptionType) {
        return ElementMatchers.canThrow(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(exceptionType)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> canThrow(TypeDescription exceptionType) {
        return exceptionType.isAssignableTo(RuntimeException.class) || exceptionType.isAssignableTo(Error.class) ? new BooleanMatcher(true) : ElementMatchers.declaresGenericException(new CollectionItemMatcher<T>(ElementMatchers.rawType(ElementMatchers.isSuperTypeOf(exceptionType))));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> declaresGenericException(Type exceptionType) {
        return ElementMatchers.declaresGenericException(GenericTypeDescription.Sort.describe(exceptionType));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> declaresGenericException(GenericTypeDescription exceptionType) {
        return !exceptionType.getSort().isWildcard() && exceptionType.asErasure().isAssignableTo(Throwable.class) ? ElementMatchers.declaresGenericException(new CollectionItemMatcher<T>(ElementMatchers.is(exceptionType))) : new BooleanMatcher(false);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> declaresException(Class<? extends Throwable> exceptionType) {
        return ElementMatchers.declaresException(new TypeDescription.ForLoadedType(exceptionType));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> declaresException(TypeDescription exceptionType) {
        return !exceptionType.getSort().isWildcard() && exceptionType.asErasure().isAssignableTo(Throwable.class) ? ElementMatchers.declaresGenericException(new CollectionItemMatcher<T>(ElementMatchers.rawType(exceptionType))) : new BooleanMatcher(false);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> declaresGenericException(ElementMatcher<? super Iterable<? extends GenericTypeDescription>> exceptionMatcher) {
        return new MethodExceptionTypeMatcher(ByteBuddyCommons.nonNull(exceptionMatcher));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> isInterface() {
        return new ModifierMatcher(ModifierMatcher.Mode.INTERFACE);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isMethod() {
        return new MethodSortMatcher(MethodSortMatcher.Sort.METHOD);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isConstructor() {
        return new MethodSortMatcher(MethodSortMatcher.Sort.CONSTRUCTOR);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isTypeInitializer() {
        return new MethodSortMatcher(MethodSortMatcher.Sort.TYPE_INITIALIZER);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isVirtual() {
        return new MethodSortMatcher(MethodSortMatcher.Sort.VIRTUAL);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isDefaultMethod() {
        return new MethodSortMatcher(MethodSortMatcher.Sort.DEFAULT_METHOD);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isDefaultConstructor() {
        return ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(0));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isDefaultFinalizer() {
        return ElementMatchers.isFinalizer().and(ElementMatchers.isDeclaredBy(TypeDescription.OBJECT));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isFinalizer() {
        return ElementMatchers.named("finalize").and(ElementMatchers.takesArguments(0)).and(ElementMatchers.returns(TypeDescription.VOID));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isHashCode() {
        return ElementMatchers.named("hashCode").and(ElementMatchers.takesArguments(0)).and(ElementMatchers.returns(Integer.TYPE));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isEquals() {
        return ElementMatchers.named("equals").and(ElementMatchers.takesArguments(TypeDescription.OBJECT)).and(ElementMatchers.returns(Boolean.TYPE));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isClone() {
        return ElementMatchers.named("clone").and(ElementMatchers.takesArguments(0)).and(ElementMatchers.returns(TypeDescription.OBJECT));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isToString() {
        return ElementMatchers.named("toString").and(ElementMatchers.takesArguments(0)).and(ElementMatchers.returns(TypeDescription.STRING));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isSetter() {
        return ElementMatchers.nameStartsWith("set").and(ElementMatchers.takesArguments(1)).and(ElementMatchers.returns(TypeDescription.VOID));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isSetter(Type type) {
        return ElementMatchers.isSetter(GenericTypeDescription.Sort.describe(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isSetter(GenericTypeDescription typeDescription) {
        return ElementMatchers.isSetter(ElementMatchers.is(ByteBuddyCommons.nonNull(typeDescription)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isSetter(ElementMatcher<? super GenericTypeDescription> matcher) {
        return ElementMatchers.isSetter().and(ElementMatchers.takesGenericArguments(new CollectionOneToOneMatcher<GenericTypeDescription>(Collections.singletonList(ByteBuddyCommons.nonNull(matcher)))));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGetter() {
        return ElementMatchers.takesArguments(0).and(ElementMatchers.not(ElementMatchers.returns(TypeDescription.VOID))).and(ElementMatchers.nameStartsWith("get").or(ElementMatchers.nameStartsWith("is").and(ElementMatchers.returnsGeneric(ElementMatchers.anyOf(new Type[]{Boolean.TYPE, Boolean.class})))));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGetter(Type type) {
        return ElementMatchers.isGetter(GenericTypeDescription.Sort.describe(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGetter(GenericTypeDescription typeDescription) {
        return ElementMatchers.isGetter(ElementMatchers.is(ByteBuddyCommons.nonNull(typeDescription)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGetter(ElementMatcher<? super GenericTypeDescription> matcher) {
        return ElementMatchers.isGetter().and(ElementMatchers.returnsGeneric(ByteBuddyCommons.nonNull(matcher)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> hasMethodName(String internalName) {
        if ("<init>".equals(internalName)) {
            return ElementMatchers.isConstructor();
        }
        if ("<clinit>".equals(internalName)) {
            return ElementMatchers.isTypeInitializer();
        }
        return ElementMatchers.named(internalName);
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> isSubTypeOf(Class<?> type) {
        return ElementMatchers.isSubTypeOf(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> isSubTypeOf(TypeDescription typeDescription) {
        return new SubTypeMatcher(ByteBuddyCommons.nonNull(typeDescription));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> isSuperTypeOf(Class<?> type) {
        return ElementMatchers.isSuperTypeOf(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> isSuperTypeOf(TypeDescription typeDescription) {
        return new SuperTypeMatcher(ByteBuddyCommons.nonNull(typeDescription));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> inheritsAnnotation(Class<?> type) {
        return ElementMatchers.inheritsAnnotation(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> inheritsAnnotation(TypeDescription typeDescription) {
        return ElementMatchers.inheritsAnnotation(ElementMatchers.is(ByteBuddyCommons.nonNull(typeDescription)));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> inheritsAnnotation(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.hasAnnotation(new AnnotationTypeMatcher(ByteBuddyCommons.nonNull(matcher)));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> hasAnnotation(ElementMatcher<? super AnnotationDescription> matcher) {
        return new InheritedAnnotationMatcher(new CollectionItemMatcher<AnnotationDescription>(ByteBuddyCommons.nonNull(matcher)));
    }

    public static <T extends GenericTypeDescription> ElementMatcher.Junction<T> declaresField(ElementMatcher<? super FieldDescription> fieldMatcher) {
        return new DeclaringFieldMatcher(new CollectionItemMatcher<FieldDescription>(ByteBuddyCommons.nonNull(fieldMatcher)));
    }

    public static <T extends GenericTypeDescription> ElementMatcher.Junction<T> declaresMethod(ElementMatcher<? super MethodDescription> methodMatcher) {
        return new DeclaringMethodMatcher(new CollectionItemMatcher<MethodDescription>(ByteBuddyCommons.nonNull(methodMatcher)));
    }

    public static <T extends GenericTypeDescription> ElementMatcher.Junction<T> ofSort(GenericTypeDescription.Sort sort) {
        return ElementMatchers.ofSort(ElementMatchers.is((Object)ByteBuddyCommons.nonNull(sort)));
    }

    public static <T extends GenericTypeDescription> ElementMatcher.Junction<T> ofSort(ElementMatcher<? super GenericTypeDescription.Sort> matcher) {
        return new TypeSortMatcher(ByteBuddyCommons.nonNull(matcher));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> genericFieldType(Type fieldType) {
        return ElementMatchers.genericFieldType(GenericTypeDescription.Sort.describe(fieldType));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> genericFieldType(GenericTypeDescription fieldType) {
        return ElementMatchers.genericFieldType(ElementMatchers.is(ByteBuddyCommons.nonNull(fieldType)));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> genericFieldType(ElementMatcher<? super GenericTypeDescription> matcher) {
        return new FieldTypeMatcher(ByteBuddyCommons.nonNull(matcher));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> fieldType(Class<?> fieldType) {
        return ElementMatchers.fieldType(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(fieldType)));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> fieldType(TypeDescription fieldType) {
        return ElementMatchers.fieldType(ElementMatchers.is(ByteBuddyCommons.nonNull(fieldType)));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> fieldType(ElementMatcher<? super GenericTypeDescription> matcher) {
        return ElementMatchers.genericFieldType(ElementMatchers.rawType(ByteBuddyCommons.nonNull(matcher)));
    }

    public static <T extends ClassLoader> ElementMatcher<T> isBootstrapClassLoader() {
        return new NullMatcher();
    }

    public static <T extends ClassLoader> ElementMatcher<T> isSystemClassLoader() {
        return new EqualityMatcher(ClassLoader.getSystemClassLoader());
    }

    public static <T extends ClassLoader> ElementMatcher<T> isExtensionClassLoader() {
        return new EqualityMatcher(ClassLoader.getSystemClassLoader().getParent());
    }

    public static <T extends ClassLoader> ElementMatcher<T> isChildOf(ClassLoader classLoader) {
        return classLoader == BOOTSTRAP_CLASSLOADER ? new BooleanMatcher(true) : ElementMatchers.hasChild(ElementMatchers.is(classLoader));
    }

    public static <T extends ClassLoader> ElementMatcher<T> hasChild(ElementMatcher<? super ClassLoader> matcher) {
        return new ClassLoaderHierarchyMatcher(ByteBuddyCommons.nonNull(matcher));
    }

    public static <T extends ClassLoader> ElementMatcher<T> isParentOf(ClassLoader classLoader) {
        return classLoader == BOOTSTRAP_CLASSLOADER ? ElementMatchers.isBootstrapClassLoader() : new ClassLoaderParentMatcher(classLoader);
    }
}

