/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility;

import java.io.InputStream;
import java.lang.reflect.AnnotatedElement;
import java.security.AccessController;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.annotation.AnnotationSource;
import net.bytebuddy.description.type.PackageDescription;
import net.bytebuddy.utility.JavaDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaModule
implements NamedElement.WithOptionalName,
AnnotationSource {
    public static final JavaModule UNSUPPORTED = null;
    protected static final Resolver RESOLVER = AccessController.doPrivileged(JavaDispatcher.of(Resolver.class));
    protected static final Module MODULE = AccessController.doPrivileged(JavaDispatcher.of(Module.class));
    private final AnnotatedElement module;

    protected JavaModule(AnnotatedElement module) {
        this.module = module;
    }

    public static JavaModule ofType(Class<?> type) {
        Object module = RESOLVER.getModule(type);
        return module == null ? UNSUPPORTED : new JavaModule((AnnotatedElement)module);
    }

    public static JavaModule of(Object module) {
        if (!MODULE.isInstance(module)) {
            throw new IllegalArgumentException("Not a Java module: " + module);
        }
        return new JavaModule((AnnotatedElement)module);
    }

    public static boolean isSupported() {
        return ClassFileVersion.ofThisVm().isAtLeast(ClassFileVersion.JAVA_V9);
    }

    @Override
    public boolean isNamed() {
        return MODULE.isNamed(this.module);
    }

    @Override
    public String getActualName() {
        return MODULE.getName(this.module);
    }

    public InputStream getResourceAsStream(String name) {
        return MODULE.getResourceAsStream(this.module, name);
    }

    public ClassLoader getClassLoader() {
        return MODULE.getClassLoader(this.module);
    }

    public Object unwrap() {
        return this.module;
    }

    public boolean canRead(JavaModule module) {
        return MODULE.canRead(this.module, module.unwrap());
    }

    public boolean isExported(PackageDescription packageDescription, JavaModule module) {
        return packageDescription == null || MODULE.isExported(this.module, packageDescription.getName(), module.unwrap());
    }

    public boolean isOpened(PackageDescription packageDescription, JavaModule module) {
        return packageDescription == null || MODULE.isOpen(this.module, packageDescription.getName(), module.unwrap());
    }

    @Override
    public AnnotationList getDeclaredAnnotations() {
        return new AnnotationList.ForLoadedAnnotations(this.module.getDeclaredAnnotations());
    }

    public int hashCode() {
        return this.module.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JavaModule)) {
            return false;
        }
        JavaModule javaModule = (JavaModule)other;
        return this.module.equals(javaModule.module);
    }

    public String toString() {
        return this.module.toString();
    }

    @JavaDispatcher.Proxied(value="java.lang.Module")
    protected static interface Module {
        @JavaDispatcher.Instance
        public boolean isInstance(Object var1);

        public boolean isNamed(Object var1);

        public String getName(Object var1);

        public InputStream getResourceAsStream(Object var1, String var2);

        public ClassLoader getClassLoader(Object var1);

        public boolean isExported(Object var1, String var2, @JavaDispatcher.Proxied(value="java.lang.Module") Object var3);

        public boolean isOpen(Object var1, String var2, @JavaDispatcher.Proxied(value="java.lang.Module") Object var3);

        public boolean canRead(Object var1, @JavaDispatcher.Proxied(value="java.lang.Module") Object var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JavaDispatcher.Proxied(value="java.lang.Class")
    protected static interface Resolver {
        @JavaDispatcher.Defaults
        public Object getModule(Class<?> var1);
    }
}

