/*
 * Decompiled with CFR 0.152.
 */
package net.rootdev.javardfa.uri;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import net.rootdev.javardfa.Constants;
import net.rootdev.javardfa.EvalContext;
import net.rootdev.javardfa.Resolver;
import net.rootdev.javardfa.Setting;
import net.rootdev.javardfa.uri.URIExtractor;

public class URIExtractor10
implements URIExtractor {
    private Set<Setting> settings;
    private final Resolver resolver;

    public URIExtractor10(Resolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void setSettings(Set<Setting> settings) {
        this.settings = settings;
    }

    @Override
    public String getURI(StartElement element, QName attrName, EvalContext context) {
        Attribute attr = element.getAttributeByName(attrName);
        if (attr == null) {
            return null;
        }
        if (attrName.equals(Constants.href) || attrName.equals(Constants.src)) {
            if (attr.getValue().length() == 0) {
                return context.getBase();
            }
            return this.resolver.resolve(context.getBase(), attr.getValue());
        }
        if (attrName.equals(Constants.about) || attrName.equals(Constants.resource)) {
            return this.expandSafeCURIE(element, attr.getValue(), context);
        }
        if (attrName.equals(Constants.datatype)) {
            String val = attr.getValue();
            if (val.length() == 0) {
                return "";
            }
            return this.expandCURIE(element, attr.getValue(), context);
        }
        throw new RuntimeException("Unexpected attribute: " + attr);
    }

    @Override
    public List<String> getURIs(StartElement element, QName attrName, EvalContext context) {
        Attribute attr = element.getAttributeByName(attrName);
        if (attr == null) {
            return null;
        }
        LinkedList<String> uris = new LinkedList<String>();
        String[] curies = attr.getValue().split("\\s+");
        boolean permitReserved = Constants.rel.equals(attr.getName()) || Constants.rev.equals(attr.getName());
        for (String curie : curies) {
            if (Constants.SpecialRels.contains(curie.toLowerCase())) {
                if (!permitReserved) continue;
                uris.add("http://www.w3.org/1999/xhtml/vocab#" + curie.toLowerCase());
                continue;
            }
            String uri = this.expandCURIE(element, curie, context);
            if (uri == null) continue;
            uris.add(uri);
        }
        return uris;
    }

    public String expandCURIE(StartElement element, String value, EvalContext context) {
        String namespaceURI;
        if (value.startsWith("_:")) {
            if (!this.settings.contains((Object)Setting.ManualNamespaces)) {
                return value;
            }
            if (element.getNamespaceURI("_") == null) {
                return value;
            }
        }
        if (this.settings.contains((Object)Setting.FormMode) && value.startsWith("?")) {
            return value;
        }
        int offset = value.indexOf(":") + 1;
        if (offset == 0) {
            return null;
        }
        String prefix = value.substring(0, offset - 1);
        if ("xml".equals(prefix) || "xmlns".equals(prefix)) {
            return null;
        }
        String string = namespaceURI = prefix.length() == 0 ? "http://www.w3.org/1999/xhtml/vocab#" : element.getNamespaceURI(prefix);
        if (namespaceURI == null) {
            return null;
        }
        return namespaceURI + value.substring(offset);
    }

    public String expandSafeCURIE(StartElement element, String value, EvalContext context) {
        if (value.startsWith("[") && value.endsWith("]")) {
            return this.expandCURIE(element, value.substring(1, value.length() - 1), context);
        }
        if (value.length() == 0) {
            return context.getBase();
        }
        if (this.settings.contains((Object)Setting.FormMode) && value.startsWith("?")) {
            return value;
        }
        return this.resolver.resolve(context.getBase(), value);
    }

    @Override
    public String resolveURI(String uri, EvalContext context) {
        return this.resolver.resolve(context.getBase(), uri);
    }
}

