/*
 * Decompiled with CFR 0.152.
 */
package DTDDoc;

import DTDDoc.AntLogger;
import DTDDoc.DTDCommenter;
import DTDDoc.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;

public class DTDDocTask
extends MatchingTask {
    private boolean showHiddenTags = false;
    private boolean showFixmeTags = true;
    private boolean getAroundNetBeansComments = true;
    private boolean sourceDirSet = false;
    private File sourceDir = new File(".");
    private File destDir = new File(".");
    private String docTitle = "";
    private File styleSheet = null;
    private List filesets = new ArrayList();
    private Logger log = new AntLogger((Task)this);

    public void setShowHiddenTags(boolean f) {
        this.showHiddenTags = f;
    }

    public void setShowFixmeTags(boolean f) {
        this.showFixmeTags = f;
    }

    public void setGetAroundNetBeansComments(boolean f) {
        this.getAroundNetBeansComments = f;
    }

    public void setSourceDir(File f) {
        this.sourceDir = f;
        this.sourceDirSet = true;
    }

    public void setDir(File dir) {
        this.setSourceDir(dir);
    }

    public void setFile(File file) {
        this.setSourceDir(file.getParentFile());
        this.setIncludes(file.getName());
    }

    public void setDestDir(File f) {
        this.destDir = f;
    }

    public void setDocTitle(String s) {
        this.docTitle = s;
    }

    public void setStyleSheet(File f) {
        if (f.canRead()) {
            this.styleSheet = f;
        } else {
            this.log.warn("Sorry, the style sheet '" + f + "' was not" + " found. I'll use the default one instead.");
        }
    }

    public void addFileset(FileSet fileset) {
        this.filesets.add(fileset);
    }

    private void scanDirectory(DirectoryScanner scanner, File sDir, Set hfiles) {
        String[] files = scanner.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            hfiles.add(new File(sDir, files[i]));
        }
    }

    public void execute() throws BuildException {
        this.log.info("Welcome to DTDDoc " + DTDCommenter.VERSION + ".");
        this.log.info("Parts of this program are from DTDParser and RegExp of the Apache Project.");
        this.log.info("The settings are :");
        this.log.info("   " + (this.showHiddenTags ? "Show" : "Don't show") + " @hidden tags.");
        this.log.info("   " + (this.showFixmeTags ? "Show" : "Don't show") + " @fixme tags.");
        if (this.styleSheet != null) {
            this.log.info("   Style sheet source is '" + this.styleSheet.getPath() + "'.");
        } else {
            this.log.info("   No style sheet was specified.");
        }
        try {
            this.log.info("   Source directory is '" + this.sourceDir.getCanonicalPath() + "'.");
            this.log.info("   Destination directory is '" + this.destDir.getCanonicalPath() + "'.");
        }
        catch (IOException ex) {
            this.log.error("Something went wrong while figuring out the source/dest directories paths.", ex);
            return;
        }
        DirectoryScanner scanner = this.getDirectoryScanner(this.sourceDir);
        String[] files = scanner.getIncludedFiles();
        if (files.length == 0) {
            this.log.error(" No files to process ! Please note that you have to specify which files to include with the <include> tags. There's no automatic selection of all DTD's anymore (as of 0.0.7).");
        }
        HashSet scan = new HashSet();
        if (this.filesets.size() > 0) {
            if (this.sourceDirSet) {
                this.log.warn("When using filesets, the \"dir\" attribute of the file set has precedence over the \"sourceDir\" of the task.");
            }
            Iterator itFSets = this.filesets.iterator();
            while (itFSets.hasNext()) {
                FileSet fs = (FileSet)itFSets.next();
                this.scanDirectory(fs.getDirectoryScanner(this.getProject()), fs.getDir(this.getProject()), scan);
            }
        } else {
            this.scanDirectory(this.getDirectoryScanner(this.sourceDir), this.sourceDir, scan);
        }
        try {
            DTDCommenter commenter = new DTDCommenter(this.log);
            commenter.commentDTDs(scan, this.sourceDir, this.destDir, this.showHiddenTags, this.showFixmeTags, this.getAroundNetBeansComments, this.docTitle, this.styleSheet);
        }
        catch (Exception ex) {
            this.log.error("A problem occured while instanciating or executing the DTDDoc task !", ex);
            return;
        }
    }
}

