/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dtddoc.maven2;

import DTDDoc.DTDCommenter;
import DTDDoc.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.sf.dtddoc.maven2.MavenLogger;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class DTDDocReport
extends AbstractMavenReport {
    private File outputDirectory;
    private File sourceDirectory;
    private String[] includes;
    private String[] excludes;
    private boolean showHiddenTags = false;
    private boolean showFixmeTags = true;
    private boolean getAroundNetBeansComments = true;
    private String docTitle = "";
    private File styleSheet = null;
    protected Renderer siteRenderer;
    private MavenProject project;

    public String getName(Locale locale) {
        return "DTDDoc";
    }

    public String getDescription(Locale locale) {
        return "DTD documentation";
    }

    public String getOutputName() {
        return "dtddoc/index";
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsoluteFile().toString();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        this.executeReport(locale);
    }

    private List getDtdFiles() {
        if (!this.sourceDirectory.exists() || !this.sourceDirectory.isDirectory()) {
            return new ArrayList();
        }
        String includesAsString = "**/*.dtd";
        if (this.includes != null) {
            includesAsString = StringUtils.join((Object[])this.includes, (String)",");
        }
        String excludesAsString = "";
        if (this.excludes != null) {
            excludesAsString = StringUtils.join((Object[])this.excludes, (String)",");
        }
        try {
            return FileUtils.getFiles((File)this.sourceDirectory, (String)includesAsString, (String)excludesAsString, (boolean)true);
        }
        catch (IOException ioe) {
            this.getLog().warn((CharSequence)"unable to determine which DTDs to process", (Throwable)ioe);
            return new ArrayList();
        }
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        HashSet dtds = new HashSet(this.getDtdFiles());
        File dtddocDirectory = this.getReportOutputDirectory();
        if (!dtddocDirectory.getAbsolutePath().equals(this.getOutputDirectory())) {
            dtddocDirectory = new File(dtddocDirectory, "dtddoc");
        }
        dtddocDirectory.mkdirs();
        try {
            this.getLog().info((CharSequence)("documenting " + dtds.size() + " DTD(s), show @hidden tags: " + this.showHiddenTags + ", show @fixme tags: " + this.showFixmeTags));
            File commonBase = this.getCommonBase(this.sourceDirectory, dtds);
            if (!this.sourceDirectory.equals(commonBase)) {
                this.getLog().info((CharSequence)("sourceDirectory optimized as " + commonBase.getPath()));
            }
            DTDCommenter commenter = new DTDCommenter((Logger)new MavenLogger(this.getLog()));
            commenter.commentDTDs(dtds, commonBase, dtddocDirectory, this.showHiddenTags, this.showFixmeTags, this.getAroundNetBeansComments, this.docTitle, this.styleSheet);
        }
        catch (IOException ioe) {
            throw new MavenReportException("error while generating DTDDoc reports : " + ioe.getMessage(), (Exception)ioe);
        }
        catch (Exception e) {
            throw new MavenReportException("error while generating DTDDoc reports : " + e.getMessage(), e);
        }
    }

    public boolean isExternalReport() {
        return true;
    }

    public boolean canGenerateReport() {
        return this.getDtdFiles().size() > 0;
    }

    protected static File[] getFileHierarchy(File from, File to) {
        ArrayList<File> hierarchy = new ArrayList<File>();
        hierarchy.add(to);
        while (!to.equals(from)) {
            to = to.getParentFile();
            hierarchy.add(to);
        }
        Collections.reverse(hierarchy);
        File[] files = new File[hierarchy.size()];
        return hierarchy.toArray(files);
    }

    protected File getCommonBase(File sourceDirectory, Set files) {
        if (files.size() == 1) {
            return ((File)files.iterator().next()).getParentFile();
        }
        File[] base = null;
        Iterator iter = files.iterator();
        block0: while (iter.hasNext()) {
            File current = ((File)iter.next()).getParentFile();
            File[] currentHierarchy = DTDDocReport.getFileHierarchy(sourceDirectory, current);
            if (base == null) {
                base = currentHierarchy;
                continue;
            }
            int len = Math.min(base.length, currentHierarchy.length);
            ArrayList<File> newHierarchy = new ArrayList<File>();
            for (int i = 0; i < len; ++i) {
                File a = base[i];
                File b = currentHierarchy[i];
                if (!a.equals(b)) {
                    if (newHierarchy.size() == 1) {
                        return sourceDirectory;
                    }
                    base = new File[newHierarchy.size()];
                    newHierarchy.toArray(base);
                    continue block0;
                }
                newHierarchy.add(a);
            }
        }
        return base[base.length - 1];
    }
}

