/*
 * Decompiled with CFR 0.152.
 */
package com.wutka.dtd;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class DTDReader {
    private static final String XML_HEADER = "<?xml";
    private static final int XML_HEADER_MAX_LENGTH = 1000;
    private String encoding = null;

    private static boolean startsWith(InputStream inputStream, String string) throws IOException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("startsWith: null string to find");
        }
        int n = 0;
        int n2 = inputStream.read();
        while (n2 != -1 && n < string.length() && string.charAt(n) == n2) {
            n2 = inputStream.read();
            ++n;
        }
        return n == string.length();
    }

    private static void skipSpaces(PushbackInputStream pushbackInputStream) throws IOException {
        int n = pushbackInputStream.read();
        while (n != -1 && Character.isWhitespace((char)n)) {
            n = pushbackInputStream.read();
        }
        pushbackInputStream.unread(n);
    }

    private static String tokenize(PushbackInputStream pushbackInputStream, String string, boolean bl) throws IOException {
        String string2 = "";
        int n = pushbackInputStream.read();
        while (!(n == -1 || bl && Character.isWhitespace((char)n) || string.indexOf(n) != -1)) {
            string2 = string2 + (char)n;
            n = pushbackInputStream.read();
        }
        pushbackInputStream.unread(n);
        if (string2.length() == 0) {
            return null;
        }
        return string2;
    }

    private static boolean skipAndTest(InputStream inputStream, String string) throws IOException {
        return string.indexOf(inputStream.read()) != -1;
    }

    private static String getEncoding(PushbackInputStream pushbackInputStream) throws IOException {
        if (DTDReader.startsWith(pushbackInputStream, XML_HEADER)) {
            int n = -1;
            do {
                DTDReader.skipSpaces(pushbackInputStream);
                String string = DTDReader.tokenize(pushbackInputStream, "=", true);
                DTDReader.skipSpaces(pushbackInputStream);
                if (!DTDReader.skipAndTest(pushbackInputStream, "=")) {
                    return null;
                }
                DTDReader.skipSpaces(pushbackInputStream);
                if (!DTDReader.skipAndTest(pushbackInputStream, "'\"")) {
                    return null;
                }
                String string2 = DTDReader.tokenize(pushbackInputStream, "'\"", true);
                if (!DTDReader.skipAndTest(pushbackInputStream, "'\"")) {
                    return null;
                }
                if ("encoding".equals(string.toLowerCase())) {
                    return string2;
                }
                n = pushbackInputStream.read();
                pushbackInputStream.unread(n);
            } while ('?' != (char)n);
        }
        return null;
    }

    public String getEncoding() {
        return this.encoding;
    }

    Reader makeBufferedReader(InputStream inputStream) {
        try {
            if (inputStream != null) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                bufferedInputStream.mark(XML_HEADER.length());
                this.encoding = DTDReader.getEncoding(new PushbackInputStream(bufferedInputStream));
                try {
                    bufferedInputStream.reset();
                }
                catch (IOException iOException) {
                    System.out.println("makeBufferedReader() : Unable to reset stream !");
                }
                if (this.encoding != null) {
                    try {
                        return new BufferedReader(new InputStreamReader((InputStream)bufferedInputStream, this.encoding));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        System.out.println("Unable to get a proper reader : Unsupported encoding (" + this.encoding + ")");
                        return null;
                    }
                }
                return new BufferedReader(new InputStreamReader(bufferedInputStream));
            }
            return null;
        }
        catch (IOException iOException) {
            System.out.println("Unable to get a proper reader : " + iOException);
            return null;
        }
    }
}

