/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.ClassWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.compilers.JRGroovyGenerator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRAbstractJavaCompiler;
import net.sf.jasperreports.engine.design.JRCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRCompilationUnit;
import net.sf.jasperreports.engine.design.JRDefaultCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;

public class JRGroovyCompiler
extends JRAbstractJavaCompiler {
    protected static final String SOURCE_ENCODING = "UTF-8";
    public static final String EXCEPTION_MESSAGE_KEY_COMPILING_EXPRESSIONS_CLASS_FILE = "compilers.compiling.expressions.class.file";
    public static final String EXCEPTION_MESSAGE_KEY_TOO_FEW_CLASSES_GENERATED = "compilers.groovy.too.few.classes.generated";
    public static final String EXCEPTION_MESSAGE_KEY_TOO_MANY_CLASSES_GENERATED = "compilers.groovy.too.many.classes.generated";

    public JRGroovyCompiler(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext, false);
    }

    @Override
    protected String compileUnits(JRCompilationUnit[] units, String classpath, File tempDirFile) throws JRException {
        CompilerConfiguration config = new CompilerConfiguration();
        config.setSourceEncoding(SOURCE_ENCODING);
        CompilationUnit unit = new CompilationUnit(config);
        for (int i = 0; i < units.length; ++i) {
            try {
                byte[] sourceBytes = units[i].getSourceCode().getBytes(SOURCE_ENCODING);
                unit.addSource("calculator_" + units[i].getName(), (InputStream)new ByteArrayInputStream(sourceBytes));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new JRRuntimeException(e);
            }
        }
        ClassCollector collector = new ClassCollector();
        unit.setClassgenCallback((CompilationUnit.ClassgenCallback)collector);
        try {
            unit.compile(7);
        }
        catch (CompilationFailedException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_COMPILING_EXPRESSIONS_CLASS_FILE, new Object[]{e.toString()}, e);
        }
        if (collector.classes.size() < units.length) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_TOO_FEW_CLASSES_GENERATED, (Object[])null);
        }
        if (collector.classCount > units.length) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_TOO_MANY_CLASSES_GENERATED, (Object[])null);
        }
        for (int i = 0; i < units.length; ++i) {
            units[i].setCompileData((Serializable)collector.classes.get(units[i].getName()));
        }
        return null;
    }

    @Override
    protected void checkLanguage(String language) throws JRException {
        if (!"groovy".equals(language) && !"java".equals(language)) {
            throw new JRException("compilers.language.not.supported", new Object[]{language, "groovy", "java"});
        }
    }

    @Override
    protected JRCompilationSourceCode generateSourceCode(JRSourceCompileTask sourceTask) throws JRException {
        return new JRDefaultCompilationSourceCode(JRGroovyGenerator.generateClass(sourceTask), null);
    }

    @Override
    protected String getSourceFileName(String unitName) {
        return unitName + ".groovy";
    }

    private static class ClassCollector
    extends CompilationUnit.ClassgenCallback {
        public Map<String, byte[]> classes = new HashMap<String, byte[]>();
        public int classCount;

        private ClassCollector() {
        }

        public void call(ClassVisitor writer, ClassNode node) throws CompilationFailedException {
            ++this.classCount;
            String name = node.getName();
            if (!this.classes.containsKey(name)) {
                byte[] bytes = ((ClassWriter)writer).toByteArray();
                this.classes.put(name, bytes);
            }
        }
    }
}

