/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import jxl.CellView;
import jxl.SheetSettings;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.biff.DisplayFormat;
import jxl.format.Alignment;
import jxl.format.BoldStyle;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.Orientation;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;
import jxl.format.Pattern;
import jxl.format.RGB;
import jxl.format.UnderlineStyle;
import jxl.format.VerticalAlignment;
import jxl.read.biff.BiffException;
import jxl.write.Blank;
import jxl.write.Boolean;
import jxl.write.DateFormat;
import jxl.write.DateTime;
import jxl.write.Formula;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableHyperlink;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.CellValue;
import jxl.write.biff.RowsExceededException;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRCommonGraphicElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.Cut;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.GenericElementJExcelApiMetadataHandler;
import net.sf.jasperreports.engine.export.JExcelApiExporterContext;
import net.sf.jasperreports.engine.export.JExcelApiExporterNature;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.JRXlsAbstractMetadataExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterNature;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.XlsRowLevelInfo;
import net.sf.jasperreports.engine.export.data.BooleanTextValue;
import net.sf.jasperreports.engine.export.data.DateTextValue;
import net.sf.jasperreports.engine.export.data.NumberTextValue;
import net.sf.jasperreports.engine.export.data.StringTextValue;
import net.sf.jasperreports.engine.export.data.TextValue;
import net.sf.jasperreports.engine.export.data.TextValueHandler;
import net.sf.jasperreports.engine.export.type.ImageAnchorTypeEnum;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.util.ImageUtil;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.export.JxlExporterConfiguration;
import net.sf.jasperreports.export.JxlMetadataExporterConfiguration;
import net.sf.jasperreports.export.JxlMetadataReportConfiguration;
import net.sf.jasperreports.export.JxlReportConfiguration;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.renderers.DimensionRenderable;
import net.sf.jasperreports.renderers.Graphics2DRenderable;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.ResourceRenderer;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JExcelApiMetadataExporter
extends JRXlsAbstractMetadataExporter<JxlMetadataReportConfiguration, JxlMetadataExporterConfiguration, JExcelApiExporterContext> {
    private static final Log log = LogFactory.getLog(JExcelApiMetadataExporter.class);
    public static final String EXCEPTION_MESSAGE_KEY_CURRENT_SHEET_TOO_MANY_ROWS = "export.xls.current.sheet.too.many.rows";
    public static final String EXCEPTION_MESSAGE_KEY_SHEET_TOO_MANY_ROWS = "export.xls.sheet.too.many.rows";
    public static final String PROPERTY_USE_TEMP_FILE = "net.sf.jasperreports.export.jxl.use.temp.file";
    public static final String PROPERTY_COMPLEX_FORMAT = "net.sf.jasperreports.export.jxl.cell.complex.format";
    public static final String JXL_EXPORTER_KEY = "net.sf.jasperreports.jxl";
    protected static final Colour WHITE = Colour.WHITE;
    protected static final Colour BLACK = Colour.BLACK;
    protected static final String EMPTY_SHEET_NAME = "Sheet1";
    private static Map<Color, Colour> colorsCache = new ReferenceMap();
    private static final Colour[] FIXED_COLOURS = new Colour[]{WHITE, BLACK, Colour.PALETTE_BLACK, Colour.DEFAULT_BACKGROUND, Colour.DEFAULT_BACKGROUND1, Colour.AUTOMATIC, Colour.UNKNOWN};
    private Map<StyleInfo, WritableCellFormat> loadedCellStyles = new HashMap<StyleInfo, WritableCellFormat>();
    private WritableWorkbook workbook;
    private WritableSheet sheet;
    private Pattern backgroundMode = Pattern.SOLID;
    private Map<String, NumberFormat> numberFormats = new HashMap<String, NumberFormat>();
    private Map<String, DateFormat> dateFormats = new HashMap<String, DateFormat>();
    protected Map<Color, Colour> workbookColours = new HashMap<Color, Colour>();
    protected Map<Colour, RGB> usedColours = new HashMap<Colour, RGB>();
    protected ExporterNature nature;
    protected final java.text.DateFormat isoDateFormat = JRDataUtils.getIsoDateFormat();

    public JExcelApiMetadataExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JExcelApiMetadataExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.exporterContext = new ExporterContext();
    }

    @Override
    protected Class<JxlMetadataExporterConfiguration> getConfigurationInterface() {
        return JxlMetadataExporterConfiguration.class;
    }

    @Override
    protected Class<JxlMetadataReportConfiguration> getItemConfigurationInterface() {
        return JxlMetadataReportConfiguration.class;
    }

    @Override
    protected void initExport() {
        super.initExport();
        JxlMetadataExporterConfiguration configuration = (JxlMetadataExporterConfiguration)this.getCurrentConfiguration();
        if (configuration.isCreateCustomPalette().booleanValue()) {
            this.initCustomPalette();
        }
        this.sheet = null;
    }

    @Override
    protected void initReport() {
        super.initReport();
        JxlMetadataReportConfiguration configuration = (JxlMetadataReportConfiguration)this.getCurrentItemConfiguration();
        this.backgroundMode = configuration.isWhitePageBackground() != false ? Pattern.SOLID : Pattern.NONE;
        this.nature = new JExcelApiExporterNature(this.jasperReportsContext, this.filter, configuration.isIgnoreGraphics(), configuration.isIgnorePageMargins());
    }

    protected void initCustomPalette() {
        for (int i = 0; i < FIXED_COLOURS.length; ++i) {
            Colour colour = FIXED_COLOURS[i];
            this.setColourUsed(colour);
        }
    }

    protected void setColourUsed(Colour colour) {
        this.usedColours.put(colour, colour.getDefaultRGB());
    }

    protected void setColourUsed(Colour colour, Color reportColour) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Modifying palette colour " + colour.getValue() + " to " + reportColour));
        }
        int red = reportColour.getRed();
        int green = reportColour.getGreen();
        int blue = reportColour.getBlue();
        this.workbook.setColourRGB(colour, red, green, blue);
        RGB customRGB = new RGB(red, green, blue);
        this.usedColours.put(colour, customRGB);
    }

    @Override
    protected void openWorkbook(OutputStream os) throws JRException {
        JxlMetadataExporterConfiguration configuration = (JxlMetadataExporterConfiguration)this.getCurrentConfiguration();
        WorkbookSettings settings = new WorkbookSettings();
        settings.setUseTemporaryFileDuringWrite(configuration.isUseTempFile().booleanValue());
        InputStream templateIs = null;
        try {
            String lcWorkbookTemplate;
            String string = lcWorkbookTemplate = this.workbookTemplate == null ? configuration.getWorkbookTemplate() : this.workbookTemplate;
            if (lcWorkbookTemplate == null) {
                this.workbook = Workbook.createWorkbook((OutputStream)os, (WorkbookSettings)settings);
            } else {
                templateIs = RepositoryUtil.getInstance(this.jasperReportsContext).getInputStreamFromLocation(lcWorkbookTemplate);
                if (templateIs == null) {
                    throw new JRRuntimeException("export.xls.common.template.not.found", new Object[]{lcWorkbookTemplate});
                }
                Workbook template = Workbook.getWorkbook((InputStream)templateIs);
                this.workbook = Workbook.createWorkbook((OutputStream)os, (Workbook)template, (WorkbookSettings)settings);
                boolean keepSheets = this.keepTemplateSheets == null ? configuration.isKeepWorkbookTemplateSheets() : this.keepTemplateSheets;
                if (!keepSheets) {
                    for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
                        this.workbook.removeSheet(i);
                    }
                } else {
                    this.sheetIndex += this.workbook.getNumberOfSheets();
                }
            }
            this.firstPageNotSet = true;
        }
        catch (IOException e) {
            throw new JRException("export.xls.common.report.generation.error", new Object[]{this.jasperPrint.getName()}, e);
        }
        catch (BiffException e) {
            throw new JRException("export.xls.common.report.generation.error", new Object[]{this.jasperPrint.getName()}, e);
        }
        finally {
            if (templateIs != null) {
                try {
                    templateIs.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    protected void createSheet(JRXlsAbstractExporter.SheetInfo sheetInfo) {
        this.sheetInfo = sheetInfo;
        this.sheet = this.workbook.createSheet(sheetInfo.sheetName, Integer.MAX_VALUE);
        this.setSheetSettings(sheetInfo, this.sheet);
    }

    @Override
    protected void closeSheet() {
        if (this.sheet == null) {
            return;
        }
        if (this.sheetInfo.sheetPageScale != null && this.sheetInfo.sheetPageScale > 9 && this.sheetInfo.sheetPageScale < 401) {
            SheetSettings sheetSettings = this.sheet.getSettings();
            sheetSettings.setScaleFactor(this.sheetInfo.sheetPageScale.intValue());
            sheetSettings.setFitWidth(0);
            sheetSettings.setFitHeight(0);
            sheetSettings.setFitToPages(false);
        } else {
            JxlReportConfiguration configuration = (JxlReportConfiguration)this.getCurrentItemConfiguration();
            Integer fitWidth = configuration.getFitWidth();
            Integer fitHeight = configuration.getFitHeight();
            Integer n = fitHeight == null ? (java.lang.Boolean.TRUE == configuration.isAutoFitPageHeight() ? Integer.valueOf(this.pageIndex - this.sheetInfo.sheetFirstPageIndex) : null) : (fitHeight = fitHeight);
            if (fitWidth != null || fitWidth != null) {
                SheetSettings sheetSettings = this.sheet.getSettings();
                sheetSettings.setFitWidth(fitWidth == null ? 1 : fitWidth);
                sheetSettings.setFitHeight(fitHeight == null ? 1 : fitHeight);
                sheetSettings.setFitToPages(true);
            }
        }
    }

    @Override
    protected void closeWorkbook(OutputStream os) throws JRException {
        if (this.sheet == null) {
            this.workbook.createSheet(EMPTY_SHEET_NAME, Integer.MAX_VALUE);
        }
        try {
            this.workbook.write();
            this.workbook.close();
        }
        catch (IOException e) {
            throw new JRException("export.xls.common.report.generation.error", new Object[]{this.jasperPrint.getName()}, e);
        }
        catch (WriteException e) {
            throw new JRException("export.xls.common.report.generation.error", new Object[]{this.jasperPrint.getName()}, e);
        }
    }

    @Override
    protected void setColumnWidth(int col, int width, boolean autoFit) {
        CellView cv = new CellView();
        if (autoFit) {
            cv.setAutosize(true);
        } else {
            cv.setSize(43 * width);
        }
        this.sheet.setColumnView(col, cv);
    }

    @Override
    protected void setRowHeight(int rowIndex, int lastRowHeight, Cut yCut, XlsRowLevelInfo levelInfo) throws JRException {
        boolean isAutoFit;
        boolean bl = isAutoFit = yCut != null && yCut.hasProperty("net.sf.jasperreports.export.xls.auto.fit.row") && (java.lang.Boolean)yCut.getProperty("net.sf.jasperreports.export.xls.auto.fit.row") != false;
        if (isAutoFit) {
            try {
                CellView cv = this.sheet.getRowView(rowIndex) == null ? new CellView() : this.sheet.getRowView(rowIndex);
                cv.setAutosize(true);
                this.sheet.setRowView(rowIndex, cv);
            }
            catch (RowsExceededException e) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_SHEET_TOO_MANY_ROWS, new Object[]{this.sheet.getName(), rowIndex}, e);
            }
        }
        try {
            CellView cv = this.sheet.getRowView(rowIndex);
            if (cv == null || cv.getSize() < LengthUtil.twip(lastRowHeight)) {
                this.sheet.setRowView(rowIndex, LengthUtil.twip(lastRowHeight));
            }
        }
        catch (RowsExceededException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_SHEET_TOO_MANY_ROWS, new Object[]{this.sheet.getName(), rowIndex}, e);
        }
    }

    @Override
    protected void addRowBreak(int rowIndex) {
        this.sheet.addRowPageBreak(rowIndex);
    }

    protected void addBlankCell(WritableCellFormat baseStyleFormat, Map<String, Object> cellValueMap, String currentColumnName) throws JRException {
        if (baseStyleFormat != null) {
            int colIndex = (Integer)this.columnNamesMap.get(currentColumnName);
            cellValueMap.put(currentColumnName, new Blank(colIndex, this.rowIndex, (CellFormat)baseStyleFormat));
        }
    }

    @Override
    protected void writeCurrentRow(Map<String, Object> currentRow, Map<String, Object> repeatedValues) throws JRException {
        for (int i = 0; i < this.columnNames.size(); ++i) {
            CellValue cellValue;
            Object object = (CellValue)currentRow.get(this.columnNames.get(i)) == null ? (repeatedValues.get(this.columnNames.get(i)) != null ? (CellValue)((CellValue)repeatedValues.get(this.columnNames.get(i))).copyTo(i, this.rowIndex) : null) : (cellValue = (CellValue)currentRow.get(this.columnNames.get(i)));
            if (cellValue == null) continue;
            try {
                this.sheet.addCell((WritableCell)cellValue);
                continue;
            }
            catch (RowsExceededException e) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_CURRENT_SHEET_TOO_MANY_ROWS, null, e);
            }
            catch (WriteException e) {
                throw new JRException(e);
            }
        }
        ++this.rowIndex;
    }

    @Override
    protected void exportLine(JRPrintLine line) throws JRException {
        String currentColumnName = line.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.column.name");
        if (currentColumnName != null && currentColumnName.length() > 0) {
            boolean repeatValue = this.getPropertiesUtil().getBooleanProperty(line, "net.sf.jasperreports.export.xls.repeat.value", false);
            this.setColumnName(currentColumnName);
            this.setColumnWidth((Integer)this.columnNamesMap.get(currentColumnName), line.getWidth());
            this.setRowHeight(this.rowIndex, line.getHeight());
            Colour forecolor2 = this.getWorkbookColour(line.getLinePen().getLineColor());
            WritableFont cellFont2 = this.getLoadedFont(this.getDefaultFont(), forecolor2.getValue(), this.getLocale());
            Colour backcolor = WHITE;
            Pattern mode = this.backgroundMode;
            if (!java.lang.Boolean.TRUE.equals(this.sheetInfo.ignoreCellBackground) && line.getBackcolor() != null) {
                mode = Pattern.SOLID;
                backcolor = this.getWorkbookColour(line.getBackcolor(), true);
            }
            int side = 0;
            float ratio = line.getWidth() / line.getHeight();
            side = ratio > 1.0f ? (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? 0 : 2) : (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? 1 : 3);
            BoxStyle boxStyle = new BoxStyle(side, line.getLinePen());
            WritableCellFormat cellStyle2 = this.getLoadedCellStyle(mode, backcolor, cellFont2, boxStyle, this.isWrapText(line), this.isCellLocked(line), this.isShrinkToFit(line));
            this.addBlankElement(cellStyle2, repeatValue, currentColumnName);
        }
    }

    @Override
    protected void exportRectangle(JRPrintGraphicElement element) throws JRException {
        String currentColumnName = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.column.name");
        if (currentColumnName != null && currentColumnName.length() > 0) {
            boolean repeatValue = this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.xls.repeat.value", false);
            this.setColumnName(currentColumnName);
            this.setColumnWidth((Integer)this.columnNamesMap.get(currentColumnName), element.getWidth());
            this.setRowHeight(this.rowIndex, element.getHeight());
            Colour backcolor = WHITE;
            Pattern mode = this.backgroundMode;
            if (!java.lang.Boolean.TRUE.equals(this.sheetInfo.ignoreCellBackground) && element.getBackcolor() != null) {
                mode = Pattern.SOLID;
                backcolor = this.getWorkbookColour(element.getBackcolor(), true);
            }
            Colour forecolor = this.getWorkbookColour(element.getLinePen().getLineColor());
            WritableFont cellFont2 = this.getLoadedFont(this.getDefaultFont(), forecolor.getValue(), this.getLocale());
            BoxStyle boxStyle = new BoxStyle(element.getStyle());
            WritableCellFormat cellStyle2 = this.getLoadedCellStyle(mode, backcolor, cellFont2, boxStyle, this.isWrapText(element), this.isCellLocked(element), this.isShrinkToFit(element));
            this.addBlankElement(cellStyle2, repeatValue, currentColumnName);
        }
    }

    @Override
    protected void exportText(JRPrintText textElement) throws JRException {
        String currentColumnName = textElement.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.column.name");
        if (currentColumnName != null && currentColumnName.length() > 0) {
            boolean hasCurrentColumnData = textElement.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.data");
            String currentColumnData = textElement.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.data");
            boolean repeatValue = this.getPropertiesUtil().getBooleanProperty(textElement, "net.sf.jasperreports.export.xls.repeat.value", false);
            this.setColumnName(currentColumnName);
            this.setColumnWidth((Integer)this.columnNamesMap.get(currentColumnName), textElement.getWidth());
            this.setRowHeight(this.rowIndex, textElement.getHeight());
            Color textForecolor = textElement.getForecolor() == null ? Color.BLACK : textElement.getForecolor();
            Colour forecolor = this.getWorkbookColour(textForecolor);
            WritableFont cellFont = this.getLoadedFont(textElement, forecolor.getValue(), this.getTextLocale(textElement));
            JRXlsAbstractExporter.TextAlignHolder alignment = JExcelApiMetadataExporter.getTextAlignHolder(textElement);
            int horizontalAlignment = this.getHorizontalAlignment(alignment);
            int verticalAlignment = this.getVerticalAlignment(alignment);
            int rotation = this.getRotation(alignment);
            Pattern mode = this.backgroundMode;
            Colour backcolor = WHITE;
            if (!java.lang.Boolean.TRUE.equals(this.sheetInfo.ignoreCellBackground) && textElement.getBackcolor() != null) {
                mode = Pattern.SOLID;
                backcolor = this.getWorkbookColour(textElement.getBackcolor(), true);
            }
            StyleInfo baseStyle = this.isIgnoreTextFormatting(textElement) ? new StyleInfo(mode, WHITE, horizontalAlignment, verticalAlignment, 0, null, (BoxStyle)null, this.isWrapText(textElement) || java.lang.Boolean.TRUE.equals(((JRXlsExporterNature)this.nature).getColumnAutoFit(textElement)), this.isCellLocked(textElement), this.isShrinkToFit(textElement)) : new StyleInfo(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, cellFont, textElement, this.isWrapText(textElement) || java.lang.Boolean.TRUE.equals(((JExcelApiExporterNature)this.nature).getColumnAutoFit(textElement)), this.isCellLocked(textElement), this.isShrinkToFit(textElement));
            String href = null;
            JRHyperlinkProducer customHandler = this.getHyperlinkProducer(textElement);
            if (customHandler == null) {
                switch (textElement.getHyperlinkTypeValue()) {
                    case REFERENCE: {
                        href = textElement.getHyperlinkReference();
                        break;
                    }
                }
            } else {
                href = customHandler.getHyperlink(textElement);
            }
            Integer colIndex = (Integer)this.columnNamesMap.get(currentColumnName);
            if (href != null) {
                try {
                    URL url = new URL(href);
                    WritableHyperlink hyperlink = new WritableHyperlink(colIndex.intValue(), this.rowIndex, colIndex.intValue(), this.rowIndex, url);
                    this.sheet.addHyperlink(hyperlink);
                }
                catch (MalformedURLException e) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Reference \"" + href + "\" could not be parsed as URL."), (Throwable)e);
                    }
                }
                catch (RowsExceededException e) {
                    throw new JRException(EXCEPTION_MESSAGE_KEY_CURRENT_SHEET_TOO_MANY_ROWS, null, e);
                }
                catch (WriteException e) {
                    throw new JRException(e);
                }
            }
            JRStyledText styledText = null;
            String textStr = null;
            if (hasCurrentColumnData) {
                styledText = new JRStyledText();
                if (currentColumnData != null) {
                    styledText.append(currentColumnData);
                }
                textStr = currentColumnData;
            } else {
                styledText = this.getStyledText(textElement);
                if (styledText != null) {
                    textStr = styledText.getText();
                }
            }
            this.addTextElement(textElement, textStr, baseStyle, repeatValue, currentColumnName, hasCurrentColumnData);
        }
    }

    protected void addTextElement(JRPrintText textElement, String textStr, StyleInfo baseStyle, boolean repeatValue, String currentColumnName, boolean hasCurrentColumnData) throws JRException {
        if (this.columnNames.size() > 0) {
            if (this.columnNames.contains(currentColumnName) && !this.currentRow.containsKey(currentColumnName) && this.isColumnReadOnTime(this.currentRow, currentColumnName)) {
                this.addCell(textElement, textStr, baseStyle, this.currentRow, currentColumnName, hasCurrentColumnData);
            } else if (this.columnNames.contains(currentColumnName) && !this.currentRow.containsKey(currentColumnName) && !this.isColumnReadOnTime(this.currentRow, currentColumnName) || this.columnNames.contains(currentColumnName) && this.currentRow.containsKey(currentColumnName)) {
                if (this.rowIndex == 1 && ((JxlMetadataReportConfiguration)this.getCurrentItemConfiguration()).isWriteHeader().booleanValue()) {
                    this.writeReportHeader();
                }
                this.writeCurrentRow(this.currentRow, this.repeatedValues);
                this.currentRow = new HashMap();
                this.addCell(textElement, textStr, baseStyle, this.currentRow, currentColumnName, hasCurrentColumnData);
            }
            if (repeatValue) {
                if (currentColumnName != null && currentColumnName.length() > 0 && textStr.length() > 0) {
                    this.addCell(textElement, textStr, baseStyle, this.repeatedValues, currentColumnName, hasCurrentColumnData);
                }
            } else {
                this.repeatedValues.remove(currentColumnName);
            }
        }
    }

    protected void addBlankElement(WritableCellFormat baseCellFormat, boolean repeatValue, String currentColumnName) throws JRException {
        if (this.columnNames.size() > 0) {
            if (this.columnNames.contains(currentColumnName) && !this.currentRow.containsKey(currentColumnName) && this.isColumnReadOnTime(this.currentRow, currentColumnName)) {
                this.addBlankCell(baseCellFormat, this.currentRow, currentColumnName);
            } else if (this.columnNames.contains(currentColumnName) && !this.currentRow.containsKey(currentColumnName) && !this.isColumnReadOnTime(this.currentRow, currentColumnName) || this.columnNames.contains(currentColumnName) && this.currentRow.containsKey(currentColumnName)) {
                if (this.rowIndex == 1 && ((JxlMetadataReportConfiguration)this.getCurrentItemConfiguration()).isWriteHeader().booleanValue()) {
                    this.writeReportHeader();
                }
                this.writeCurrentRow(this.currentRow, this.repeatedValues);
                this.currentRow = new HashMap();
                this.addBlankCell(baseCellFormat, this.currentRow, currentColumnName);
            }
            if (repeatValue) {
                if (repeatValue && currentColumnName != null && currentColumnName.length() > 0 && baseCellFormat != null) {
                    this.addBlankCell(baseCellFormat, this.repeatedValues, currentColumnName);
                }
            } else {
                this.repeatedValues.remove(currentColumnName);
            }
        }
    }

    protected void addCell(JRPrintText text, String textStr, StyleInfo baseStyle, Map<String, Object> cellValueMap, String currentColumnName, boolean hasCurrentColumnData) throws JRException {
        String textFormula;
        CellValue cellValue = null;
        TextValue textValue = null;
        int colIndex = (Integer)this.columnNamesMap.get(currentColumnName);
        String string = textFormula = hasCurrentColumnData ? null : this.getFormula(text);
        if (text != null && textFormula != null) {
            textValue = this.getTextValue(text, textStr);
            cellValue = this.getFormulaCellValue(colIndex, this.rowIndex, text, textValue, textFormula, baseStyle, this.isComplexFormat(text));
        }
        if (cellValue == null) {
            JxlReportConfiguration configuration = (JxlReportConfiguration)this.getCurrentItemConfiguration();
            if (configuration.isDetectCellType().booleanValue()) {
                if (textFormula == null) {
                    textValue = this.getTextValue(text, textStr, hasCurrentColumnData);
                }
                cellValue = this.getDetectedCellValue(colIndex, this.rowIndex, text, textValue, baseStyle, this.isComplexFormat(text));
            } else {
                cellValue = this.getLabelCell(colIndex, this.rowIndex, textStr, baseStyle);
            }
        }
        cellValueMap.put(currentColumnName, cellValue);
    }

    protected CellValue getFormulaCellValue(int x, int y, JRPrintText textElement, TextValue textValue, String formula, StyleInfo baseStyle, boolean complexFormat) throws JRException {
        FormulaTextValueHandler handler = new FormulaTextValueHandler(x, y, textElement, formula, baseStyle, complexFormat);
        textValue.handle(handler);
        return handler.getResult();
    }

    protected CellValue getDetectedCellValue(int x, int y, JRPrintText textElement, TextValue textValue, StyleInfo baseStyle, boolean complexFormat) throws JRException {
        CellTextValueHandler handler = new CellTextValueHandler(x, y, textElement, baseStyle, complexFormat);
        textValue.handle(handler);
        return handler.getResult();
    }

    protected NumberFormat getNumberFormat(String convertedPattern, boolean isComplexFormat) {
        NumberFormat cellFormat = this.numberFormats.get(convertedPattern);
        if (cellFormat == null) {
            cellFormat = isComplexFormat ? new NumberFormat(convertedPattern, NumberFormat.COMPLEX_FORMAT) : new NumberFormat(convertedPattern);
            this.numberFormats.put(convertedPattern, cellFormat);
        }
        return cellFormat;
    }

    protected DateFormat getDateFormat(String convertedPattern) {
        DateFormat cellFormat = this.dateFormats.get(convertedPattern);
        if (cellFormat == null) {
            cellFormat = new DateFormat(convertedPattern);
            this.dateFormats.put(convertedPattern, cellFormat);
        }
        return cellFormat;
    }

    protected CellValue getLabelCell(int x, int y, String textStr, StyleInfo baseStyle) throws JRException {
        WritableCellFormat cellStyle = null;
        cellStyle = baseStyle != null ? this.getLoadedCellStyle(baseStyle) : new WritableCellFormat();
        return new Label(x, y, textStr, (CellFormat)cellStyle);
    }

    private int getHorizontalAlignment(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.horizontalAlignment) {
            case RIGHT: {
                return Alignment.RIGHT.getValue();
            }
            case CENTER: {
                return Alignment.CENTRE.getValue();
            }
            case JUSTIFIED: {
                return Alignment.JUSTIFY.getValue();
            }
        }
        return Alignment.LEFT.getValue();
    }

    private int getVerticalAlignment(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.verticalAlignment) {
            case BOTTOM: {
                return VerticalAlignment.BOTTOM.getValue();
            }
            case MIDDLE: {
                return VerticalAlignment.CENTRE.getValue();
            }
            case JUSTIFIED: {
                return VerticalAlignment.JUSTIFY.getValue();
            }
        }
        return VerticalAlignment.TOP.getValue();
    }

    private int getRotation(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.rotation) {
            case LEFT: {
                return Orientation.PLUS_90.getValue();
            }
            case RIGHT: {
                return Orientation.MINUS_90.getValue();
            }
        }
        return Orientation.HORIZONTAL.getValue();
    }

    @Override
    public void exportImage(JRPrintImage element) throws JRException {
        String currentColumnName = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.column.name");
        if (currentColumnName != null && currentColumnName.length() > 0) {
            boolean repeatValue = this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.xls.repeat.value", false);
            this.setColumnName(currentColumnName);
            this.setColumnWidth((Integer)this.columnNamesMap.get(currentColumnName), element.getWidth());
            this.setRowHeight(this.rowIndex, element.getHeight());
            InternalImageProcessor imageProcessor = new InternalImageProcessor(element);
            Renderable renderer = element.getRenderer();
            if (renderer != null && imageProcessor.availableImageWidth > 0 && imageProcessor.availableImageHeight > 0) {
                InternalImageProcessorResult imageProcessorResult;
                block11: {
                    imageProcessorResult = null;
                    try {
                        imageProcessorResult = imageProcessor.process(renderer);
                    }
                    catch (Exception e) {
                        Renderable onErrorRenderer = this.getRendererUtil().handleImageError(e, element.getOnErrorTypeValue());
                        if (onErrorRenderer == null) break block11;
                        imageProcessorResult = imageProcessor.process(onErrorRenderer);
                    }
                }
                if (imageProcessorResult != null) {
                    Pattern mode = this.backgroundMode;
                    Colour background = WHITE;
                    JxlReportConfiguration configuration = (JxlReportConfiguration)this.getCurrentItemConfiguration();
                    if (!java.lang.Boolean.TRUE.equals(this.sheetInfo.ignoreCellBackground) && element.getBackcolor() != null) {
                        mode = Pattern.SOLID;
                        background = this.getWorkbookColour(element.getBackcolor(), true);
                    }
                    if (element.getModeValue() == ModeEnum.OPAQUE) {
                        background = this.getWorkbookColour(element.getBackcolor(), true);
                    }
                    Colour forecolor = this.getWorkbookColour(element.getLineBox().getPen().getLineColor());
                    WritableFont cellFont2 = this.getLoadedFont(this.getDefaultFont(), forecolor.getValue(), this.getLocale());
                    WritableCellFormat cellStyle2 = this.getLoadedCellStyle(mode, background, cellFont2, new BoxStyle(element), this.isWrapText(element), this.isCellLocked(element), this.isShrinkToFit(element));
                    this.addBlankElement(cellStyle2, repeatValue, currentColumnName);
                    try {
                        int colIndex = (Integer)this.columnNamesMap.get(currentColumnName);
                        WritableImage image = new WritableImage((double)colIndex, (double)this.rowIndex, 1.0, 1.0, imageProcessorResult.imageData);
                        ImageAnchorTypeEnum imageAnchorType = ImageAnchorTypeEnum.getByName(JRPropertiesUtil.getOwnProperty(element, "net.sf.jasperreports.export.xls.image.anchor.type"));
                        if (imageAnchorType == null && (imageAnchorType = configuration.getImageAnchorType()) == null) {
                            imageAnchorType = ImageAnchorTypeEnum.MOVE_NO_SIZE;
                        }
                        this.setAnchorType(image, imageAnchorType);
                        this.sheet.addImage(image);
                    }
                    catch (Exception ex) {
                        throw new JRException("export.xls.common.cannot.add.cell", null, ex);
                    }
                    catch (Error err) {
                        throw new JRException("export.xls.common.cannot.add.cell", null, err);
                    }
                }
            }
        }
    }

    protected Colour getWorkbookColour(Color awtColor, boolean isBackcolor) {
        if (isBackcolor && awtColor.getRGB() == Color.black.getRGB()) {
            return Colour.PALETTE_BLACK;
        }
        return this.getWorkbookColour(awtColor);
    }

    protected Colour getWorkbookColour(Color awtColor) {
        Colour colour;
        JxlExporterConfiguration configuration = (JxlExporterConfiguration)this.getCurrentConfiguration();
        if (configuration.isCreateCustomPalette().booleanValue()) {
            colour = this.workbookColours.get(awtColor);
            if (colour == null) {
                colour = this.determineWorkbookColour(awtColor);
                this.workbookColours.put(awtColor, colour);
            }
        } else {
            colour = JExcelApiMetadataExporter.getNearestColour(awtColor);
        }
        return colour;
    }

    protected Colour determineWorkbookColour(Color awtColor) {
        Colour workbookColour;
        int minDist = 999;
        Colour minColour = null;
        int minDistAvailable = 999;
        Colour minColourAvailable = null;
        Colour[] colors = Colour.getAllColours();
        for (int i = 0; i < colors.length; ++i) {
            Colour colour = colors[i];
            RGB customRGB = this.usedColours.get(colour);
            RGB rgb = customRGB == null ? colour.getDefaultRGB() : customRGB;
            int dist = JExcelApiMetadataExporter.rgbDistance(awtColor, rgb);
            if (dist < minDist) {
                minDist = dist;
                minColour = colour;
            }
            if (dist == 0) break;
            if (customRGB != null || dist >= minDistAvailable) continue;
            minDistAvailable = dist;
            minColourAvailable = colour;
        }
        if (minDist == 0) {
            if (!this.usedColours.containsKey(minColour)) {
                this.setColourUsed(minColour);
            }
            workbookColour = minColour;
        } else if (minColourAvailable == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("No more available colours in the palette.  Using the nearest match for " + awtColor));
            }
            workbookColour = minColour;
        } else {
            this.setColourUsed(minColourAvailable, awtColor);
            workbookColour = minColourAvailable;
        }
        return workbookColour;
    }

    protected static Colour getNearestColour(Color awtColor) {
        Colour color = colorsCache.get(awtColor);
        if (color == null) {
            Colour[] colors = Colour.getAllColours();
            if (colors != null && colors.length > 0) {
                int minDiff = 999;
                for (int i = 0; i < colors.length; ++i) {
                    Colour crtColor = colors[i];
                    int diff = JExcelApiMetadataExporter.rgbDistance(awtColor, crtColor.getDefaultRGB());
                    if (diff >= minDiff) continue;
                    minDiff = diff;
                    color = crtColor;
                }
            }
            colorsCache.put(awtColor, color);
        }
        return color;
    }

    protected static int rgbDistance(Color awtColor, RGB rgb) {
        return Math.abs(rgb.getRed() - awtColor.getRed()) + Math.abs(rgb.getGreen() - awtColor.getGreen()) + Math.abs(rgb.getBlue() - awtColor.getBlue());
    }

    private WritableFont getLoadedFont(JRFont font, int forecolor, Locale locale) throws JRException {
        boolean isFontSizeFixEnabled = ((JxlMetadataReportConfiguration)this.getCurrentItemConfiguration()).isFontSizeFixEnabled();
        WritableFont cellFont = null;
        if (this.loadedFonts != null && this.loadedFonts.size() > 0) {
            for (int i = 0; i < this.loadedFonts.size(); ++i) {
                WritableFont cf = (WritableFont)this.loadedFonts.get(i);
                int fontSize = (int)font.getFontsize();
                if (isFontSizeFixEnabled) {
                    --fontSize;
                }
                String fontName = this.fontUtil.getExportFontFamily(font.getFontName(), locale, this.getExporterKey());
                if (!cf.getName().equals(fontName) || cf.getColour().getValue() != forecolor || cf.getPointSize() != fontSize || !(cf.getUnderlineStyle() == UnderlineStyle.SINGLE ? font.isUnderline() : !font.isUnderline()) || cf.isStruckout() != font.isStrikeThrough() || !(cf.getBoldWeight() == BoldStyle.BOLD.getValue() ? font.isBold() : !font.isBold()) || cf.isItalic() != font.isItalic()) continue;
                cellFont = cf;
                break;
            }
        }
        try {
            if (cellFont == null) {
                int fontSize = (int)font.getFontsize();
                if (isFontSizeFixEnabled) {
                    --fontSize;
                }
                String fontName = font.getFontName();
                cellFont = new WritableFont(WritableFont.createFont((String)fontName), fontSize, font.isBold() ? WritableFont.BOLD : WritableFont.NO_BOLD, font.isItalic(), font.isUnderline() ? UnderlineStyle.SINGLE : UnderlineStyle.NO_UNDERLINE, Colour.getInternalColour((int)forecolor));
                cellFont.setStruckout(font.isStrikeThrough());
                this.loadedFonts.add(cellFont);
            }
        }
        catch (Exception e) {
            throw new JRException("export.xls.common.loaded.fonts.error", null, e);
        }
        return cellFont;
    }

    private WritableCellFormat getLoadedCellStyle(Pattern mode, Colour backcolor, WritableFont font, BoxStyle box, boolean wrapText, boolean cellLocked, boolean shrinkToFit) throws JRException {
        StyleInfo styleKey = new StyleInfo(mode, backcolor, Alignment.LEFT.getValue(), VerticalAlignment.TOP.getValue(), Orientation.HORIZONTAL.getValue(), font, box, wrapText, cellLocked, shrinkToFit);
        return this.getLoadedCellStyle(styleKey);
    }

    protected WritableCellFormat getLoadedCellStyle(StyleInfo styleKey) throws JRException {
        WritableCellFormat cellStyle = this.loadedCellStyles.get(styleKey);
        if (cellStyle == null) {
            try {
                cellStyle = styleKey.font == null ? new WritableCellFormat() : (styleKey.getDisplayFormat() == null ? new WritableCellFormat(styleKey.font) : new WritableCellFormat(styleKey.font, styleKey.getDisplayFormat()));
                cellStyle.setBackground(styleKey.backcolor, styleKey.mode);
                cellStyle.setAlignment(Alignment.getAlignment((int)styleKey.horizontalAlignment));
                cellStyle.setVerticalAlignment(VerticalAlignment.getAlignment((int)styleKey.verticalAlignment));
                cellStyle.setOrientation(Orientation.getOrientation((int)styleKey.rotation));
                cellStyle.setWrap(styleKey.isWrapText);
                cellStyle.setLocked(styleKey.isCellLocked);
                if (!java.lang.Boolean.TRUE.equals(this.sheetInfo.ignoreCellBorder) && styleKey.box != null) {
                    BoxStyle box = styleKey.box;
                    cellStyle.setBorder(Border.TOP, box.borderStyle[0], box.borderColour[0]);
                    cellStyle.setBorder(Border.BOTTOM, box.borderStyle[2], box.borderColour[2]);
                    cellStyle.setBorder(Border.LEFT, box.borderStyle[1], box.borderColour[1]);
                    cellStyle.setBorder(Border.RIGHT, box.borderStyle[3], box.borderColour[3]);
                }
            }
            catch (Exception e) {
                throw new JRException("export.xls.common.cell.format.template.error", null, e);
            }
            this.loadedCellStyles.put(styleKey, cellStyle);
        }
        return cellStyle;
    }

    protected static BorderLineStyle getBorderLineStyle(JRPen pen) {
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth > 0.0f) {
            switch (pen.getLineStyleValue()) {
                case DOUBLE: {
                    return BorderLineStyle.DOUBLE;
                }
                case DOTTED: {
                    return BorderLineStyle.DOTTED;
                }
                case DASHED: {
                    if (lineWidth >= 1.0f) {
                        return BorderLineStyle.MEDIUM_DASHED;
                    }
                    return BorderLineStyle.DASHED;
                }
            }
            if (lineWidth >= 2.0f) {
                return BorderLineStyle.THICK;
            }
            if (lineWidth >= 1.0f) {
                return BorderLineStyle.MEDIUM;
            }
            if (lineWidth >= 0.5f) {
                return BorderLineStyle.THIN;
            }
            return BorderLineStyle.HAIR;
        }
        return BorderLineStyle.NONE;
    }

    private final void setSheetSettings(JRXlsAbstractExporter.SheetInfo sheetInfo, WritableSheet sheet) {
        String sheetFooterRight;
        String sheetFooterCenter;
        String sheetFooterLeft;
        String sheetHeaderRight;
        String sheetHeaderCenter;
        String sheetHeaderLeft;
        this.rowIndex = 0;
        PageOrientation po = this.pageFormat.getOrientation() == OrientationEnum.PORTRAIT ? PageOrientation.PORTRAIT : PageOrientation.LANDSCAPE;
        PaperSize ps = this.getSuitablePaperSize();
        if (ps != null) {
            sheet.setPageSetup(po, ps, 0.0, 0.0);
        } else {
            sheet.setPageSetup(po);
        }
        SheetSettings sheets = sheet.getSettings();
        JxlReportConfiguration configuration = (JxlReportConfiguration)this.getCurrentItemConfiguration();
        sheets.setTopMargin(0.0);
        sheets.setLeftMargin(0.0);
        sheets.setRightMargin(0.0);
        sheets.setBottomMargin(0.0);
        sheets.setHeaderMargin(0.0);
        sheets.setFooterMargin(0.0);
        String password = configuration.getPassword();
        if (password != null) {
            sheets.setPassword(password);
            sheets.setProtected(true);
        }
        if ((sheetHeaderLeft = configuration.getSheetHeaderLeft()) != null) {
            sheets.getHeader().getLeft().append(sheetHeaderLeft);
        }
        if ((sheetHeaderCenter = configuration.getSheetHeaderCenter()) != null) {
            sheets.getHeader().getCentre().append(sheetHeaderCenter);
        }
        if ((sheetHeaderRight = configuration.getSheetHeaderRight()) != null) {
            sheets.getHeader().getRight().append(sheetHeaderRight);
        }
        if ((sheetFooterLeft = configuration.getSheetFooterLeft()) != null) {
            sheets.getFooter().getLeft().append(sheetFooterLeft);
        }
        if ((sheetFooterCenter = configuration.getSheetFooterCenter()) != null) {
            sheets.getFooter().getCentre().append(sheetFooterCenter);
        }
        if ((sheetFooterRight = configuration.getSheetFooterRight()) != null) {
            sheets.getFooter().getRight().append(sheetFooterRight);
        }
        if (sheetInfo.sheetFirstPageNumber != null && sheetInfo.sheetFirstPageNumber > 0) {
            sheets.setPageStart(sheetInfo.sheetFirstPageNumber.intValue());
            this.firstPageNotSet = false;
        } else {
            Integer documentFirstPageNumber = configuration.getFirstPageNumber();
            if (documentFirstPageNumber != null && documentFirstPageNumber > 0 && this.firstPageNotSet) {
                sheets.setPageStart(documentFirstPageNumber.intValue());
                this.firstPageNotSet = false;
            }
        }
        if (!this.firstPageNotSet && sheets.getFooter().getCentre().empty()) {
            sheets.getFooter().getCentre().append("Page ");
            sheets.getFooter().getCentre().appendPageNumber();
        }
        boolean showGridlines = true;
        if (sheetInfo.sheetShowGridlines == null) {
            java.lang.Boolean documentShowGridlines = configuration.isShowGridLines();
            if (documentShowGridlines != null) {
                showGridlines = documentShowGridlines;
            }
        } else {
            showGridlines = sheetInfo.sheetShowGridlines;
        }
        sheets.setShowGridLines(showGridlines);
        this.backgroundMode = java.lang.Boolean.TRUE.equals(sheetInfo.whitePageBackground) ? Pattern.SOLID : Pattern.NONE;
    }

    private final PaperSize getSuitablePaperSize() {
        if (this.pageFormat == null) {
            return null;
        }
        long width = 0L;
        long height = 0L;
        PaperSize ps = null;
        if (this.pageFormat.getPageWidth() != 0 && this.pageFormat.getPageHeight() != 0) {
            double dWidth = (double)this.pageFormat.getPageWidth().intValue() / 72.0;
            double dHeight = (double)this.pageFormat.getPageHeight().intValue() / 72.0;
            height = Math.round(dHeight * 25.4);
            width = Math.round(dWidth * 25.4);
            for (int i = 3; i < 6; ++i) {
                int w = this.calculateWidthForDinAN(i);
                int h = this.calculateHeightForDinAN(i);
                if (((long)w != width || (long)h != height) && ((long)h != width || (long)w != height)) continue;
                if (i == 3) {
                    ps = PaperSize.A3;
                    break;
                }
                if (i == 4) {
                    ps = PaperSize.A4;
                    break;
                }
                if (i != 5) break;
                ps = PaperSize.A5;
                break;
            }
            if (ps == null) {
                if (width == 216L && height == 279L || width == 279L && height == 216L) {
                    ps = PaperSize.LETTER;
                }
                if (width == 216L && height == 356L || width == 356L && height == 216L) {
                    ps = PaperSize.LEGAL;
                }
            }
        }
        return ps;
    }

    @Override
    protected void exportFrame(JRPrintFrame frame) throws JRException {
        for (JRPrintElement element : frame.getElements()) {
            if (element instanceof JRPrintLine) {
                this.exportLine((JRPrintLine)element);
                continue;
            }
            if (element instanceof JRPrintRectangle) {
                this.exportRectangle((JRPrintRectangle)element);
                continue;
            }
            if (element instanceof JRPrintEllipse) {
                this.exportRectangle((JRPrintEllipse)element);
                continue;
            }
            if (element instanceof JRPrintImage) {
                this.exportImage((JRPrintImage)element);
                continue;
            }
            if (element instanceof JRPrintText) {
                this.exportText((JRPrintText)element);
                continue;
            }
            if (element instanceof JRPrintFrame) {
                this.exportFrame((JRPrintFrame)element);
                continue;
            }
            if (!(element instanceof JRGenericPrintElement)) continue;
            this.exportGenericElement((JRGenericPrintElement)element);
        }
    }

    @Override
    protected void exportGenericElement(JRGenericPrintElement element) throws JRException {
        String currentColumnName = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.column.name");
        if (currentColumnName != null && currentColumnName.length() > 0) {
            boolean repeatValue = this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.xls.repeat.value", false);
            int colIndex = (Integer)this.columnNamesMap.get(currentColumnName);
            this.setColumnName(currentColumnName);
            this.setColumnWidth((Integer)this.columnNamesMap.get(currentColumnName), element.getWidth());
            this.setRowHeight(this.rowIndex, element.getHeight());
            GenericElementJExcelApiMetadataHandler handler = (GenericElementJExcelApiMetadataHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(element.getGenericType(), JXL_EXPORTER_KEY);
            if (handler != null) {
                this.rowIndex = handler.exportElement((JExcelApiExporterContext)this.exporterContext, element, this.currentRow, this.repeatedValues, this.columnNames, this.columnNamesMap, currentColumnName, colIndex, this.rowIndex, repeatValue);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("No XLS generic element handler for " + element.getGenericType()));
            }
        }
    }

    @Override
    protected ExporterNature getNature() {
        return this.nature;
    }

    @Override
    public String getExporterKey() {
        return JXL_EXPORTER_KEY;
    }

    @Override
    public String getExporterPropertiesPrefix() {
        return "net.sf.jasperreports.export.xls.";
    }

    protected boolean isComplexFormat(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty(PROPERTY_COMPLEX_FORMAT)) {
            return this.getPropertiesUtil().getBooleanProperty(element, PROPERTY_COMPLEX_FORMAT, (boolean)((JxlMetadataReportConfiguration)this.getCurrentItemConfiguration()).isComplexFormat());
        }
        return ((JxlMetadataReportConfiguration)this.getCurrentItemConfiguration()).isComplexFormat();
    }

    protected void setColumnName(String currentColumnName) {
        if (!this.hasDefinedColumns && currentColumnName != null && currentColumnName.length() > 0 && !this.columnNames.contains(currentColumnName)) {
            this.columnNamesMap.put(currentColumnName, this.columnNames.size());
            this.columnNames.add(currentColumnName);
        }
    }

    @Override
    protected void writeReportHeader() throws JRException {
        try {
            for (int i = 0; i < this.columnNames.size(); ++i) {
                CellValue cellValue = this.getLabelCell(i, 0, (String)this.columnNames.get(i), null);
                this.sheet.addCell((WritableCell)cellValue);
            }
        }
        catch (RowsExceededException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_CURRENT_SHEET_TOO_MANY_ROWS, null, e);
        }
        catch (WriteException e) {
            throw new JRException(e);
        }
    }

    @Override
    protected void setFreezePane(int rowIndex, int colIndex) {
        if (rowIndex > 0 || colIndex > 0) {
            SheetSettings settings = this.sheet.getSettings();
            settings.setVerticalFreeze(Math.max(0, rowIndex));
            settings.setHorizontalFreeze(Math.max(0, colIndex));
        }
    }

    @Override
    protected void setFreezePane(int rowIndex, int colIndex, boolean isRowEdge, boolean isColumnEdge) {
        this.setFreezePane(rowIndex, colIndex);
    }

    @Override
    protected void setSheetName(String sheetName) {
        this.sheet.setName(sheetName);
    }

    @Override
    protected void setAutoFilter(String autoFilterRange) {
    }

    @Override
    protected void setRowLevels(XlsRowLevelInfo levelInfo, String level) {
    }

    protected void setAnchorType(WritableImage image, ImageAnchorTypeEnum anchorType) {
        switch (anchorType) {
            case MOVE_SIZE: {
                image.setImageAnchor(WritableImage.MOVE_AND_SIZE_WITH_CELLS);
                break;
            }
            case NO_MOVE_NO_SIZE: {
                image.setImageAnchor(WritableImage.NO_MOVE_OR_SIZE_WITH_CELLS);
                break;
            }
            default: {
                image.setImageAnchor(WritableImage.MOVE_WITH_CELLS);
            }
        }
    }

    protected TextValue getTextValue(JRPrintText text, String textStr, boolean hasCurrentColumnData) {
        TextValue textValue;
        if (!hasCurrentColumnData) {
            return this.getTextValue(text, textStr);
        }
        String valueClassName = text.getValueClassName();
        if (valueClassName == null) {
            textValue = this.getTextValueString(text, textStr);
        } else {
            try {
                Class<?> valueClass = (Class<?>)this.textValueClasses.get(valueClassName);
                if (valueClass == null) {
                    valueClass = JRClassLoader.loadClassForRealName(valueClassName);
                    this.textValueClasses.put(valueClassName, valueClass);
                }
                textValue = java.lang.Number.class.isAssignableFrom(valueClass) ? new NumberTextValue(textStr, Double.parseDouble(textStr), text.getPattern()) : (Date.class.isAssignableFrom(valueClass) ? new DateTextValue(textStr, this.isoDateFormat.parse(textStr), text.getPattern()) : (java.lang.Boolean.class.equals(valueClass) ? new BooleanTextValue(textStr, java.lang.Boolean.valueOf(textStr)) : this.getTextValueString(text, textStr)));
            }
            catch (ParseException e) {
                textValue = this.getTextValueString(text, textStr);
            }
            catch (ClassNotFoundException e) {
                textValue = this.getTextValueString(text, textStr);
            }
        }
        return textValue;
    }

    protected class StyleInfo {
        protected final Pattern mode;
        protected final Colour backcolor;
        protected final int horizontalAlignment;
        protected final int verticalAlignment;
        protected final int rotation;
        protected final WritableFont font;
        protected final BoxStyle box;
        protected final boolean isWrapText;
        protected final boolean isCellLocked;
        protected final boolean isShrinkToFit;
        private DisplayFormat displayFormat;
        private int hashCode;

        protected StyleInfo(Pattern mode, Colour backcolor, int horizontalAlignment, int verticalAlignment, int rotation, WritableFont font, JRBoxContainer element, boolean wrapText, boolean cellLocked, boolean shrinkToFit) {
            this(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, element == null ? null : jExcelApiMetadataExporter.new BoxStyle(element), wrapText, cellLocked, shrinkToFit);
        }

        protected StyleInfo(Pattern mode, Colour backcolor, int horizontalAlignment, int verticalAlignment, int rotation, WritableFont font, BoxStyle box, boolean wrapText, boolean cellLocked, boolean shrinkToFit) {
            this.mode = mode;
            this.backcolor = backcolor;
            this.horizontalAlignment = horizontalAlignment;
            this.verticalAlignment = verticalAlignment;
            this.rotation = rotation;
            this.font = font;
            this.box = box;
            this.isWrapText = shrinkToFit ? false : wrapText;
            this.isCellLocked = cellLocked;
            this.isShrinkToFit = shrinkToFit;
            this.computeHash();
        }

        protected void computeHash() {
            int hash = this.mode.hashCode();
            hash = 31 * hash + this.backcolor.hashCode();
            hash = 31 * hash + this.horizontalAlignment;
            hash = 31 * hash + this.verticalAlignment;
            hash = 31 * hash + this.rotation;
            hash = 31 * hash + (this.font == null ? 0 : this.font.hashCode());
            hash = 31 * hash + (this.box == null ? 0 : this.box.hashCode());
            hash = 31 * hash + (this.displayFormat == null ? 0 : this.displayFormat.hashCode());
            hash = 31 * hash + (this.isWrapText ? 0 : 1);
            hash = 31 * hash + (this.isCellLocked ? 0 : 1);
            this.hashCode = hash = 31 * hash + (this.isShrinkToFit ? 0 : 1);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            StyleInfo k = (StyleInfo)o;
            return k.mode.equals(this.mode) && k.backcolor.equals(this.backcolor) && k.horizontalAlignment == this.horizontalAlignment && k.verticalAlignment == this.verticalAlignment && k.rotation == this.rotation && (k.font == null ? this.font == null : k.font.equals((Object)this.font)) && (k.box == null ? this.box == null : this.box != null && k.box.equals(this.box)) && (k.displayFormat == null ? this.displayFormat == null : this.displayFormat != null && k.displayFormat.equals(this.displayFormat) && k.isWrapText == this.isWrapText && k.isCellLocked == this.isCellLocked && k.isShrinkToFit == this.isShrinkToFit);
        }

        public DisplayFormat getDisplayFormat() {
            return this.displayFormat;
        }

        public void setDisplayFormat(DisplayFormat displayFormat) {
            this.displayFormat = displayFormat;
            this.computeHash();
        }

        public String toString() {
            return "(" + this.mode + "," + this.backcolor + "," + this.horizontalAlignment + "," + this.verticalAlignment + "," + this.rotation + "," + this.font + "," + this.box + "," + this.displayFormat + "," + this.isWrapText + "," + this.isCellLocked + "," + this.isShrinkToFit + ")";
        }
    }

    protected class BoxStyle {
        protected static final int TOP = 0;
        protected static final int LEFT = 1;
        protected static final int BOTTOM = 2;
        protected static final int RIGHT = 3;
        protected BorderLineStyle[] borderStyle = new BorderLineStyle[]{BorderLineStyle.NONE, BorderLineStyle.NONE, BorderLineStyle.NONE, BorderLineStyle.NONE};
        protected Colour[] borderColour = new Colour[]{BLACK, BLACK, BLACK, BLACK};
        private int hash;

        public BoxStyle(int side, JRPen pen) {
            this.borderStyle[side] = JExcelApiMetadataExporter.getBorderLineStyle(pen);
            this.borderColour[side] = JExcelApiMetadataExporter.this.getWorkbookColour(pen.getLineColor());
            this.hash = this.computeHash();
        }

        public BoxStyle(JRBoxContainer element) {
            if (element != null) {
                JRLineBox lineBox = element.getLineBox();
                if (lineBox != null) {
                    this.setBox(lineBox);
                }
                if (element instanceof JRCommonGraphicElement) {
                    this.setPen(((JRCommonGraphicElement)((Object)element)).getLinePen());
                }
                this.hash = this.computeHash();
            }
        }

        public void setBox(JRLineBox box) {
            this.borderStyle[0] = JExcelApiMetadataExporter.getBorderLineStyle(box.getTopPen());
            this.borderColour[0] = JExcelApiMetadataExporter.this.getWorkbookColour(box.getTopPen().getLineColor());
            this.borderStyle[2] = JExcelApiMetadataExporter.getBorderLineStyle(box.getBottomPen());
            this.borderColour[2] = JExcelApiMetadataExporter.this.getWorkbookColour(box.getBottomPen().getLineColor());
            this.borderStyle[1] = JExcelApiMetadataExporter.getBorderLineStyle(box.getLeftPen());
            this.borderColour[1] = JExcelApiMetadataExporter.this.getWorkbookColour(box.getLeftPen().getLineColor());
            this.borderStyle[3] = JExcelApiMetadataExporter.getBorderLineStyle(box.getRightPen());
            this.borderColour[3] = JExcelApiMetadataExporter.this.getWorkbookColour(box.getRightPen().getLineColor());
            this.hash = this.computeHash();
        }

        public void setPen(JRPen pen) {
            if (this.borderStyle[0] == BorderLineStyle.NONE && this.borderStyle[1] == BorderLineStyle.NONE && this.borderStyle[2] == BorderLineStyle.NONE && this.borderStyle[3] == BorderLineStyle.NONE) {
                BorderLineStyle style = JExcelApiMetadataExporter.getBorderLineStyle(pen);
                Colour colour = JExcelApiMetadataExporter.this.getWorkbookColour(pen.getLineColor());
                this.borderStyle[0] = style;
                this.borderStyle[1] = style;
                this.borderStyle[2] = style;
                this.borderStyle[3] = style;
                this.borderColour[0] = colour;
                this.borderColour[1] = colour;
                this.borderColour[2] = colour;
                this.borderColour[3] = colour;
            }
            this.hash = this.computeHash();
        }

        private int computeHash() {
            int hashCode = this.borderStyle[0].hashCode();
            hashCode = 31 * hashCode + this.borderColour[0].hashCode();
            hashCode = 31 * hashCode + this.borderStyle[2].hashCode();
            hashCode = 31 * hashCode + this.borderColour[2].hashCode();
            hashCode = 31 * hashCode + this.borderStyle[1].hashCode();
            hashCode = 31 * hashCode + this.borderColour[1].hashCode();
            hashCode = 31 * hashCode + this.borderStyle[3].hashCode();
            hashCode = 31 * hashCode + this.borderColour[3].hashCode();
            return hashCode;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            BoxStyle b = (BoxStyle)o;
            return b.borderStyle[0].equals(this.borderStyle[0]) && b.borderColour[0].equals(this.borderColour[0]) && b.borderStyle[1].equals(this.borderStyle[1]) && b.borderColour[1].equals(this.borderColour[1]) && b.borderStyle[2].equals(this.borderStyle[2]) && b.borderColour[2].equals(this.borderColour[2]) && b.borderStyle[3].equals(this.borderStyle[3]) && b.borderColour[3].equals(this.borderColour[3]);
        }

        public String toString() {
            return "(" + this.borderStyle[0].getValue() + "/" + this.borderColour[0].getValue() + "," + this.borderStyle[2].getValue() + "/" + this.borderColour[2].getValue() + "," + this.borderStyle[1].getValue() + "/" + this.borderColour[1].getValue() + "," + this.borderStyle[3].getValue() + "/" + this.borderColour[3].getValue() + ")";
        }
    }

    private class InternalImageProcessorResult {
        private final byte[] imageData;

        protected InternalImageProcessorResult(byte[] imageData) {
            this.imageData = imageData;
        }
    }

    private class InternalImageProcessor {
        private final JRPrintImage imageElement;
        private final int topPadding;
        private final int leftPadding;
        private final int bottomPadding;
        private final int rightPadding;
        private final int availableImageWidth;
        private final int availableImageHeight;

        protected InternalImageProcessor(JRPrintImage imageElement) {
            this.imageElement = imageElement;
            this.topPadding = Math.max(imageElement.getLineBox().getTopPadding(), JExcelApiMetadataExporter.this.getImageBorderCorrection(imageElement.getLineBox().getTopPen()));
            this.leftPadding = Math.max(imageElement.getLineBox().getLeftPadding(), JExcelApiMetadataExporter.this.getImageBorderCorrection(imageElement.getLineBox().getLeftPen()));
            this.bottomPadding = Math.max(imageElement.getLineBox().getBottomPadding(), JExcelApiMetadataExporter.this.getImageBorderCorrection(imageElement.getLineBox().getBottomPen()));
            this.rightPadding = Math.max(imageElement.getLineBox().getRightPadding(), JExcelApiMetadataExporter.this.getImageBorderCorrection(imageElement.getLineBox().getRightPen()));
            int tmpAvailableImageWidth = imageElement.getWidth() - this.leftPadding - this.rightPadding;
            this.availableImageWidth = tmpAvailableImageWidth < 0 ? 0 : tmpAvailableImageWidth;
            int tmpAvailableImageHeight = imageElement.getHeight() - this.topPadding - this.bottomPadding;
            this.availableImageHeight = tmpAvailableImageHeight < 0 ? 0 : tmpAvailableImageHeight;
        }

        private InternalImageProcessorResult process(Renderable renderer) throws JRException {
            InternalImageProcessorResult imageProcessorResult = null;
            if (renderer instanceof ResourceRenderer) {
                renderer = JExcelApiMetadataExporter.this.renderersCache.getLoadedRenderer((ResourceRenderer)renderer);
            }
            switch (this.imageElement.getScaleImageValue()) {
                case CLIP: {
                    imageProcessorResult = this.processImageClip(JExcelApiMetadataExporter.this.renderersCache.getGraphics2DRenderable(renderer));
                    break;
                }
                case FILL_FRAME: {
                    imageProcessorResult = this.processImageFillFrame(JExcelApiMetadataExporter.this.getRendererUtil().getImageDataRenderable(JExcelApiMetadataExporter.this.renderersCache, renderer, new Dimension(this.availableImageWidth, this.availableImageHeight), ModeEnum.OPAQUE == this.imageElement.getModeValue() ? this.imageElement.getBackcolor() : null));
                    break;
                }
                default: {
                    imageProcessorResult = this.processImageRetainShape(JExcelApiMetadataExporter.this.getRendererUtil().getImageDataRenderable(JExcelApiMetadataExporter.this.renderersCache, renderer, new Dimension(this.availableImageWidth, this.availableImageHeight), ModeEnum.OPAQUE == this.imageElement.getModeValue() ? this.imageElement.getBackcolor() : null));
                }
            }
            return imageProcessorResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InternalImageProcessorResult processImageClip(Graphics2DRenderable renderer) throws JRException {
            Dimension2D dimension;
            int normalWidth = this.availableImageWidth;
            int normalHeight = this.availableImageHeight;
            Dimension2D dimension2D = dimension = renderer instanceof DimensionRenderable ? ((DimensionRenderable)((Object)renderer)).getDimension(JExcelApiMetadataExporter.this.jasperReportsContext) : null;
            if (dimension != null) {
                normalWidth = (int)dimension.getWidth();
                normalHeight = (int)dimension.getHeight();
            }
            int dpi = JExcelApiMetadataExporter.this.getPropertiesUtil().getIntegerProperty("net.sf.jasperreports.image.dpi", 72);
            double scale = (double)dpi / 72.0;
            BufferedImage bi = new BufferedImage((int)(scale * (double)this.availableImageWidth), (int)(scale * (double)this.availableImageHeight), 2);
            Graphics2D grx = bi.createGraphics();
            try {
                grx.scale(scale, scale);
                grx.clip(new Rectangle(0, 0, this.availableImageWidth, this.availableImageHeight));
                renderer.render(JExcelApiMetadataExporter.this.jasperReportsContext, grx, new Rectangle((int)(ImageUtil.getXAlignFactor(this.imageElement) * (float)(this.availableImageWidth - normalWidth)), (int)(ImageUtil.getYAlignFactor(this.imageElement) * (float)(this.availableImageHeight - normalHeight)), normalWidth, normalHeight));
            }
            finally {
                grx.dispose();
            }
            return new InternalImageProcessorResult(JRImageLoader.getInstance(JExcelApiMetadataExporter.this.jasperReportsContext).loadBytesFromAwtImage(bi, ImageTypeEnum.PNG));
        }

        private InternalImageProcessorResult processImageFillFrame(DataRenderable renderer) throws JRException {
            return new InternalImageProcessorResult(renderer.getData(JExcelApiMetadataExporter.this.jasperReportsContext));
        }

        private InternalImageProcessorResult processImageRetainShape(DataRenderable renderer) throws JRException {
            double ratio;
            Dimension2D dimension;
            int normalWidth = this.availableImageWidth;
            int normalHeight = this.availableImageHeight;
            Dimension2D dimension2D = dimension = renderer instanceof DimensionRenderable ? ((DimensionRenderable)((Object)renderer)).getDimension(JExcelApiMetadataExporter.this.jasperReportsContext) : null;
            if (dimension != null) {
                normalWidth = (int)dimension.getWidth();
                normalHeight = (int)dimension.getHeight();
            }
            if ((ratio = (double)normalWidth / (double)normalHeight) > (double)this.availableImageWidth / (double)this.availableImageHeight) {
                normalWidth = this.availableImageWidth;
                normalHeight = (int)((double)this.availableImageWidth / ratio);
            } else {
                normalWidth = (int)((double)this.availableImageHeight * ratio);
                normalHeight = this.availableImageHeight;
            }
            return new InternalImageProcessorResult(renderer.getData(JExcelApiMetadataExporter.this.jasperReportsContext));
        }
    }

    protected class CellTextValueHandler
    implements TextValueHandler {
        private final int x;
        private final int y;
        private final JRPrintText textElement;
        private final StyleInfo baseStyle;
        private final boolean cellComplexFormat;
        private CellValue result;

        public CellTextValueHandler(int x, int y, JRPrintText textElement, StyleInfo baseStyle, boolean cellComplexFormat) {
            this.x = x;
            this.y = y;
            this.textElement = textElement;
            this.baseStyle = baseStyle;
            this.cellComplexFormat = cellComplexFormat;
        }

        @Override
        public void handle(StringTextValue textValue) throws JRException {
            WritableCellFormat cellStyle = JExcelApiMetadataExporter.this.getLoadedCellStyle(this.baseStyle);
            this.result = new Label(this.x, this.y, textValue.getText(), (CellFormat)cellStyle);
        }

        @Override
        public void handle(NumberTextValue textValue) throws JRException {
            String convertedPattern = JExcelApiMetadataExporter.this.getConvertedPattern(this.textElement, textValue.getPattern());
            if (convertedPattern != null) {
                this.baseStyle.setDisplayFormat((DisplayFormat)JExcelApiMetadataExporter.this.getNumberFormat(convertedPattern, this.cellComplexFormat));
            }
            WritableCellFormat cellStyle = JExcelApiMetadataExporter.this.getLoadedCellStyle(this.baseStyle);
            if (textValue.getValue() == null) {
                this.result = this.blank(cellStyle);
            } else {
                double doubleValue = textValue.getValue().doubleValue();
                if ("[h]:mm:ss".equals(convertedPattern)) {
                    doubleValue /= 86400.0;
                }
                this.result = new Number(this.x, this.y, doubleValue, (CellFormat)cellStyle);
            }
        }

        @Override
        public void handle(DateTextValue textValue) throws JRException {
            String convertedPattern = JExcelApiMetadataExporter.this.getConvertedPattern(this.textElement, textValue.getPattern());
            if (convertedPattern != null) {
                this.baseStyle.setDisplayFormat((DisplayFormat)JExcelApiMetadataExporter.this.getDateFormat(convertedPattern));
            }
            WritableCellFormat cellStyle = JExcelApiMetadataExporter.this.getLoadedCellStyle(this.baseStyle);
            Date date = textValue.getValue();
            if (date == null) {
                this.result = this.blank(cellStyle);
            } else {
                date = JExcelApiMetadataExporter.this.translateDateValue(this.textElement, date);
                this.result = new DateTime(this.x, this.y, date, (CellFormat)cellStyle);
            }
        }

        @Override
        public void handle(BooleanTextValue textValue) throws JRException {
            WritableCellFormat cellStyle = JExcelApiMetadataExporter.this.getLoadedCellStyle(this.baseStyle);
            this.result = textValue.getValue() == null ? this.blank(cellStyle) : new Boolean(this.x, this.y, textValue.getValue().booleanValue(), (CellFormat)cellStyle);
        }

        protected Blank blank(WritableCellFormat cellStyle) {
            return new Blank(this.x, this.y, (CellFormat)cellStyle);
        }

        public CellValue getResult() {
            return this.result;
        }

        public boolean isCellComplexFormat() {
            return this.cellComplexFormat;
        }
    }

    protected class FormulaTextValueHandler
    implements TextValueHandler {
        private final int x;
        private final int y;
        private final JRPrintText textElement;
        private final String formula;
        private final StyleInfo baseStyle;
        private final boolean cellComplexFormat;
        private CellValue result;

        public FormulaTextValueHandler(int x, int y, JRPrintText textElement, String formula, StyleInfo baseStyle, boolean cellComplexFormat) {
            this.x = x;
            this.y = y;
            this.textElement = textElement;
            this.formula = formula;
            this.baseStyle = baseStyle;
            this.cellComplexFormat = cellComplexFormat;
        }

        @Override
        public void handle(StringTextValue textValue) throws JRException {
            this.result = this.formula();
        }

        @Override
        public void handle(NumberTextValue textValue) throws JRException {
            String convertedPattern = JExcelApiMetadataExporter.this.getConvertedPattern(this.textElement, textValue.getPattern());
            if (convertedPattern != null) {
                this.baseStyle.setDisplayFormat((DisplayFormat)JExcelApiMetadataExporter.this.getNumberFormat(convertedPattern, this.cellComplexFormat));
            }
            this.result = this.formula();
        }

        @Override
        public void handle(DateTextValue textValue) throws JRException {
            String convertedPattern = JExcelApiMetadataExporter.this.getConvertedPattern(this.textElement, textValue.getPattern());
            if (convertedPattern != null) {
                this.baseStyle.setDisplayFormat((DisplayFormat)JExcelApiMetadataExporter.this.getDateFormat(convertedPattern));
            }
            this.result = this.formula();
        }

        @Override
        public void handle(BooleanTextValue textValue) throws JRException {
            this.result = this.formula();
        }

        protected Formula formula() throws JRException {
            try {
                return new Formula(this.x, this.y, this.formula, (CellFormat)JExcelApiMetadataExporter.this.getLoadedCellStyle(this.baseStyle));
            }
            catch (Exception e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
                return null;
            }
        }

        public CellValue getResult() {
            return this.result;
        }
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JExcelApiExporterContext {
        protected ExporterContext() {
            super(JExcelApiMetadataExporter.this);
        }
    }
}

