/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sf.jasperreports.engine.JRRuntimeException;

public class ConcurrentMapping<K, V> {
    private final Mapper<K, V> mapper;
    private ConcurrentHashMap<K, Entry<V>> entries;

    public ConcurrentMapping(Mapper<K, V> mapper) {
        this.mapper = mapper;
        this.entries = new ConcurrentHashMap();
    }

    public V get(K key) {
        Entry<V> existingEntry = this.entries.get(key);
        Entry newEntry = null;
        V result = existingEntry == null ? ((existingEntry = this.entries.putIfAbsent(key, newEntry = new Entry())) == null ? this.getNew(newEntry, key) : this.getExisting(existingEntry, key)) : this.getExisting(existingEntry, key);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V getExisting(Entry<V> entry, K key) {
        Object result;
        block7: {
            Entry.Result entryResult = ((Entry)entry).result;
            if (entryResult.isAvailable()) {
                result = entryResult.value;
            } else {
                ((Entry)entry).lock();
                try {
                    ((Entry)entry).waitForStatus();
                    entryResult = ((Entry)entry).result;
                    if (entryResult.isAvailable()) {
                        result = entryResult.value;
                        break block7;
                    }
                    if (entryResult.isError()) {
                        ((Entry)entry).result = Entry.pendingResult();
                        result = this.getNew(entry, key);
                        break block7;
                    }
                    throw new JRRuntimeException("Unexpected entry status " + (Object)((Object)((Entry)entry).result.status));
                }
                finally {
                    ((Entry)entry).unlock();
                }
            }
        }
        return (V)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V getNew(Entry<V> entry, K key) {
        ((Entry)entry).lock();
        try {
            V v;
            block9: {
                block8: {
                    V value = null;
                    boolean success = false;
                    try {
                        value = this.mapper.compute(key);
                        success = true;
                        v = value;
                        if (!success) break block8;
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            ((Entry)entry).setValue(value);
                        } else {
                            ((Entry)entry).setError();
                        }
                        throw throwable;
                    }
                    ((Entry)entry).setValue(value);
                    break block9;
                }
                ((Entry)entry).setError();
            }
            return v;
        }
        finally {
            ((Entry)entry).unlock();
        }
    }

    public void clear() {
        this.entries.clear();
    }

    public Iterator<V> currentValues() {
        return new ValuesIterator();
    }

    private class ValuesIterator
    implements Iterator<V> {
        private Iterator<Entry<V>> entriesIterator;
        private Entry.Result<V> currentResult;

        private ValuesIterator() {
            this.entriesIterator = ConcurrentMapping.this.entries.values().iterator();
        }

        private void findAvailable() {
            this.currentResult = null;
            while (this.currentResult == null && this.entriesIterator.hasNext()) {
                Entry entry = this.entriesIterator.next();
                Entry.Result result = entry.result;
                if (!result.isAvailable()) continue;
                this.currentResult = result;
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentResult != null;
        }

        @Override
        public V next() {
            if (this.currentResult == null) {
                throw new NoSuchElementException();
            }
            Object value = this.currentResult.value;
            this.findAvailable();
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Entry<V> {
        private static final Result<?> RESULT_PENDING = new Result(Status.PENDING, null);
        private static final Result<?> RESULT_ERROR = new Result(Status.ERROR, null);
        private final Lock lock = new ReentrantLock();
        private final Condition statusCondition = this.lock.newCondition();
        private volatile Result<V> result = Entry.pendingResult();

        private static <V> Result<V> pendingResult() {
            return RESULT_PENDING;
        }

        private static <V> Result<V> errorResult() {
            return RESULT_ERROR;
        }

        private Entry() {
        }

        private void lock() {
            try {
                this.lock.lockInterruptibly();
            }
            catch (InterruptedException e) {
                throw new JRRuntimeException(e);
            }
        }

        private void unlock() {
            this.lock.unlock();
        }

        private void setValue(V value) {
            this.result = new Result(Status.AVAILABLE, value);
            this.statusCondition.signalAll();
        }

        private void setError() {
            this.result = Entry.errorResult();
            this.statusCondition.signalAll();
        }

        private void waitForStatus() {
            try {
                while (((Result)this.result).status == Status.PENDING) {
                    this.statusCondition.await();
                }
            }
            catch (InterruptedException e) {
                throw new JRRuntimeException(e);
            }
        }

        private static class Result<V> {
            private Status status;
            private V value;

            private Result(Status status, V value) {
                this.status = status;
                this.value = value;
            }

            public boolean isAvailable() {
                return this.status == Status.AVAILABLE;
            }

            public boolean isError() {
                return this.status == Status.ERROR;
            }
        }

        private static enum Status {
            PENDING,
            AVAILABLE,
            ERROR;

        }
    }

    public static interface Mapper<K, V> {
        public V compute(K var1);
    }
}

