/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.renderers;

import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.type.RenderableTypeEnum;
import net.sf.jasperreports.renderers.AbstractRenderToImageAwareRenderer;
import net.sf.jasperreports.renderers.AreaHyperlinksRenderable;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.renderers.DimensionRenderable;
import net.sf.jasperreports.renderers.Graphics2DRenderable;
import net.sf.jasperreports.renderers.WrappingImageDataToGraphics2DRenderer;
import net.sf.jasperreports.renderers.WrappingSvgDataToGraphics2DRenderer;
import net.sf.jasperreports.renderers.util.RendererUtil;

public class WrappingDataToGraphics2DRenderer
extends AbstractRenderToImageAwareRenderer
implements DataRenderable,
Graphics2DRenderable,
DimensionRenderable,
AreaHyperlinksRenderable {
    private static final long serialVersionUID = 10200L;
    private final DataRenderable dataRenderer;
    private final AreaHyperlinksRenderable areaHyperlinksRenderer;
    private JasperReportsContext jasperReportsContext;
    private byte[] data;
    private RenderableTypeEnum renderableType;
    private Graphics2DRenderable grxRenderer;
    private DimensionRenderable dimensionRenderer;

    public WrappingDataToGraphics2DRenderer(DataRenderable dataRenderer) {
        this.dataRenderer = dataRenderer;
        this.areaHyperlinksRenderer = dataRenderer instanceof AreaHyperlinksRenderable ? (AreaHyperlinksRenderable)((Object)dataRenderer) : null;
    }

    @Override
    public List<JRPrintImageAreaHyperlink> getImageAreaHyperlinks(Rectangle2D renderingArea) throws JRException {
        return this.areaHyperlinksRenderer == null ? null : this.areaHyperlinksRenderer.getImageAreaHyperlinks(renderingArea);
    }

    @Override
    public boolean hasImageAreaHyperlinks() {
        return this.areaHyperlinksRenderer == null ? false : this.areaHyperlinksRenderer.hasImageAreaHyperlinks();
    }

    @Override
    public byte[] getData(JasperReportsContext jasperReportsContext) throws JRException {
        this.updateCache(jasperReportsContext);
        return this.data;
    }

    @Override
    public Dimension2D getDimension(JasperReportsContext jasperReportsContext) throws JRException {
        this.updateCache(jasperReportsContext);
        return this.dimensionRenderer.getDimension(jasperReportsContext);
    }

    @Override
    public void render(JasperReportsContext jasperReportsContext, Graphics2D grx, Rectangle2D rectangle) throws JRException {
        this.updateCache(jasperReportsContext);
        this.grxRenderer.render(jasperReportsContext, grx, rectangle);
    }

    public RenderableTypeEnum getRenderableType() {
        try {
            this.updateCache(DefaultJasperReportsContext.getInstance());
        }
        catch (JRException e) {
            return RenderableTypeEnum.IMAGE;
        }
        return this.renderableType;
    }

    protected void updateCache(JasperReportsContext jasperReportsContext) throws JRException {
        if (this.jasperReportsContext != jasperReportsContext || this.data == null) {
            this.jasperReportsContext = jasperReportsContext;
            this.data = this.dataRenderer.getData(jasperReportsContext);
            boolean isSvgData = RendererUtil.getInstance(jasperReportsContext).isSvgData(this.data);
            if (isSvgData) {
                this.grxRenderer = new WrappingSvgDataToGraphics2DRenderer(this.dataRenderer);
                this.renderableType = RenderableTypeEnum.SVG;
            } else {
                this.grxRenderer = new WrappingImageDataToGraphics2DRenderer(this.dataRenderer);
                this.renderableType = RenderableTypeEnum.IMAGE;
            }
            this.dimensionRenderer = (DimensionRenderable)((Object)this.grxRenderer);
        }
    }
}

