/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.headertoolbar.actions;

import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.web.commands.Command;

public class HideUnhideColumnCommand
implements Command {
    private String expressionText;
    private String oldPrintWhenExpressionText;
    private StandardColumn column;
    private JRDesignExpression newPrintWhenExpression;
    private static final String BOOLEAN_FALSE = "Boolean.FALSE";
    private static final String BOOLEAN_TRUE = "Boolean.TRUE";

    public HideUnhideColumnCommand(StandardColumn column, boolean hide) {
        this.column = column;
        this.expressionText = hide ? BOOLEAN_FALSE : BOOLEAN_TRUE;
    }

    @Override
    public void execute() {
        if (this.column.getPrintWhenExpression() != null) {
            this.oldPrintWhenExpressionText = this.column.getPrintWhenExpression().getText();
            ((JRDesignExpression)this.column.getPrintWhenExpression()).setText(this.expressionText);
        } else {
            this.newPrintWhenExpression = new JRDesignExpression();
            this.newPrintWhenExpression.setText(this.expressionText);
            this.column.setPrintWhenExpression(this.newPrintWhenExpression);
        }
    }

    @Override
    public void undo() {
        if (this.oldPrintWhenExpressionText != null) {
            ((JRDesignExpression)this.column.getPrintWhenExpression()).setText(this.oldPrintWhenExpressionText);
        } else {
            this.column.setPrintWhenExpression(null);
        }
    }

    @Override
    public void redo() {
        if (this.newPrintWhenExpression != null) {
            this.column.setPrintWhenExpression(this.newPrintWhenExpression);
        } else {
            ((JRDesignExpression)this.column.getPrintWhenExpression()).setText(this.expressionText);
        }
    }
}

