/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.text.AttributedCharacterIterator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementIndex;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBoxPen;
import net.sf.jasperreports.engine.export.Cut;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.HyperlinkUtil;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.OccupiedGridCell;
import net.sf.jasperreports.engine.export.XlsRowLevelInfo;
import net.sf.jasperreports.engine.export.data.BooleanTextValue;
import net.sf.jasperreports.engine.export.data.DateTextValue;
import net.sf.jasperreports.engine.export.data.NumberTextValue;
import net.sf.jasperreports.engine.export.data.StringTextValue;
import net.sf.jasperreports.engine.export.data.TextValue;
import net.sf.jasperreports.engine.export.data.TextValueHandler;
import net.sf.jasperreports.engine.export.ooxml.GenericElementXlsxHandler;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporterContext;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporterNature;
import net.sf.jasperreports.engine.export.ooxml.PropsAppHelper;
import net.sf.jasperreports.engine.export.ooxml.PropsCoreHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxCellHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxContentTypesHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxDrawingHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxDrawingRelsHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxRelsHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxRunHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxSheetHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxSheetRelsHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxStyleHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxWorkbookHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxZip;
import net.sf.jasperreports.engine.export.type.ImageAnchorTypeEnum;
import net.sf.jasperreports.engine.export.zip.ExportZipEntry;
import net.sf.jasperreports.engine.export.zip.FileBufferedZipEntry;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterInputItem;
import net.sf.jasperreports.export.XlsReportConfiguration;
import net.sf.jasperreports.export.XlsxExporterConfiguration;
import net.sf.jasperreports.export.XlsxReportConfiguration;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.renderers.DimensionRenderable;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.RenderersCache;
import net.sf.jasperreports.renderers.ResourceRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRXlsxExporter
extends JRXlsAbstractExporter<XlsxReportConfiguration, XlsxExporterConfiguration, JRXlsxExporterContext> {
    private static final Log log = LogFactory.getLog(JRXlsxExporter.class);
    public static final String XLSX_EXPORTER_KEY = "net.sf.jasperreports.xlsx";
    protected static final String XLSX_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.xlsx.";
    protected static final String ONE_CELL = "oneCell";
    protected static final String TWO_CELL = "twoCell";
    protected static final String ABSOLUTE = "absolute";
    public static final String PROPERTY_MACRO_TEMPLATE = "net.sf.jasperreports.export.xlsx.macro.template";
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    public static final String IMAGE_NAME_PREFIX = "img_";
    protected static final int IMAGE_NAME_PREFIX_LEGTH = "img_".length();
    protected XlsxZip xlsxZip;
    protected XlsxWorkbookHelper wbHelper;
    protected XlsxRelsHelper relsHelper;
    protected XlsxContentTypesHelper ctHelper;
    protected PropsAppHelper appHelper;
    protected PropsCoreHelper coreHelper;
    protected XlsxSheetHelper sheetHelper;
    protected XlsxSheetRelsHelper sheetRelsHelper;
    protected XlsxDrawingHelper drawingHelper;
    protected XlsxDrawingRelsHelper drawingRelsHelper;
    protected XlsxStyleHelper styleHelper;
    protected XlsxCellHelper cellHelper;
    protected StringBuilder definedNames;
    protected String firstSheetName;
    protected String currentSheetName;
    protected Map<String, String> rendererToImagePathMap;
    protected int tableIndex;
    protected boolean startPage;
    protected LinkedList<Color> backcolorStack = new LinkedList();
    protected Color backcolor;
    private XlsxRunHelper runHelper;
    protected String sheetAutoFilter;
    protected String macroTemplate;
    protected PrintPageFormat oldPageFormat;
    protected Integer currentSheetPageScale;
    protected Integer currentSheetFirstPageNumber;
    protected Map<String, Integer> sheetMapping;

    public JRXlsxExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRXlsxExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.exporterContext = new ExporterContext();
        this.maxColumnIndex = 16383;
    }

    @Override
    protected Class<XlsxExporterConfiguration> getConfigurationInterface() {
        return XlsxExporterConfiguration.class;
    }

    @Override
    protected Class<XlsxReportConfiguration> getItemConfigurationInterface() {
        return XlsxReportConfiguration.class;
    }

    @Override
    protected void initExport() {
        super.initExport();
    }

    @Override
    protected void initReport() {
        super.initReport();
        XlsReportConfiguration configuration = (XlsReportConfiguration)this.getCurrentItemConfiguration();
        this.styleHelper.setConfiguration(configuration);
        this.nature = new JRXlsxExporterNature(this.jasperReportsContext, this.filter, configuration.isIgnoreGraphics(), configuration.isIgnorePageMargins());
    }

    @Override
    protected int exportPage(JRPrintPage page, CutsInfo xCuts, int startRow, String defaultSheetName) throws JRException {
        if (this.oldPageFormat != this.pageFormat) {
            this.oldPageFormat = this.pageFormat;
        }
        return super.exportPage(page, xCuts, startRow, defaultSheetName);
    }

    public JRPrintImage getImage(ExporterInput exporterInput, JRPrintElementIndex imageIndex) throws JRException {
        List<ExporterInputItem> items = exporterInput.getItems();
        ExporterInputItem item = items.get(imageIndex.getReportIndex());
        JasperPrint report = item.getJasperPrint();
        JRPrintPage page = report.getPages().get(imageIndex.getPageIndex());
        Integer[] elementIndexes = imageIndex.getAddressArray();
        JRPrintElement element = page.getElements().get(elementIndexes[0]);
        for (int i = 1; i < elementIndexes.length; ++i) {
            JRPrintFrame frame = (JRPrintFrame)element;
            element = frame.getElements().get(elementIndexes[i]);
        }
        if (element instanceof JRGenericPrintElement) {
            JRGenericPrintElement genericPrintElement = (JRGenericPrintElement)element;
            return ((GenericElementXlsxHandler)GenericElementHandlerEnviroment.getInstance(this.jasperReportsContext).getElementHandler(genericPrintElement.getGenericType(), XLSX_EXPORTER_KEY)).getImage((JRXlsxExporterContext)this.exporterContext, genericPrintElement);
        }
        return (JRPrintImage)element;
    }

    protected void exportStyledText(JRStyle style, JRStyledText styledText, Locale locale, boolean isStyledText) {
        String text = styledText.getText();
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            this.runHelper.export(style, iterator.getAttributes(), text.substring(iterator.getIndex(), runLimit), locale, this.invalidCharReplacement, isStyledText);
            iterator.setIndex(runLimit);
        }
    }

    protected JRPrintElementIndex getElementIndex(JRExporterGridCell gridCell) {
        JRPrintElementIndex imageIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, gridCell.getElementAddress());
        return imageIndex;
    }

    public static JRPrintElementIndex getPrintElementIndex(String imageName) {
        if (!imageName.startsWith(IMAGE_NAME_PREFIX)) {
            throw new JRRuntimeException("export.common.invalid.image.name", new Object[]{imageName});
        }
        return JRPrintElementIndex.parsePrintElementIndex(imageName.substring(IMAGE_NAME_PREFIX_LEGTH));
    }

    protected void setBackcolor(Color color) {
        this.backcolorStack.addLast(this.backcolor);
        this.backcolor = color;
    }

    protected void restoreBackcolor() {
        this.backcolor = this.backcolorStack.removeLast();
    }

    protected String getHyperlinkTarget(JRPrintHyperlink link) {
        String target = null;
        switch (link.getHyperlinkTargetValue()) {
            case SELF: {
                target = "_self";
                break;
            }
            default: {
                target = "_blank";
            }
        }
        return target;
    }

    protected String getHyperlinkURL(JRPrintHyperlink link) {
        String href;
        block16: {
            JRHyperlinkProducer customHandler;
            block17: {
                href = null;
                XlsReportConfiguration configuration = (XlsReportConfiguration)this.getCurrentItemConfiguration();
                Boolean ignoreHyperlink = HyperlinkUtil.getIgnoreHyperlink("net.sf.jasperreports.export.xls.ignore.hyperlink", link);
                if (ignoreHyperlink == null) {
                    ignoreHyperlink = configuration.isIgnoreHyperlink();
                }
                if (ignoreHyperlink.booleanValue()) break block16;
                customHandler = this.getHyperlinkProducer(link);
                if (customHandler != null) break block17;
                switch (link.getHyperlinkTypeValue()) {
                    case REFERENCE: {
                        if (link.getHyperlinkReference() != null) {
                            try {
                                href = link.getHyperlinkReference().replaceAll("\\s", URLEncoder.encode(" ", "UTF-8"));
                            }
                            catch (UnsupportedEncodingException e) {
                                href = link.getHyperlinkReference();
                            }
                            break;
                        }
                        break block16;
                    }
                    case LOCAL_ANCHOR: {
                        if (!configuration.isIgnoreAnchors().booleanValue() && link.getHyperlinkAnchor() != null) {
                            href = link.getHyperlinkAnchor();
                            break;
                        }
                        break block16;
                    }
                    case LOCAL_PAGE: {
                        if (!configuration.isIgnoreAnchors().booleanValue() && link.getHyperlinkPage() != null) {
                            href = JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + (configuration.isOnePagePerSheet() != false ? link.getHyperlinkPage().toString() : "1");
                            break;
                        }
                        break block16;
                    }
                    case REMOTE_ANCHOR: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkAnchor() != null) {
                            try {
                                href = link.getHyperlinkReference().replaceAll("\\s", URLEncoder.encode(" ", "UTF-8"));
                            }
                            catch (UnsupportedEncodingException e) {
                                href = link.getHyperlinkReference();
                            }
                            href = href + "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block16;
                    }
                    case REMOTE_PAGE: {
                        break;
                    }
                }
                break block16;
            }
            href = customHandler.getHyperlink(link);
        }
        return href;
    }

    protected void insertPageAnchor(int colIndex, int rowIndex) {
        if (!((XlsxReportConfiguration)this.getCurrentItemConfiguration()).isIgnoreAnchors().booleanValue() && this.startPage) {
            String anchorPage = JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + (this.sheetIndex - this.sheetsBeforeCurrentReport);
            String ref = "'" + JRStringUtil.xmlEncode(this.currentSheetName) + "'!$A$1";
            this.definedNames.append("<definedName name=\"" + this.getDefinedName(anchorPage) + "\">" + ref + "</definedName>\n");
            this.startPage = false;
        }
    }

    @Override
    protected void addBlankCell(JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        this.cellHelper.exportHeader(gridCell, rowIndex, colIndex, this.maxColumnIndex, this.sheetInfo);
        this.cellHelper.exportFooter();
    }

    @Override
    protected void closeWorkbook(OutputStream os) throws JRException {
        if (this.sheetMapping != null && this.definedNamesMap != null && !this.definedNamesMap.isEmpty()) {
            for (Map.Entry entry : this.definedNamesMap.entrySet()) {
                String name = ((JRXlsAbstractExporter.NameScope)entry.getKey()).getName();
                String localSheetId = "";
                if (name == null || entry.getValue() == null) continue;
                String scope = ((JRXlsAbstractExporter.NameScope)entry.getKey()).getScope();
                if (scope != null && !scope.equalsIgnoreCase("workbook") && this.sheetMapping.containsKey(scope)) {
                    localSheetId = " localSheetId=\"" + this.sheetMapping.get(scope) + "\"";
                }
                this.definedNames.append("<definedName name=\"" + name + "\"" + localSheetId + ">" + (String)entry.getValue() + "</definedName>\n");
            }
        }
        this.styleHelper.export();
        this.styleHelper.close();
        try {
            this.wbHelper.exportFooter();
            this.wbHelper.close();
            this.relsHelper.exportFooter();
            this.relsHelper.close();
            this.ctHelper.exportFooter();
            this.ctHelper.close();
            this.appHelper.exportFooter();
            this.appHelper.close();
            this.coreHelper.exportFooter();
            this.coreHelper.close();
            this.xlsxZip.zipEntries(os);
            this.xlsxZip.dispose();
        }
        catch (IOException e) {
            throw new JRException(e);
        }
    }

    @Override
    protected void createSheet(CutsInfo xCuts, JRXlsAbstractExporter.SheetInfo sheetInfo) {
        this.startPage = true;
        this.currentSheetPageScale = sheetInfo.sheetPageScale;
        this.currentSheetFirstPageNumber = sheetInfo.sheetFirstPageNumber;
        this.currentSheetName = sheetInfo.sheetName;
        this.firstSheetName = this.firstSheetName == null ? this.currentSheetName : this.firstSheetName;
        this.wbHelper.exportSheet(this.sheetIndex + 1, this.currentSheetName, this.sheetMapping);
        this.ctHelper.exportSheet(this.sheetIndex + 1);
        this.relsHelper.exportSheet(this.sheetIndex + 1);
        XlsxReportConfiguration configuration = (XlsxReportConfiguration)this.getCurrentItemConfiguration();
        ExportZipEntry sheetRelsEntry = this.xlsxZip.addSheetRels(this.sheetIndex + 1);
        Writer sheetRelsWriter = sheetRelsEntry.getWriter();
        this.sheetRelsHelper = new XlsxSheetRelsHelper(this.jasperReportsContext, sheetRelsWriter);
        ExportZipEntry sheetEntry = this.xlsxZip.addSheet(this.sheetIndex + 1);
        Writer sheetWriter = sheetEntry.getWriter();
        this.sheetHelper = new XlsxSheetHelper(this.jasperReportsContext, sheetWriter, this.sheetRelsHelper, configuration);
        ExportZipEntry drawingRelsEntry = this.xlsxZip.addDrawingRels(this.sheetIndex + 1);
        Writer drawingRelsWriter = drawingRelsEntry.getWriter();
        this.drawingRelsHelper = new XlsxDrawingRelsHelper(this.jasperReportsContext, drawingRelsWriter);
        ExportZipEntry drawingEntry = this.xlsxZip.addDrawing(this.sheetIndex + 1);
        Writer drawingWriter = drawingEntry.getWriter();
        this.drawingHelper = new XlsxDrawingHelper(this.jasperReportsContext, drawingWriter, this.drawingRelsHelper);
        this.cellHelper = new XlsxCellHelper(this.jasperReportsContext, sheetWriter, this.styleHelper);
        this.runHelper = new XlsxRunHelper(this.jasperReportsContext, sheetWriter, this.getExporterKey());
        boolean showGridlines = true;
        if (sheetInfo.sheetShowGridlines == null) {
            Boolean documentShowGridlines = configuration.isShowGridLines();
            if (documentShowGridlines != null) {
                showGridlines = documentShowGridlines;
            }
        } else {
            showGridlines = sheetInfo.sheetShowGridlines;
        }
        this.sheetHelper.exportHeader(showGridlines, sheetInfo.sheetPageScale == null ? 0 : sheetInfo.sheetPageScale, sheetInfo.rowFreezeIndex, sheetInfo.columnFreezeIndex, this.maxColumnIndex, this.jasperPrint, sheetInfo.tabColor);
        this.sheetRelsHelper.exportHeader(this.sheetIndex + 1);
        this.drawingHelper.exportHeader();
        this.drawingRelsHelper.exportHeader();
    }

    @Override
    protected void closeSheet() {
        if (this.sheetHelper != null) {
            XlsReportConfiguration configuration = (XlsReportConfiguration)this.getCurrentItemConfiguration();
            boolean isIgnorePageMargins = configuration.isIgnorePageMargins();
            if (this.currentSheetFirstPageNumber != null && this.currentSheetFirstPageNumber > 0) {
                this.sheetHelper.exportFooter(this.sheetIndex, this.oldPageFormat == null ? this.pageFormat : this.oldPageFormat, isIgnorePageMargins, this.sheetAutoFilter, this.currentSheetPageScale, this.currentSheetFirstPageNumber, false, this.pageIndex - this.sheetInfo.sheetFirstPageIndex, this.sheetInfo.printSettings);
                this.firstPageNotSet = false;
            } else {
                Integer documentFirstPageNumber = configuration.getFirstPageNumber();
                if (documentFirstPageNumber != null && documentFirstPageNumber > 0 && this.firstPageNotSet) {
                    this.sheetHelper.exportFooter(this.sheetIndex, this.oldPageFormat == null ? this.pageFormat : this.oldPageFormat, isIgnorePageMargins, this.sheetAutoFilter, this.currentSheetPageScale, documentFirstPageNumber, false, this.pageIndex - this.sheetInfo.sheetFirstPageIndex, this.sheetInfo.printSettings);
                    this.firstPageNotSet = false;
                } else {
                    this.sheetHelper.exportFooter(this.sheetIndex, this.oldPageFormat == null ? this.pageFormat : this.oldPageFormat, isIgnorePageMargins, this.sheetAutoFilter, this.currentSheetPageScale, null, this.firstPageNotSet, this.pageIndex - this.sheetInfo.sheetFirstPageIndex, this.sheetInfo.printSettings);
                }
            }
            if (this.sheetAutoFilter != null) {
                int index = Math.max(0, this.sheetIndex - 1);
                this.definedNames.append("<definedName name=\"_xlnm._FilterDatabase\" localSheetId=\"" + index + "\">'" + JRStringUtil.xmlEncode(this.currentSheetName) + "'!" + this.sheetAutoFilter + "</definedName>\n");
            }
            this.sheetHelper.close();
            this.sheetRelsHelper.exportFooter();
            this.sheetRelsHelper.close();
            this.drawingHelper.exportFooter();
            this.drawingHelper.close();
            this.drawingRelsHelper.exportFooter();
            this.drawingRelsHelper.close();
        }
    }

    @Override
    protected void exportFrame(JRPrintFrame frame, JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        this.cellHelper.exportHeader(gridCell, rowIndex, colIndex, this.maxColumnIndex, this.sheetInfo);
        this.sheetHelper.exportMergedCells(rowIndex, colIndex, this.maxColumnIndex, gridCell.getRowSpan(), gridCell.getColSpan());
        this.cellHelper.exportFooter();
    }

    @Override
    public void exportImage(JRPrintImage image, JRExporterGridCell gridCell, int colIndex, int rowIndex, int emptyCols, int yCutsRow, JRGridLayout layout) throws JRException {
        int topPadding = Math.max(image.getLineBox().getTopPadding(), this.getImageBorderCorrection(image.getLineBox().getTopPen()));
        int leftPadding = Math.max(image.getLineBox().getLeftPadding(), this.getImageBorderCorrection(image.getLineBox().getLeftPen()));
        int bottomPadding = Math.max(image.getLineBox().getBottomPadding(), this.getImageBorderCorrection(image.getLineBox().getBottomPen()));
        int rightPadding = Math.max(image.getLineBox().getRightPadding(), this.getImageBorderCorrection(image.getLineBox().getRightPen()));
        int availableImageWidth = image.getWidth() - leftPadding - rightPadding;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = image.getHeight() - topPadding - bottomPadding;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        this.cellHelper.exportHeader(gridCell, rowIndex, colIndex, this.maxColumnIndex, this.sheetInfo);
        Renderable renderer = image.getRenderer();
        if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
            InternalImageProcessorResult imageProcessorResult;
            block31: {
                InternalImageProcessor imageProcessor = new InternalImageProcessor(image, image.getScaleImageValue() != ScaleImageEnum.FILL_FRAME, gridCell, availableImageWidth, availableImageHeight);
                imageProcessorResult = null;
                try {
                    imageProcessorResult = imageProcessor.process(renderer);
                }
                catch (Exception e) {
                    Renderable onErrorRenderer = this.getRendererUtil().handleImageError(e, image.getOnErrorTypeValue());
                    if (onErrorRenderer == null) break block31;
                    imageProcessorResult = imageProcessor.process(onErrorRenderer);
                }
            }
            if (imageProcessorResult != null) {
                String href;
                int width = availableImageWidth;
                int height = availableImageHeight;
                double cropTop = 0.0;
                double cropLeft = 0.0;
                double cropBottom = 0.0;
                double cropRight = 0.0;
                block1 : switch (image.getScaleImageValue()) {
                    case FILL_FRAME: {
                        width = availableImageWidth;
                        height = availableImageHeight;
                        break;
                    }
                    case CLIP: {
                        double normalWidth = availableImageWidth;
                        double normalHeight = availableImageHeight;
                        Dimension2D dimension = imageProcessorResult.dimension;
                        if (dimension != null) {
                            normalWidth = dimension.getWidth();
                            normalHeight = dimension.getHeight();
                        }
                        switch (image.getHorizontalImageAlign()) {
                            case RIGHT: {
                                cropLeft = 100000.0 * ((double)availableImageWidth - normalWidth) / (double)availableImageWidth;
                                cropRight = 0.0;
                                break;
                            }
                            case CENTER: {
                                cropRight = cropLeft = 100000.0 * ((double)availableImageWidth - normalWidth) / (double)availableImageWidth / 2.0;
                                break;
                            }
                            default: {
                                cropLeft = 0.0;
                                cropRight = 100000.0 * ((double)availableImageWidth - normalWidth) / (double)availableImageWidth;
                            }
                        }
                        switch (image.getVerticalImageAlign()) {
                            case TOP: {
                                cropTop = 0.0;
                                cropBottom = 100000.0 * ((double)availableImageHeight - normalHeight) / (double)availableImageHeight;
                                break block1;
                            }
                            case MIDDLE: {
                                cropBottom = cropTop = 100000.0 * ((double)availableImageHeight - normalHeight) / (double)availableImageHeight / 2.0;
                                break block1;
                            }
                        }
                        cropTop = 100000.0 * ((double)availableImageHeight - normalHeight) / (double)availableImageHeight;
                        cropBottom = 0.0;
                        break;
                    }
                    default: {
                        double ratio;
                        double normalWidth = availableImageWidth;
                        double normalHeight = availableImageHeight;
                        Dimension2D dimension = imageProcessorResult.dimension;
                        if (dimension != null) {
                            normalWidth = dimension.getWidth();
                            normalHeight = dimension.getHeight();
                        }
                        if ((ratio = normalWidth / normalHeight) > (double)availableImageWidth / (double)availableImageHeight) {
                            width = availableImageWidth;
                            height = (int)((double)width / ratio);
                            switch (image.getVerticalImageAlign()) {
                                case TOP: {
                                    cropTop = 0.0;
                                    cropBottom = 100000 * (availableImageHeight - height) / availableImageHeight;
                                    break block1;
                                }
                                case MIDDLE: {
                                    cropBottom = cropTop = (double)(100000 * (availableImageHeight - height) / availableImageHeight / 2);
                                    break block1;
                                }
                            }
                            cropTop = 100000 * (availableImageHeight - height) / availableImageHeight;
                            cropBottom = 0.0;
                            break;
                        }
                        height = availableImageHeight;
                        width = (int)(ratio * (double)height);
                        switch (image.getHorizontalImageAlign()) {
                            case RIGHT: {
                                cropLeft = 100000 * (availableImageWidth - width) / availableImageWidth;
                                cropRight = 0.0;
                                break block1;
                            }
                            case CENTER: {
                                cropRight = cropLeft = (double)(100000 * (availableImageWidth - width) / availableImageWidth / 2);
                                break block1;
                            }
                        }
                        cropLeft = 0.0;
                        cropRight = 100000 * (availableImageWidth - width) / availableImageWidth;
                    }
                }
                XlsReportConfiguration configuration = (XlsReportConfiguration)this.getCurrentItemConfiguration();
                if (!configuration.isIgnoreAnchors().booleanValue()) {
                    this.insertPageAnchor(colIndex, rowIndex);
                    if (image.getAnchorName() != null) {
                        String ref = "'" + JRStringUtil.xmlEncode(this.currentSheetName) + "'!$" + JRXlsAbstractExporter.getColumIndexName(colIndex, this.maxColumnIndex) + "$" + (rowIndex + 1);
                        this.definedNames.append("<definedName name=\"" + this.getDefinedName(image.getAnchorName()) + "\">" + ref + "</definedName>\n");
                    }
                }
                this.drawingRelsHelper.exportImage(imageProcessorResult.imagePath);
                this.sheetHelper.exportMergedCells(rowIndex, colIndex, this.maxColumnIndex, gridCell.getRowSpan(), gridCell.getColSpan());
                ImageAnchorTypeEnum imageAnchorType = ImageAnchorTypeEnum.getByName(JRPropertiesUtil.getOwnProperty(image, "net.sf.jasperreports.export.xls.image.anchor.type"));
                if (imageAnchorType == null && (imageAnchorType = configuration.getImageAnchorType()) == null) {
                    imageAnchorType = ImageAnchorTypeEnum.MOVE_NO_SIZE;
                }
                this.drawingHelper.write("<xdr:twoCellAnchor editAs=\"" + this.getAnchorType(imageAnchorType) + "\">\n");
                this.drawingHelper.write("<xdr:from><xdr:col>" + colIndex + "</xdr:col><xdr:colOff>" + LengthUtil.emu(leftPadding) + "</xdr:colOff><xdr:row>" + rowIndex + "</xdr:row><xdr:rowOff>" + LengthUtil.emu(topPadding) + "</xdr:rowOff></xdr:from>\n");
                this.drawingHelper.write("<xdr:to><xdr:col>" + (colIndex + gridCell.getColSpan()) + "</xdr:col><xdr:colOff>" + LengthUtil.emu(-rightPadding) + "</xdr:colOff><xdr:row>" + (rowIndex + (configuration.isCollapseRowSpan() != false ? 1 : gridCell.getRowSpan())) + "</xdr:row><xdr:rowOff>" + LengthUtil.emu(-bottomPadding) + "</xdr:rowOff></xdr:to>\n");
                this.drawingHelper.write("<xdr:pic>\n");
                this.drawingHelper.write("<xdr:nvPicPr><xdr:cNvPr id=\"" + (image.hashCode() > 0 ? image.hashCode() : -image.hashCode()) + "\" name=\"Picture\">\n");
                String string = href = HyperlinkTypeEnum.LOCAL_ANCHOR.equals(image.getHyperlinkTypeValue()) || HyperlinkTypeEnum.LOCAL_PAGE.equals(image.getHyperlinkTypeValue()) ? "#" + this.getHyperlinkURL(image) : this.getHyperlinkURL(image);
                if (href != null) {
                    this.drawingHelper.exportHyperlink(href);
                }
                this.drawingHelper.write("</xdr:cNvPr><xdr:cNvPicPr/></xdr:nvPicPr>\n");
                this.drawingHelper.write("<xdr:blipFill>\n");
                this.drawingHelper.write("<a:blip r:embed=\"" + imageProcessorResult.imagePath + "\"/>");
                this.drawingHelper.write("<a:srcRect");
                this.drawingHelper.write("/>");
                this.drawingHelper.write("<a:stretch><a:fillRect");
                this.drawingHelper.write(" l=\"" + (int)cropLeft + "\"");
                this.drawingHelper.write(" t=\"" + (int)cropTop + "\"");
                this.drawingHelper.write(" r=\"" + (int)cropRight + "\"");
                this.drawingHelper.write(" b=\"" + (int)cropBottom + "\"");
                this.drawingHelper.write("/></a:stretch>\n");
                this.drawingHelper.write("</xdr:blipFill>\n");
                this.drawingHelper.write("<xdr:spPr><a:xfrm><a:off x=\"0\" y=\"0\"/><a:ext cx=\"" + LengthUtil.emu(0.0f) + "\" cy=\"" + LengthUtil.emu(0.0f) + "\"/>");
                this.drawingHelper.write("</a:xfrm><a:prstGeom prst=\"rect\"></a:prstGeom>\n");
                this.drawingHelper.write("</xdr:spPr>\n");
                this.drawingHelper.write("</xdr:pic>\n");
                this.drawingHelper.write("<xdr:clientData/>\n");
                this.drawingHelper.write("</xdr:twoCellAnchor>\n");
            }
        }
        this.cellHelper.exportFooter();
    }

    @Override
    protected void exportLine(JRPrintLine line, JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        JRBaseLineBox box = new JRBaseLineBox(null);
        JRBoxPen pen = null;
        LineDirectionEnum direction = null;
        float ratio = line.getWidth() / line.getHeight();
        if (ratio > 1.0f) {
            if (line.getHeight() > 1) {
                direction = line.getDirectionValue();
                pen = box.getPen();
            } else {
                pen = line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? box.getTopPen() : box.getBottomPen();
            }
        } else if (line.getWidth() > 1) {
            direction = line.getDirectionValue();
            pen = box.getPen();
        } else {
            pen = line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? box.getLeftPen() : box.getRightPen();
        }
        pen.setLineColor(line.getLinePen().getLineColor());
        pen.setLineStyle(line.getLinePen().getLineStyleValue());
        pen.setLineWidth(line.getLinePen().getLineWidth());
        gridCell.setBox(box);
        this.cellHelper.exportHeader(gridCell, rowIndex, colIndex, this.maxColumnIndex, this.sheetInfo, direction);
        this.sheetHelper.exportMergedCells(rowIndex, colIndex, this.maxColumnIndex, gridCell.getRowSpan(), gridCell.getColSpan());
        this.cellHelper.exportFooter();
    }

    @Override
    protected void exportRectangle(JRPrintGraphicElement rectangle, JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        JRBaseLineBox box = new JRBaseLineBox(null);
        JRBoxPen pen = box.getPen();
        pen.setLineColor(rectangle.getLinePen().getLineColor());
        pen.setLineStyle(rectangle.getLinePen().getLineStyleValue());
        pen.setLineWidth(rectangle.getLinePen().getLineWidth());
        gridCell.setBox(box);
        this.cellHelper.exportHeader(gridCell, rowIndex, colIndex, this.maxColumnIndex, this.sheetInfo);
        this.sheetHelper.exportMergedCells(rowIndex, colIndex, this.maxColumnIndex, gridCell.getRowSpan(), gridCell.getColSpan());
        this.cellHelper.exportFooter();
    }

    @Override
    public void exportText(final JRPrintText text, JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        String href;
        final JRStyledText styledText = this.getStyledText(text);
        final String textStr = styledText.getText();
        TextValue textValue = null;
        String pattern = null;
        XlsReportConfiguration configuration = (XlsReportConfiguration)this.getCurrentItemConfiguration();
        if (configuration.isDetectCellType().booleanValue()) {
            textValue = this.getTextValue(text, textStr);
            if (textValue instanceof NumberTextValue) {
                pattern = ((NumberTextValue)textValue).getPattern();
            } else if (textValue instanceof DateTextValue) {
                pattern = ((DateTextValue)textValue).getPattern();
            }
        }
        final String convertedPattern = this.getConvertedPattern(text, pattern);
        this.cellHelper.exportHeader(gridCell, rowIndex, colIndex, this.maxColumnIndex, textValue, convertedPattern, this.getTextLocale(text), this.isWrapText(gridCell.getElement()) || Boolean.TRUE.equals(((JRXlsxExporterNature)this.nature).getColumnAutoFit(gridCell.getElement())), this.isCellHidden(gridCell.getElement()), this.isCellLocked(gridCell.getElement()), this.isShrinkToFit(gridCell.getElement()), this.isIgnoreTextFormatting(text), text.getRotationValue(), this.sheetInfo);
        this.sheetHelper.exportMergedCells(rowIndex, colIndex, this.maxColumnIndex, gridCell.getRowSpan(), gridCell.getColSpan());
        String textFormula = this.getFormula(text);
        if (textFormula != null) {
            this.sheetHelper.write("<f>" + textFormula + "</f>\n");
        }
        if (!configuration.isIgnoreAnchors().booleanValue()) {
            this.insertPageAnchor(colIndex, rowIndex);
            if (text.getAnchorName() != null) {
                String ref = "'" + JRStringUtil.xmlEncode(this.currentSheetName) + "'!$" + JRXlsAbstractExporter.getColumIndexName(colIndex, this.maxColumnIndex) + "$" + (rowIndex + 1);
                this.definedNames.append("<definedName name=\"" + this.getDefinedName(text.getAnchorName()) + "\">" + ref + "</definedName>\n");
            }
        }
        if ((href = this.getHyperlinkURL(text)) != null) {
            this.sheetHelper.exportHyperlink(rowIndex, colIndex, this.maxColumnIndex, href, HyperlinkTypeEnum.LOCAL_ANCHOR.equals(text.getHyperlinkTypeValue()) || HyperlinkTypeEnum.LOCAL_PAGE.equals(text.getHyperlinkTypeValue()));
        }
        TextValueHandler handler = new TextValueHandler(){

            @Override
            public void handle(BooleanTextValue textValue) throws JRException {
                if (textValue.getValue() != null) {
                    JRXlsxExporter.this.sheetHelper.write("<v>" + textValue.getValue() + "</v>");
                }
            }

            @Override
            public void handle(DateTextValue textValue) throws JRException {
                Date date = textValue.getValue();
                if (date != null) {
                    JRXlsxExporter.this.sheetHelper.write("<v>" + (date == null ? "" : Double.valueOf(JRDataUtils.getExcelSerialDayNumber(date, JRXlsxExporter.this.getTextLocale(text), JRXlsxExporter.this.getTextTimeZone(text)))) + "</v>");
                }
            }

            @Override
            public void handle(NumberTextValue textValue) throws JRException {
                if (textValue.getValue() != null) {
                    JRXlsxExporter.this.sheetHelper.write("<v>");
                    double doubleValue = textValue.getValue().doubleValue();
                    if ("[h]:mm:ss".equals(convertedPattern)) {
                        doubleValue /= 86400.0;
                    }
                    JRXlsxExporter.this.sheetHelper.write(String.valueOf(doubleValue));
                    JRXlsxExporter.this.sheetHelper.write("</v>");
                }
            }

            @Override
            public void handle(StringTextValue textValue) throws JRException {
                this.writeText();
            }

            private void writeText() throws JRException {
                if (textStr != null && textStr.length() > 0) {
                    JRXlsxExporter.this.sheetHelper.write("<is>");
                    String markup = text.getMarkup();
                    boolean isStyledText = markup != null && !"none".equals(markup);
                    JRXlsxExporter.this.exportStyledText(text.getStyle(), styledText, JRXlsxExporter.this.getTextLocale(text), isStyledText);
                    JRXlsxExporter.this.sheetHelper.write("</is>");
                }
            }
        };
        if (textValue != null) {
            textValue.handle(handler);
        } else {
            handler.handle((StringTextValue)null);
        }
        this.cellHelper.exportFooter();
    }

    @Override
    protected void exportGenericElement(JRGenericPrintElement element, JRExporterGridCell gridCell, int colIndex, int rowIndex, int emptyCols, int yCutsRow, JRGridLayout layout) throws JRException {
        GenericElementXlsxHandler handler = (GenericElementXlsxHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(element.getGenericType(), XLSX_EXPORTER_KEY);
        if (handler != null) {
            handler.exportElement((JRXlsxExporterContext)this.exporterContext, element, gridCell, colIndex, rowIndex);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No XLSX generic element handler for " + element.getGenericType()));
        }
    }

    @Override
    protected void openWorkbook(OutputStream os) throws JRException {
        this.rendererToImagePathMap = new HashMap<String, String>();
        this.definedNames = new StringBuilder();
        this.sheetMapping = new HashMap<String, Integer>();
        try {
            String keywords;
            String author;
            String subject;
            String macro;
            String memoryThreshold = this.jasperPrint.getPropertiesMap().getProperty("net.sf.jasperreports.file.buffer.os.memory.threshold");
            this.xlsxZip = new XlsxZip(this.jasperReportsContext, memoryThreshold == null ? null : Integer.valueOf(JRPropertiesUtil.asInteger(memoryThreshold)));
            this.wbHelper = new XlsxWorkbookHelper(this.jasperReportsContext, this.xlsxZip.getWorkbookEntry().getWriter(), this.definedNames);
            this.wbHelper.exportHeader();
            this.relsHelper = new XlsxRelsHelper(this.jasperReportsContext, this.xlsxZip.getRelsEntry().getWriter());
            this.ctHelper = new XlsxContentTypesHelper(this.jasperReportsContext, this.xlsxZip.getContentTypesEntry().getWriter());
            this.appHelper = new PropsAppHelper(this.jasperReportsContext, this.xlsxZip.getAppEntry().getWriter());
            this.coreHelper = new PropsCoreHelper(this.jasperReportsContext, this.xlsxZip.getCoreEntry().getWriter());
            XlsxExporterConfiguration configuration = (XlsxExporterConfiguration)this.getCurrentConfiguration();
            String string = macro = this.macroTemplate == null ? configuration.getMacroTemplate() : this.macroTemplate;
            if (macro != null) {
                this.xlsxZip.addMacro(macro);
                this.relsHelper.setContainsMacro(true);
                this.ctHelper.setContainsMacro(true);
            }
            this.relsHelper.exportHeader();
            this.ctHelper.exportHeader();
            this.appHelper.exportHeader();
            String application = configuration.getMetadataApplication();
            if (application == null) {
                application = "JasperReports Library version " + Package.getPackage("net.sf.jasperreports.engine").getImplementationVersion();
            }
            this.appHelper.exportProperty("Application", application);
            this.coreHelper.exportHeader();
            String title = configuration.getMetadataTitle();
            if (title != null) {
                this.coreHelper.exportProperty("dc:title", title);
            }
            if ((subject = configuration.getMetadataSubject()) != null) {
                this.coreHelper.exportProperty("dc:subject", subject);
            }
            if ((author = configuration.getMetadataAuthor()) != null) {
                this.coreHelper.exportProperty("dc:creator", author);
            }
            if ((keywords = configuration.getMetadataKeywords()) != null) {
                this.coreHelper.exportProperty("cp:keywords", keywords);
            }
            this.styleHelper = new XlsxStyleHelper(this.jasperReportsContext, this.xlsxZip.getStylesEntry().getWriter(), this.getExporterKey());
            this.firstPageNotSet = true;
            this.firstSheetName = null;
        }
        catch (IOException e) {
            throw new JRException(e);
        }
    }

    protected void setBackground() {
    }

    @Override
    protected void addOccupiedCell(OccupiedGridCell occupiedGridCell, int colIndex, int rowIndex) {
        this.cellHelper.exportHeader(occupiedGridCell, rowIndex, colIndex, this.maxColumnIndex, this.sheetInfo);
        this.cellHelper.exportFooter();
    }

    @Override
    protected void setColumnWidth(int col, int width, boolean autoFit) {
        this.sheetHelper.exportColumn(col, width, autoFit);
    }

    @Override
    protected void setRowHeight(int rowIndex, int rowHeight, Cut yCut, XlsRowLevelInfo levelInfo) throws JRException {
        this.sheetHelper.exportRow(rowHeight, yCut, levelInfo);
    }

    @Override
    protected void addRowBreak(int rowIndex) {
        this.sheetHelper.addRowBreak(rowIndex);
    }

    @Override
    public String getExporterKey() {
        return XLSX_EXPORTER_KEY;
    }

    @Override
    public String getExporterPropertiesPrefix() {
        return XLSX_EXPORTER_PROPERTIES_PREFIX;
    }

    @Override
    protected void setFreezePane(int rowIndex, int colIndex) {
    }

    @Override
    protected void setFreezePane(int rowIndex, int colIndex, boolean isRowEdge, boolean isColumnEdge) {
    }

    @Override
    protected void setSheetName(String sheetName) {
    }

    @Override
    protected void setAutoFilter(String autoFilterRange) {
        this.sheetAutoFilter = autoFilterRange;
    }

    @Override
    protected void resetAutoFilters() {
        super.resetAutoFilters();
        this.sheetAutoFilter = null;
    }

    @Override
    protected void setRowLevels(XlsRowLevelInfo levelInfo, String level) {
    }

    public String getMacroTemplatePath() {
        return this.macroTemplate;
    }

    public void setMacroTemplate(String macroTemplate) {
        this.macroTemplate = macroTemplate;
    }

    protected void setScale(Integer scale) {
    }

    protected String getAnchorType(ImageAnchorTypeEnum anchorType) {
        switch (anchorType) {
            case MOVE_SIZE: {
                return TWO_CELL;
            }
            case NO_MOVE_NO_SIZE: {
                return ABSOLUTE;
            }
        }
        return ONE_CELL;
    }

    protected String getDefinedName(String name) {
        if (name != null) {
            return name.replaceAll("\\W", "");
        }
        return null;
    }

    private class InternalImageProcessorResult {
        protected final String imagePath;
        protected final Dimension2D dimension;

        protected InternalImageProcessorResult(String imagePath, Dimension2D dimension) {
            this.imagePath = imagePath;
            this.dimension = dimension;
        }
    }

    private class InternalImageProcessor {
        private final JRPrintElement imageElement;
        private final RenderersCache imageRenderersCache;
        private final boolean needDimension;
        private final JRExporterGridCell cell;
        private final int availableImageWidth;
        private final int availableImageHeight;

        protected InternalImageProcessor(JRPrintImage imageElement, boolean needDimension, JRExporterGridCell cell, int availableImageWidth, int availableImageHeight) {
            this.imageElement = imageElement;
            this.imageRenderersCache = imageElement.isUsingCache() ? JRXlsxExporter.this.renderersCache : new RenderersCache(JRXlsxExporter.this.getJasperReportsContext());
            this.needDimension = needDimension;
            this.cell = cell;
            this.availableImageWidth = availableImageWidth;
            this.availableImageHeight = availableImageHeight;
        }

        private InternalImageProcessorResult process(Renderable renderer) throws JRException {
            if (renderer instanceof ResourceRenderer) {
                renderer = this.imageRenderersCache.getLoadedRenderer((ResourceRenderer)renderer);
            }
            Dimension2D dimension = null;
            if (this.needDimension) {
                DimensionRenderable dimensionRenderer = this.imageRenderersCache.getDimensionRenderable(renderer);
                dimension = dimensionRenderer == null ? null : dimensionRenderer.getDimension(JRXlsxExporter.this.jasperReportsContext);
            }
            String imagePath = null;
            if (renderer instanceof DataRenderable && JRXlsxExporter.this.rendererToImagePathMap.containsKey(renderer.getId())) {
                imagePath = JRXlsxExporter.this.rendererToImagePathMap.get(renderer.getId());
            } else {
                JRPrintElementIndex imageIndex = JRXlsxExporter.this.getElementIndex(this.cell);
                DataRenderable imageRenderer = JRXlsxExporter.this.getRendererUtil().getImageDataRenderable(this.imageRenderersCache, renderer, new Dimension(this.availableImageWidth, this.availableImageHeight), ModeEnum.OPAQUE == this.imageElement.getModeValue() ? this.imageElement.getBackcolor() : null);
                byte[] imageData = imageRenderer.getData(JRXlsxExporter.this.jasperReportsContext);
                String fileExtension = JRTypeSniffer.getImageTypeValue(imageData).getFileExtension();
                String imageName = JRXlsxExporter.IMAGE_NAME_PREFIX + imageIndex.toString() + (fileExtension == null ? "" : "." + fileExtension);
                JRXlsxExporter.this.xlsxZip.addEntry(new FileBufferedZipEntry("xl/media/" + imageName, imageData));
                imagePath = imageName;
                if (imageRenderer == renderer) {
                    JRXlsxExporter.this.rendererToImagePathMap.put(renderer.getId(), imagePath);
                }
            }
            return new InternalImageProcessorResult(imagePath, dimension);
        }
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRXlsxExporterContext {
        protected ExporterContext() {
        }
    }
}

