/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export;

import java.awt.Color;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.type.NamedEnum;
import net.sf.jasperreports.engine.util.ClassUtils;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.export.CommonExportConfiguration;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.annotations.ExporterProperty;

public class PropertiesNoDefaultsConfigurationFactory<C extends CommonExportConfiguration> {
    private final JasperReportsContext jasperReportsContext;

    public PropertiesNoDefaultsConfigurationFactory(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public C getConfiguration(Class<C> configurationInterface, JRPropertiesHolder propertiesHolder) {
        return this.getProxy(configurationInterface, new PropertiesInvocationHandler(propertiesHolder));
    }

    private final C getProxy(Class<?> clazz, InvocationHandler handler) {
        ArrayList allInterfaces = new ArrayList();
        if (clazz.isInterface()) {
            allInterfaces.add(clazz);
        } else {
            List<Class<?>> lcInterfaces = ClassUtils.getInterfaces(clazz);
            allInterfaces.addAll(lcInterfaces);
        }
        CommonExportConfiguration proxy = (CommonExportConfiguration)Proxy.newProxyInstance(ExporterConfiguration.class.getClassLoader(), allInterfaces.toArray(new Class[allInterfaces.size()]), handler);
        return (C)proxy;
    }

    protected Object getPropertyValue(Method method, JRPropertiesHolder propertiesHolder) {
        Object value = null;
        ExporterProperty exporterProperty = method.getAnnotation(ExporterProperty.class);
        if (exporterProperty != null) {
            value = PropertiesNoDefaultsConfigurationFactory.getPropertyValue(this.jasperReportsContext, propertiesHolder, exporterProperty, method.getReturnType());
        }
        return value;
    }

    public static Object getPropertyValue(JasperReportsContext jasperReportsContext, JRPropertiesHolder propertiesHolder, ExporterProperty exporterProperty, Class<?> type) {
        Object value = null;
        String propertyName = exporterProperty.value();
        if (String[].class.equals(type)) {
            List<JRPropertiesUtil.PropertySuffix> properties = JRPropertiesUtil.getProperties(propertiesHolder, propertyName);
            if (properties != null && !properties.isEmpty()) {
                String[] values = new String[properties.size()];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = properties.get(i).getValue();
                }
                value = values;
            }
        } else if (JRPropertiesUtil.PropertySuffix[].class.equals(type)) {
            List<JRPropertiesUtil.PropertySuffix> properties = JRPropertiesUtil.getProperties(propertiesHolder, propertyName);
            if (properties != null && !properties.isEmpty()) {
                value = properties.toArray(new JRPropertiesUtil.PropertySuffix[properties.size()]);
            }
        } else if (Map.class.equals(type)) {
            List<JRPropertiesUtil.PropertySuffix> properties = JRPropertiesUtil.getProperties(propertiesHolder, propertyName);
            if (properties != null && !properties.isEmpty()) {
                HashMap<String, String> values = new HashMap<String, String>();
                for (JRPropertiesUtil.PropertySuffix propertySuffix : properties) {
                    values.put(propertySuffix.getSuffix(), propertySuffix.getValue());
                }
                value = values;
            }
        } else {
            String strValue = null;
            JRPropertiesMap propertiesMap = propertiesHolder.getPropertiesMap();
            if (propertiesMap != null && propertiesMap.containsProperty(propertyName)) {
                strValue = propertiesMap.getProperty(propertyName);
            }
            if (strValue != null) {
                if (String.class.equals(type)) {
                    value = strValue;
                } else if (Character.class.equals(type)) {
                    value = JRPropertiesUtil.asCharacter(strValue);
                } else if (Integer.class.equals(type)) {
                    value = JRPropertiesUtil.asInteger(strValue);
                } else if (Long.class.equals(type)) {
                    value = JRPropertiesUtil.asLong(strValue);
                } else if (Float.class.equals(type)) {
                    value = Float.valueOf(JRPropertiesUtil.asFloat(strValue));
                } else if (Boolean.class.equals(type)) {
                    value = JRPropertiesUtil.asBoolean(strValue);
                } else if (Color.class.equals(type)) {
                    value = strValue == null ? null : JRColorUtil.getColor(strValue, null);
                } else if (NamedEnum.class.isAssignableFrom(type)) {
                    try {
                        Method byNameMethod = type.getMethod("getByName", String.class);
                        value = byNameMethod.invoke(null, strValue);
                    }
                    catch (NoSuchMethodException e) {
                        throw new JRRuntimeException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new JRRuntimeException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new JRRuntimeException(e);
                    }
                } else {
                    throw new JRRuntimeException("export.common.properties.type.not.supported", new Object[]{type});
                }
            }
        }
        return value;
    }

    class PropertiesInvocationHandler
    implements InvocationHandler {
        private final JRPropertiesHolder propertiesHolder;

        public PropertiesInvocationHandler(JRPropertiesHolder propertiesHolder) {
            this.propertiesHolder = propertiesHolder;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return PropertiesNoDefaultsConfigurationFactory.this.getPropertyValue(method, this.propertiesHolder);
        }
    }
}

