/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.geom.Dimension2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementIndex;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintImageArea;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintElementId;
import net.sf.jasperreports.engine.PrintElementVisitor;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.export.AbstractHtmlExporter;
import net.sf.jasperreports.engine.export.DefaultHyperlinkTargetProducerFactory;
import net.sf.jasperreports.engine.export.ExporterFilter;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.GenericElementHtmlHandler;
import net.sf.jasperreports.engine.export.GenericElementsFilterDecorator;
import net.sf.jasperreports.engine.export.HtmlFontFamily;
import net.sf.jasperreports.engine.export.HtmlResourceHandler;
import net.sf.jasperreports.engine.export.HyperlinkUtil;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRHtmlExporterContext;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRHyperlinkTargetProducer;
import net.sf.jasperreports.engine.export.JRHyperlinkTargetProducerFactory;
import net.sf.jasperreports.engine.export.tabulator.Cell;
import net.sf.jasperreports.engine.export.tabulator.CellVisitor;
import net.sf.jasperreports.engine.export.tabulator.Column;
import net.sf.jasperreports.engine.export.tabulator.ElementCell;
import net.sf.jasperreports.engine.export.tabulator.FrameCell;
import net.sf.jasperreports.engine.export.tabulator.LayeredCell;
import net.sf.jasperreports.engine.export.tabulator.Row;
import net.sf.jasperreports.engine.export.tabulator.SplitCell;
import net.sf.jasperreports.engine.export.tabulator.Table;
import net.sf.jasperreports.engine.export.tabulator.TableCell;
import net.sf.jasperreports.engine.export.tabulator.TablePosition;
import net.sf.jasperreports.engine.export.tabulator.Tabulator;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.LineSpacingEnum;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import net.sf.jasperreports.engine.util.HyperlinkData;
import net.sf.jasperreports.engine.util.ImageUtil;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import net.sf.jasperreports.engine.util.Pair;
import net.sf.jasperreports.export.ExportInterruptedException;
import net.sf.jasperreports.export.ExporterInputItem;
import net.sf.jasperreports.export.HtmlExporterConfiguration;
import net.sf.jasperreports.export.HtmlExporterOutput;
import net.sf.jasperreports.export.HtmlReportConfiguration;
import net.sf.jasperreports.export.parameters.ParametersHtmlExporterOutput;
import net.sf.jasperreports.renderers.AreaHyperlinksRenderable;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.renderers.DimensionRenderable;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.RenderersCache;
import net.sf.jasperreports.renderers.ResourceRenderer;
import net.sf.jasperreports.renderers.util.RendererUtil;
import net.sf.jasperreports.renderers.util.SvgDataSniffer;
import net.sf.jasperreports.renderers.util.SvgFontProcessor;
import net.sf.jasperreports.search.HitTermInfo;
import net.sf.jasperreports.search.SpansInfo;
import net.sf.jasperreports.util.Base64Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HtmlExporter
extends AbstractHtmlExporter<HtmlReportConfiguration, HtmlExporterConfiguration> {
    private static final Log log = LogFactory.getLog(HtmlExporter.class);
    private static final String EXCEPTION_MESSAGE_KEY_INTERNAL_ERROR = "export.html.internal.error";
    private static final String EXCEPTION_MESSAGE_KEY_UNEXPECTED_ROTATION_VALUE = "export.html.unexpected.rotation.value";
    public static final String HTML_EXPORTER_KEY = "net.sf.jasperreports.html";
    public static final String HTML_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.html.";
    public static final String PROPERTY_IGNORE_HYPERLINK = "net.sf.jasperreports.export.html.ignore.hyperlink";
    public static final String PROPERTY_HTML_CLASS = "net.sf.jasperreports.export.html.class";
    public static final String PROPERTY_HTML_ID = "net.sf.jasperreports.export.html.id";
    public static final String PROPERTY_BORDER_COLLAPSE = "net.sf.jasperreports.export.html.border.collapse";
    protected JRHyperlinkTargetProducerFactory targetProducerFactory;
    protected Map<String, String> rendererToImagePathMap;
    protected Map<Pair<String, Rectangle>, String> imageMaps;
    protected RenderersCache renderersCache;
    protected Writer writer;
    protected int reportIndex;
    protected int pageIndex;
    protected LinkedList<Color> backcolorStack = new LinkedList();
    protected ExporterFilter tableFilter;
    protected int pointerEventsNoneStack = 0;
    private List<HyperlinkData> hyperlinksData = new ArrayList<HyperlinkData>();

    public HtmlExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public HtmlExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.exporterContext = new ExporterContext();
    }

    @Override
    public String getExporterKey() {
        return HTML_EXPORTER_KEY;
    }

    @Override
    public String getExporterPropertiesPrefix() {
        return HTML_EXPORTER_PROPERTIES_PREFIX;
    }

    @Override
    public void exportReport() throws JRException {
        this.ensureJasperReportsContext();
        this.ensureInput();
        this.rendererToImagePathMap = new HashMap<String, String>();
        this.imageMaps = new HashMap<Pair<String, Rectangle>, String>();
        this.renderersCache = new RenderersCache(this.getJasperReportsContext());
        this.fontsToProcess = new HashMap();
        this.initExport();
        this.ensureOutput();
        this.writer = ((HtmlExporterOutput)this.getExporterOutput()).getWriter();
        try {
            this.exportReportToWriter();
        }
        catch (IOException e) {
            throw new JRException("export.common.output.writer.error", new Object[]{this.jasperPrint.getName()}, e);
        }
        finally {
            ((HtmlExporterOutput)this.getExporterOutput()).close();
            this.resetExportContext();
        }
    }

    @Override
    protected Class<HtmlExporterConfiguration> getConfigurationInterface() {
        return HtmlExporterConfiguration.class;
    }

    @Override
    protected Class<HtmlReportConfiguration> getItemConfigurationInterface() {
        return HtmlReportConfiguration.class;
    }

    @Override
    protected void ensureOutput() {
        if (this.exporterOutput == null) {
            this.exporterOutput = new ParametersHtmlExporterOutput(this.getJasperReportsContext(), this.getParameters(), this.getCurrentJasperPrint());
        }
    }

    @Override
    protected void initExport() {
        super.initExport();
    }

    @Override
    protected void initReport() {
        super.initReport();
        HtmlReportConfiguration configuration = (HtmlReportConfiguration)this.getCurrentItemConfiguration();
        if (configuration.isRemoveEmptySpaceBetweenRows().booleanValue()) {
            log.info((Object)"Removing empty space between rows not supported");
        }
        this.tableFilter = new GenericElementsFilterDecorator(this.jasperReportsContext, HTML_EXPORTER_KEY, this.filter);
    }

    @Override
    protected void setJasperReportsContext(JasperReportsContext jasperReportsContext) {
        super.setJasperReportsContext(jasperReportsContext);
        this.targetProducerFactory = new DefaultHyperlinkTargetProducerFactory(jasperReportsContext);
    }

    protected void exportReportToWriter() throws JRException, IOException {
        HtmlExporterConfiguration configuration = (HtmlExporterConfiguration)this.getCurrentConfiguration();
        String htmlHeader = configuration.getHtmlHeader();
        String betweenPagesHtml = configuration.getBetweenPagesHtml();
        String htmlFooter = configuration.getHtmlFooter();
        boolean flushOutput = configuration.isFlushOutput();
        if (htmlHeader == null) {
            String encoding = ((HtmlExporterOutput)this.getExporterOutput()).getEncoding();
            this.writer.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n");
            this.writer.write("<html>\n");
            this.writer.write("<head>\n");
            this.writer.write("  <title></title>\n");
            this.writer.write("  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + encoding + "\"/>\n");
            this.writer.write("  <style type=\"text/css\">\n");
            this.writer.write("    a {text-decoration: none}\n");
            this.writer.write("  </style>\n");
            this.writer.write("</head>\n");
            this.writer.write("<body text=\"#000000\" link=\"#000000\" alink=\"#000000\" vlink=\"#000000\">\n");
            this.writer.write("<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\n");
            this.writer.write("<tr><td width=\"50%\">&nbsp;</td><td align=\"center\">\n");
            this.writer.write("\n");
        } else {
            this.writer.write(htmlHeader);
        }
        List<ExporterInputItem> items = this.exporterInput.getItems();
        this.reportIndex = 0;
        while (this.reportIndex < items.size()) {
            ExporterInputItem item = items.get(this.reportIndex);
            this.setCurrentExporterInputItem(item);
            List<JRPrintPage> pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                JRAbstractExporter.PageRange pageRange = this.getPageRange();
                int startPageIndex = pageRange == null || pageRange.getStartPageIndex() == null ? 0 : pageRange.getStartPageIndex();
                int endPageIndex = pageRange == null || pageRange.getEndPageIndex() == null ? pages.size() - 1 : pageRange.getEndPageIndex();
                JRPrintPage page = null;
                this.pageIndex = startPageIndex;
                while (this.pageIndex <= endPageIndex) {
                    if (Thread.interrupted()) {
                        throw new ExportInterruptedException();
                    }
                    page = pages.get(this.pageIndex);
                    this.writer.write("<a name=\"JR_PAGE_ANCHOR_" + this.reportIndex + "_" + (this.pageIndex + 1) + "\"></a>\n");
                    this.exportPage(page);
                    if (this.reportIndex < items.size() - 1 || this.pageIndex < endPageIndex) {
                        if (betweenPagesHtml == null) {
                            this.writer.write("<br/>\n<br/>\n");
                        } else {
                            this.writer.write(betweenPagesHtml);
                        }
                    }
                    this.writer.write("\n");
                    ++this.pageIndex;
                }
            }
            ++this.reportIndex;
        }
        ReportContext reportContext = this.getReportContext();
        if (this.fontsToProcess != null && this.fontsToProcess.size() > 0) {
            if (reportContext == null) {
                HtmlResourceHandler resourceHandler = ((HtmlExporterOutput)this.getExporterOutput()).getResourceHandler() == null ? this.getResourceHandler() : ((HtmlExporterOutput)this.getExporterOutput()).getResourceHandler();
                for (HtmlFontFamily htmlFontFamily : this.fontsToProcess.values()) {
                    this.writer.write("<link class=\"jrWebFont\" rel=\"stylesheet\" href=\"" + resourceHandler.getResourcePath(htmlFontFamily.getId()) + "\">\n");
                }
                this.writer.write("<!--[if IE]>\n");
                this.writer.write("<script>\n");
                this.writer.write("var links = document.querySelectorAll('link.jrWebFont');\n");
                this.writer.write("setTimeout(function(){ if (links) { for (var i = 0; i < links.length; i++) { links.item(i).href = links.item(i).href; } } }, 0);\n");
                this.writer.write("</script>\n");
                this.writer.write("<![endif]-->\n");
            } else {
                reportContext.setParameterValue("net.sf.jasperreports.html.webfonts", this.fontsToProcess);
            }
        }
        if (this.hyperlinksData.size() > 0) {
            reportContext.setParameterValue("net.sf.jasperreports.html.hyperlinks", this.hyperlinksData);
        }
        if (htmlFooter == null) {
            this.writer.write("</td><td width=\"50%\">&nbsp;</td></tr>\n");
            this.writer.write("</table>\n");
            this.writer.write("</body>\n");
            this.writer.write("</html>\n");
        } else {
            this.writer.write(htmlFooter);
        }
        if (flushOutput) {
            this.writer.flush();
        }
    }

    protected void exportPage(JRPrintPage page) throws IOException {
        JRExportProgressMonitor progressMonitor;
        Tabulator tabulator = new Tabulator(this.tableFilter, page.getElements());
        tabulator.tabulate();
        HtmlReportConfiguration configuration = (HtmlReportConfiguration)this.getCurrentItemConfiguration();
        boolean isIgnorePageMargins = configuration.isIgnorePageMargins();
        if (!isIgnorePageMargins) {
            PrintPageFormat pageFormat = this.jasperPrint.getPageFormat(this.pageIndex);
            tabulator.addMargins(pageFormat.getPageWidth(), pageFormat.getPageHeight());
        }
        Table table = tabulator.getTable();
        boolean isWhitePageBackground = configuration.isWhitePageBackground();
        if (isWhitePageBackground) {
            this.setBackcolor(Color.white);
        }
        CellElementVisitor elementVisitor = new CellElementVisitor();
        TableVisitor tableVisitor = new TableVisitor(tabulator, elementVisitor);
        this.exportTable(tableVisitor, table, isWhitePageBackground, true);
        if (isWhitePageBackground) {
            this.restoreBackcolor();
        }
        if ((progressMonitor = configuration.getProgressMonitor()) != null) {
            progressMonitor.afterPageExport();
        }
    }

    public void exportElements(List<JRPrintElement> elements) throws IOException {
        Tabulator tabulator = new Tabulator(this.tableFilter, elements);
        tabulator.tabulate();
        Table table = tabulator.getTable();
        CellElementVisitor elementVisitor = new CellElementVisitor();
        TableVisitor tableVisitor = new TableVisitor(tabulator, elementVisitor);
        this.exportTable(tableVisitor, table, false, false);
    }

    protected void exportTable(TableVisitor tableVisitor, Table table, boolean whiteBackground, boolean isMainReportTable) throws IOException {
        SortedSet<Column> columns = table.getColumns().getUserEntries();
        SortedSet<Row> rows = table.getRows().getUserEntries();
        if (columns.isEmpty() || rows.isEmpty()) {
            return;
        }
        if (isMainReportTable) {
            int totalWidth = columns.last().getEndCoord() - columns.first().getStartCoord();
            this.writer.write("<table class=\"jrPage\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"empty-cells: show; width: ");
            this.writer.write(this.toSizeUnit(totalWidth));
            this.writer.write(";");
        } else {
            this.writer.write("<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"empty-cells: show; width: 100%;");
        }
        String borderCollapse = ((HtmlReportConfiguration)this.getCurrentItemConfiguration()).getBorderCollapse();
        if (borderCollapse != null) {
            this.writer.write(" border-collapse: ");
            this.writer.write(borderCollapse);
            this.writer.write(";");
        }
        if (whiteBackground) {
            this.writer.write(" background-color: white;");
        }
        this.writer.write("\">\n");
        this.writer.write("<tr valign=\"top\" style=\"height:0\">\n");
        for (Column col : columns) {
            this.writer.write("<td style=\"width:");
            this.writer.write(this.toSizeUnit(col.getExtent()));
            this.writer.write("\"></td>\n");
        }
        this.writer.write("</tr>\n");
        for (Row row : rows) {
            this.writer.write("<tr valign=\"top\" style=\"height:");
            this.writer.write(this.toSizeUnit(row.getExtent()));
            this.writer.write("\">\n");
            int emptySpan = 0;
            for (Column col : columns) {
                Cell cell = row.getCell(col);
                if (cell == null) {
                    ++emptySpan;
                    continue;
                }
                if (emptySpan > 0) {
                    this.writeEmptyCell(emptySpan, 1);
                }
                emptySpan = 0;
                TablePosition position = new TablePosition(table, col, row);
                cell.accept(tableVisitor, position);
            }
            if (emptySpan > 0) {
                this.writeEmptyCell(emptySpan, 1);
            }
            this.writer.write("</tr>\n");
        }
        this.writer.write("</table>\n");
    }

    protected void writeText(JRPrintText text, TableCell cell) throws IOException {
        JRStyledText styledText = this.getStyledText(text);
        int textLength = styledText == null ? 0 : styledText.length();
        this.startCell(text, cell);
        if (text.getRunDirectionValue() == RunDirectionEnum.RTL) {
            this.writer.write(" dir=\"rtl\"");
        }
        StringBuilder styleBuffer = new StringBuilder();
        String verticalAlignment = "top";
        switch (text.getVerticalTextAlign()) {
            case BOTTOM: {
                verticalAlignment = "bottom";
                break;
            }
            case MIDDLE: {
                verticalAlignment = "middle";
                break;
            }
            default: {
                verticalAlignment = "top";
            }
        }
        this.appendElementCellGenericStyle(cell, styleBuffer);
        this.appendBackcolorStyle(cell, styleBuffer);
        this.appendBorderStyle(cell.getBox(), styleBuffer);
        this.appendPaddingStyle(text.getLineBox(), styleBuffer);
        String horizontalAlignment = "left";
        if (textLength > 0) {
            switch (text.getHorizontalTextAlign()) {
                case RIGHT: {
                    horizontalAlignment = "right";
                    break;
                }
                case CENTER: {
                    horizontalAlignment = "center";
                    break;
                }
                case JUSTIFIED: {
                    horizontalAlignment = "justify";
                    break;
                }
                default: {
                    horizontalAlignment = "left";
                }
            }
        }
        if (((HtmlReportConfiguration)this.getCurrentItemConfiguration()).isWrapBreakWord().booleanValue()) {
            styleBuffer.append("width: " + this.toSizeUnit(text.getWidth()) + "; ");
            styleBuffer.append("word-wrap: break-word; ");
        }
        if (text.getLineBreakOffsets() != null) {
            styleBuffer.append("white-space: nowrap; ");
        }
        styleBuffer.append("text-indent: " + text.getParagraph().getFirstLineIndent() + "px; ");
        String rotationValue = null;
        StringBuilder spanStyleBuffer = new StringBuilder();
        StringBuilder divStyleBuffer = new StringBuilder();
        if (text.getRotationValue() == RotationEnum.NONE) {
            if (!verticalAlignment.equals("top")) {
                styleBuffer.append(" vertical-align: ");
                styleBuffer.append(verticalAlignment);
                styleBuffer.append(";");
            }
            styleBuffer.append("text-align: ");
            styleBuffer.append(horizontalAlignment);
            styleBuffer.append(";");
        } else {
            rotationValue = this.setRotationStyles(text, horizontalAlignment, spanStyleBuffer, divStyleBuffer);
        }
        this.writeStyle(styleBuffer);
        this.finishStartCell();
        if (text.getAnchorName() != null) {
            this.writer.write("<a name=\"");
            this.writer.write(text.getAnchorName());
            this.writer.write("\"/>");
        }
        if (text.getBookmarkLevel() != 0) {
            this.writer.write("<a name=\"");
            this.writer.write("JR_BKMRK_" + this.reportIndex + "_" + this.pageIndex + "_" + cell.getElementAddress());
            this.writer.write("\"/>");
        }
        if (rotationValue != null) {
            this.writer.write("<div style=\"position: relative; overflow: hidden; ");
            this.writer.write(divStyleBuffer.toString());
            this.writer.write("\">\n");
            this.writer.write("<span class=\"rotated\" data-rotation=\"");
            this.writer.write(rotationValue);
            this.writer.write("\" style=\"position: absolute; display: table; ");
            this.writer.write(spanStyleBuffer.toString());
            this.writer.write("\">");
            this.writer.write("<span style=\"display: table-cell; vertical-align:");
            this.writer.write(verticalAlignment);
            this.writer.write(";\">");
        }
        boolean hyperlinkStarted = this.startHyperlink(text);
        if (textLength > 0) {
            this.exportStyledText(text, styledText, text.getHyperlinkTooltip(), hyperlinkStarted);
        }
        if (hyperlinkStarted) {
            this.endHyperlink();
        }
        if (rotationValue != null) {
            this.writer.write("</span></span></div>");
        }
        this.endCell();
    }

    protected String setRotationStyles(JRPrintText text, String horizontalAlignment, StringBuilder spanStyleBuffer, StringBuilder divStyleBuffer) {
        String rotationValue;
        int rotationAngle;
        int rotationIE;
        int rotatedHeight;
        int rotatedWidth;
        int translateY;
        int translateX;
        int textWidth = text.getWidth() - text.getLineBox().getLeftPadding() - text.getLineBox().getRightPadding();
        int textHeight = text.getHeight() - text.getLineBox().getTopPadding() - text.getLineBox().getBottomPadding();
        switch (text.getRotationValue()) {
            case LEFT: {
                translateX = -(textHeight - textWidth) / 2;
                translateY = (textHeight - textWidth) / 2;
                rotatedWidth = textHeight;
                rotatedHeight = textWidth;
                rotationIE = 3;
                rotationAngle = -90;
                rotationValue = "left";
                break;
            }
            case RIGHT: {
                translateX = -(textHeight - textWidth) / 2;
                translateY = (textHeight - textWidth) / 2;
                rotatedWidth = textHeight;
                rotatedHeight = textWidth;
                rotationIE = 1;
                rotationAngle = 90;
                rotationValue = "right";
                break;
            }
            case UPSIDE_DOWN: {
                translateX = 0;
                translateY = 0;
                rotatedWidth = textWidth;
                rotatedHeight = textHeight;
                rotationIE = 2;
                rotationAngle = 180;
                rotationValue = "upsideDown";
                break;
            }
            default: {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNEXPECTED_ROTATION_VALUE, new Object[]{text.getRotationValue()});
            }
        }
        this.appendSizeStyle(textWidth, textHeight, divStyleBuffer);
        this.appendSizeStyle(rotatedWidth, rotatedHeight, spanStyleBuffer);
        spanStyleBuffer.append("text-align: ");
        spanStyleBuffer.append(horizontalAlignment);
        spanStyleBuffer.append(";");
        spanStyleBuffer.append("-webkit-transform: translate(" + translateX + "px," + translateY + "px) ");
        spanStyleBuffer.append("rotate(" + rotationAngle + "deg); ");
        spanStyleBuffer.append("-moz-transform: translate(" + translateX + "px," + translateY + "px) ");
        spanStyleBuffer.append("rotate(" + rotationAngle + "deg); ");
        spanStyleBuffer.append("-ms-transform: translate(" + translateX + "px," + translateY + "px) ");
        spanStyleBuffer.append("rotate(" + rotationAngle + "deg); ");
        spanStyleBuffer.append("-o-transform: translate(" + translateX + "px," + translateY + "px) ");
        spanStyleBuffer.append("rotate(" + rotationAngle + "deg); ");
        spanStyleBuffer.append("filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=" + rotationIE + "); ");
        return rotationValue;
    }

    protected void appendSizeStyle(int width, int height, StringBuilder styleBuffer) {
        styleBuffer.append("width:");
        styleBuffer.append(this.toSizeUnit(width));
        styleBuffer.append(";");
        styleBuffer.append("height:");
        styleBuffer.append(this.toSizeUnit(height));
        styleBuffer.append(";");
    }

    protected void writeImage(JRPrintImage image, TableCell cell) throws IOException, JRException {
        Renderable renderer;
        boolean isLazy;
        int availableImageHeight;
        this.startCell(image, cell);
        int availableImageWidth = image.getWidth() - image.getLineBox().getLeftPadding() - image.getLineBox().getRightPadding();
        if (availableImageWidth < 0) {
            availableImageWidth = 0;
        }
        if ((availableImageHeight = image.getHeight() - image.getLineBox().getTopPadding() - image.getLineBox().getBottomPadding()) < 0) {
            availableImageHeight = 0;
        }
        String horizontalAlignment = this.getImageHorizontalAlignmentStyle(image);
        String verticalAlignment = this.getImageVerticalAlignmentStyle(image);
        StringBuilder styleBuffer = new StringBuilder();
        ScaleImageEnum scaleImage = image.getScaleImageValue();
        if (scaleImage != ScaleImageEnum.CLIP) {
            if (!horizontalAlignment.equals("left")) {
                styleBuffer.append("text-align: ");
                styleBuffer.append(horizontalAlignment);
                styleBuffer.append(";");
            }
            if (!verticalAlignment.equals("top")) {
                styleBuffer.append(" vertical-align: ");
                styleBuffer.append(verticalAlignment);
                styleBuffer.append(";");
            }
        }
        if ((isLazy = RendererUtil.isLazy(renderer = image.getRenderer())) || scaleImage == ScaleImageEnum.CLIP && availableImageHeight > 0) {
            styleBuffer.append("height: ");
            styleBuffer.append(this.toSizeUnit(availableImageHeight));
            styleBuffer.append("; ");
        }
        this.appendElementCellGenericStyle(cell, styleBuffer);
        this.appendBackcolorStyle(cell, styleBuffer);
        boolean addedToStyle = this.appendBorderStyle(cell.getBox(), styleBuffer);
        if (!addedToStyle) {
            this.appendPen(styleBuffer, image.getLinePen(), null);
        }
        this.appendPaddingStyle(image.getLineBox(), styleBuffer);
        this.writeStyle(styleBuffer);
        this.finishStartCell();
        if (image.getAnchorName() != null) {
            this.writer.write("<a name=\"");
            this.writer.write(image.getAnchorName());
            this.writer.write("\"/>");
        }
        if (image.getBookmarkLevel() != 0) {
            this.writer.write("<a name=\"");
            this.writer.write("JR_BKMRK_" + this.reportIndex + "_" + this.pageIndex + "_" + cell.getElementAddress());
            this.writer.write("\"/>");
        }
        if (renderer != null) {
            InternalImageProcessorResult imageProcessorResult;
            boolean useBackgroundLazyImage;
            List<JRPrintImageAreaHyperlink> imageMapAreas;
            String imageMapName;
            boolean hyperlinkStarted;
            boolean hasHyperlinks;
            boolean startedDiv;
            block53: {
                startedDiv = false;
                if (scaleImage == ScaleImageEnum.CLIP || isLazy && (scaleImage == ScaleImageEnum.RETAIN_SHAPE || scaleImage == ScaleImageEnum.REAL_HEIGHT || scaleImage == ScaleImageEnum.REAL_SIZE || image.getHorizontalImageAlign() != HorizontalImageAlignEnum.LEFT || image.getVerticalImageAlign() != VerticalImageAlignEnum.TOP)) {
                    this.writer.write("<div style=\"width: 100%; height: 100%; position: relative; overflow: hidden;\">\n");
                    startedDiv = true;
                }
                boolean hasAreaHyperlinks = renderer instanceof AreaHyperlinksRenderable && ((AreaHyperlinksRenderable)((Object)renderer)).hasImageAreaHyperlinks();
                hasHyperlinks = false;
                if (hasAreaHyperlinks) {
                    hyperlinkStarted = false;
                    hasHyperlinks = true;
                } else {
                    hasHyperlinks = hyperlinkStarted = this.startHyperlink(image);
                }
                imageMapName = null;
                imageMapAreas = null;
                if (hasAreaHyperlinks) {
                    Rectangle renderingArea = new Rectangle(image.getWidth(), image.getHeight());
                    if (renderer instanceof DataRenderable) {
                        imageMapName = this.imageMaps.get(new Pair<String, Rectangle>(renderer.getId(), renderingArea));
                    }
                    if (imageMapName == null) {
                        Renderable originalRenderer = image.getRenderer();
                        imageMapName = "map_" + this.getElementIndex(cell).toString() + "-" + originalRenderer.getId();
                        imageMapAreas = ((AreaHyperlinksRenderable)((Object)originalRenderer)).getImageAreaHyperlinks(renderingArea);
                        if (renderer instanceof DataRenderable) {
                            this.imageMaps.put(new Pair<String, Rectangle>(renderer.getId(), renderingArea), imageMapName);
                        }
                    }
                }
                useBackgroundLazyImage = isLazy && (scaleImage == ScaleImageEnum.RETAIN_SHAPE || scaleImage == ScaleImageEnum.REAL_HEIGHT || scaleImage == ScaleImageEnum.REAL_SIZE || image.getHorizontalImageAlign() != HorizontalImageAlignEnum.LEFT || image.getVerticalImageAlign() != VerticalImageAlignEnum.TOP);
                InternalImageProcessor imageProcessor = new InternalImageProcessor(image, isLazy, !useBackgroundLazyImage && scaleImage != ScaleImageEnum.FILL_FRAME && !isLazy, cell, availableImageWidth, availableImageHeight);
                imageProcessorResult = null;
                try {
                    imageProcessorResult = imageProcessor.process(renderer);
                }
                catch (Exception e) {
                    Renderable onErrorRenderer = this.getRendererUtil().handleImageError(e, image.getOnErrorTypeValue());
                    if (onErrorRenderer == null) break block53;
                    imageProcessorResult = imageProcessor.process(onErrorRenderer);
                }
            }
            if (imageProcessorResult != null) {
                if (useBackgroundLazyImage) {
                    this.writer.write("<div style=\"width: 100%; height: 100%; background-image: url('");
                    String imagePath = imageProcessorResult.imageSource;
                    if (imagePath != null) {
                        this.writer.write(imagePath);
                    }
                    this.writer.write("'); background-repeat: no-repeat; background-position: " + horizontalAlignment + " " + (image.getVerticalImageAlign() == VerticalImageAlignEnum.MIDDLE ? "center" : verticalAlignment) + ";background-size: ");
                    switch (scaleImage) {
                        case FILL_FRAME: {
                            this.writer.write("100% 100%");
                            break;
                        }
                        case CLIP: {
                            this.writer.write("auto");
                            break;
                        }
                        default: {
                            this.writer.write("contain");
                        }
                    }
                    this.writer.write(";\"></div>");
                } else if (imageProcessorResult.isEmbededSvgData) {
                    this.writer.write("<svg");
                    switch (scaleImage) {
                        case FILL_FRAME: {
                            Dimension2D dimension = imageProcessorResult.dimension;
                            if (dimension != null) {
                                this.writer.write(" viewBox=\"0 0 ");
                                this.writer.write(String.valueOf(dimension.getWidth()));
                                this.writer.write(" ");
                                this.writer.write(String.valueOf(dimension.getHeight()));
                                this.writer.write("\"");
                            }
                            this.writer.write(" width=\"");
                            this.writer.write(String.valueOf(availableImageWidth));
                            this.writer.write("\"");
                            this.writer.write(" height=\"");
                            this.writer.write(String.valueOf(availableImageHeight));
                            this.writer.write("\"");
                            this.writer.write(" preserveAspectRatio=\"none\"");
                            break;
                        }
                        case CLIP: {
                            double normalWidth = availableImageWidth;
                            double normalHeight = availableImageHeight;
                            Dimension2D dimension = imageProcessorResult.dimension;
                            if (dimension != null) {
                                normalWidth = dimension.getWidth();
                                normalHeight = dimension.getHeight();
                                this.writer.write(" viewBox=\"");
                                this.writer.write(String.valueOf((int)((double)ImageUtil.getXAlignFactor(image) * (normalWidth - (double)availableImageWidth))));
                                this.writer.write(" ");
                                this.writer.write(String.valueOf((int)((double)ImageUtil.getYAlignFactor(image) * (normalHeight - (double)availableImageHeight))));
                                this.writer.write(" ");
                                this.writer.write(String.valueOf(availableImageWidth));
                                this.writer.write(" ");
                                this.writer.write(String.valueOf(availableImageHeight));
                                this.writer.write("\"");
                            }
                            this.writer.write(" width=\"");
                            this.writer.write(String.valueOf(availableImageWidth));
                            this.writer.write("\"");
                            this.writer.write(" height=\"");
                            this.writer.write(String.valueOf(availableImageHeight));
                            this.writer.write("\"");
                            break;
                        }
                        default: {
                            double ratio;
                            if (availableImageHeight <= 0) break;
                            double normalWidth = availableImageWidth;
                            double normalHeight = availableImageHeight;
                            Dimension2D dimension = imageProcessorResult.dimension;
                            if (dimension != null) {
                                normalWidth = dimension.getWidth();
                                normalHeight = dimension.getHeight();
                                this.writer.write(" viewBox=\"0 0 ");
                                this.writer.write(String.valueOf(normalWidth));
                                this.writer.write(" ");
                                this.writer.write(String.valueOf(normalHeight));
                                this.writer.write("\"");
                            }
                            if ((ratio = normalWidth / normalHeight) > (double)availableImageWidth / (double)availableImageHeight) {
                                this.writer.write(" width=\"");
                                this.writer.write(String.valueOf(availableImageWidth));
                                this.writer.write("\"");
                                break;
                            }
                            this.writer.write(" height=\"");
                            this.writer.write(String.valueOf(availableImageHeight));
                            this.writer.write("\"");
                        }
                    }
                    this.writer.write("><g>\n");
                    this.writer.write(imageProcessorResult.imageSource);
                    this.writer.write("</g></svg>");
                } else {
                    this.writer.write("<img");
                    this.writer.write(" src=\"");
                    String imagePath = imageProcessorResult.imageSource;
                    if (imagePath != null) {
                        this.writer.write(imagePath);
                    }
                    this.writer.write("\"");
                    switch (scaleImage) {
                        case FILL_FRAME: {
                            this.writer.write(" style=\"width: ");
                            this.writer.write(this.toSizeUnit(availableImageWidth));
                            this.writer.write("; height: ");
                            this.writer.write(this.toSizeUnit(availableImageHeight));
                            this.writer.write("\"");
                            break;
                        }
                        case CLIP: {
                            int positionTop;
                            int positionLeft;
                            HorizontalImageAlignEnum horizontalAlign = image.getHorizontalImageAlign();
                            VerticalImageAlignEnum verticalAlign = image.getVerticalImageAlign();
                            if (isLazy || horizontalAlign == HorizontalImageAlignEnum.LEFT && verticalAlign == VerticalImageAlignEnum.TOP) {
                                positionLeft = 0;
                                positionTop = 0;
                            } else {
                                double normalWidth = availableImageWidth;
                                double normalHeight = availableImageHeight;
                                Dimension2D dimension = imageProcessorResult.dimension;
                                if (dimension != null) {
                                    normalWidth = dimension.getWidth();
                                    normalHeight = dimension.getHeight();
                                }
                                positionLeft = (int)((double)ImageUtil.getXAlignFactor(horizontalAlign) * ((double)availableImageWidth - normalWidth));
                                positionTop = (int)((double)ImageUtil.getYAlignFactor(verticalAlign) * ((double)availableImageHeight - normalHeight));
                            }
                            this.writer.write(" style=\"position: absolute; left:");
                            this.writer.write(this.toSizeUnit(positionLeft));
                            this.writer.write("; top: ");
                            this.writer.write(this.toSizeUnit(positionTop));
                            this.writer.write(";\"");
                            break;
                        }
                        default: {
                            double ratio;
                            if (availableImageHeight <= 0) break;
                            double normalWidth = availableImageWidth;
                            double normalHeight = availableImageHeight;
                            Dimension2D dimension = imageProcessorResult.dimension;
                            if (dimension != null) {
                                normalWidth = dimension.getWidth();
                                normalHeight = dimension.getHeight();
                            }
                            if ((ratio = normalWidth / normalHeight) > (double)availableImageWidth / (double)availableImageHeight) {
                                this.writer.write(" style=\"width: ");
                                this.writer.write(this.toSizeUnit(availableImageWidth));
                                this.writer.write("\"");
                                break;
                            }
                            this.writer.write(" style=\"height: ");
                            this.writer.write(this.toSizeUnit(availableImageHeight));
                            this.writer.write("\"");
                        }
                    }
                    if (imageMapName != null) {
                        this.writer.write(" usemap=\"#" + imageMapName + "\"");
                    }
                    this.writer.write(" alt=\"\"");
                    if (hasHyperlinks) {
                        this.writer.write(" border=\"0\"");
                    }
                    if (image.getHyperlinkTooltip() != null) {
                        this.writer.write(" title=\"");
                        this.writer.write(JRStringUtil.xmlEncode(image.getHyperlinkTooltip()));
                        this.writer.write("\"");
                    }
                    this.writer.write("/>");
                }
            }
            if (hyperlinkStarted) {
                this.endHyperlink();
            }
            if (startedDiv) {
                this.writer.write("</div>");
            }
            if (imageMapAreas != null) {
                this.writer.write("\n");
                this.writeImageMap(imageMapName, image, imageMapAreas);
            }
        }
        this.endCell();
    }

    protected String getImageHorizontalAlignmentStyle(JRPrintImage image) {
        String horizontalAlignment = "left";
        switch (image.getHorizontalImageAlign()) {
            case RIGHT: {
                horizontalAlignment = "right";
                break;
            }
            case CENTER: {
                horizontalAlignment = "center";
                break;
            }
            default: {
                horizontalAlignment = "left";
            }
        }
        return horizontalAlignment;
    }

    protected String getImageVerticalAlignmentStyle(JRPrintImage image) {
        String verticalAlignment = "top";
        switch (image.getVerticalImageAlign()) {
            case BOTTOM: {
                verticalAlignment = "bottom";
                break;
            }
            case MIDDLE: {
                verticalAlignment = "middle";
                break;
            }
            default: {
                verticalAlignment = "top";
            }
        }
        return verticalAlignment;
    }

    protected JRPrintElementIndex getElementIndex(TableCell cell) {
        String elementAddress = cell.getElementAddress();
        JRPrintElementIndex elementIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, elementAddress);
        return elementIndex;
    }

    protected void writeImageMap(String imageMapName, JRPrintImage image, List<JRPrintImageAreaHyperlink> imageMapAreas) throws IOException {
        this.writer.write("<map name=\"" + imageMapName + "\">\n");
        ListIterator<JRPrintImageAreaHyperlink> it = imageMapAreas.listIterator(imageMapAreas.size());
        while (it.hasPrevious()) {
            JRPrintImageAreaHyperlink areaHyperlink = it.previous();
            JRPrintHyperlink link = areaHyperlink.getHyperlink();
            JRPrintImageArea area = areaHyperlink.getArea();
            this.writer.write("  <area shape=\"" + JRPrintImageArea.getHtmlShape(area.getShape()) + "\"");
            this.writeImageAreaCoordinates(area.getCoordinates());
            this.writeImageAreaHyperlink(link);
            this.writer.write("/>\n");
        }
        if (image.getHyperlinkTypeValue() != HyperlinkTypeEnum.NONE) {
            this.writer.write("  <area shape=\"default\"");
            this.writeImageAreaCoordinates(new int[]{0, 0, image.getWidth(), image.getHeight()});
            this.writeImageAreaHyperlink(image);
            this.writer.write("/>\n");
        }
        this.writer.write("</map>\n");
    }

    protected void writeImageAreaCoordinates(int[] coords) throws IOException {
        if (coords != null && coords.length > 0) {
            StringBuilder coordsEnum = new StringBuilder(coords.length * 4);
            coordsEnum.append(this.toZoom(coords[0]));
            for (int i = 1; i < coords.length; ++i) {
                coordsEnum.append(',');
                coordsEnum.append(this.toZoom(coords[i]));
            }
            this.writer.write(" coords=\"" + coordsEnum + "\"");
        }
    }

    protected void writeImageAreaHyperlink(JRPrintHyperlink hyperlink) throws IOException {
        if (this.getReportContext() != null) {
            if (hyperlink.getLinkType() != null) {
                int id = hyperlink.hashCode() & Integer.MAX_VALUE;
                this.writer.write(" class=\"_jrHyperLink " + hyperlink.getLinkType() + "\" data-id=\"" + id + "\"");
                HyperlinkData hyperlinkData = new HyperlinkData();
                hyperlinkData.setId(String.valueOf(id));
                hyperlinkData.setHref(this.getHyperlinkURL(hyperlink));
                hyperlinkData.setSelector("._jrHyperLink." + hyperlink.getLinkType());
                hyperlinkData.setHyperlink(hyperlink);
                this.hyperlinksData.add(hyperlinkData);
            }
        } else {
            String href = this.getHyperlinkURL(hyperlink);
            if (href == null) {
                this.writer.write(" nohref=\"nohref\"");
            } else {
                this.writer.write(" href=\"" + href + "\"");
                String target = this.getHyperlinkTarget(hyperlink);
                if (target != null) {
                    this.writer.write(" target=\"");
                    this.writer.write(target);
                    this.writer.write("\"");
                }
            }
        }
        if (hyperlink.getHyperlinkTooltip() != null) {
            this.writer.write(" title=\"");
            this.writer.write(JRStringUtil.xmlEncode(hyperlink.getHyperlinkTooltip()));
            this.writer.write("\"");
        }
    }

    protected void writeRectangle(JRPrintRectangle rectangle, TableCell cell) throws IOException {
        this.startCell(rectangle, cell);
        int radius = rectangle.getRadius();
        if (radius == 0) {
            StringBuilder styleBuffer = new StringBuilder();
            this.appendElementCellGenericStyle(cell, styleBuffer);
            this.appendBackcolorStyle(cell, styleBuffer);
            this.appendPen(styleBuffer, rectangle.getLinePen(), null);
            this.writeStyle(styleBuffer);
        }
        this.finishStartCell();
        if (radius != 0) {
            float lineDiff = rectangle.getLinePen().getLineWidth().floatValue() / 2.0f;
            this.writer.write("<svg height=\"" + rectangle.getHeight() + "\" width=\"" + rectangle.getWidth() + "\">");
            this.writer.write("<rect x=\"" + lineDiff + "\" y=\"" + lineDiff + "\" rx=\"" + radius + "\" ry=\"" + radius + "\" ");
            this.writer.write("height=\"" + ((float)rectangle.getHeight() - 2.0f * lineDiff) + "\" width=\"" + ((float)rectangle.getWidth() - 2.0f * lineDiff) + "\" ");
            this.writeSvgStyle(rectangle);
            this.writer.write("\"/></svg>");
        }
        this.endCell();
    }

    protected void writeEllipse(JRPrintEllipse ellipse, TableCell cell) throws IOException {
        this.startCell(ellipse, cell);
        this.finishStartCell();
        float lineDiff = ellipse.getLinePen().getLineWidth().floatValue() / 2.0f;
        this.writer.write("<svg height=\"" + ellipse.getHeight() + "\" width=\"" + ellipse.getWidth() + "\">");
        this.writer.write("<ellipse cx=\"" + ellipse.getWidth() / 2 + "\" cy=\"" + ellipse.getHeight() / 2);
        this.writer.write("\" rx=\"" + ((float)(ellipse.getWidth() / 2) - lineDiff) + "\" ry=\"" + ((float)(ellipse.getHeight() / 2) - lineDiff) + "\" ");
        this.writeSvgStyle(ellipse);
        this.writer.write("\"/></svg>");
        this.endCell();
    }

    protected void writeSvgStyle(JRPrintGraphicElement element) throws IOException {
        this.writer.write("style=\"fill:" + JRColorUtil.getCssColor(element.getBackcolor()) + ";");
        this.writer.write("stroke:" + JRColorUtil.getCssColor(element.getLinePen().getLineColor()) + ";");
        this.writer.write("stroke-width:" + element.getLinePen().getLineWidth() + ";");
        switch (element.getLinePen().getLineStyleValue()) {
            case DOTTED: {
                this.writer.write("stroke-dasharray:" + element.getLinePen().getLineWidth() + "," + element.getLinePen().getLineWidth() + ";");
                break;
            }
            case DASHED: {
                this.writer.write("stroke-dasharray:" + 5.0f * element.getLinePen().getLineWidth().floatValue() + "," + 3.0f * element.getLinePen().getLineWidth().floatValue() + ";");
                break;
            }
        }
    }

    protected void writeLine(JRPrintLine line, TableCell cell) throws IOException {
        this.startCell(line, cell);
        if (this.isOblique(line)) {
            this.finishStartCell();
            int width = line.getWidth();
            int height = line.getHeight();
            LineDirectionEnum lineDirection = line.getDirectionValue();
            int y1 = lineDirection == LineDirectionEnum.BOTTOM_UP ? height : 0;
            int y2 = lineDirection == LineDirectionEnum.BOTTOM_UP ? 0 : height;
            this.writer.write("<svg height=\"" + height + "\" width=\"" + width + "\">");
            this.writer.write("<line x1=\"0\" y1=\"" + y1 + "\" x2=\"" + width + "\" y2=\"" + y2 + "\" ");
            this.writeSvgStyle(line);
            this.writer.write("\"/></svg>");
        } else {
            StringBuilder styleBuffer = new StringBuilder();
            this.appendElementCellGenericStyle(cell, styleBuffer);
            this.appendBackcolorStyle(cell, styleBuffer);
            String side = null;
            float ratio = line.getWidth() / line.getHeight();
            side = ratio > 1.0f ? (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? "top" : "bottom") : (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? "left" : "right");
            this.appendPen(styleBuffer, line.getLinePen(), side);
            this.writeStyle(styleBuffer);
            this.finishStartCell();
        }
        this.endCell();
    }

    protected boolean isOblique(JRPrintLine line) {
        return line.getWidth() > 1 && line.getHeight() > 1;
    }

    protected void writeGenericElement(JRGenericPrintElement element, TableCell cell) throws IOException {
        GenericElementHtmlHandler handler = (GenericElementHtmlHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(element.getGenericType(), HTML_EXPORTER_KEY);
        if (handler == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No HTML generic element handler for " + element.getGenericType()));
            }
            this.writeEmptyCell(cell.getColumnSpan(), cell.getRowSpan());
        } else {
            this.startCell(element, cell);
            StringBuilder styleBuffer = new StringBuilder();
            this.appendElementCellGenericStyle(cell, styleBuffer);
            this.appendBackcolorStyle(cell, styleBuffer);
            this.appendBorderStyle(cell.getBox(), styleBuffer);
            if (styleBuffer.length() > 0) {
                this.writer.write(" style=\"");
                this.writer.write(styleBuffer.toString());
                this.writer.write("\"");
            }
            this.finishStartCell();
            String htmlFragment = handler.getHtmlFragment((JRHtmlExporterContext)this.exporterContext, element);
            if (htmlFragment != null) {
                this.writer.write(htmlFragment);
            }
            this.endCell();
        }
    }

    protected void writeLayers(List<Table> layers, TableVisitor tableVisitor, TableCell cell) throws IOException {
        this.startCell(cell);
        StringBuilder styleBuffer = new StringBuilder();
        this.appendElementCellGenericStyle(cell, styleBuffer);
        this.appendBackcolorStyle(cell, styleBuffer);
        this.appendBorderStyle(cell.getBox(), styleBuffer);
        this.writeStyle(styleBuffer);
        this.finishStartCell();
        this.setBackcolor(null);
        this.writer.write("<div style=\"width: 100%; height: 100%; position: relative;\">\n");
        ListIterator<Table> it = layers.listIterator();
        while (it.hasNext()) {
            Table table = it.next();
            StringBuilder layerStyleBuffer = new StringBuilder();
            if (it.hasNext()) {
                layerStyleBuffer.append("position: absolute; overflow: hidden; ");
            } else {
                layerStyleBuffer.append("position: relative; ");
            }
            layerStyleBuffer.append("width: 100%; height: 100%; ");
            if (it.previousIndex() > 0) {
                layerStyleBuffer.append("pointer-events: none; ");
            }
            this.writer.write("<div style=\"");
            this.writer.write(layerStyleBuffer.toString());
            this.writer.write("\">\n");
            ++this.pointerEventsNoneStack;
            this.exportTable(tableVisitor, table, false, false);
            --this.pointerEventsNoneStack;
            this.writer.write("</div>\n");
        }
        this.writer.write("</div>\n");
        this.restoreBackcolor();
        this.endCell();
    }

    protected void startCell(JRPrintElement element, TableCell cell) throws IOException {
        this.startCell(cell.getColumnSpan(), cell.getRowSpan());
        String dataAttr = this.getDataAttributes(element, cell);
        if (dataAttr != null) {
            this.writer.write(dataAttr);
        }
    }

    public String getDataAttributes(JRPrintElement element, TableCell cell) {
        String xtabColIdx;
        String xtabId;
        String columnIndex;
        String tableUuid;
        String cellId;
        String colUuid;
        String clazz;
        StringBuilder sb = new StringBuilder();
        String id = this.getCellProperty(element, cell, PROPERTY_HTML_ID);
        if (id != null) {
            sb.append(" id=\"" + id + "\"");
        }
        if ((clazz = this.getCellProperty(element, cell, PROPERTY_HTML_CLASS)) != null) {
            sb.append(" class=\"" + clazz + "\"");
        }
        if ((colUuid = this.getCellProperty(element, cell, "net.sf.jasperreports.export.headertoolbar.columnUUID")) != null) {
            sb.append(" data-coluuid=\"" + colUuid + "\"");
        }
        if ((cellId = this.getCellProperty(element, cell, "net.sf.jasperreports.export.headertoolbar.cellID")) != null) {
            sb.append(" data-cellid=\"" + cellId + "\"");
        }
        if ((tableUuid = this.getCellProperty(element, cell, "net.sf.jasperreports.export.headertoolbar.tableUUID")) != null) {
            sb.append(" data-tableuuid=\"" + tableUuid + "\"");
        }
        if ((columnIndex = this.getCellProperty(element, cell, "net.sf.jasperreports.export.headertoolbar.columnIndex")) != null) {
            sb.append(" data-colidx=\"" + columnIndex + "\"");
        }
        if ((xtabId = this.getCellProperty(element, cell, "net.sf.jasperreports.export.crosstab.crosstabId")) != null) {
            sb.append(" data-jrxtid=\"" + JRStringUtil.htmlEncode(xtabId) + "\"");
        }
        if ((xtabColIdx = this.getCellProperty(element, cell, "net.sf.jasperreports.export.crosstab.columnIndex")) != null) {
            sb.append(" data-jrxtcolidx=\"" + JRStringUtil.htmlEncode(xtabColIdx) + "\"");
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    protected String getCellProperty(JRPrintElement element, TableCell cell, String key) {
        String property = null;
        if (element != null) {
            property = this.getPropertiesUtil().getProperty(element, key);
        }
        if (property == null) {
            Tabulator tabulator = cell.getTabulator();
            for (FrameCell parentCell = cell.getCell().getParent(); parentCell != null && property == null; parentCell = parentCell.getParent()) {
                JRPrintElement parentElement = tabulator.getCellElement(parentCell);
                property = this.getPropertiesUtil().getProperty(parentElement, key);
            }
        }
        return property;
    }

    protected void startCell(TableCell cell) throws IOException {
        this.startCell(cell.getElement(), cell);
    }

    protected void startCell(int colSpan, int rowSpan) throws IOException {
        this.writer.write("<td");
        if (colSpan > 1) {
            this.writer.write(" colspan=\"");
            this.writer.write(Integer.toString(colSpan));
            this.writer.write("\"");
        }
        if (rowSpan > 1) {
            this.writer.write(" rowspan=\"");
            this.writer.write(Integer.toString(rowSpan));
            this.writer.write("\"");
        }
    }

    protected void finishStartCell() throws IOException {
        this.writer.write(">\n");
    }

    protected void endCell() throws IOException {
        this.writer.write("</td>\n");
    }

    protected void writeEmptyCell(int colSpan, int rowSpan) throws IOException {
        this.startCell(colSpan, rowSpan);
        this.finishStartCell();
        this.endCell();
    }

    protected void writeFrameCell(TableCell cell) throws IOException {
        this.startCell(cell);
        StringBuilder styleBuffer = new StringBuilder();
        this.appendElementCellGenericStyle(cell, styleBuffer);
        this.appendBackcolorStyle(cell, styleBuffer);
        this.appendBorderStyle(cell.getBox(), styleBuffer);
        this.writeStyle(styleBuffer);
        this.finishStartCell();
        this.endCell();
    }

    protected void writeStyle(StringBuilder styleBuffer) throws IOException {
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
    }

    protected void appendElementCellGenericStyle(TableCell cell, StringBuilder styleBuffer) {
        if (this.pointerEventsNoneStack > 0 && cell.getElement() != null) {
            styleBuffer.append("pointer-events: auto; ");
        }
    }

    protected void setBackcolor(Color color) {
        this.backcolorStack.addFirst(color);
    }

    protected void restoreBackcolor() {
        this.backcolorStack.removeFirst();
    }

    protected boolean matchesBackcolor(Color backcolor) {
        if (this.backcolorStack.isEmpty()) {
            return false;
        }
        Color currentBackcolor = this.backcolorStack.getFirst();
        return currentBackcolor != null && backcolor.getRGB() == currentBackcolor.getRGB();
    }

    protected Color appendBackcolorStyle(TableCell cell, StringBuilder styleBuffer) {
        Color cellBackcolor = cell.getBackcolor();
        if (cellBackcolor != null && !this.matchesBackcolor(cellBackcolor)) {
            styleBuffer.append("background-color: ");
            styleBuffer.append(JRColorUtil.getCssColor(cellBackcolor));
            styleBuffer.append("; ");
            return cellBackcolor;
        }
        return null;
    }

    protected boolean appendBorderStyle(JRLineBox box, StringBuilder styleBuffer) {
        boolean addedToStyle = false;
        if (box != null) {
            LineStyleEnum tps = box.getTopPen().getLineStyleValue();
            LineStyleEnum lps = box.getLeftPen().getLineStyleValue();
            LineStyleEnum bps = box.getBottomPen().getLineStyleValue();
            LineStyleEnum rps = box.getRightPen().getLineStyleValue();
            float tpw = box.getTopPen().getLineWidth().floatValue();
            float lpw = box.getLeftPen().getLineWidth().floatValue();
            float bpw = box.getBottomPen().getLineWidth().floatValue();
            float rpw = box.getRightPen().getLineWidth().floatValue();
            if (0.0f < tpw && tpw < 1.0f) {
                tpw = 1.0f;
            }
            if (0.0f < lpw && lpw < 1.0f) {
                lpw = 1.0f;
            }
            if (0.0f < bpw && bpw < 1.0f) {
                bpw = 1.0f;
            }
            if (0.0f < rpw && rpw < 1.0f) {
                rpw = 1.0f;
            }
            Color tpc = box.getTopPen().getLineColor();
            if (tps == lps && tps == bps && tps == rps && tpw == lpw && tpw == bpw && tpw == rpw && tpc.equals(box.getLeftPen().getLineColor()) && tpc.equals(box.getBottomPen().getLineColor()) && tpc.equals(box.getRightPen().getLineColor())) {
                addedToStyle |= this.appendPen(styleBuffer, box.getTopPen(), null);
            } else {
                addedToStyle |= this.appendPen(styleBuffer, box.getTopPen(), "top");
                addedToStyle |= this.appendPen(styleBuffer, box.getLeftPen(), "left");
                addedToStyle |= this.appendPen(styleBuffer, box.getBottomPen(), "bottom");
                addedToStyle |= this.appendPen(styleBuffer, box.getRightPen(), "right");
            }
        }
        return addedToStyle;
    }

    protected boolean appendPen(StringBuilder sb, JRPen pen, String side) {
        boolean addedToStyle = false;
        float borderWidth = pen.getLineWidth().floatValue();
        if (0.0f < borderWidth && borderWidth < 1.0f) {
            borderWidth = 1.0f;
        }
        String borderStyle = null;
        switch (pen.getLineStyleValue()) {
            case DOUBLE: {
                borderStyle = "double";
                break;
            }
            case DOTTED: {
                borderStyle = "dotted";
                break;
            }
            case DASHED: {
                borderStyle = "dashed";
                break;
            }
            default: {
                borderStyle = "solid";
            }
        }
        if (borderWidth > 0.0f) {
            sb.append("border");
            if (side != null) {
                sb.append("-");
                sb.append(side);
            }
            sb.append(": ");
            sb.append(this.toSizeUnit((int)borderWidth));
            sb.append(" ");
            sb.append(borderStyle);
            sb.append(" ");
            sb.append(JRColorUtil.getCssColor(pen.getLineColor()));
            sb.append("; ");
            addedToStyle = true;
        }
        return addedToStyle;
    }

    protected boolean appendPaddingStyle(JRLineBox box, StringBuilder styleBuffer) {
        boolean addedToStyle = false;
        if (box != null) {
            Integer tp = box.getTopPadding();
            Integer lp = box.getLeftPadding();
            Integer bp = box.getBottomPadding();
            Integer rp = box.getRightPadding();
            if (tp == lp && tp == bp && tp == rp) {
                addedToStyle |= this.appendPadding(styleBuffer, tp, null);
            } else {
                addedToStyle |= this.appendPadding(styleBuffer, box.getTopPadding(), "top");
                addedToStyle |= this.appendPadding(styleBuffer, box.getLeftPadding(), "left");
                addedToStyle |= this.appendPadding(styleBuffer, box.getBottomPadding(), "bottom");
                addedToStyle |= this.appendPadding(styleBuffer, box.getRightPadding(), "right");
            }
        }
        return addedToStyle;
    }

    protected boolean appendPadding(StringBuilder sb, Integer padding, String side) {
        boolean addedToStyle = false;
        if (padding > 0) {
            sb.append("padding");
            if (side != null) {
                sb.append("-");
                sb.append(side);
            }
            sb.append(": ");
            sb.append(this.toSizeUnit(padding));
            sb.append("; ");
            addedToStyle = true;
        }
        return addedToStyle;
    }

    protected boolean startHyperlink(JRPrintHyperlink link) throws IOException {
        boolean hyperlinkStarted = false;
        boolean canWrite = false;
        if (this.getReportContext() != null) {
            Boolean ignoreHyperlink = HyperlinkUtil.getIgnoreHyperlink(PROPERTY_IGNORE_HYPERLINK, link);
            if (ignoreHyperlink == null) {
                ignoreHyperlink = ((HtmlReportConfiguration)this.getCurrentItemConfiguration()).isIgnoreHyperlink();
            }
            if (!ignoreHyperlink.booleanValue() && link.getLinkType() != null) {
                canWrite = true;
                int id = link.hashCode() & Integer.MAX_VALUE;
                this.writer.write("<span class=\"_jrHyperLink " + link.getLinkType() + "\" data-id=\"" + id + "\"");
                HyperlinkData hyperlinkData = new HyperlinkData();
                hyperlinkData.setId(String.valueOf(id));
                hyperlinkData.setHref(this.getHyperlinkURL(link));
                hyperlinkData.setSelector("._jrHyperLink." + link.getLinkType());
                hyperlinkData.setHyperlink(link);
                this.hyperlinksData.add(hyperlinkData);
                hyperlinkStarted = true;
            }
        } else {
            String href = this.getHyperlinkURL(link);
            if (href != null) {
                canWrite = true;
                this.writer.write("<a href=\"");
                this.writer.write(href);
                this.writer.write("\"");
                String target = this.getHyperlinkTarget(link);
                if (target != null) {
                    this.writer.write(" target=\"");
                    this.writer.write(target);
                    this.writer.write("\"");
                }
            }
            boolean bl = hyperlinkStarted = href != null;
        }
        if (canWrite) {
            if (link.getHyperlinkTooltip() != null) {
                this.writer.write(" title=\"");
                this.writer.write(JRStringUtil.xmlEncode(link.getHyperlinkTooltip()));
                this.writer.write("\"");
            }
            this.writer.write(">");
        }
        return hyperlinkStarted;
    }

    protected void endHyperlink() throws IOException {
        if (this.getReportContext() != null) {
            this.writer.write("</span>");
        } else {
            this.writer.write("</a>");
        }
    }

    protected String getHyperlinkURL(JRPrintHyperlink link) {
        return this.resolveHyperlinkURL(this.reportIndex, link);
    }

    protected String resolveHyperlinkURL(int reportIndex, JRPrintHyperlink link) {
        String href;
        block13: {
            JRHyperlinkProducer customHandler;
            block14: {
                href = null;
                Boolean ignoreHyperlink = HyperlinkUtil.getIgnoreHyperlink(PROPERTY_IGNORE_HYPERLINK, link);
                if (ignoreHyperlink == null) {
                    ignoreHyperlink = ((HtmlReportConfiguration)this.getCurrentItemConfiguration()).isIgnoreHyperlink();
                }
                if (ignoreHyperlink.booleanValue()) break block13;
                customHandler = this.getHyperlinkProducer(link);
                if (customHandler != null) break block14;
                switch (link.getHyperlinkTypeValue()) {
                    case REFERENCE: {
                        if (link.getHyperlinkReference() != null) {
                            href = link.getHyperlinkReference();
                            break;
                        }
                        break block13;
                    }
                    case LOCAL_ANCHOR: {
                        if (link.getHyperlinkAnchor() != null) {
                            href = "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case LOCAL_PAGE: {
                        if (link.getHyperlinkPage() != null) {
                            href = "#JR_PAGE_ANCHOR_" + reportIndex + "_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                    case REMOTE_ANCHOR: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkAnchor() != null) {
                            href = link.getHyperlinkReference() + "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case REMOTE_PAGE: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkPage() != null) {
                            href = link.getHyperlinkReference() + "#" + "JR_PAGE_ANCHOR_" + "0_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                }
                break block13;
            }
            href = customHandler.getHyperlink(link);
        }
        return href;
    }

    protected String getHyperlinkTarget(JRPrintHyperlink link) {
        String target;
        block10: {
            JRHyperlinkTargetProducer producer;
            block9: {
                target = null;
                producer = this.targetProducerFactory.getHyperlinkTargetProducer(link.getLinkTarget());
                if (producer != null) break block9;
                switch (link.getHyperlinkTargetValue()) {
                    case BLANK: {
                        target = "_blank";
                        break;
                    }
                    case PARENT: {
                        target = "_parent";
                        break;
                    }
                    case TOP: {
                        target = "_top";
                        break;
                    }
                    case CUSTOM: {
                        List<JRPrintHyperlinkParameter> parameters;
                        boolean paramFound = false;
                        List<JRPrintHyperlinkParameter> list = parameters = link.getHyperlinkParameters() == null ? null : link.getHyperlinkParameters().getParameters();
                        if (parameters != null) {
                            for (JRPrintHyperlinkParameter parameter : parameters) {
                                if (!link.getLinkTarget().equals(parameter.getName())) continue;
                                target = parameter.getValue() == null ? null : parameter.getValue().toString();
                                paramFound = true;
                                break;
                            }
                        }
                        if (!paramFound) {
                            target = link.getLinkTarget();
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block10;
            }
            target = producer.getHyperlinkTarget(link);
        }
        return target;
    }

    public String toSizeUnit(float size) {
        Number number = Float.valueOf(this.toZoom(size));
        if ((float)((Number)number).intValue() == ((Number)number).floatValue()) {
            number = ((Number)number).intValue();
        }
        return String.valueOf(number) + ((HtmlReportConfiguration)this.getCurrentItemConfiguration()).getSizeUnit().getName();
    }

    public String toSizeUnit(int size) {
        return this.toSizeUnit((float)size);
    }

    protected float toZoom(float size) {
        float zoom = 1.0f;
        Float zoomRatio = ((HtmlReportConfiguration)this.getCurrentItemConfiguration()).getZoomRatio();
        if (zoomRatio != null && (zoom = zoomRatio.floatValue()) <= 0.0f) {
            throw new JRRuntimeException("export.common.invalid.zoom.ratio", new Object[]{Float.valueOf(zoom)});
        }
        return zoom * size;
    }

    protected int toZoom(int size) {
        return (int)this.toZoom((float)size);
    }

    private void addSearchAttributes(JRStyledText styledText, JRPrintText textElement) {
        ReportContext reportContext = this.getReportContext();
        if (reportContext != null) {
            SpansInfo spansInfo = (SpansInfo)reportContext.getParameterValue("net.sf.jasperreports.search.term.highlighter");
            PrintElementId pei = PrintElementId.forElement(textElement);
            if (spansInfo != null && spansInfo.hasHitTermsInfo(pei.toString())) {
                List<HitTermInfo> hitTermInfos = JRCloneUtils.cloneList(spansInfo.getHitTermsInfo(pei.toString()));
                short[] lineBreakOffsets = textElement.getLineBreakOffsets();
                if (lineBreakOffsets != null && lineBreakOffsets.length > 0) {
                    int sz = lineBreakOffsets.length;
                    for (HitTermInfo ti : hitTermInfos) {
                        for (int i = 0; i < sz && lineBreakOffsets[i] <= ti.getStart(); ++i) {
                            ti.setStart(ti.getStart() + 1);
                            ti.setEnd(ti.getEnd() + 1);
                        }
                    }
                }
                AttributedString attributedString = styledText.getAttributedString();
                int ln = hitTermInfos.size();
                for (int i = 0; i < ln; i += spansInfo.getTermsPerQuery()) {
                    attributedString.addAttribute(JRTextAttribute.SEARCH_HIGHLIGHT, Color.yellow, hitTermInfos.get(i).getStart(), hitTermInfos.get(i + spansInfo.getTermsPerQuery() - 1).getEnd());
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"No ReportContext to hold search data!");
        }
    }

    protected void exportStyledText(JRPrintText printText, JRStyledText styledText, String tooltip, boolean hyperlinkStarted) throws IOException {
        Locale locale = this.getTextLocale(printText);
        LineSpacingEnum lineSpacing = printText.getParagraph().getLineSpacing();
        Float lineSpacingSize = printText.getParagraph().getLineSpacingSize();
        float lineSpacingFactor = printText.getLineSpacingFactor();
        Color backcolor = printText.getBackcolor();
        String text = styledText.getText();
        int runLimit = 0;
        this.addSearchAttributes(styledText, printText);
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        boolean first = true;
        boolean startedSpan = false;
        boolean highlightStarted = false;
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            if (first && runLimit < styledText.length() && tooltip != null) {
                startedSpan = true;
                this.writer.write("<span title=\"");
                this.writer.write(JRStringUtil.xmlEncode(tooltip));
                this.writer.write("\">");
                tooltip = null;
            }
            first = false;
            Map<AttributedCharacterIterator.Attribute, Object> attributes = iterator.getAttributes();
            Color highlightColor = (Color)attributes.get(JRTextAttribute.SEARCH_HIGHLIGHT);
            if (highlightColor != null && !highlightStarted) {
                highlightStarted = true;
                this.writer.write("<span class=\"jr_search_result\">");
            } else if (highlightColor == null && highlightStarted) {
                highlightStarted = false;
                this.writer.write("</span>");
            }
            this.exportStyledTextRun(attributes, text.substring(iterator.getIndex(), runLimit), tooltip, locale, lineSpacing, lineSpacingSize, lineSpacingFactor, backcolor, hyperlinkStarted);
            iterator.setIndex(runLimit);
        }
        if (highlightStarted) {
            this.writer.write("</span>");
        }
        if (startedSpan) {
            this.writer.write("</span>");
        }
    }

    protected void exportStyledTextRun(Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, String tooltip, Locale locale, LineSpacingEnum lineSpacing, Float lineSpacingSize, float lineSpacingFactor, Color backcolor, boolean hyperlinkStarted) throws IOException {
        Color runBackcolor;
        boolean localHyperlink = false;
        JRPrintHyperlink hyperlink = (JRPrintHyperlink)attributes.get(JRTextAttribute.HYPERLINK);
        if (!hyperlinkStarted && hyperlink != null) {
            localHyperlink = this.startHyperlink(hyperlink);
        }
        boolean isBold = TextAttribute.WEIGHT_BOLD.equals(attributes.get(TextAttribute.WEIGHT));
        boolean isItalic = TextAttribute.POSTURE_OBLIQUE.equals(attributes.get(TextAttribute.POSTURE));
        String fontFamily = this.resolveFontFamily(attributes, locale);
        this.writer.write("<span style=\"font-family: ");
        this.writer.write(fontFamily);
        this.writer.write("; ");
        Color forecolor = (Color)attributes.get(TextAttribute.FOREGROUND);
        if (!hyperlinkStarted || !Color.black.equals(forecolor)) {
            this.writer.write("color: ");
            this.writer.write(JRColorUtil.getCssColor(forecolor));
            this.writer.write("; ");
        }
        if ((runBackcolor = (Color)attributes.get(TextAttribute.BACKGROUND)) != null && !runBackcolor.equals(backcolor)) {
            this.writer.write("background-color: ");
            this.writer.write(JRColorUtil.getCssColor(runBackcolor));
            this.writer.write("; ");
        }
        this.writer.write("font-size: ");
        this.writer.write(this.toSizeUnit(((Float)attributes.get(TextAttribute.SIZE)).floatValue()));
        this.writer.write(";");
        switch (lineSpacing) {
            default: {
                if (lineSpacingFactor == 0.0f) {
                    this.writer.write(" line-height: 1; *line-height: normal;");
                    break;
                }
                this.writer.write(" line-height: " + lineSpacingFactor + ";");
                break;
            }
            case ONE_AND_HALF: {
                if (lineSpacingFactor == 0.0f) {
                    this.writer.write(" line-height: 1.5;");
                    break;
                }
                this.writer.write(" line-height: " + lineSpacingFactor + ";");
                break;
            }
            case DOUBLE: {
                if (lineSpacingFactor == 0.0f) {
                    this.writer.write(" line-height: 2.0;");
                    break;
                }
                this.writer.write(" line-height: " + lineSpacingFactor + ";");
                break;
            }
            case PROPORTIONAL: {
                if (lineSpacingSize == null) break;
                this.writer.write(" line-height: " + lineSpacingSize.floatValue() + ";");
                break;
            }
            case AT_LEAST: 
            case FIXED: {
                if (lineSpacingSize == null) break;
                this.writer.write(" line-height: " + lineSpacingSize.floatValue() + "px;");
            }
        }
        if (isBold) {
            this.writer.write(" font-weight: bold;");
        }
        if (isItalic) {
            this.writer.write(" font-style: italic;");
        }
        if (TextAttribute.UNDERLINE_ON.equals(attributes.get(TextAttribute.UNDERLINE))) {
            this.writer.write(" text-decoration: underline;");
        }
        if (TextAttribute.STRIKETHROUGH_ON.equals(attributes.get(TextAttribute.STRIKETHROUGH))) {
            this.writer.write(" text-decoration: line-through;");
        }
        if (TextAttribute.SUPERSCRIPT_SUPER.equals(attributes.get(TextAttribute.SUPERSCRIPT))) {
            this.writer.write(" vertical-align: super;");
        } else if (TextAttribute.SUPERSCRIPT_SUB.equals(attributes.get(TextAttribute.SUPERSCRIPT))) {
            this.writer.write(" vertical-align: sub;");
        }
        this.writer.write("\"");
        if (tooltip != null) {
            this.writer.write(" title=\"");
            this.writer.write(JRStringUtil.xmlEncode(tooltip));
            this.writer.write("\"");
        }
        this.writer.write(">");
        this.writer.write(JRStringUtil.htmlEncode(text));
        this.writer.write("</span>");
        if (localHyperlink) {
            this.endHyperlink();
        }
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRHtmlExporterContext {
        protected ExporterContext() {
        }

        @Override
        public String getHyperlinkURL(JRPrintHyperlink link) {
            return HtmlExporter.this.getHyperlinkURL(link);
        }
    }

    protected class CellElementVisitor
    implements PrintElementVisitor<TableCell> {
        protected CellElementVisitor() {
        }

        @Override
        public void visit(JRPrintText textElement, TableCell cell) {
            try {
                HtmlExporter.this.writeText(textElement, cell);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }

        @Override
        public void visit(JRPrintImage image, TableCell cell) {
            try {
                HtmlExporter.this.writeImage(image, cell);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
        }

        @Override
        public void visit(JRPrintRectangle rectangle, TableCell cell) {
            try {
                HtmlExporter.this.writeRectangle(rectangle, cell);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }

        @Override
        public void visit(JRPrintLine line, TableCell cell) {
            try {
                HtmlExporter.this.writeLine(line, cell);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }

        @Override
        public void visit(JRPrintEllipse ellipse, TableCell cell) {
            try {
                HtmlExporter.this.writeEllipse(ellipse, cell);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }

        @Override
        public void visit(JRPrintFrame frame, TableCell cell) {
            throw new JRRuntimeException(HtmlExporter.EXCEPTION_MESSAGE_KEY_INTERNAL_ERROR, (Object[])null);
        }

        @Override
        public void visit(JRGenericPrintElement printElement, TableCell cell) {
            try {
                HtmlExporter.this.writeGenericElement(printElement, cell);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
    }

    protected class TableVisitor
    implements CellVisitor<TablePosition, Void, IOException> {
        private final Tabulator tabulator;
        private final PrintElementVisitor<TableCell> elementVisitor;

        public TableVisitor(Tabulator tabulator, PrintElementVisitor<TableCell> elementVisitor) {
            this.tabulator = tabulator;
            this.elementVisitor = elementVisitor;
        }

        @Override
        public Void visit(ElementCell cell, TablePosition position) {
            TableCell tableCell = this.tabulator.getTableCell(position, cell);
            JRPrintElement element = tableCell.getElement();
            element.accept(this.elementVisitor, tableCell);
            return null;
        }

        @Override
        public Void visit(SplitCell cell, TablePosition position) {
            return null;
        }

        @Override
        public Void visit(FrameCell frameCell, TablePosition position) throws IOException {
            TableCell tableCell = this.tabulator.getTableCell(position, frameCell);
            HtmlExporter.this.writeFrameCell(tableCell);
            return null;
        }

        @Override
        public Void visit(LayeredCell layeredCell, TablePosition position) throws IOException {
            TableCell tableCell = this.tabulator.getTableCell(position, layeredCell);
            HtmlExporter.this.writeLayers(layeredCell.getLayers(), this, tableCell);
            return null;
        }
    }

    private static class InternalImageProcessorResult {
        protected final String imageSource;
        protected final Dimension2D dimension;
        protected final boolean isEmbededSvgData;

        protected InternalImageProcessorResult(String imagePath, Dimension2D dimension, boolean isEmbededSvgData) {
            this.imageSource = imagePath;
            this.dimension = dimension;
            this.isEmbededSvgData = isEmbededSvgData;
        }
    }

    private class InternalImageProcessor {
        private final JRPrintElement imageElement;
        private final RenderersCache imageRenderersCache;
        private final boolean isLazy;
        private final boolean embedImage;
        private final boolean needDimension;
        private final TableCell cell;
        private final int availableImageWidth;
        private final int availableImageHeight;

        protected InternalImageProcessor(JRPrintImage imageElement, boolean isLazy, boolean needDimension, TableCell cell, int availableImageWidth, int availableImageHeight) {
            this.imageElement = imageElement;
            this.imageRenderersCache = imageElement.isUsingCache() ? HtmlExporter.this.renderersCache : new RenderersCache(HtmlExporter.this.getJasperReportsContext());
            this.isLazy = isLazy;
            this.embedImage = HtmlExporter.this.isEmbedImage(imageElement);
            this.needDimension = needDimension;
            this.cell = cell;
            this.availableImageWidth = availableImageWidth;
            this.availableImageHeight = availableImageHeight;
        }

        protected InternalImageProcessorResult process(Renderable renderer) throws JRException, IOException {
            String imageSource = null;
            Dimension2D dimension = null;
            boolean isEmbededSvgData = false;
            if (this.isLazy) {
                imageSource = RendererUtil.getResourceLocation(renderer);
            } else {
                if (renderer instanceof ResourceRenderer) {
                    renderer = this.imageRenderersCache.getLoadedRenderer((ResourceRenderer)renderer);
                }
                if (this.needDimension) {
                    DimensionRenderable dimensionRenderer = this.imageRenderersCache.getDimensionRenderable(renderer);
                    Dimension2D dimension2D = dimension = dimensionRenderer == null ? null : dimensionRenderer.getDimension(HtmlExporter.this.jasperReportsContext);
                }
                if (!this.embedImage && renderer instanceof DataRenderable && HtmlExporter.this.rendererToImagePathMap.containsKey(renderer.getId())) {
                    imageSource = HtmlExporter.this.rendererToImagePathMap.get(renderer.getId());
                } else if (this.embedImage) {
                    DataRenderable dataRenderer = null;
                    dataRenderer = HtmlExporter.this.isConvertSvgToImage(this.imageElement) ? HtmlExporter.this.getRendererUtil().getImageDataRenderable(this.imageRenderersCache, renderer, new Dimension(this.availableImageWidth, this.availableImageHeight), ModeEnum.OPAQUE == this.imageElement.getModeValue() ? this.imageElement.getBackcolor() : null) : HtmlExporter.this.getRendererUtil().getDataRenderable(renderer, new Dimension(this.availableImageWidth, this.availableImageHeight), ModeEnum.OPAQUE == this.imageElement.getModeValue() ? this.imageElement.getBackcolor() : null);
                    byte[] imageData = dataRenderer.getData(HtmlExporter.this.jasperReportsContext);
                    SvgDataSniffer.SvgInfo svgInfo = HtmlExporter.this.getRendererUtil().getSvgInfo(imageData);
                    if (svgInfo != null) {
                        if (HtmlExporter.this.isEmbeddedSvgUseFonts(this.imageElement)) {
                            Locale locale = HtmlExporter.this.getLocale();
                            SvgFontProcessor svgFontProcessor = new SvgFontProcessor(HtmlExporter.this.jasperReportsContext, locale){

                                @Override
                                public String getFontFamily(String fontFamily, Locale locale) {
                                    return HtmlExporter.this.getFontFamily(true, fontFamily, locale);
                                }
                            };
                            imageData = svgFontProcessor.process(imageData);
                        }
                        isEmbededSvgData = true;
                        String encoding = svgInfo.getEncoding();
                        imageSource = new String(imageData, encoding == null ? "UTF-8" : encoding);
                        DimensionRenderable dimensionRenderer = this.imageRenderersCache.getDimensionRenderable(renderer);
                        dimension = dimensionRenderer == null ? null : dimensionRenderer.getDimension(HtmlExporter.this.jasperReportsContext);
                    } else {
                        String imageMimeType = JRTypeSniffer.getImageTypeValue(imageData).getMimeType();
                        ByteArrayInputStream bais = new ByteArrayInputStream(imageData);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        Base64Util.encode(bais, baos);
                        imageSource = "data:" + imageMimeType + ";base64," + new String(baos.toByteArray(), "UTF-8");
                    }
                } else {
                    HtmlResourceHandler imageHandler;
                    HtmlResourceHandler htmlResourceHandler = imageHandler = HtmlExporter.this.getImageHandler() == null ? ((HtmlExporterOutput)HtmlExporter.this.getExporterOutput()).getImageHandler() : HtmlExporter.this.getImageHandler();
                    if (imageHandler != null) {
                        DataRenderable dataRenderer = null;
                        dataRenderer = HtmlExporter.this.isConvertSvgToImage(this.imageElement) ? HtmlExporter.this.getRendererUtil().getImageDataRenderable(this.imageRenderersCache, renderer, new Dimension(this.availableImageWidth, this.availableImageHeight), ModeEnum.OPAQUE == this.imageElement.getModeValue() ? this.imageElement.getBackcolor() : null) : HtmlExporter.this.getRendererUtil().getDataRenderable(renderer, new Dimension(this.availableImageWidth, this.availableImageHeight), ModeEnum.OPAQUE == this.imageElement.getModeValue() ? this.imageElement.getBackcolor() : null);
                        byte[] imageData = dataRenderer.getData(HtmlExporter.this.jasperReportsContext);
                        String fileExtension = HtmlExporter.this.getRendererUtil().isSvgData(imageData) ? "svg" : JRTypeSniffer.getImageTypeValue(imageData).getFileExtension();
                        String imageName = AbstractHtmlExporter.getImageName(HtmlExporter.this.getElementIndex(this.cell), fileExtension);
                        imageHandler.handleResource(imageName, imageData);
                        imageSource = imageHandler.getResourcePath(imageName);
                        if (dataRenderer == renderer) {
                            HtmlExporter.this.rendererToImagePathMap.put(renderer.getId(), imageSource);
                        }
                    }
                }
            }
            return new InternalImageProcessorResult(imageSource, dimension, isEmbededSvgData);
        }
    }
}

