/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.DownloadedContent;
import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebClientOptions;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.httpclient.HtmlUnitCookieSpecProvider;
import com.gargoylesoftware.htmlunit.httpclient.HtmlUnitCookieStore;
import com.gargoylesoftware.htmlunit.httpclient.HtmlUnitRedirectStrategie;
import com.gargoylesoftware.htmlunit.httpclient.HtmlUnitSSLConnectionSocketFactory;
import com.gargoylesoftware.htmlunit.httpclient.SocksConnectionSocketFactory;
import com.gargoylesoftware.htmlunit.util.KeyDataPair;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.RequestAddCookies;
import org.apache.http.client.protocol.RequestAuthCache;
import org.apache.http.client.protocol.RequestClientConnControl;
import org.apache.http.client.protocol.RequestDefaultHeaders;
import org.apache.http.client.protocol.RequestExpectContinue;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.client.protocol.ResponseProcessCookies;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.conn.util.PublicSuffixMatcherLoader;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.TextUtils;

public class HttpWebConnection
implements WebConnection {
    private static final Log LOG = LogFactory.getLog(HttpWebConnection.class);
    private static final String HACKED_COOKIE_POLICY = "mine";
    private ThreadLocal<HttpClientBuilder> httpClientBuilder_ = new ThreadLocal();
    private final WebClient webClient_;
    private final HttpContext httpContext_;
    private String virtualHost_;
    private final CookieSpecProvider htmlUnitCookieSpecProvider_;
    private final WebClientOptions usedOptions_;
    private PoolingHttpClientConnectionManager connectionManager_;

    public HttpWebConnection(WebClient webClient) {
        this.webClient_ = webClient;
        this.htmlUnitCookieSpecProvider_ = new HtmlUnitCookieSpecProvider(webClient.getBrowserVersion());
        this.httpContext_ = new HttpClientContext();
        this.usedOptions_ = new WebClientOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebResponse getResponse(WebRequest request) throws IOException {
        URL url = request.getUrl();
        HttpClientBuilder builder = this.reconfigureHttpClientIfNeeded(this.getHttpClientBuilder());
        if (this.connectionManager_ == null) {
            this.connectionManager_ = HttpWebConnection.createConnectionManager(builder);
        }
        builder.setConnectionManager((HttpClientConnectionManager)this.connectionManager_);
        HttpUriRequest httpMethod = null;
        try {
            try {
                httpMethod = this.makeHttpMethod(request, builder);
            }
            catch (URISyntaxException e) {
                throw new IOException("Unable to create URI from URL: " + url.toExternalForm() + " (reason: " + e.getMessage() + ")", e);
            }
            HttpHost hostConfiguration = HttpWebConnection.getHostConfiguration(request);
            long startTime = System.currentTimeMillis();
            CloseableHttpResponse httpResponse = null;
            try {
                httpResponse = builder.build().execute(hostConfiguration, (HttpRequest)httpMethod, this.httpContext_);
            }
            catch (SSLPeerUnverifiedException s) {
                if (this.webClient_.getOptions().isUseInsecureSSL()) {
                    HtmlUnitSSLConnectionSocketFactory.setUseSSL3Only(this.httpContext_, true);
                    httpResponse = builder.build().execute(hostConfiguration, (HttpRequest)httpMethod, this.httpContext_);
                }
                throw s;
            }
            catch (Error e) {
                this.httpClientBuilder_.set(null);
                throw e;
            }
            DownloadedContent downloadedBody = this.downloadResponseBody((HttpResponse)httpResponse);
            long endTime = System.currentTimeMillis();
            WebResponse webResponse = this.makeWebResponse((HttpResponse)httpResponse, request, downloadedBody, endTime - startTime);
            return webResponse;
        }
        finally {
            if (httpMethod != null) {
                this.onResponseGenerated(httpMethod);
            }
        }
    }

    protected void onResponseGenerated(HttpUriRequest httpMethod) {
    }

    private static HttpHost getHostConfiguration(WebRequest webRequest) {
        URL url = webRequest.getUrl();
        return new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
    }

    private void setProxy(HttpRequestBase httpRequest, WebRequest webRequest) {
        RequestConfig.Builder requestBuilder = HttpWebConnection.createRequestConfigBuilder(this.getTimeout());
        if (webRequest.getProxyHost() != null) {
            HttpHost proxy = new HttpHost(webRequest.getProxyHost(), webRequest.getProxyPort());
            if (webRequest.isSocksProxy()) {
                SocksConnectionSocketFactory.setSocksProxy(this.httpContext_, proxy);
            } else {
                requestBuilder.setProxy(proxy);
                httpRequest.setConfig(requestBuilder.build());
            }
        } else {
            requestBuilder.setProxy(null);
            httpRequest.setConfig(requestBuilder.build());
        }
    }

    private HttpUriRequest makeHttpMethod(WebRequest webRequest, HttpClientBuilder httpClientBuilder) throws URISyntaxException {
        Credentials requestCredentials;
        String charset = webRequest.getCharset();
        URL url = UrlUtils.encodeUrl(webRequest.getUrl(), false, charset);
        URI uri = URIUtils.createURI((String)url.getProtocol(), (String)url.getHost(), (int)url.getPort(), (String)url.getPath(), (String)HttpWebConnection.escapeQuery(url.getQuery()), null);
        if (this.getVirtualHost() != null) {
            uri = URI.create(this.getVirtualHost());
        }
        HttpRequestBase httpMethod = HttpWebConnection.buildHttpMethod(webRequest.getHttpMethod(), uri);
        this.setProxy(httpMethod, webRequest);
        if (!(httpMethod instanceof HttpEntityEnclosingRequest)) {
            if (!webRequest.getRequestParameters().isEmpty()) {
                List<NameValuePair> pairs = webRequest.getRequestParameters();
                org.apache.http.NameValuePair[] httpClientPairs = NameValuePair.toHttpClient(pairs);
                String query = URLEncodedUtils.format(Arrays.asList(httpClientPairs), (String)charset);
                uri = URIUtils.createURI((String)url.getProtocol(), (String)url.getHost(), (int)url.getPort(), (String)url.getPath(), (String)query, null);
                httpMethod.setURI(uri);
            }
        } else {
            HttpEntityEnclosingRequest method = (HttpEntityEnclosingRequest)httpMethod;
            if (webRequest.getEncodingType() == FormEncodingType.URL_ENCODED && method instanceof HttpPost) {
                HttpPost postMethod = (HttpPost)method;
                if (webRequest.getRequestBody() == null) {
                    List<NameValuePair> pairs = webRequest.getRequestParameters();
                    org.apache.http.NameValuePair[] httpClientPairs = NameValuePair.toHttpClient(pairs);
                    String query = URLEncodedUtils.format(Arrays.asList(httpClientPairs), (String)charset);
                    StringEntity urlEncodedEntity = new StringEntity(query, charset);
                    urlEncodedEntity.setContentType("application/x-www-form-urlencoded");
                    postMethod.setEntity((HttpEntity)urlEncodedEntity);
                } else {
                    String body = StringUtils.defaultString((String)webRequest.getRequestBody());
                    StringEntity urlEncodedEntity = new StringEntity(body, charset);
                    urlEncodedEntity.setContentType("application/x-www-form-urlencoded");
                    postMethod.setEntity((HttpEntity)urlEncodedEntity);
                }
            } else if (FormEncodingType.MULTIPART == webRequest.getEncodingType()) {
                Charset c = HttpWebConnection.getCharset(charset, webRequest.getRequestParameters());
                MultipartEntityBuilder builder = MultipartEntityBuilder.create().setLaxMode();
                builder.setCharset(c);
                for (NameValuePair pair : webRequest.getRequestParameters()) {
                    if (pair instanceof KeyDataPair) {
                        this.buildFilePart((KeyDataPair)pair, builder);
                        continue;
                    }
                    builder.addTextBody(pair.getName(), pair.getValue(), ContentType.create((String)"text/plain", (String)charset));
                }
                method.setEntity(builder.build());
            } else {
                String body = webRequest.getRequestBody();
                if (body != null) {
                    method.setEntity((HttpEntity)new StringEntity(body, charset));
                }
            }
        }
        this.configureHttpProcessorBuilder(httpClientBuilder, webRequest);
        CredentialsProvider credentialsProvider = this.webClient_.getCredentialsProvider();
        Credentials requestUrlCredentials = webRequest.getUrlCredentials();
        if (null != requestUrlCredentials && this.webClient_.getBrowserVersion().hasFeature(BrowserVersionFeatures.URL_AUTH_CREDENTIALS)) {
            URL requestUrl = webRequest.getUrl();
            AuthScope authScope = new AuthScope(requestUrl.getHost(), requestUrl.getPort());
            credentialsProvider.setCredentials(authScope, requestUrlCredentials);
            this.httpContext_.removeAttribute("http.auth.target-scope");
        }
        if (null != (requestCredentials = webRequest.getCredentials())) {
            URL requestUrl = webRequest.getUrl();
            AuthScope authScope = new AuthScope(requestUrl.getHost(), requestUrl.getPort());
            credentialsProvider.setCredentials(authScope, requestCredentials);
            this.httpContext_.removeAttribute("http.auth.target-scope");
        }
        httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        this.httpContext_.removeAttribute("http.auth.credentials-provider");
        return httpMethod;
    }

    private static String escapeQuery(String query) {
        if (query == null) {
            return null;
        }
        return query.replace("%%", "%25%25");
    }

    private static Charset getCharset(String charset, List<NameValuePair> pairs) {
        for (NameValuePair pair : pairs) {
            KeyDataPair pairWithFile;
            if (!(pair instanceof KeyDataPair) || (pairWithFile = (KeyDataPair)pair).getData() != null || pairWithFile.getFile() == null) continue;
            String fileName = pairWithFile.getFile().getName();
            for (int i = 0; i < fileName.length(); ++i) {
                if (fileName.codePointAt(i) <= 127) continue;
                return Charset.forName(charset);
            }
        }
        return null;
    }

    void buildFilePart(KeyDataPair pairWithFile, MultipartEntityBuilder builder) {
        String mimeType = pairWithFile.getMimeType();
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        ContentType contentType = ContentType.create((String)mimeType);
        File file = pairWithFile.getFile();
        if (pairWithFile.getData() != null) {
            String filename = file == null ? pairWithFile.getValue() : (pairWithFile.getFileName() != null ? pairWithFile.getFileName() : (this.webClient_.getBrowserVersion().hasFeature(BrowserVersionFeatures.HEADER_CONTENT_DISPOSITION_ABSOLUTE_PATH) ? file.getAbsolutePath() : file.getName()));
            builder.addBinaryBody(pairWithFile.getName(), (InputStream)new ByteArrayInputStream(pairWithFile.getData()), contentType, filename);
            return;
        }
        if (file == null) {
            builder.addPart(pairWithFile.getName(), (ContentBody)new InputStreamBody(new ByteArrayInputStream(new byte[0]), contentType, pairWithFile.getValue()){

                public long getContentLength() {
                    return 0L;
                }
            });
            return;
        }
        String filename = pairWithFile.getFile() == null ? pairWithFile.getValue() : (pairWithFile.getFileName() != null ? pairWithFile.getFileName() : (this.webClient_.getBrowserVersion().hasFeature(BrowserVersionFeatures.HEADER_CONTENT_DISPOSITION_ABSOLUTE_PATH) ? pairWithFile.getFile().getAbsolutePath() : pairWithFile.getFile().getName()));
        builder.addBinaryBody(pairWithFile.getName(), pairWithFile.getFile(), contentType, filename);
    }

    private static HttpRequestBase buildHttpMethod(HttpMethod submitMethod, URI uri) {
        HttpGet method;
        switch (submitMethod) {
            case GET: {
                method = new HttpGet(uri);
                break;
            }
            case POST: {
                method = new HttpPost(uri);
                break;
            }
            case PUT: {
                method = new HttpPut(uri);
                break;
            }
            case DELETE: {
                method = new HttpDelete(uri);
                break;
            }
            case OPTIONS: {
                method = new HttpOptions(uri);
                break;
            }
            case HEAD: {
                method = new HttpHead(uri);
                break;
            }
            case TRACE: {
                method = new HttpTrace(uri);
                break;
            }
            case PATCH: {
                method = new HttpPatch(uri);
                break;
            }
            default: {
                throw new IllegalStateException("Submit method not yet supported: " + (Object)((Object)submitMethod));
            }
        }
        return method;
    }

    protected HttpClientBuilder getHttpClientBuilder() {
        HttpClientBuilder builder = this.httpClientBuilder_.get();
        if (builder == null) {
            builder = this.createHttpClient();
            RegistryBuilder registeryBuilder = RegistryBuilder.create().register(HACKED_COOKIE_POLICY, (Object)this.htmlUnitCookieSpecProvider_);
            builder.setDefaultCookieSpecRegistry((Lookup)registeryBuilder.build());
            builder.setDefaultCookieStore((CookieStore)new HtmlUnitCookieStore(this.webClient_.getCookieManager()));
            this.httpClientBuilder_.set(builder);
        }
        return builder;
    }

    protected int getTimeout() {
        return this.webClient_.getOptions().getTimeout();
    }

    protected HttpClientBuilder createHttpClient() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setRedirectStrategy((RedirectStrategy)new HtmlUnitRedirectStrategie());
        this.configureTimeout(builder, this.getTimeout());
        this.configureHttpsScheme(builder);
        builder.setMaxConnPerRoute(6);
        return builder;
    }

    private void configureTimeout(HttpClientBuilder builder, int timeout) {
        RequestConfig.Builder requestBuilder = HttpWebConnection.createRequestConfigBuilder(timeout);
        builder.setDefaultRequestConfig(requestBuilder.build());
        builder.setDefaultSocketConfig(HttpWebConnection.createSocketConfigBuilder(timeout).build());
        this.httpContext_.removeAttribute("http.request-config");
        this.usedOptions_.setTimeout(timeout);
    }

    private static RequestConfig.Builder createRequestConfigBuilder(int timeout) {
        RequestConfig.Builder requestBuilder = RequestConfig.custom().setCookieSpec(HACKED_COOKIE_POLICY).setRedirectsEnabled(false).setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout);
        return requestBuilder;
    }

    private static SocketConfig.Builder createSocketConfigBuilder(int timeout) {
        SocketConfig.Builder socketBuilder = SocketConfig.custom().setSoTimeout(timeout);
        return socketBuilder;
    }

    private HttpClientBuilder reconfigureHttpClientIfNeeded(HttpClientBuilder httpClientBuilder) {
        int timeout;
        WebClientOptions options = this.webClient_.getOptions();
        if (options.isUseInsecureSSL() != this.usedOptions_.isUseInsecureSSL() || options.getSSLClientCertificateStore() != this.usedOptions_.getSSLClientCertificateStore() || options.getSSLTrustStore() != this.usedOptions_.getSSLTrustStore() || options.getSSLClientCipherSuites() != this.usedOptions_.getSSLClientCipherSuites() || options.getSSLClientProtocols() != this.usedOptions_.getSSLClientProtocols() || options.getProxyConfig() != this.usedOptions_.getProxyConfig()) {
            this.configureHttpsScheme(httpClientBuilder);
            if (this.connectionManager_ != null) {
                this.connectionManager_.shutdown();
                this.connectionManager_ = null;
            }
        }
        if ((timeout = this.getTimeout()) != this.usedOptions_.getTimeout()) {
            this.configureTimeout(httpClientBuilder, timeout);
        }
        return httpClientBuilder;
    }

    private void configureHttpsScheme(HttpClientBuilder builder) {
        WebClientOptions options = this.webClient_.getOptions();
        SSLConnectionSocketFactory socketFactory = HtmlUnitSSLConnectionSocketFactory.buildSSLSocketFactory(options);
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory);
        this.usedOptions_.setUseInsecureSSL(options.isUseInsecureSSL());
        this.usedOptions_.setSSLClientCertificateStore(options.getSSLClientCertificateStore());
        this.usedOptions_.setSSLTrustStore(options.getSSLTrustStore());
        this.usedOptions_.setSSLClientCipherSuites(options.getSSLClientCipherSuites());
        this.usedOptions_.setSSLClientProtocols(options.getSSLClientProtocols());
        this.usedOptions_.setProxyConfig(options.getProxyConfig());
    }

    private void configureHttpProcessorBuilder(HttpClientBuilder builder, WebRequest webRequest) {
        HttpProcessorBuilder b = HttpProcessorBuilder.create();
        for (HttpRequestInterceptor i : this.getHttpRequestInterceptors(webRequest)) {
            b.add(i);
        }
        b.addAll(new HttpRequestInterceptor[]{new RequestDefaultHeaders(null), new RequestContent(), new RequestTargetHost(), new RequestExpectContinue()});
        b.add((HttpRequestInterceptor)new RequestAcceptEncoding());
        b.add((HttpRequestInterceptor)new RequestAuthCache());
        b.add((HttpResponseInterceptor)new ResponseProcessCookies());
        b.add((HttpResponseInterceptor)new ResponseContentEncoding());
        builder.setHttpProcessor(b.build());
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost_ = virtualHost;
    }

    public String getVirtualHost() {
        return this.virtualHost_;
    }

    private WebResponse makeWebResponse(HttpResponse httpResponse, WebRequest request, DownloadedContent responseBody, long loadTime) {
        String statusMessage = httpResponse.getStatusLine().getReasonPhrase();
        if (statusMessage == null) {
            statusMessage = "Unknown status message";
        }
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        ArrayList<NameValuePair> headers = new ArrayList<NameValuePair>();
        for (Header header : httpResponse.getAllHeaders()) {
            headers.add(new NameValuePair(header.getName(), header.getValue()));
        }
        WebResponseData responseData = new WebResponseData(responseBody, statusCode, statusMessage, headers);
        return this.newWebResponseInstance(responseData, loadTime, request);
    }

    protected DownloadedContent downloadResponseBody(HttpResponse httpResponse) throws IOException {
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity == null) {
            return new DownloadedContent.InMemory(new byte[0]);
        }
        return HttpWebConnection.downloadContent(httpEntity.getContent(), this.webClient_.getOptions().getMaxInMemory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DownloadedContent downloadContent(InputStream is, int maxInMemory) {
        if (is == null) {
            return new DownloadedContent.InMemory(new byte[0]);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int nbRead;
            while ((nbRead = is.read(buffer)) != -1) {
                bos.write(buffer, 0, nbRead);
                if (bos.size() <= maxInMemory) continue;
                File file = File.createTempFile("htmlunit", ".tmp");
                file.deleteOnExit();
                try (FileOutputStream fos = new FileOutputStream(file);){
                    bos.writeTo(fos);
                    IOUtils.copyLarge((InputStream)is, (OutputStream)fos);
                }
                DownloadedContent.OnFile onFile = new DownloadedContent.OnFile(file, true);
                return onFile;
            }
        }
        catch (ConnectionClosedException e) {
            LOG.warn((Object)"Connection was closed while reading from stream.", (Throwable)e);
            DownloadedContent.InMemory inMemory = new DownloadedContent.InMemory(bos.toByteArray());
            return inMemory;
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception while reading from stream.", (Throwable)e);
            DownloadedContent.InMemory inMemory = new DownloadedContent.InMemory(bos.toByteArray());
            return inMemory;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return new DownloadedContent.InMemory(bos.toByteArray());
    }

    protected WebResponse newWebResponseInstance(WebResponseData responseData, long loadTime, WebRequest request) {
        return new WebResponse(responseData, request, loadTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HttpRequestInterceptor> getHttpRequestInterceptors(WebRequest webRequest) {
        ArrayList<HttpRequestInterceptor> list = new ArrayList<HttpRequestInterceptor>();
        Map<String, String> requestHeaders = webRequest.getAdditionalHeaders();
        URL url = webRequest.getUrl();
        StringBuilder host = new StringBuilder(url.getHost());
        int port = url.getPort();
        if (port > 0 && port != url.getDefaultPort()) {
            host.append(':');
            host.append(Integer.toString(port));
        }
        String userAgent = this.webClient_.getBrowserVersion().getUserAgent();
        String[] headerNames = this.webClient_.getBrowserVersion().getHeaderNamesOrdered();
        if (headerNames != null) {
            for (String header : headerNames) {
                if ("Host".equals(header)) {
                    list.add(new HostHeaderHttpRequestInterceptor(host.toString()));
                    continue;
                }
                if ("User-Agent".equals(header)) {
                    list.add(new UserAgentHeaderHttpRequestInterceptor(userAgent));
                    continue;
                }
                if ("Accept".equals(header) && requestHeaders.get(header) != null) {
                    list.add(new AcceptHeaderHttpRequestInterceptor(requestHeaders.get(header)));
                    continue;
                }
                if ("Accept-Language".equals(header) && requestHeaders.get(header) != null) {
                    list.add(new AcceptLanguageHeaderHttpRequestInterceptor(requestHeaders.get(header)));
                    continue;
                }
                if ("Accept-Encoding".equals(header) && requestHeaders.get(header) != null) {
                    list.add(new AcceptEncodingHeaderHttpRequestInterceptor(requestHeaders.get(header)));
                    continue;
                }
                if ("Referer".equals(header) && requestHeaders.get(header) != null) {
                    list.add(new RefererHeaderHttpRequestInterceptor(requestHeaders.get(header)));
                    continue;
                }
                if ("Connection".equals(header)) {
                    list.add((HttpRequestInterceptor)new RequestClientConnControl());
                    continue;
                }
                if ("Cookie".equals(header)) {
                    list.add((HttpRequestInterceptor)new RequestAddCookies());
                    continue;
                }
                if (!"DNT".equals(header) || !this.webClient_.getOptions().isDoNotTrackEnabled()) continue;
                list.add(new DntHeaderHttpRequestInterceptor("1"));
            }
        } else {
            list.add(new UserAgentHeaderHttpRequestInterceptor(userAgent));
            list.add((HttpRequestInterceptor)new RequestAddCookies());
            list.add((HttpRequestInterceptor)new RequestClientConnControl());
        }
        if (this.webClient_.getOptions().isDoNotTrackEnabled()) {
            list.add(new DntHeaderHttpRequestInterceptor("1"));
        }
        Map<String, String> map = requestHeaders;
        synchronized (map) {
            list.add(new MultiHttpRequestInterceptor(new HashMap<String, String>(requestHeaders)));
        }
        return list;
    }

    @Override
    public void close() {
        if (this.httpClientBuilder_.get() != null) {
            this.httpClientBuilder_.set(null);
        }
        if (this.connectionManager_ != null) {
            this.connectionManager_.shutdown();
            this.connectionManager_ = null;
        }
    }

    private static PoolingHttpClientConnectionManager createConnectionManager(HttpClientBuilder builder) {
        SocksConnectionSocketFactory socketFactory = new SocksConnectionSocketFactory();
        try {
            String s;
            HttpRequestExecutor requestExec;
            PublicSuffixMatcher publicSuffixMatcher = (PublicSuffixMatcher)HttpWebConnection.getField(builder, "publicSuffixMatcher");
            if (publicSuffixMatcher == null) {
                publicSuffixMatcher = PublicSuffixMatcherLoader.getDefault();
            }
            if ((requestExec = (HttpRequestExecutor)HttpWebConnection.getField(builder, "requestExec")) == null) {
                requestExec = new HttpRequestExecutor();
            }
            LayeredConnectionSocketFactory sslSocketFactory = (LayeredConnectionSocketFactory)HttpWebConnection.getField(builder, "sslSocketFactory");
            SocketConfig defaultSocketConfig = (SocketConfig)HttpWebConnection.getField(builder, "defaultSocketConfig");
            ConnectionConfig defaultConnectionConfig = (ConnectionConfig)HttpWebConnection.getField(builder, "defaultConnectionConfig");
            boolean systemProperties = (Boolean)HttpWebConnection.getField(builder, "systemProperties");
            int maxConnTotal = (Integer)HttpWebConnection.getField(builder, "maxConnTotal");
            int maxConnPerRoute = (Integer)HttpWebConnection.getField(builder, "maxConnPerRoute");
            HostnameVerifier hostnameVerifier = (HostnameVerifier)HttpWebConnection.getField(builder, "hostnameVerifier");
            SSLContext sslcontext = (SSLContext)HttpWebConnection.getField(builder, "sslContext");
            DnsResolver dnsResolver = (DnsResolver)HttpWebConnection.getField(builder, "dnsResolver");
            long connTimeToLive = (Long)HttpWebConnection.getField(builder, "connTimeToLive");
            TimeUnit connTimeToLiveTimeUnit = (TimeUnit)((Object)HttpWebConnection.getField(builder, "connTimeToLiveTimeUnit"));
            if (sslSocketFactory == null) {
                String[] supportedCipherSuites;
                String[] supportedProtocols = systemProperties ? HttpWebConnection.split(System.getProperty("https.protocols")) : null;
                String[] stringArray = supportedCipherSuites = systemProperties ? HttpWebConnection.split(System.getProperty("https.cipherSuites")) : null;
                if (hostnameVerifier == null) {
                    hostnameVerifier = new DefaultHostnameVerifier(publicSuffixMatcher);
                }
                sslSocketFactory = sslcontext != null ? new SSLConnectionSocketFactory(sslcontext, supportedProtocols, supportedCipherSuites, hostnameVerifier) : (systemProperties ? new SSLConnectionSocketFactory((SSLSocketFactory)SSLSocketFactory.getDefault(), supportedProtocols, supportedCipherSuites, hostnameVerifier) : new SSLConnectionSocketFactory(SSLContexts.createDefault(), hostnameVerifier));
            }
            PoolingHttpClientConnectionManager poolingmgr = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)socketFactory).register("https", (Object)sslSocketFactory).build(), null, null, dnsResolver, connTimeToLive, connTimeToLiveTimeUnit != null ? connTimeToLiveTimeUnit : TimeUnit.MILLISECONDS);
            if (defaultSocketConfig != null) {
                poolingmgr.setDefaultSocketConfig(defaultSocketConfig);
            }
            if (defaultConnectionConfig != null) {
                poolingmgr.setDefaultConnectionConfig(defaultConnectionConfig);
            }
            if (systemProperties && "true".equalsIgnoreCase(s = System.getProperty("http.keepAlive", "true"))) {
                s = System.getProperty("http.maxConnections", "5");
                int max = Integer.parseInt(s);
                poolingmgr.setDefaultMaxPerRoute(max);
                poolingmgr.setMaxTotal(2 * max);
            }
            if (maxConnTotal > 0) {
                poolingmgr.setMaxTotal(maxConnTotal);
            }
            if (maxConnPerRoute > 0) {
                poolingmgr.setDefaultMaxPerRoute(maxConnPerRoute);
            }
            return poolingmgr;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static String[] split(String s) {
        if (TextUtils.isBlank((CharSequence)s)) {
            return null;
        }
        return s.split(" *, *");
    }

    private static <T> T getField(Object target, String fieldName) throws IllegalAccessException {
        return (T)FieldUtils.readDeclaredField((Object)target, (String)fieldName, (boolean)true);
    }

    private static class MultiHttpRequestInterceptor
    implements HttpRequestInterceptor {
        private final Map<String, String> map_;

        MultiHttpRequestInterceptor(Map<String, String> map) {
            this.map_ = map;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            for (String key : this.map_.keySet()) {
                request.setHeader(key, this.map_.get(key));
            }
        }
    }

    private static final class DntHeaderHttpRequestInterceptor
    implements HttpRequestInterceptor {
        private String value_;

        DntHeaderHttpRequestInterceptor(String value) {
            this.value_ = value;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            request.setHeader("DNT", this.value_);
        }
    }

    private static final class RefererHeaderHttpRequestInterceptor
    implements HttpRequestInterceptor {
        private String value_;

        RefererHeaderHttpRequestInterceptor(String value) {
            this.value_ = value;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            request.setHeader("Referer", this.value_);
        }
    }

    private static final class AcceptEncodingHeaderHttpRequestInterceptor
    implements HttpRequestInterceptor {
        private String value_;

        AcceptEncodingHeaderHttpRequestInterceptor(String value) {
            this.value_ = value;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            request.setHeader("Accept-Encoding", this.value_);
        }
    }

    private static final class AcceptLanguageHeaderHttpRequestInterceptor
    implements HttpRequestInterceptor {
        private String value_;

        AcceptLanguageHeaderHttpRequestInterceptor(String value) {
            this.value_ = value;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            request.setHeader("Accept-Language", this.value_);
        }
    }

    private static final class AcceptHeaderHttpRequestInterceptor
    implements HttpRequestInterceptor {
        private String value_;

        AcceptHeaderHttpRequestInterceptor(String value) {
            this.value_ = value;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            request.setHeader("Accept", this.value_);
        }
    }

    private static final class UserAgentHeaderHttpRequestInterceptor
    implements HttpRequestInterceptor {
        private String value_;

        UserAgentHeaderHttpRequestInterceptor(String value) {
            this.value_ = value;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            request.setHeader("User-Agent", this.value_);
        }
    }

    private static final class HostHeaderHttpRequestInterceptor
    implements HttpRequestInterceptor {
        private String value_;

        HostHeaderHttpRequestInterceptor(String value) {
            this.value_ = value;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            request.setHeader("Host", this.value_);
        }
    }
}

