/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.impl.SelectionDelegate;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

class DoTypeProcessor
implements Serializable,
ClipboardOwner {
    private static Map<Integer, Character> SPECIAL_KEYS_MAP_ = new HashMap<Integer, Character>();
    private DomNode domNode_;

    DoTypeProcessor(DomNode domNode) {
        this.domNode_ = domNode;
    }

    void doType(String currentValue, SelectionDelegate selectionDelegate, char c, boolean shiftKey, boolean ctrlKey, boolean altKey) {
        int selectionStart = selectionDelegate.getSelectionStart();
        int selectionEnd = selectionDelegate.getSelectionEnd();
        StringBuilder newValue = new StringBuilder(currentValue);
        if (c == '\b') {
            if (selectionStart > 0) {
                newValue.deleteCharAt(selectionStart - 1);
                --selectionStart;
                --selectionEnd;
            }
        } else if (this.acceptChar(c)) {
            if (ctrlKey && (c == 'C' || c == 'c')) {
                String content = newValue.substring(selectionStart, selectionEnd);
                this.setClipboardContent(content);
            } else if (ctrlKey && (c == 'V' || c == 'v')) {
                String content = DoTypeProcessor.getClipboardContent();
                DoTypeProcessor.add(newValue, content, selectionStart, selectionEnd);
                selectionEnd = selectionStart += content.length();
            } else if (ctrlKey && (c == 'X' || c == 'x')) {
                String content = newValue.substring(selectionStart, selectionEnd);
                this.setClipboardContent(content);
                newValue.delete(selectionStart, selectionEnd);
                selectionEnd = selectionStart;
            } else {
                DoTypeProcessor.add(newValue, c, selectionStart, selectionEnd);
                selectionEnd = ++selectionStart;
            }
        }
        this.typeDone(newValue.toString());
        selectionDelegate.setSelectionStart(selectionStart);
        selectionDelegate.setSelectionEnd(selectionEnd);
    }

    private static void add(StringBuilder newValue, char c, int selectionStart, int selectionEnd) {
        if (selectionStart != newValue.length()) {
            newValue.replace(selectionStart, selectionEnd, Character.toString(c));
        } else {
            newValue.append(c);
        }
    }

    private static void add(StringBuilder newValue, String string, int selectionStart, int selectionEnd) {
        if (selectionStart != newValue.length()) {
            newValue.replace(selectionStart, selectionEnd, string);
        } else {
            newValue.append(string);
        }
    }

    private static String getClipboardContent() {
        String result = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(null);
        if (contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                result = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException | IOException exception) {
                // empty catch block
            }
        }
        return result;
    }

    private void setClipboardContent(String string) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, this);
    }

    private void typeDone(String newValue) {
        if (this.domNode_ instanceof DomText) {
            ((DomText)this.domNode_).setData(newValue);
        } else {
            ((HtmlElement)this.domNode_).typeDone(newValue);
        }
    }

    private boolean acceptChar(char ch) {
        if (this.domNode_ instanceof DomText) {
            return ((DomText)this.domNode_).acceptChar(ch);
        }
        return ((HtmlElement)this.domNode_).acceptChar(ch);
    }

    void doType(String currentValue, SelectionDelegate selectionDelegate, int keyCode, boolean shiftKey, boolean ctrlKey, boolean altKey) {
        StringBuilder newValue = new StringBuilder(currentValue);
        int selectionStart = selectionDelegate.getSelectionStart();
        int selectionEnd = selectionDelegate.getSelectionEnd();
        Character ch = SPECIAL_KEYS_MAP_.get(keyCode);
        if (ch != null) {
            this.doType(currentValue, selectionDelegate, ch.charValue(), shiftKey, ctrlKey, altKey);
            return;
        }
        switch (keyCode) {
            case 8: {
                if (selectionStart <= 0) break;
                newValue.deleteCharAt(selectionStart - 1);
                --selectionStart;
                break;
            }
            case 37: {
                if (selectionStart <= 0) break;
                --selectionStart;
                break;
            }
            case 39: {
                if (shiftKey) {
                    ++selectionEnd;
                    break;
                }
                if (selectionStart <= 0) break;
                ++selectionStart;
                break;
            }
            case 36: {
                selectionStart = 0;
                break;
            }
            case 35: {
                if (shiftKey) {
                    selectionEnd = newValue.length();
                    break;
                }
                selectionStart = newValue.length();
                break;
            }
            case 46: {
                if (selectionEnd == selectionStart) {
                    ++selectionEnd;
                }
                newValue.delete(selectionStart, selectionEnd);
                selectionEnd = selectionStart;
                break;
            }
            default: {
                return;
            }
        }
        if (!shiftKey) {
            selectionEnd = selectionStart;
        }
        this.typeDone(newValue.toString());
        selectionDelegate.setSelectionStart(selectionStart);
        selectionDelegate.setSelectionEnd(selectionEnd);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    static {
        SPECIAL_KEYS_MAP_.put(107, Character.valueOf('+'));
        SPECIAL_KEYS_MAP_.put(110, Character.valueOf('.'));
        SPECIAL_KEYS_MAP_.put(111, Character.valueOf('/'));
        SPECIAL_KEYS_MAP_.put(61, Character.valueOf('='));
        SPECIAL_KEYS_MAP_.put(106, Character.valueOf('*'));
        SPECIAL_KEYS_MAP_.put(59, Character.valueOf(';'));
        SPECIAL_KEYS_MAP_.put(108, Character.valueOf(','));
        SPECIAL_KEYS_MAP_.put(32, Character.valueOf(' '));
        SPECIAL_KEYS_MAP_.put(109, Character.valueOf('-'));
        for (int i = 96; i <= 105; ++i) {
            SPECIAL_KEYS_MAP_.put(i, Character.valueOf((char)(48 + (i - 96))));
        }
    }
}

