/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.InteractivePage;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlPasswordInput;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import com.gargoylesoftware.htmlunit.html.Keyboard;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventHandler;
import com.gargoylesoftware.htmlunit.javascript.host.event.KeyboardEvent;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public abstract class HtmlElement
extends DomElement {
    private static final Log LOG = LogFactory.getLog(HtmlElement.class);
    public static final Short TAB_INDEX_OUT_OF_BOUNDS = new Short(Short.MIN_VALUE);
    private final Collection<HtmlAttributeChangeListener> attributeListeners_ = new LinkedHashSet<HtmlAttributeChangeListener>();
    private HtmlForm owningForm_;

    protected HtmlElement(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super("http://www.w3.org/1999/xhtml", qualifiedName, page, attributes);
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue) {
        boolean mappedElement;
        if (null == this.getHtmlPageOrNull()) {
            super.setAttributeNS(namespaceURI, qualifiedName, attributeValue);
            return;
        }
        String oldAttributeValue = this.getAttribute(qualifiedName);
        HtmlPage htmlPage = (HtmlPage)this.getPage();
        boolean bl = mappedElement = this.isAttachedToPage() && HtmlPage.isMappedElement(htmlPage, qualifiedName);
        if (mappedElement) {
            htmlPage.removeMappedElement(this);
        }
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue);
        if (mappedElement) {
            htmlPage.addMappedElement(this);
        }
        if (oldAttributeValue == ATTRIBUTE_NOT_DEFINED) {
            HtmlAttributeChangeEvent htmlEvent = new HtmlAttributeChangeEvent(this, qualifiedName, attributeValue);
            this.fireHtmlAttributeAdded(htmlEvent);
            htmlPage.fireHtmlAttributeAdded(htmlEvent);
        } else {
            HtmlAttributeChangeEvent htmlEvent = new HtmlAttributeChangeEvent(this, qualifiedName, oldAttributeValue);
            this.fireHtmlAttributeReplaced(htmlEvent);
            htmlPage.fireHtmlAttributeReplaced(htmlEvent);
        }
    }

    @Override
    public Attr setAttributeNode(Attr attribute) {
        boolean mappedElement;
        String qualifiedName = attribute.getName();
        String oldAttributeValue = this.getAttribute(qualifiedName);
        HtmlPage htmlPage = (HtmlPage)this.getPage();
        boolean bl = mappedElement = this.isAttachedToPage() && HtmlPage.isMappedElement(htmlPage, qualifiedName);
        if (mappedElement) {
            htmlPage.removeMappedElement(this);
        }
        Attr result = super.setAttributeNode(attribute);
        if (mappedElement) {
            htmlPage.addMappedElement(this);
        }
        if (oldAttributeValue == ATTRIBUTE_NOT_DEFINED) {
            HtmlAttributeChangeEvent htmlEvent = new HtmlAttributeChangeEvent(this, qualifiedName, attribute.getValue());
            this.fireHtmlAttributeAdded(htmlEvent);
            htmlPage.fireHtmlAttributeAdded(htmlEvent);
        } else {
            HtmlAttributeChangeEvent htmlEvent = new HtmlAttributeChangeEvent(this, qualifiedName, oldAttributeValue);
            this.fireHtmlAttributeReplaced(htmlEvent);
            htmlPage.fireHtmlAttributeReplaced(htmlEvent);
        }
        return result;
    }

    @Deprecated
    public final List<HtmlElement> getHtmlElementsByTagNames(List<String> tagNames) {
        ArrayList<HtmlElement> list = new ArrayList<HtmlElement>();
        for (String tagName : tagNames) {
            list.addAll((Collection<HtmlElement>)((Object)this.getElementsByTagName(tagName)));
        }
        return list;
    }

    @Deprecated
    public final <E extends HtmlElement> List<E> getHtmlElementsByTagName(String tagName) {
        return new ArrayList(this.getElementsByTagNameImpl(tagName));
    }

    @Override
    public final void removeAttribute(String attributeName) {
        String value = this.getAttribute(attributeName);
        if (value == ATTRIBUTE_NOT_DEFINED) {
            return;
        }
        HtmlPage htmlPage = this.getHtmlPageOrNull();
        if (htmlPage != null) {
            htmlPage.removeMappedElement(this);
        }
        super.removeAttribute(attributeName.toLowerCase(Locale.ROOT));
        if (htmlPage != null) {
            htmlPage.addMappedElement(this);
            HtmlAttributeChangeEvent event = new HtmlAttributeChangeEvent(this, attributeName, value);
            this.fireHtmlAttributeRemoved(event);
            htmlPage.fireHtmlAttributeRemoved(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireHtmlAttributeAdded(HtmlAttributeChangeEvent event) {
        Collection<HtmlAttributeChangeListener> collection = this.attributeListeners_;
        synchronized (collection) {
            for (HtmlAttributeChangeListener listener : this.attributeListeners_) {
                listener.attributeAdded(event);
            }
        }
        DomNode parentNode = this.getParentNode();
        if (parentNode instanceof HtmlElement) {
            ((HtmlElement)parentNode).fireHtmlAttributeAdded(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireHtmlAttributeReplaced(HtmlAttributeChangeEvent event) {
        Collection<HtmlAttributeChangeListener> collection = this.attributeListeners_;
        synchronized (collection) {
            for (HtmlAttributeChangeListener listener : this.attributeListeners_) {
                listener.attributeReplaced(event);
            }
        }
        DomNode parentNode = this.getParentNode();
        if (parentNode instanceof HtmlElement) {
            ((HtmlElement)parentNode).fireHtmlAttributeReplaced(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireHtmlAttributeRemoved(HtmlAttributeChangeEvent event) {
        Collection<HtmlAttributeChangeListener> collection = this.attributeListeners_;
        synchronized (collection) {
            for (HtmlAttributeChangeListener listener : this.attributeListeners_) {
                listener.attributeRemoved(event);
            }
        }
        DomNode parentNode = this.getParentNode();
        if (parentNode instanceof HtmlElement) {
            ((HtmlElement)parentNode).fireHtmlAttributeRemoved(event);
        }
    }

    @Override
    public String getNodeName() {
        String prefix = this.getPrefix();
        if (prefix != null) {
            StringBuilder name = new StringBuilder(prefix.toLowerCase(Locale.ROOT));
            name.append(':');
            name.append(this.getLocalName().toLowerCase(Locale.ROOT));
            return name.toString();
        }
        return this.getLocalName().toLowerCase(Locale.ROOT);
    }

    public final void setId(String newId) {
        this.setAttribute("id", newId);
    }

    public Short getTabIndex() {
        String index = this.getAttribute("tabindex");
        if (index == null || index.isEmpty()) {
            return null;
        }
        try {
            long l = Long.parseLong(index);
            if (l >= 0L && l <= 32767L) {
                return (short)l;
            }
            return TAB_INDEX_OUT_OF_BOUNDS;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public HtmlElement getEnclosingElement(String tagName) {
        String tagNameLC = tagName.toLowerCase(Locale.ROOT);
        for (DomNode currentNode = this.getParentNode(); currentNode != null; currentNode = currentNode.getParentNode()) {
            if (!(currentNode instanceof HtmlElement) || !currentNode.getNodeName().equals(tagNameLC)) continue;
            return (HtmlElement)currentNode;
        }
        return null;
    }

    public HtmlForm getEnclosingForm() {
        if (this.owningForm_ != null) {
            return this.owningForm_;
        }
        return (HtmlForm)this.getEnclosingElement("form");
    }

    public HtmlForm getEnclosingFormOrDie() throws IllegalStateException {
        HtmlForm form = this.getEnclosingForm();
        if (form == null) {
            throw new IllegalStateException("Element is not contained within a form: " + this);
        }
        return form;
    }

    public void type(String text) throws IOException {
        for (char ch : text.toCharArray()) {
            this.type(ch);
        }
    }

    @Deprecated
    public void type(String text, boolean shiftKey, boolean ctrlKey, boolean altKey) throws IOException {
        for (char ch : text.toCharArray()) {
            this.type(ch, shiftKey, ctrlKey, altKey);
        }
    }

    public Page type(char c) throws IOException {
        return this.type(c, false, false, false);
    }

    @Deprecated
    public Page type(char c, boolean shiftKey, boolean ctrlKey, boolean altKey) throws IOException {
        HtmlForm form;
        ScriptResult shiftDownResult;
        KeyboardEvent shiftDown;
        boolean isShiftNeeded;
        if (this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return this.getPage();
        }
        this.getPage().getWebClient().setCurrentWindow(this.getPage().getEnclosingWindow());
        HtmlPage page = (HtmlPage)this.getPage();
        if (page.getFocusedElement() != this) {
            this.focus();
        }
        if (isShiftNeeded = KeyboardEvent.isShiftNeeded(c, shiftKey)) {
            shiftDown = new KeyboardEvent((DomNode)this, "keydown", 16, true, ctrlKey, altKey);
            shiftDownResult = this.fireEvent(shiftDown);
        } else {
            shiftDown = null;
            shiftDownResult = null;
        }
        KeyboardEvent keyDown = new KeyboardEvent((DomNode)this, "keydown", c, shiftKey, ctrlKey, altKey);
        ScriptResult keyDownResult = this.fireEvent(keyDown);
        KeyboardEvent keyPress = new KeyboardEvent((DomNode)this, "keypress", c, shiftKey, ctrlKey, altKey);
        ScriptResult keyPressResult = this.fireEvent(keyPress);
        if (!(shiftDownResult != null && shiftDown.isAborted(shiftDownResult) || keyDown.isAborted(keyDownResult) || keyPress.isAborted(keyPressResult))) {
            this.doType(c, shiftKey, ctrlKey, altKey);
        }
        WebClient webClient = page.getWebClient();
        if (this instanceof HtmlTextInput || this instanceof HtmlTextArea || this instanceof HtmlPasswordInput) {
            KeyboardEvent input = new KeyboardEvent((DomNode)this, "input", c, shiftKey, ctrlKey, altKey);
            this.fireEvent(input);
        }
        KeyboardEvent keyUp = new KeyboardEvent((DomNode)this, "keyup", c, shiftKey, ctrlKey, altKey);
        this.fireEvent(keyUp);
        if (isShiftNeeded) {
            KeyboardEvent shiftUp = new KeyboardEvent((DomNode)this, "keyup", 16, false, ctrlKey, altKey);
            this.fireEvent(shiftUp);
        }
        if ((form = this.getEnclosingForm()) != null && c == '\n' && this.isSubmittableByEnter()) {
            HtmlSubmitInput submit = (HtmlSubmitInput)form.getFirstByXPath(".//input[@type='submit']");
            if (submit != null) {
                return submit.click();
            }
            form.submit((SubmittableElement)((Object)this));
            webClient.getJavaScriptEngine().processPostponedActions();
        }
        return webClient.getCurrentWindow().getEnclosedPage();
    }

    public Page type(int keyCode) {
        return this.type(keyCode, false, false, false, true, true, true);
    }

    public Page type(Keyboard keyboard) throws IOException {
        Page page = null;
        boolean shiftPressed = false;
        boolean ctrlPressed = false;
        boolean altPressed = false;
        ArrayList<Integer> specialKeys = null;
        List<Object[]> keys = keyboard.getKeys();
        for (Object[] entry : keys) {
            if (entry.length == 1) {
                this.type(((Character)entry[0]).charValue(), shiftPressed, ctrlPressed, altPressed);
                continue;
            }
            int key = (Integer)entry[0];
            boolean pressed = (Boolean)entry[1];
            switch (key) {
                case 16: {
                    shiftPressed = pressed;
                    break;
                }
                case 17: {
                    ctrlPressed = pressed;
                    break;
                }
                case 18: {
                    altPressed = pressed;
                    break;
                }
            }
            if (pressed) {
                boolean keyPress = true;
                boolean keyUp = true;
                switch (key) {
                    case 16: 
                    case 17: 
                    case 18: {
                        if (specialKeys == null) {
                            specialKeys = new ArrayList<Integer>(keys.size());
                        }
                        specialKeys.add(key);
                        keyPress = false;
                        keyUp = false;
                        break;
                    }
                }
                page = this.type(key, shiftPressed, ctrlPressed, altPressed, true, keyPress, keyUp);
                continue;
            }
            switch (key) {
                case 16: 
                case 17: 
                case 18: {
                    if (specialKeys == null) break;
                    Iterator it = specialKeys.iterator();
                    while (it.hasNext()) {
                        if ((Integer)it.next() != key) continue;
                        it.remove();
                    }
                    break;
                }
            }
            page = this.type(key, shiftPressed, ctrlPressed, altPressed, false, false, true);
        }
        if (specialKeys != null) {
            for (int i = specialKeys.size() - 1; i >= 0; --i) {
                int key = (Integer)specialKeys.get(i);
                switch (key) {
                    case 16: {
                        shiftPressed = false;
                        break;
                    }
                    case 17: {
                        ctrlPressed = false;
                        break;
                    }
                    case 18: {
                        altPressed = false;
                        break;
                    }
                }
                page = this.type(key, shiftPressed, ctrlPressed, altPressed, false, false, true);
            }
        }
        return page;
    }

    @Deprecated
    public Page type(int keyCode, boolean shiftKey, boolean ctrlKey, boolean altKey) {
        return this.type(keyCode, shiftKey, ctrlKey, altKey, true, true, true);
    }

    private Page type(int keyCode, boolean shiftKey, boolean ctrlKey, boolean altKey, boolean fireKeyDown, boolean fireKeyPress, boolean fireKeyUp) {
        ScriptResult keyPressResult;
        KeyboardEvent keyPress;
        ScriptResult keyDownResult;
        KeyboardEvent keyDown;
        if (this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return this.getPage();
        }
        HtmlPage page = (HtmlPage)this.getPage();
        if (page.getFocusedElement() != this) {
            this.focus();
        }
        if (fireKeyDown) {
            keyDown = new KeyboardEvent((DomNode)this, "keydown", keyCode, shiftKey, ctrlKey, altKey);
            keyDownResult = this.fireEvent(keyDown);
        } else {
            keyDown = null;
            keyDownResult = null;
        }
        BrowserVersion browserVersion = page.getWebClient().getBrowserVersion();
        if (fireKeyPress && browserVersion.hasFeature(BrowserVersionFeatures.KEYBOARD_EVENT_SPECIAL_KEYPRESS)) {
            keyPress = new KeyboardEvent((DomNode)this, "keypress", keyCode, shiftKey, ctrlKey, altKey);
            keyPressResult = this.fireEvent(keyPress);
        } else {
            keyPress = null;
            keyPressResult = null;
        }
        if (!(keyDown == null || keyDown.isAborted(keyDownResult) || keyPress != null && keyPress.isAborted(keyPressResult))) {
            this.doType(keyCode, shiftKey, ctrlKey, altKey);
        }
        if (this instanceof HtmlTextInput || this instanceof HtmlTextArea || this instanceof HtmlPasswordInput) {
            KeyboardEvent input = new KeyboardEvent((DomNode)this, "input", keyCode, shiftKey, ctrlKey, altKey);
            this.fireEvent(input);
        }
        if (fireKeyUp) {
            KeyboardEvent keyUp = new KeyboardEvent((DomNode)this, "keyup", keyCode, shiftKey, ctrlKey, altKey);
            this.fireEvent(keyUp);
        }
        return page.getWebClient().getCurrentWindow().getEnclosedPage();
    }

    protected void doType(char c, boolean shiftKey, boolean ctrlKey, boolean altKey) {
        DomNode domNode = this.getDoTypeNode();
        if (domNode instanceof DomText) {
            ((DomText)domNode).doType(c, shiftKey, ctrlKey, altKey);
        } else if (domNode instanceof HtmlElement) {
            try {
                ((HtmlElement)domNode).type(c, shiftKey, ctrlKey, altKey);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void doType(int keyCode, boolean shiftKey, boolean ctrlKey, boolean altKey) {
        DomNode domNode = this.getDoTypeNode();
        if (domNode instanceof DomText) {
            ((DomText)domNode).doType(keyCode, shiftKey, ctrlKey, altKey);
        } else if (domNode instanceof HtmlElement) {
            ((HtmlElement)domNode).type(keyCode, shiftKey, ctrlKey, altKey);
        }
    }

    private DomNode getDoTypeNode() {
        DomNode node = null;
        HTMLElement scriptElement = (HTMLElement)this.getScriptableObject();
        if (scriptElement.getIsContentEditable()) {
            NodeList children = this.getChildNodes();
            if (!children.isEmpty()) {
                DomNode lastChild = (DomNode)children.get(children.size() - 1);
                if (lastChild instanceof DomText) {
                    node = lastChild;
                } else if (lastChild instanceof HtmlElement) {
                    node = lastChild;
                }
            }
            if (node == null) {
                DomText domText = new DomText(this.getPage(), "");
                this.appendChild(domText);
                node = domText;
            }
        }
        return node;
    }

    protected void typeDone(String newValue) {
    }

    protected boolean acceptChar(char c) {
        return !(c >= '\ue000' && c <= '\uf8ff' || c != ' ' && Character.isWhitespace(c));
    }

    protected boolean isSubmittableByEnter() {
        return false;
    }

    public final <E extends HtmlElement> E getOneHtmlElementByAttribute(String elementName, String attributeName, String attributeValue) throws ElementNotFoundException {
        WebAssert.notNull("elementName", elementName);
        WebAssert.notNull("attributeName", attributeName);
        WebAssert.notNull("attributeValue", attributeValue);
        List<E> list = this.getElementsByAttribute(elementName, attributeName, attributeValue);
        int listSize = list.size();
        if (listSize == 0) {
            throw new ElementNotFoundException(elementName, attributeName, attributeValue);
        }
        return (E)((HtmlElement)list.get(0));
    }

    public final <E extends HtmlElement> List<E> getElementsByAttribute(String elementName, String attributeName, String attributeValue) {
        ArrayList<HtmlElement> list = new ArrayList<HtmlElement>();
        String lowerCaseTagName = elementName.toLowerCase(Locale.ROOT);
        for (HtmlElement next : this.getHtmlElementDescendants()) {
            String attValue;
            if (!next.getTagName().equals(lowerCaseTagName) || (attValue = next.getAttribute(attributeName)) == null || !attValue.equals(attributeValue)) continue;
            list.add(next);
        }
        return list;
    }

    public final HtmlElement appendChildIfNoneExists(String tagName) {
        HtmlElement child;
        NodeList children = this.getElementsByTagName(tagName);
        if (children.isEmpty()) {
            child = (HtmlElement)((HtmlPage)this.getPage()).createElement(tagName);
            this.appendChild(child);
        } else {
            child = (HtmlElement)children.get(0);
        }
        return child;
    }

    public final void removeChild(String tagName, int i) {
        NodeList children = this.getElementsByTagName(tagName);
        if (i >= 0 && i < children.size()) {
            ((HtmlElement)children.get(i)).remove();
        }
    }

    public final boolean hasEventHandlers(String eventName) {
        HTMLElement jsObj = (HTMLElement)this.getScriptableObject();
        return jsObj.hasEventHandlers(eventName);
    }

    public final void setEventHandler(String eventName, Function eventHandler) {
        HTMLElement jsObj = (HTMLElement)this.getScriptableObject();
        jsObj.setEventHandler(eventName, eventHandler);
    }

    public final void setEventHandler(String eventName, String jsSnippet) {
        EventHandler function = new EventHandler(this, eventName, jsSnippet);
        this.setEventHandler(eventName, (Function)function);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created event handler " + function.getFunctionName() + " for " + eventName + " on " + this));
        }
    }

    public final void removeEventHandler(String eventName) {
        this.setEventHandler(eventName, (Function)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHtmlAttributeChangeListener(HtmlAttributeChangeListener listener) {
        WebAssert.notNull("listener", listener);
        Collection<HtmlAttributeChangeListener> collection = this.attributeListeners_;
        synchronized (collection) {
            this.attributeListeners_.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHtmlAttributeChangeListener(HtmlAttributeChangeListener listener) {
        WebAssert.notNull("listener", listener);
        Collection<HtmlAttributeChangeListener> collection = this.attributeListeners_;
        synchronized (collection) {
            this.attributeListeners_.remove(listener);
        }
    }

    @Override
    protected void checkChildHierarchy(Node childNode) throws DOMException {
        if (!(childNode instanceof Element || childNode instanceof Text || childNode instanceof Comment || childNode instanceof ProcessingInstruction || childNode instanceof CDATASection || childNode instanceof EntityReference)) {
            throw new DOMException(3, "The Element may not have a child of this type: " + childNode.getNodeType());
        }
        super.checkChildHierarchy(childNode);
    }

    void setOwningForm(HtmlForm form) {
        this.owningForm_ = form;
    }

    @Override
    protected boolean isAttributeCaseSensitive() {
        return false;
    }

    public final String getLangAttribute() {
        return this.getAttribute("lang");
    }

    public final String getXmlLangAttribute() {
        return this.getAttribute("xml:lang");
    }

    public final String getTextDirectionAttribute() {
        return this.getAttribute("dir");
    }

    public final String getOnClickAttribute() {
        return this.getAttribute("onclick");
    }

    public final String getOnDblClickAttribute() {
        return this.getAttribute("ondblclick");
    }

    public final String getOnMouseDownAttribute() {
        return this.getAttribute("onmousedown");
    }

    public final String getOnMouseUpAttribute() {
        return this.getAttribute("onmouseup");
    }

    public final String getOnMouseOverAttribute() {
        return this.getAttribute("onmouseover");
    }

    public final String getOnMouseMoveAttribute() {
        return this.getAttribute("onmousemove");
    }

    public final String getOnMouseOutAttribute() {
        return this.getAttribute("onmouseout");
    }

    public final String getOnKeyPressAttribute() {
        return this.getAttribute("onkeypress");
    }

    public final String getOnKeyDownAttribute() {
        return this.getAttribute("onkeydown");
    }

    public final String getOnKeyUpAttribute() {
        return this.getAttribute("onkeyup");
    }

    @Override
    public String getCanonicalXPath() {
        DomNode parent = this.getParentNode();
        if (parent.getNodeType() == 9) {
            return "/" + this.getNodeName();
        }
        return parent.getCanonicalXPath() + '/' + this.getXPathToken();
    }

    private String getXPathToken() {
        DomNode parent = this.getParentNode();
        int total = 0;
        int nodeIndex = 0;
        for (DomNode child : parent.getChildren()) {
            if (child.getNodeType() == 1 && child.getNodeName().equals(this.getNodeName())) {
                ++total;
            }
            if (child != this) continue;
            nodeIndex = total;
        }
        if (nodeIndex == 1 && total == 1) {
            return this.getNodeName();
        }
        return this.getNodeName() + '[' + nodeIndex + ']';
    }

    @Override
    public boolean isDisplayed() {
        if (ATTRIBUTE_NOT_DEFINED != this.getAttribute("hidden")) {
            return false;
        }
        return super.isDisplayed();
    }

    public DisplayStyle getDefaultStyleDisplay() {
        return DisplayStyle.BLOCK;
    }

    protected final String getSrcAttributeNormalized() {
        String attrib = this.getAttribute("src");
        if (ATTRIBUTE_NOT_DEFINED == attrib) {
            return attrib;
        }
        return StringUtils.replaceChars((String)attrib, (String)"\r\n", (String)"");
    }

    @Override
    protected void detach() {
        HTMLDocument doc = (HTMLDocument)this.getPage().getScriptableObject();
        HTMLElement activeElement = doc.getActiveElement();
        if (activeElement == this.getScriptableObject()) {
            doc.setActiveElement(null);
            if (this.hasFeature(BrowserVersionFeatures.HTMLELEMENT_REMOVE_ACTIVE_TRIGGERS_BLUR_EVENT)) {
                ((InteractivePage)this.getPage()).setFocusedElement(null);
            } else {
                ((InteractivePage)this.getPage()).setElementWithFocus(null);
            }
            super.detach();
            return;
        }
        Iterator i$ = this.getChildNodes().iterator();
        while (i$.hasNext()) {
            DomNode child = (DomNode)i$.next();
            if (activeElement != child.getScriptableObject()) continue;
            doc.setActiveElement(null);
            if (this.hasFeature(BrowserVersionFeatures.HTMLELEMENT_REMOVE_ACTIVE_TRIGGERS_BLUR_EVENT)) {
                ((InteractivePage)this.getPage()).setFocusedElement(null);
            } else {
                ((InteractivePage)this.getPage()).setElementWithFocus(null);
            }
            super.detach();
            return;
        }
        super.detach();
    }

    @Override
    public boolean handles(Event event) {
        if ("blur".equals(event.getType()) || "focus".equals(event.getType())) {
            return this instanceof SubmittableElement;
        }
        if (this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return false;
        }
        return super.handles(event);
    }

    public static enum DisplayStyle {
        EMPTY(""),
        NONE("none"),
        BLOCK("block"),
        INLINE("inline"),
        INLINE_BLOCK("inline-block"),
        LIST_ITEM("list-item"),
        TABLE("table"),
        TABLE_CELL("table-cell"),
        TABLE_COLUMN("table-column"),
        TABLE_COLUMN_GROUP("table-column-group"),
        TABLE_ROW("table-row"),
        TABLE_ROW_GROUP("table-row-group"),
        TABLE_HEADER_GROUP("table-header-group"),
        TABLE_FOOTER_GROUP("table-footer-group"),
        TABLE_CAPTION("table-caption"),
        RUBY("ruby"),
        RUBY_TEXT("ruby-text");

        private final String value_;

        private DisplayStyle(String value) {
            this.value_ = value;
        }

        public String value() {
            return this.value_;
        }
    }
}

