/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSS2Properties;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSPrimitiveValue;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSValue;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.SelectorSpecificity;
import com.gargoylesoftware.htmlunit.javascript.host.css.StyleAttributes;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCanvasElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLHtmlElement;
import com.steadystate.css.dom.CSSValueImpl;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.SACParserCSS3;
import java.awt.Color;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;

@JsxClass
public class CSSStyleDeclaration
extends SimpleScriptable
implements ScriptableWithFallbackGetter {
    protected static final String PRIORITY_IMPORTANT = "important";
    private static final String BACKGROUND = "background";
    private static final String BACKGROUND_ATTACHMENT = "background-attachment";
    private static final String BACKGROUND_COLOR = "background-color";
    private static final String BACKGROUND_IMAGE = "background-image";
    private static final String BACKGROUND_POSITION = "background-position";
    private static final String BACKGROUND_REPEAT = "background-repeat";
    private static final String BEHAVIOR = "behavior";
    private static final String BORDER = "border";
    private static final String BORDER_BOTTOM = "border-bottom";
    private static final String BORDER_BOTTOM_COLOR = "border-bottom-color";
    private static final String BORDER_BOTTOM_STYLE = "border-bottom-style";
    private static final String BORDER_BOTTOM_WIDTH = "border-bottom-width";
    private static final String BORDER_LEFT = "border-left";
    private static final String BORDER_LEFT_COLOR = "border-left-color";
    private static final String BORDER_LEFT_STYLE = "border-left-style";
    private static final String BORDER_WIDTH = "border-width";
    private static final String BORDER_LEFT_WIDTH = "border-left-width";
    private static final String BORDER_RIGHT = "border-right";
    private static final String BORDER_RIGHT_COLOR = "border-right-color";
    private static final String BORDER_RIGHT_STYLE = "border-right-style";
    private static final String BORDER_RIGHT_WIDTH = "border-right-width";
    private static final String BORDER_TOP = "border-top";
    private static final String BORDER_TOP_COLOR = "border-top-color";
    private static final String BORDER_TOP_STYLE = "border-top-style";
    private static final String BORDER_TOP_WIDTH = "border-top-width";
    private static final String BOTTOM = "bottom";
    private static final String COLOR = "color";
    private static final String DISPLAY = "display";
    private static final String FONT_SIZE = "font-size";
    private static final String HEIGHT = "height";
    private static final String LEFT = "left";
    private static final String LETTER_SPACING = "letter-spacing";
    private static final String MARGIN_BOTTOM = "margin-bottom";
    private static final String MARGIN_LEFT = "margin-left";
    private static final String MARGIN_RIGHT = "margin-right";
    private static final String MARGIN = "margin";
    private static final String MARGIN_TOP = "margin-top";
    private static final String MARKS = "marks";
    private static final String MAX_HEIGHT = "max-height";
    private static final String MAX_WIDTH = "max-width";
    private static final String MIN_HEIGHT = "min-height";
    private static final String MIN_WIDTH = "min-width";
    private static final String OPACITY = "opacity";
    private static final String OUTLINE = "outline";
    private static final String OUTLINE_WIDTH = "outline-width";
    private static final String PADDING_BOTTOM = "padding-bottom";
    private static final String PADDING_LEFT = "padding-left";
    private static final String PADDING_RIGHT = "padding-right";
    private static final String PADDING = "padding";
    private static final String PADDING_TOP = "padding-top";
    private static final String PAGE = "page";
    private static final String RIGHT = "right";
    private static final String RUBY_ALIGN = "ruby-align";
    private static final String SIZE = "size";
    private static final String TEXT_INDENT = "text-indent";
    private static final String TOP = "top";
    private static final String VERTICAL_ALIGN = "vertical-align";
    private static final String WORD_SPACING = "word-spacing";
    private static final String Z_INDEX = "z-index";
    protected static final String WIDTH = "width";
    private static final Pattern TO_INT_PATTERN = Pattern.compile("(\\d+).*");
    private static final Pattern URL_PATTERN = Pattern.compile("url\\(\\s*[\"']?(.*?)[\"']?\\s*\\)");
    private static final Pattern POSITION_PATTERN = Pattern.compile("(\\d+\\s*(%|px|cm|mm|in|pt|pc|em|ex))\\s*(\\d+\\s*(%|px|cm|mm|in|pt|pc|em|ex)|top|bottom|center)");
    private static final Pattern POSITION_PATTERN2 = Pattern.compile("(left|right|center)\\s*(\\d+\\s*(%|px|cm|mm|in|pt|pc|em|ex)|top|bottom|center)");
    private static final Pattern POSITION_PATTERN3 = Pattern.compile("(top|bottom|center)\\s*(\\d+\\s*(%|px|cm|mm|in|pt|pc|em|ex)|left|right|center)");
    private static final Log LOG = LogFactory.getLog(CSSStyleDeclaration.class);
    private static final Map<String, String> CSSColors_ = new HashMap<String, String>();
    private static final Map<String, String> CamelizeCache_ = Collections.synchronizedMap(new HashMap());
    private static final MessageFormat URL_FORMAT = new MessageFormat("url({0})");
    private Element jsElement_;
    private org.w3c.dom.css.CSSStyleDeclaration styleDeclaration_;
    private String styleString_ = new String();
    private Map<String, StyleElement> styleMap_;
    private long currentElementIndex_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public CSSStyleDeclaration() {
    }

    public CSSStyleDeclaration(Element element) {
        this.setParentScope(element.getParentScope());
        this.setPrototype(this.getPrototype(this.getClass()));
        this.initialize(element);
    }

    CSSStyleDeclaration(Scriptable parentScope, org.w3c.dom.css.CSSStyleDeclaration styleDeclaration) {
        this.setParentScope(parentScope);
        this.setPrototype(this.getPrototype(this.getClass()));
        this.styleDeclaration_ = styleDeclaration;
    }

    void initialize(Element element) {
        WebAssert.notNull("htmlElement", element);
        this.jsElement_ = element;
        this.setDomNode(element.getDomNodeOrNull(), false);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_SUPPORTS_BEHAVIOR_PROPERTY) && element instanceof HTMLElement) {
            HTMLElement htmlElement = (HTMLElement)element;
            String behavior = this.getStyleAttribute(BEHAVIOR);
            if (StringUtils.isNotBlank((CharSequence)behavior)) {
                try {
                    Object[] url = URL_FORMAT.parse(behavior);
                    if (url.length > 0) {
                        htmlElement.addBehavior((String)url[0]);
                    }
                }
                catch (ParseException e) {
                    LOG.warn((Object)("Invalid behavior: '" + behavior + "'."));
                }
            }
        }
    }

    @Override
    public Object getWithFallback(String name) {
        StyleElement element;
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_STYLE_UNSUPPORTED_PROPERTY_GETTER) && null != this.jsElement_ && (element = this.getStyleElement(name)) != null && element.getValue() != null) {
            return element.getValue();
        }
        return NOT_FOUND;
    }

    protected Element getElement() {
        return this.jsElement_;
    }

    protected String getStyleAttribute(String name) {
        if (this.styleDeclaration_ != null) {
            return this.styleDeclaration_.getPropertyValue(name);
        }
        StyleElement element = this.getStyleElement(name);
        if (element != null && element.getValue() != null) {
            String value = element.getValue();
            if (!value.contains("url") && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_STYLE_SET_PROPERTY_IMPORTANT_IGNORES_CASE)) {
                return value.toLowerCase(Locale.ROOT);
            }
            return value;
        }
        return "";
    }

    protected String getStylePriority(String name) {
        if (this.styleDeclaration_ != null) {
            return this.styleDeclaration_.getPropertyPriority(name);
        }
        StyleElement element = this.getStyleElement(name);
        if (element != null && element.getValue() != null) {
            return element.getPriority();
        }
        return "";
    }

    protected StyleElement getStyleElement(String name) {
        Map<String, StyleElement> map = this.getStyleMap();
        if (map != null) {
            return map.get(name);
        }
        return null;
    }

    private StyleElement getStyleElementCaseInSensitive(String name) {
        Map<String, StyleElement> map = this.getStyleMap();
        for (Map.Entry<String, StyleElement> entry : map.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(name)) continue;
            return entry.getValue();
        }
        return null;
    }

    private String getStyleAttribute(String name1, String name2, Shorthand shorthand) {
        String value;
        if (this.styleDeclaration_ != null) {
            String value1 = this.styleDeclaration_.getPropertyValue(name1);
            String value2 = this.styleDeclaration_.getPropertyValue(name2);
            if ("".equals(value1) && "".equals(value2)) {
                return "";
            }
            if (!"".equals(value1) && "".equals(value2)) {
                return value1;
            }
            value = value2;
        } else {
            StyleElement element1 = this.getStyleElement(name1);
            StyleElement element2 = this.getStyleElement(name2);
            if (element2 == null) {
                if (element1 == null) {
                    return "";
                }
                return element1.getValue();
            }
            if (element1 == null) {
                value = element2.getValue();
            } else {
                if (element1.getIndex() > element2.getIndex()) {
                    return element1.getValue();
                }
                value = element2.getValue();
            }
        }
        String[] values = StringUtils.split((String)value);
        switch (shorthand) {
            case TOP: {
                return values[0];
            }
            case RIGHT: {
                if (values.length > 1) {
                    return values[1];
                }
                return values[0];
            }
            case BOTTOM: {
                if (values.length > 2) {
                    return values[2];
                }
                return values[0];
            }
            case LEFT: {
                if (values.length > 3) {
                    return values[3];
                }
                if (values.length > 1) {
                    return values[1];
                }
                return values[0];
            }
        }
        throw new IllegalStateException("Unknown shorthand value: " + (Object)((Object)shorthand));
    }

    protected void setStyleAttribute(String name, String newValue) {
        this.setStyleAttribute(name, newValue, "");
    }

    protected void setStyleAttribute(String name, String newValue, String important) {
        if ("null".equals(newValue)) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_SET_NULL_THROWS)) {
                // empty if block
            }
            newValue = "";
        }
        if (this.styleDeclaration_ != null) {
            this.styleDeclaration_.setProperty(name, newValue, important);
            return;
        }
        this.replaceStyleAttribute(name, newValue, important);
    }

    private void replaceStyleAttribute(String name, String value, String priority) {
        if (StringUtils.isBlank((CharSequence)value)) {
            this.removeStyleAttribute(name);
        } else {
            Map<String, StyleElement> styleMap = this.getStyleMap();
            StyleElement old = styleMap.get(name);
            long index = old != null ? old.getIndex() : this.getCurrentElementIndex();
            StyleElement element = new StyleElement(name, value, priority, SelectorSpecificity.FROM_STYLE_ATTRIBUTE, index);
            styleMap.put(name, element);
            this.writeToElement(styleMap);
        }
    }

    private String removeStyleAttribute(String name) {
        if (null != this.styleDeclaration_) {
            return this.styleDeclaration_.removeProperty(name);
        }
        Map<String, StyleElement> styleMap = this.getStyleMap();
        StyleElement value = styleMap.get(name);
        if (value == null) {
            return "";
        }
        styleMap.remove(name);
        this.writeToElement(styleMap);
        return value.getValue();
    }

    private Map<String, StyleElement> getStyleMap() {
        if (this.jsElement_ == null) {
            return Collections.emptyMap();
        }
        String styleAttribute = this.jsElement_.getDomNodeOrDie().getAttribute("style");
        if (this.styleString_ == styleAttribute) {
            return this.styleMap_;
        }
        LinkedHashMap<String, StyleElement> styleMap = new LinkedHashMap<String, StyleElement>();
        if (DomElement.ATTRIBUTE_NOT_DEFINED == styleAttribute || DomElement.ATTRIBUTE_VALUE_EMPTY == styleAttribute) {
            this.styleMap_ = styleMap;
            this.styleString_ = styleAttribute;
            return this.styleMap_;
        }
        for (String token : StringUtils.split((String)styleAttribute, (char)';')) {
            int index = token.indexOf(":");
            if (index == -1) continue;
            String key = token.substring(0, index).trim().toLowerCase(Locale.ROOT);
            String value = token.substring(index + 1).trim();
            String priority = "";
            if (StringUtils.endsWithIgnoreCase((CharSequence)value, (CharSequence)"!important")) {
                priority = PRIORITY_IMPORTANT;
                value = value.substring(0, value.length() - 10);
                value = value.trim();
            }
            StyleElement element = new StyleElement(key, value, priority, SelectorSpecificity.FROM_STYLE_ATTRIBUTE, this.getCurrentElementIndex());
            styleMap.put(key, element);
        }
        this.styleMap_ = styleMap;
        this.styleString_ = styleAttribute;
        return this.styleMap_;
    }

    private void writeToElement(Map<String, StyleElement> styleMap) {
        StringBuilder buffer = new StringBuilder();
        TreeSet<StyleElement> sortedValues = new TreeSet<StyleElement>(styleMap.values());
        for (StyleElement e : sortedValues) {
            if (buffer.length() != 0) {
                buffer.append(" ");
            }
            buffer.append(e.getName());
            buffer.append(": ");
            buffer.append(e.getValue());
            String prio = e.getPriority();
            if (StringUtils.isNotBlank((CharSequence)prio)) {
                buffer.append(" !");
                buffer.append(prio);
            }
            buffer.append(";");
        }
        this.jsElement_.getDomNodeOrDie().setAttribute("style", buffer.toString());
    }

    protected long getCurrentElementIndex() {
        return this.currentElementIndex_++;
    }

    protected static String camelize(String string) {
        if (string == null) {
            return null;
        }
        String result = CamelizeCache_.get(string);
        if (null != result) {
            return result;
        }
        int pos = string.indexOf(45);
        if (pos == -1 || pos == string.length() - 1) {
            CamelizeCache_.put(string, string);
            return string;
        }
        StringBuilder buffer = new StringBuilder(string);
        buffer.deleteCharAt(pos);
        buffer.setCharAt(pos, Character.toUpperCase(buffer.charAt(pos)));
        for (int i = pos + 1; i < buffer.length() - 1; ++i) {
            if (buffer.charAt(i) != '-') continue;
            buffer.deleteCharAt(i);
            buffer.setCharAt(i, Character.toUpperCase(buffer.charAt(i)));
        }
        result = buffer.toString();
        CamelizeCache_.put(string, result);
        return result;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getAccelerator() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.getStyleAttribute(StyleAttributes.Definition.ACCELERATOR.getAttributeName()), (CharSequence)"false");
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setAccelerator(String accelerator) {
        this.setStyleAttributePixel(StyleAttributes.Definition.ACCELERATOR.getAttributeName(), accelerator);
    }

    @JsxGetter
    public String getBackgroundAttachment() {
        String value = this.getStyleAttribute(BACKGROUND_ATTACHMENT);
        if (StringUtils.isBlank((CharSequence)value)) {
            String bg = this.getStyleAttribute(BACKGROUND);
            if (StringUtils.isNotBlank((CharSequence)bg)) {
                value = CSSStyleDeclaration.findAttachment(bg);
                if (value == null) {
                    if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_BACKGROUND_INITIAL) && this.getClass() == CSSStyleDeclaration.class) {
                        return "initial";
                    }
                    return "scroll";
                }
                return value;
            }
            return "";
        }
        return value;
    }

    @JsxSetter
    public void setBackgroundAttachment(String backgroundAttachment) {
        this.setStyleAttribute(BACKGROUND_ATTACHMENT, backgroundAttachment);
    }

    @JsxGetter
    public String getBackgroundColor() {
        String value = this.getStyleAttribute(BACKGROUND_COLOR);
        if (StringUtils.isBlank((CharSequence)value)) {
            String bg = this.getStyleAttribute(BACKGROUND);
            if (StringUtils.isBlank((CharSequence)bg)) {
                return "";
            }
            value = CSSStyleDeclaration.findColor(bg);
            if (value == null) {
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_BACKGROUND_INITIAL)) {
                    if (this.getClass() == CSSStyleDeclaration.class) {
                        return "initial";
                    }
                    return "rgba(0, 0, 0, 0)";
                }
                return "transparent";
            }
            return value;
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            return "";
        }
        return value;
    }

    @JsxSetter
    public void setBackgroundColor(String backgroundColor) {
        this.setStyleAttribute(BACKGROUND_COLOR, backgroundColor);
    }

    @JsxGetter
    public String getBackgroundImage() {
        String value = this.getStyleAttribute(BACKGROUND_IMAGE);
        if (StringUtils.isBlank((CharSequence)value)) {
            String bg = this.getStyleAttribute(BACKGROUND);
            if (StringUtils.isNotBlank((CharSequence)bg)) {
                value = CSSStyleDeclaration.findImageUrl(bg);
                boolean isComputed = this.getClass() != CSSStyleDeclaration.class;
                boolean backgroundInitial = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_BACKGROUND_INITIAL);
                if (value == null) {
                    return backgroundInitial && !isComputed ? "initial" : "none";
                }
                if (isComputed) {
                    try {
                        value = value.substring(5, value.length() - 2);
                        return "url(\"" + ((HtmlElement)this.jsElement_.getDomNodeOrDie()).getHtmlPageOrNull().getFullyQualifiedUrl(value) + "\")";
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return value;
            }
            return "";
        }
        return value;
    }

    @JsxSetter
    public void setBackgroundImage(String backgroundImage) {
        this.setStyleAttribute(BACKGROUND_IMAGE, backgroundImage);
    }

    @JsxGetter
    public String getBackgroundPosition() {
        String value = this.getStyleAttribute(BACKGROUND_POSITION);
        if (value == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            String bg = this.getStyleAttribute(BACKGROUND);
            if (bg == null) {
                return null;
            }
            if (StringUtils.isNotBlank((CharSequence)bg)) {
                String[] values;
                boolean isComputed;
                value = CSSStyleDeclaration.findPosition(bg);
                boolean isInitial = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_BACKGROUND_INITIAL);
                boolean bl = isComputed = this.getClass() != CSSStyleDeclaration.class;
                if (value == null) {
                    if (isInitial) {
                        return isComputed ? "" : "initial";
                    }
                    return "0% 0%";
                }
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_ZINDEX_TYPE_INTEGER)) {
                    values = value.split(" ");
                    if ("center".equals(values[0])) {
                        values[0] = "";
                    }
                    if ("center".equals(values[1])) {
                        values[1] = "";
                    }
                    if (!isComputed || value.contains(TOP)) {
                        return (values[0] + ' ' + values[1]).trim();
                    }
                }
                if (isInitial || isComputed) {
                    values = value.split(" ");
                    switch (values[0]) {
                        case "left": {
                            values[0] = "0%";
                            break;
                        }
                        case "center": {
                            values[0] = "50%";
                            break;
                        }
                        case "right": {
                            values[0] = "100%";
                            break;
                        }
                    }
                    switch (values[1]) {
                        case "top": {
                            values[1] = "0%";
                            break;
                        }
                        case "center": {
                            values[1] = "50%";
                            break;
                        }
                        case "bottom": {
                            values[1] = "100%";
                            break;
                        }
                    }
                    value = values[0] + ' ' + values[1];
                }
                return value;
            }
            return "";
        }
        return value;
    }

    @JsxSetter
    public void setBackgroundPosition(String backgroundPosition) {
        this.setStyleAttribute(BACKGROUND_POSITION, backgroundPosition);
    }

    @JsxGetter
    public String getBackgroundRepeat() {
        String value = this.getStyleAttribute(BACKGROUND_REPEAT);
        if (StringUtils.isBlank((CharSequence)value)) {
            String bg = this.getStyleAttribute(BACKGROUND);
            if (StringUtils.isNotBlank((CharSequence)bg)) {
                value = CSSStyleDeclaration.findRepeat(bg);
                if (value == null) {
                    if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_BACKGROUND_INITIAL) && this.getClass() == CSSStyleDeclaration.class) {
                        return "initial";
                    }
                    return "repeat";
                }
                return value;
            }
            return "";
        }
        return value;
    }

    @JsxSetter
    public void setBackgroundRepeat(String backgroundRepeat) {
        this.setStyleAttribute(BACKGROUND_REPEAT, backgroundRepeat);
    }

    @JsxGetter
    public String getBorder() {
        return this.getStyleAttribute(BORDER);
    }

    @JsxSetter
    public void setBorder(String border) {
        this.setStyleAttribute(BORDER, border);
    }

    @JsxGetter
    public String getBorderBottomColor() {
        String value = this.getStyleAttribute(BORDER_BOTTOM_COLOR);
        if (value.isEmpty()) {
            value = CSSStyleDeclaration.findColor(this.getStyleAttribute(BORDER_BOTTOM));
            if (value == null) {
                value = CSSStyleDeclaration.findColor(this.getStyleAttribute(BORDER));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    @JsxSetter
    public void setBorderBottomColor(String borderBottomColor) {
        this.setStyleAttribute(BORDER_BOTTOM_COLOR, borderBottomColor);
    }

    @JsxGetter
    public String getBorderBottomStyle() {
        String value = this.getStyleAttribute(BORDER_BOTTOM_STYLE);
        if (value.isEmpty()) {
            value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(BORDER_BOTTOM));
            if (value == null) {
                value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(BORDER));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    @JsxSetter
    public void setBorderBottomStyle(String borderBottomStyle) {
        this.setStyleAttribute(BORDER_BOTTOM_STYLE, borderBottomStyle);
    }

    @JsxGetter
    public String getBorderBottomWidth() {
        return this.getBorderWidth(Shorthand.BOTTOM);
    }

    @JsxSetter
    public void setBorderBottomWidth(String borderBottomWidth) {
        if (!borderBottomWidth.endsWith("%")) {
            this.setStyleAttributePixel(BORDER_BOTTOM_WIDTH, borderBottomWidth);
        }
    }

    @JsxGetter
    public String getBorderLeftColor() {
        String value = this.getStyleAttribute(BORDER_LEFT_COLOR);
        if (value.isEmpty()) {
            value = CSSStyleDeclaration.findColor(this.getStyleAttribute(BORDER_LEFT));
            if (value == null) {
                value = CSSStyleDeclaration.findColor(this.getStyleAttribute(BORDER));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    @JsxSetter
    public void setBorderLeftColor(String borderLeftColor) {
        this.setStyleAttribute(BORDER_LEFT_COLOR, borderLeftColor);
    }

    @JsxGetter
    public String getBorderLeftStyle() {
        String value = this.getStyleAttribute(BORDER_LEFT_STYLE);
        if (value.isEmpty()) {
            value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(BORDER_LEFT));
            if (value == null) {
                value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(BORDER));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    @JsxSetter
    public void setBorderLeftStyle(String borderLeftStyle) {
        this.setStyleAttribute(BORDER_LEFT_STYLE, borderLeftStyle);
    }

    @JsxGetter
    public String getBorderLeftWidth() {
        return this.getBorderWidth(Shorthand.LEFT);
    }

    private String getBorderWidth(Shorthand side) {
        String value = this.getStyleAttribute("border-" + (Object)((Object)side) + "-width");
        if (value.isEmpty()) {
            String[] values;
            String borderWidth;
            value = CSSStyleDeclaration.findBorderWidth(this.getStyleAttribute("border-" + (Object)((Object)side)));
            if (value == null && !StringUtils.isEmpty((CharSequence)(borderWidth = this.getStyleAttribute(BORDER_WIDTH))) && (values = StringUtils.split((String)borderWidth)).length > side.ordinal()) {
                value = values[side.ordinal()];
            }
            if (value == null) {
                value = CSSStyleDeclaration.findBorderWidth(this.getStyleAttribute(BORDER));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    @JsxSetter
    public void setBorderLeftWidth(String borderLeftWidth) {
        if (!borderLeftWidth.endsWith("%")) {
            this.setStyleAttributePixel(BORDER_LEFT_WIDTH, borderLeftWidth);
        }
    }

    @JsxGetter
    public String getBorderRightColor() {
        String value = this.getStyleAttribute(BORDER_RIGHT_COLOR);
        if (value.isEmpty()) {
            value = CSSStyleDeclaration.findColor(this.getStyleAttribute(BORDER_RIGHT));
            if (value == null) {
                value = CSSStyleDeclaration.findColor(this.getStyleAttribute(BORDER));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    @JsxSetter
    public void setBorderRightColor(String borderRightColor) {
        this.setStyleAttribute(BORDER_RIGHT_COLOR, borderRightColor);
    }

    @JsxGetter
    public String getBorderRightStyle() {
        String value = this.getStyleAttribute(BORDER_RIGHT_STYLE);
        if (value.isEmpty()) {
            value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(BORDER_RIGHT));
            if (value == null) {
                value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(BORDER));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    @JsxSetter
    public void setBorderRightStyle(String borderRightStyle) {
        this.setStyleAttribute(BORDER_RIGHT_STYLE, borderRightStyle);
    }

    @JsxGetter
    public String getBorderRightWidth() {
        return this.getBorderWidth(Shorthand.RIGHT);
    }

    @JsxSetter
    public void setBorderRightWidth(String borderRightWidth) {
        if (!borderRightWidth.endsWith("%")) {
            this.setStyleAttributePixel(BORDER_RIGHT_WIDTH, borderRightWidth);
        }
    }

    @JsxSetter
    public void setBorderTop(String borderTop) {
        this.setStyleAttribute(BORDER_TOP, borderTop);
    }

    @JsxGetter
    public String getBorderTopColor() {
        String value = this.getStyleAttribute(BORDER_TOP_COLOR);
        if (value.isEmpty()) {
            value = CSSStyleDeclaration.findColor(this.getStyleAttribute(BORDER_TOP));
            if (value == null) {
                value = CSSStyleDeclaration.findColor(this.getStyleAttribute(BORDER));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    @JsxSetter
    public void setBorderTopColor(String borderTopColor) {
        this.setStyleAttribute(BORDER_TOP_COLOR, borderTopColor);
    }

    @JsxGetter
    public String getBorderTopStyle() {
        String value = this.getStyleAttribute(BORDER_TOP_STYLE);
        if (value.isEmpty()) {
            value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(BORDER_TOP));
            if (value == null) {
                value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(BORDER));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    @JsxSetter
    public void setBorderTopStyle(String borderTopStyle) {
        this.setStyleAttribute(BORDER_TOP_STYLE, borderTopStyle);
    }

    @JsxGetter
    public String getBorderTopWidth() {
        return this.getBorderWidth(Shorthand.TOP);
    }

    @JsxSetter
    public void setBorderTopWidth(String borderTopWidth) {
        if (!borderTopWidth.endsWith("%")) {
            this.setStyleAttributePixel(BORDER_TOP_WIDTH, borderTopWidth);
        }
    }

    @JsxGetter
    public String getBottom() {
        return this.getStyleAttribute(BOTTOM);
    }

    @JsxSetter
    public void setBottom(String bottom) {
        this.setStyleAttributePixel(BOTTOM, bottom);
    }

    @JsxGetter
    public String getColor() {
        return this.getStyleAttribute(COLOR);
    }

    @JsxSetter
    public void setColor(String color) {
        this.setStyleAttribute(COLOR, color);
    }

    @JsxGetter
    public String getCssFloat() {
        return this.getStyleAttribute(StyleAttributes.Definition.FLOAT);
    }

    @JsxSetter
    public void setCssFloat(String value) {
        this.setStyleAttribute(StyleAttributes.Definition.FLOAT.getAttributeName(), value);
    }

    @JsxGetter
    public String getCssText() {
        return this.jsElement_.getDomNodeOrDie().getAttribute("style");
    }

    @JsxSetter
    public void setCssText(String value) {
        this.jsElement_.getDomNodeOrDie().setAttribute("style", value);
    }

    @JsxGetter
    public String getDisplay() {
        return this.getStyleAttribute(DISPLAY);
    }

    @JsxSetter
    public void setDisplay(String display) {
        this.setStyleAttribute(DISPLAY, display);
    }

    @JsxGetter
    public String getFontSize() {
        return this.getStyleAttribute(FONT_SIZE);
    }

    @JsxSetter
    public void setFontSize(String fontSize) {
        this.setStyleAttributePixel(FONT_SIZE, fontSize);
    }

    @JsxGetter
    public String getHeight() {
        return this.getStyleAttribute(HEIGHT);
    }

    @JsxSetter
    public void setHeight(String height) {
        this.setStyleAttributePixel(HEIGHT, height);
    }

    @JsxGetter
    public String getLeft() {
        return this.getStyleAttribute(LEFT);
    }

    @JsxSetter
    public void setLeft(String left) {
        this.setStyleAttributePixel(LEFT, left);
    }

    @JsxGetter
    public int getLength() {
        return this.getStyleMap().size();
    }

    @JsxGetter
    public String getLetterSpacing() {
        return this.getStyleAttribute(LETTER_SPACING);
    }

    @JsxSetter
    public void setLetterSpacing(String letterSpacing) {
        if (!letterSpacing.endsWith("%")) {
            this.setStyleAttributePixel(LETTER_SPACING, letterSpacing);
        }
    }

    @JsxGetter
    public String getMargin() {
        return this.getStyleAttribute(MARGIN);
    }

    @JsxSetter
    public void setMargin(String margin) {
        this.setStyleAttribute(MARGIN, margin);
    }

    @JsxGetter
    public String getMarginBottom() {
        return this.getStyleAttribute(MARGIN_BOTTOM, MARGIN, Shorthand.BOTTOM);
    }

    @JsxSetter
    public void setMarginBottom(String marginBottom) {
        this.setStyleAttributePixel(MARGIN_BOTTOM, marginBottom);
    }

    @JsxGetter
    public String getMarginLeft() {
        return this.getStyleAttribute(MARGIN_LEFT, MARGIN, Shorthand.LEFT);
    }

    @JsxSetter
    public void setMarginLeft(String marginLeft) {
        this.setStyleAttributePixel(MARGIN_LEFT, marginLeft);
    }

    @JsxGetter
    public String getMarginRight() {
        return this.getStyleAttribute(MARGIN_RIGHT, MARGIN, Shorthand.RIGHT);
    }

    @JsxSetter
    public void setMarginRight(String marginRight) {
        this.setStyleAttributePixel(MARGIN_RIGHT, marginRight);
    }

    @JsxGetter
    public String getMarginTop() {
        return this.getStyleAttribute(MARGIN_TOP, MARGIN, Shorthand.TOP);
    }

    @JsxSetter
    public void setMarginTop(String marginTop) {
        this.setStyleAttributePixel(MARGIN_TOP, marginTop);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF, maxVersion=38.0f)})
    public String getMarks() {
        return this.getStyleAttribute(MARKS);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF, maxVersion=38.0f)})
    public void setMarks(String marks) {
        this.setStyleAttribute(MARKS, marks);
    }

    @JsxGetter
    public String getMaxHeight() {
        return this.getStyleAttribute(MAX_HEIGHT);
    }

    @JsxSetter
    public void setMaxHeight(String maxHeight) {
        this.setStyleAttributePixel(MAX_HEIGHT, maxHeight);
    }

    @JsxGetter
    public String getMaxWidth() {
        return this.getStyleAttribute(MAX_WIDTH);
    }

    @JsxSetter
    public void setMaxWidth(String maxWidth) {
        this.setStyleAttributePixel(MAX_WIDTH, maxWidth);
    }

    @JsxGetter
    public String getMinHeight() {
        return this.getStyleAttribute(MIN_HEIGHT);
    }

    @JsxSetter
    public void setMinHeight(String minHeight) {
        this.setStyleAttributePixel(MIN_HEIGHT, minHeight);
    }

    @JsxGetter
    public String getMinWidth() {
        return this.getStyleAttribute(MIN_WIDTH);
    }

    @JsxSetter
    public void setMinWidth(String minWidth) {
        this.setStyleAttributePixel(MIN_WIDTH, minWidth);
    }

    @Override
    public Object get(String name, Scriptable start) {
        if (this != start) {
            return super.get(name, start);
        }
        for (Scriptable prototype = this.getPrototype(); prototype != null; prototype = prototype.getPrototype()) {
            Object value = prototype.get(name, start);
            if (value == Scriptable.NOT_FOUND) continue;
            return value;
        }
        StyleAttributes.Definition style = StyleAttributes.getDefinition(name, this.getBrowserVersion());
        if (style != null) {
            return this.getStyleAttribute(style);
        }
        return super.get(name, start);
    }

    public Object get(int index, Scriptable start) {
        if (index < 0) {
            return Undefined.instance;
        }
        int size = this.getStyleMap().size();
        if (index >= size) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_STYLE_WRONG_INDEX_RETURNS_UNDEFINED)) {
                return Undefined.instance;
            }
            return "";
        }
        return this.getStyleMap().keySet().toArray(new String[size])[index];
    }

    public String getStyleAttribute(StyleAttributes.Definition style) {
        return this.getStyleAttribute(style.getAttributeName());
    }

    public void put(String name, Scriptable start, Object value) {
        StyleAttributes.Definition style;
        if (this != start) {
            super.put(name, start, value);
            return;
        }
        Scriptable prototype = this.getPrototype();
        if (prototype != null && !"constructor".equals(name) && prototype.get(name, start) != Scriptable.NOT_FOUND) {
            prototype.put(name, start, value);
            return;
        }
        if (this.getDomNodeOrNull() != null && (style = StyleAttributes.getDefinition(name, this.getBrowserVersion())) != null) {
            String stringValue = Context.toString((Object)value);
            this.setStyleAttribute(style.getAttributeName(), stringValue);
            return;
        }
        super.put(name, start, value);
    }

    public boolean has(String name, Scriptable start) {
        if (this != start) {
            return super.has(name, start);
        }
        StyleAttributes.Definition style = StyleAttributes.getDefinition(name, this.getBrowserVersion());
        if (style != null) {
            return true;
        }
        return super.has(name, start);
    }

    public Object[] getIds() {
        Object[] normalIds;
        ArrayList<Object> ids = new ArrayList<Object>();
        for (StyleAttributes.Definition styleAttribute : StyleAttributes.getDefinitions(this.getBrowserVersion())) {
            ids.add(styleAttribute.getPropertyName());
        }
        for (Object o : normalIds = super.getIds()) {
            if (ids.contains(o)) continue;
            ids.add(o);
        }
        return ids.toArray();
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setMsImeAlign(String msImeAlign) {
        this.setStyleAttribute(StyleAttributes.Definition.MS_IME_ALIGN.getAttributeName(), msImeAlign);
    }

    @JsxGetter
    public String getOpacity() {
        String opacity = this.getStyleAttribute(OPACITY);
        if (opacity == null || opacity.isEmpty()) {
            return "";
        }
        String trimedOpacity = opacity.trim();
        try {
            float value = Float.parseFloat(trimedOpacity);
            if (value % 1.0f == 0.0f) {
                return Integer.toString((int)value);
            }
            return Float.toString(value);
        }
        catch (NumberFormatException numberFormatException) {
            return "";
        }
    }

    @JsxSetter
    public void setOpacity(String opacity) {
        if (opacity.isEmpty()) {
            this.setStyleAttribute(OPACITY, opacity);
        }
        String trimedOpacity = opacity.trim();
        try {
            Float.parseFloat(trimedOpacity);
            this.setStyleAttribute(OPACITY, trimedOpacity);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.FF)})
    public String getOutline() {
        return this.getStyleAttribute(OUTLINE);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.FF)})
    public void setOutline(String outline) {
        this.setStyleAttribute(OUTLINE, outline);
    }

    @JsxGetter
    public String getOutlineWidth() {
        return this.getStyleAttribute(OUTLINE_WIDTH);
    }

    @JsxSetter
    public void setOutlineWidth(String outlineWidth) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_SUPPORTS_BEHAVIOR_PROPERTY)) {
            if (!outlineWidth.endsWith("%")) {
                this.setStyleAttributePixel(OUTLINE_WIDTH, outlineWidth);
            }
        } else if (outlineWidth.endsWith("px") || outlineWidth.endsWith("em") || outlineWidth.endsWith("mm")) {
            this.setStyleAttributePixel(OUTLINE_WIDTH, outlineWidth);
        }
    }

    @JsxGetter
    public String getPadding() {
        return this.getStyleAttribute(PADDING);
    }

    @JsxSetter
    public void setPadding(String padding) {
        this.setStyleAttribute(PADDING, padding);
    }

    @JsxGetter
    public String getPaddingBottom() {
        return this.getStyleAttribute(PADDING_BOTTOM, PADDING, Shorthand.BOTTOM);
    }

    @JsxSetter
    public void setPaddingBottom(String paddingBottom) {
        this.setStyleAttributePixel(PADDING_BOTTOM, paddingBottom);
    }

    @JsxGetter
    public String getPaddingLeft() {
        return this.getStyleAttribute(PADDING_LEFT, PADDING, Shorthand.LEFT);
    }

    @JsxSetter
    public void setPaddingLeft(String paddingLeft) {
        this.setStyleAttributePixel(PADDING_LEFT, paddingLeft);
    }

    @JsxGetter
    public String getPaddingRight() {
        return this.getStyleAttribute(PADDING_RIGHT, PADDING, Shorthand.RIGHT);
    }

    @JsxSetter
    public void setPaddingRight(String paddingRight) {
        this.setStyleAttributePixel(PADDING_RIGHT, paddingRight);
    }

    @JsxGetter
    public String getPaddingTop() {
        return this.getStyleAttribute(PADDING_TOP, PADDING, Shorthand.TOP);
    }

    @JsxSetter
    public void setPaddingTop(String paddingTop) {
        this.setStyleAttributePixel(PADDING_TOP, paddingTop);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF, maxVersion=38.0f)})
    public String getPage() {
        return this.getStyleAttribute(PAGE);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF, maxVersion=38.0f)})
    public void setPage(String page) {
        this.setStyleAttribute(PAGE, page);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public int getPixelBottom() {
        return CSSStyleDeclaration.pixelValue(this.getBottom());
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setPixelBottom(int pixelBottom) {
        this.setBottom(pixelBottom + "px");
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public int getPixelHeight() {
        return CSSStyleDeclaration.pixelValue(this.getHeight());
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setPixelHeight(int pixelHeight) {
        this.setHeight(pixelHeight + "px");
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public int getPixelLeft() {
        return CSSStyleDeclaration.pixelValue(this.getLeft());
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setPixelLeft(int pixelLeft) {
        this.setLeft(pixelLeft + "px");
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public int getPixelRight() {
        return CSSStyleDeclaration.pixelValue(this.getRight());
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setPixelRight(int pixelRight) {
        this.setRight(pixelRight + "px");
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public int getPixelTop() {
        return CSSStyleDeclaration.pixelValue(this.getTop());
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setPixelTop(int pixelTop) {
        this.setTop(pixelTop + "px");
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public int getPixelWidth() {
        return CSSStyleDeclaration.pixelValue(this.getWidth());
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setPixelWidth(int pixelWidth) {
        this.setWidth(pixelWidth + "px");
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public int getPosBottom() {
        return 0;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setPosBottom(int posBottom) {
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public int getPosHeight() {
        return 0;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setPosHeight(int posHeight) {
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public int getPosLeft() {
        return 0;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setPosLeft(int posLeft) {
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public int getPosRight() {
        return 0;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setPosRight(int posRight) {
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public int getPosTop() {
        return 0;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setPosTop(int posTop) {
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public int getPosWidth() {
        return 0;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setPosWidth(int posWidth) {
    }

    @JsxGetter
    public String getRight() {
        return this.getStyleAttribute(RIGHT);
    }

    @JsxSetter
    public void setRight(String right) {
        this.setStyleAttributePixel(RIGHT, right);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getRubyAlign() {
        return this.getStyleAttribute(RUBY_ALIGN);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setRubyAlign(String rubyAlign) {
        this.setStyleAttribute(RUBY_ALIGN, rubyAlign);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF, maxVersion=38.0f)})
    public String getSize() {
        return this.getStyleAttribute(SIZE);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF, maxVersion=38.0f)})
    public void setSize(String size) {
        this.setStyleAttribute(SIZE, size);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public boolean getTextDecorationBlink() {
        return false;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setTextDecorationBlink(boolean textDecorationBlink) {
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public boolean getTextDecorationLineThrough() {
        return false;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setTextDecorationLineThrough(boolean textDecorationLineThrough) {
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public boolean getTextDecorationNone() {
        return false;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setTextDecorationNone(boolean textDecorationNone) {
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public boolean getTextDecorationOverline() {
        return false;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setTextDecorationOverline(boolean textDecorationOverline) {
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public boolean getTextDecorationUnderline() {
        return false;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setTextDecorationUnderline(boolean textDecorationUnderline) {
    }

    @JsxGetter
    public String getTextIndent() {
        return this.getStyleAttribute(TEXT_INDENT);
    }

    @JsxSetter
    public void setTextIndent(String textIndent) {
        this.setStyleAttributePixel(TEXT_INDENT, textIndent);
    }

    @JsxGetter
    public String getTop() {
        return this.getStyleAttribute(TOP);
    }

    @JsxSetter
    public void setTop(String top) {
        this.setStyleAttributePixel(TOP, top);
    }

    @JsxGetter
    public String getVerticalAlign() {
        return this.getStyleAttribute(VERTICAL_ALIGN);
    }

    @JsxSetter
    public void setVerticalAlign(String verticalAlign) {
        this.setStyleAttributePixel(VERTICAL_ALIGN, verticalAlign);
    }

    @JsxGetter
    public String getWidth() {
        return this.getStyleAttribute(WIDTH);
    }

    @JsxSetter
    public void setWidth(String width) {
        this.setStyleAttributePixel(WIDTH, width);
    }

    @JsxGetter
    public String getWordSpacing() {
        return this.getStyleAttribute(WORD_SPACING);
    }

    @JsxSetter
    public void setWordSpacing(String wordSpacing) {
        if (!wordSpacing.endsWith("%") || this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_STYLE_WORD_SPACING_ACCEPTS_PERCENT)) {
            this.setStyleAttributePixel(WORD_SPACING, wordSpacing);
        }
    }

    @JsxGetter
    public Object getZIndex() {
        String value = this.getStyleAttribute(Z_INDEX);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_ZINDEX_TYPE_INTEGER)) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                return "";
            }
        }
        try {
            Integer.parseInt(value);
            return value;
        }
        catch (NumberFormatException e) {
            return "";
        }
    }

    @JsxSetter
    public void setZIndex(Object zIndex) {
        if (zIndex == null || StringUtils.isEmpty((CharSequence)zIndex.toString())) {
            this.setStyleAttribute(Z_INDEX, "");
            return;
        }
        if (Context.getUndefinedValue().equals(zIndex)) {
            return;
        }
        if (zIndex instanceof Number) {
            Number number = (Number)zIndex;
            if (number.doubleValue() % 1.0 == 0.0) {
                this.setStyleAttribute(Z_INDEX, Integer.toString(number.intValue()));
            }
            return;
        }
        try {
            int i = Integer.parseInt(zIndex.toString());
            this.setStyleAttribute(Z_INDEX, Integer.toString(i));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @JsxFunction
    public String getPropertyValue(String name) {
        Object value;
        if (name != null && name.contains("-") && (value = CSSStyleDeclaration.getProperty((Scriptable)this, (String)CSSStyleDeclaration.camelize(name))) instanceof String) {
            return (String)value;
        }
        return this.getStyleAttribute(name);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public CSSValue getPropertyCSSValue(String name) {
        String cssText;
        org.w3c.dom.css.CSSValue cssValue;
        LOG.info((Object)("getPropertyCSSValue(" + name + "): getPropertyCSSValue support is experimental"));
        if (this.styleDeclaration_ == null) {
            String uri = this.getDomNodeOrDie().getPage().getWebResponse().getWebRequest().getUrl().toExternalForm();
            String styleAttribute = this.jsElement_.getDomNodeOrDie().getAttribute("style");
            InputSource source = new InputSource((Reader)new StringReader(styleAttribute));
            source.setURI(uri);
            ErrorHandler errorHandler = this.getWindow().getWebWindow().getWebClient().getCssErrorHandler();
            CSSOMParser parser = new CSSOMParser((Parser)new SACParserCSS3());
            parser.setErrorHandler(errorHandler);
            try {
                this.styleDeclaration_ = parser.parseStyleDeclaration(source);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if ((cssValue = this.styleDeclaration_.getPropertyCSSValue(name)) == null) {
            CSSValueImpl newValue = new CSSValueImpl();
            newValue.setFloatValue((short)5, 0.0f);
            cssValue = newValue;
        }
        if ((cssText = cssValue.getCssText()).startsWith("rgb(")) {
            String formatedCssText = StringUtils.replace((String)cssText, (String)",", (String)", ");
            cssValue.setCssText(formatedCssText);
        }
        return new CSSPrimitiveValue(this.jsElement_, (org.w3c.dom.css.CSSPrimitiveValue)cssValue);
    }

    @JsxFunction
    public String getPropertyPriority(String name) {
        return this.getStylePriority(name);
    }

    @JsxFunction
    public void setProperty(String name, String value, String important) {
        if (StringUtils.isEmpty((CharSequence)important) || "null".equals(important)) {
            this.setStyleAttribute(name, value, "");
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_STYLE_SET_PROPERTY_IMPORTANT_IGNORES_CASE)) {
            if (PRIORITY_IMPORTANT.equalsIgnoreCase(important)) {
                this.setStyleAttribute(name, value, PRIORITY_IMPORTANT);
            }
        } else if (PRIORITY_IMPORTANT.equals(important)) {
            this.setStyleAttribute(name, value, PRIORITY_IMPORTANT);
        }
    }

    @JsxFunction
    public String removeProperty(Object name) {
        return this.removeStyleAttribute(Context.toString((Object)name));
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public Object getAttribute(String name, int flag) {
        StyleElement style = this.getStyleElementCaseInSensitive(name);
        if (null == style) {
            return "";
        }
        return style.getValue();
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public void setAttribute(String name, String value, Object flag) {
        StyleElement style = this.getStyleElementCaseInSensitive(name);
        if (null != style) {
            this.setStyleAttribute(style.getName(), value);
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public boolean removeAttribute(String name, Object flag) {
        StyleElement style = this.getStyleElementCaseInSensitive(name);
        if (style != null) {
            this.removeStyleAttribute(style.getName());
            return true;
        }
        return false;
    }

    private static String findColor(String text) {
        String[] tokens;
        Color tmpColor = com.gargoylesoftware.htmlunit.util.StringUtils.findColorRGB(text);
        if (tmpColor != null) {
            return com.gargoylesoftware.htmlunit.util.StringUtils.formatColor(tmpColor);
        }
        for (String token : tokens = StringUtils.split((String)text, (char)' ')) {
            if (CSSStyleDeclaration.isColorKeyword(token)) {
                return token;
            }
            tmpColor = com.gargoylesoftware.htmlunit.util.StringUtils.asColorHexadecimal(token);
            if (tmpColor == null) continue;
            return com.gargoylesoftware.htmlunit.util.StringUtils.formatColor(tmpColor);
        }
        return null;
    }

    private static String findImageUrl(String text) {
        Matcher m = URL_PATTERN.matcher(text);
        if (m.find()) {
            return "url(\"" + m.group(1) + "\")";
        }
        return null;
    }

    private static String findPosition(String text) {
        Matcher m = POSITION_PATTERN.matcher(text);
        if (m.find()) {
            return m.group(1) + " " + m.group(3);
        }
        m = POSITION_PATTERN2.matcher(text);
        if (m.find()) {
            return m.group(1) + " " + m.group(2);
        }
        m = POSITION_PATTERN3.matcher(text);
        if (m.find()) {
            return m.group(2) + " " + m.group(1);
        }
        return null;
    }

    private static String findRepeat(String text) {
        if (text.contains("repeat-x")) {
            return "repeat-x";
        }
        if (text.contains("repeat-y")) {
            return "repeat-y";
        }
        if (text.contains("no-repeat")) {
            return "no-repeat";
        }
        if (text.contains("repeat")) {
            return "repeat";
        }
        return null;
    }

    private static String findAttachment(String text) {
        if (text.contains("scroll")) {
            return "scroll";
        }
        if (text.contains("fixed")) {
            return "fixed";
        }
        return null;
    }

    private static String findBorderStyle(String text) {
        for (String token : StringUtils.split((String)text, (char)' ')) {
            if (!CSSStyleDeclaration.isBorderStyle(token)) continue;
            return token;
        }
        return null;
    }

    private static String findBorderWidth(String text) {
        for (String token : StringUtils.split((String)text, (char)' ')) {
            if (!CSSStyleDeclaration.isBorderWidth(token)) continue;
            return token;
        }
        return null;
    }

    private static boolean isColorKeyword(String token) {
        return CSSColors_.containsKey(token.toLowerCase(Locale.ROOT));
    }

    public static String toRGBColor(String color) {
        String rgbValue = CSSColors_.get(color.toLowerCase(Locale.ROOT));
        if (rgbValue != null) {
            return rgbValue;
        }
        return color;
    }

    private static boolean isBorderStyle(String token) {
        return "none".equalsIgnoreCase(token) || "hidden".equalsIgnoreCase(token) || "dotted".equalsIgnoreCase(token) || "dashed".equalsIgnoreCase(token) || "solid".equalsIgnoreCase(token) || "double".equalsIgnoreCase(token) || "groove".equalsIgnoreCase(token) || "ridge".equalsIgnoreCase(token) || "inset".equalsIgnoreCase(token) || "outset".equalsIgnoreCase(token);
    }

    private static boolean isBorderWidth(String token) {
        return "thin".equalsIgnoreCase(token) || "medium".equalsIgnoreCase(token) || "thick".equalsIgnoreCase(token) || CSSStyleDeclaration.isLength(token);
    }

    private static boolean isLength(String token) {
        if (token.endsWith("em") || token.endsWith("ex") || token.endsWith("px") || token.endsWith("in") || token.endsWith("cm") || token.endsWith("mm") || token.endsWith("pt") || token.endsWith("pc") || token.endsWith("%")) {
            token = token.endsWith("%") ? token.substring(0, token.length() - 1) : token.substring(0, token.length() - 2);
            try {
                Float.parseFloat(token);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    protected static int pixelValue(Element element, CssValue value) {
        return CSSStyleDeclaration.pixelValue(element, value, false);
    }

    private static int pixelValue(Element element, CssValue value, boolean percentMode) {
        String s = value.get(element);
        if (s.endsWith("%") || s.isEmpty() && element instanceof HTMLHtmlElement) {
            int i = NumberUtils.toInt((String)TO_INT_PATTERN.matcher(s).replaceAll("$1"), (int)100);
            Element parent = element.getParentElement();
            int absoluteValue = parent == null ? value.getWindowDefaultValue() : CSSStyleDeclaration.pixelValue(parent, value, true);
            return (int)((double)i / 100.0 * (double)absoluteValue);
        }
        if ("auto".equals(s)) {
            return value.getDefaultValue();
        }
        if (s.isEmpty()) {
            if (element instanceof HTMLCanvasElement) {
                return value.getWindowDefaultValue();
            }
            if (percentMode) {
                Element parent = element.getParentElement();
                if (parent == null || parent instanceof HTMLHtmlElement) {
                    return value.getWindowDefaultValue();
                }
                return CSSStyleDeclaration.pixelValue(parent, value, true);
            }
            return 0;
        }
        return CSSStyleDeclaration.pixelValue(s);
    }

    protected static int pixelValue(String value) {
        int i = NumberUtils.toInt((String)TO_INT_PATTERN.matcher(value).replaceAll("$1"), (int)0);
        if (value.length() < 2) {
            return i;
        }
        if (!value.endsWith("px")) {
            if (value.endsWith("em")) {
                i *= 16;
            } else if (value.endsWith("%")) {
                i = i * 16 / 100;
            } else if (value.endsWith("ex")) {
                i *= 10;
            } else if (value.endsWith("in")) {
                i *= 150;
            } else if (value.endsWith("cm")) {
                i *= 50;
            } else if (value.endsWith("mm")) {
                i *= 5;
            } else if (value.endsWith("pt")) {
                i *= 2;
            } else if (value.endsWith("pc")) {
                i *= 24;
            }
        }
        return i;
    }

    public String toString() {
        if (this.jsElement_ == null) {
            return "CSSStyleDeclaration for 'null'";
        }
        String style = this.jsElement_.getDomNodeOrDie().getAttribute("style");
        return "CSSStyleDeclaration for '" + style + "'";
    }

    protected void setStyleAttributePixel(String name, String value) {
        if (value.endsWith("px")) {
            value = value.substring(0, value.length() - 2);
        }
        try {
            float floatValue = Float.parseFloat(value);
            value = floatValue % 1.0f == 0.0f ? Integer.toString((int)floatValue) + "px" : Float.toString(floatValue) + "px";
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setStyleAttribute(name, value);
    }

    static {
        CSSColors_.put("aqua", "rgb(0, 255, 255)");
        CSSColors_.put("black", "rgb(0, 0, 0)");
        CSSColors_.put("blue", "rgb(0, 0, 255)");
        CSSColors_.put("fuchsia", "rgb(255, 0, 255)");
        CSSColors_.put("gray", "rgb(128, 128, 128)");
        CSSColors_.put("green", "rgb(0, 128, 0)");
        CSSColors_.put("lime", "rgb(0, 255, 0)");
        CSSColors_.put("maroon", "rgb(128, 0, 0)");
        CSSColors_.put("navy", "rgb(0, 0, 128)");
        CSSColors_.put("olive", "rgb(128, 128, 0)");
        CSSColors_.put("purple", "rgb(128, 0, 128)");
        CSSColors_.put("red", "rgb(255, 0, 0)");
        CSSColors_.put("silver", "rgb(192, 192, 192)");
        CSSColors_.put("teal", "rgb(0, 128, 128)");
        CSSColors_.put("white", "rgb(255, 255, 255)");
        CSSColors_.put("yellow", "rgb(255, 255, 0)");
    }

    public static class StyleElement
    implements Comparable<StyleElement>,
    Serializable {
        private final String name_;
        private final String value_;
        private final String priority_;
        private final long index_;
        private final SelectorSpecificity specificity_;

        protected StyleElement(String name, String value, String priority, SelectorSpecificity specificity, long index) {
            this.name_ = name;
            this.value_ = value;
            this.priority_ = priority;
            this.index_ = index;
            this.specificity_ = specificity;
        }

        protected StyleElement(String name, String value, long index) {
            this(name, value, "", SelectorSpecificity.FROM_STYLE_ATTRIBUTE, index);
        }

        protected StyleElement(String name, String value) {
            this(name, value, Long.MIN_VALUE);
        }

        public String getName() {
            return this.name_;
        }

        public String getValue() {
            return this.value_;
        }

        public String getPriority() {
            return this.priority_;
        }

        public SelectorSpecificity getSpecificity() {
            return this.specificity_;
        }

        public long getIndex() {
            return this.index_;
        }

        public boolean isDefault() {
            return this.index_ == Long.MIN_VALUE;
        }

        public String toString() {
            return "[" + this.index_ + "]" + this.name_ + "=" + this.value_;
        }

        @Override
        public int compareTo(StyleElement e) {
            if (e != null) {
                long styleIndex = e.index_;
                return this.index_ < styleIndex ? -1 : (this.index_ == styleIndex ? 0 : 1);
            }
            return 1;
        }
    }

    protected static abstract class CssValue {
        private final int defaultValue_;
        private final int windowDefaultValue_;

        public CssValue(int defaultValue, int windowDefaultValue) {
            this.defaultValue_ = defaultValue;
            this.windowDefaultValue_ = windowDefaultValue;
        }

        public int getDefaultValue() {
            return this.defaultValue_;
        }

        public int getWindowDefaultValue() {
            return this.windowDefaultValue_;
        }

        public final String get(Element element) {
            CSS2Properties style = element.getWindow().getComputedStyle(element, null);
            String value = this.get(style);
            return value;
        }

        public abstract String get(ComputedCSSStyleDeclaration var1);
    }

    private static enum Shorthand {
        TOP("top"),
        RIGHT("right"),
        BOTTOM("bottom"),
        LEFT("left");

        private final String string_;

        private Shorthand(String stringRepresentation) {
            this.string_ = stringRepresentation;
        }

        public String toString() {
            return this.string_;
        }
    }
}

