/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.event;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.InteractivePage;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventTarget;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.NativeObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventListenersContainer
implements Serializable {
    private static final Log LOG = LogFactory.getLog(EventListenersContainer.class);
    private final Map<String, Handlers> eventHandlers_ = new HashMap<String, Handlers>();
    private final EventTarget jsNode_;

    public EventListenersContainer(EventTarget jsNode) {
        this.jsNode_ = jsNode;
    }

    public boolean addEventListener(String type, Scriptable listener, boolean useCapture) {
        if (null == listener) {
            return true;
        }
        Handlers handlers = this.getHandlersOrCreateIt(type);
        boolean added = handlers.addListener(listener, useCapture);
        if (!added) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(type + " listener already registered, skipping it (" + listener + ")"));
            }
            return false;
        }
        return true;
    }

    private Handlers getHandlersOrCreateIt(String type) {
        String typeLC = type.toLowerCase(Locale.ROOT);
        Handlers handlers = this.eventHandlers_.get(typeLC);
        if (handlers == null) {
            handlers = new Handlers();
            this.eventHandlers_.put(typeLC, handlers);
        }
        return handlers;
    }

    public List<Scriptable> getHandlers(String eventType, boolean useCapture) {
        Handlers handlers = this.eventHandlers_.get(eventType.toLowerCase(Locale.ROOT));
        if (handlers != null) {
            return handlers.getHandlers(useCapture);
        }
        return null;
    }

    public void removeEventListener(String eventType, Scriptable listener, boolean useCapture) {
        if (null == listener) {
            return;
        }
        Handlers handlers = this.eventHandlers_.get(eventType.toLowerCase(Locale.ROOT));
        if (handlers != null) {
            handlers.removeListener(listener, useCapture);
        }
    }

    public void setEventHandlerProp(String eventName, Object value) {
        Object handler = value;
        if (Undefined.instance == value) {
            handler = null;
        }
        Handlers handlers = this.getHandlersOrCreateIt(eventName);
        handlers.handler_ = handler;
    }

    public Object getEventHandlerProp(String eventName) {
        Handlers handlers = this.eventHandlers_.get(eventName);
        if (handlers == null) {
            return null;
        }
        return handlers.handler_;
    }

    private ScriptResult executeEventListeners(boolean useCapture, Event event, Object[] args) {
        DomNode node = this.jsNode_.getDomNodeOrNull();
        if (node != null && !node.handles(event)) {
            return null;
        }
        ScriptResult allResult = null;
        List<Scriptable> handlers = this.getHandlers(event.getType(), useCapture);
        if (handlers != null && !handlers.isEmpty()) {
            event.setCurrentTarget((Scriptable)this.jsNode_);
            HtmlPage page = (HtmlPage)node.getPage();
            for (Scriptable listener : handlers) {
                Object handleEvent;
                Function function = null;
                EventTarget thisObject = null;
                if (listener instanceof Function) {
                    function = (Function)listener;
                    thisObject = this.jsNode_;
                } else if (listener instanceof NativeObject && (handleEvent = ScriptableObject.getProperty((Scriptable)listener, (String)"handleEvent")) instanceof Function) {
                    function = (Function)handleEvent;
                    thisObject = listener;
                }
                if (function == null) continue;
                ScriptResult result = page.executeJavaScriptFunctionIfPossible(function, (Scriptable)thisObject, args, node);
                if (event.isPropagationStopped()) {
                    allResult = result;
                }
                if (!this.jsNode_.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_FALSE_RESULT)) continue;
                if (ScriptResult.isFalse(result)) {
                    allResult = result;
                    continue;
                }
                Object eventReturnValue = event.getReturnValue();
                if (!(eventReturnValue instanceof Boolean) || ((Boolean)eventReturnValue).booleanValue()) continue;
                allResult = new ScriptResult(Boolean.FALSE, page);
            }
        }
        return allResult;
    }

    private ScriptResult executeEventHandler(Event event, Object[] propHandlerArgs) {
        DomNode node = this.jsNode_.getDomNodeOrNull();
        if (node != null && !node.handles(event)) {
            return null;
        }
        Function handler = this.getEventHandler(event.getType());
        if (handler != null) {
            event.setCurrentTarget((Scriptable)this.jsNode_);
            InteractivePage page = (InteractivePage)(node != null ? node.getPage() : this.jsNode_.getWindow().getWebWindow().getEnclosedPage());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Executing " + event.getType() + " handler for " + node));
            }
            return page.executeJavaScriptFunctionIfPossible(handler, (Scriptable)this.jsNode_, propHandlerArgs, page);
        }
        return null;
    }

    public ScriptResult executeBubblingListeners(Event event, Object[] args, Object[] propHandlerArgs) {
        ScriptResult newResult;
        ScriptResult result = null;
        DomNode domNode = this.jsNode_.getDomNodeOrNull();
        if (!(domNode instanceof HtmlBody)) {
            result = this.executeEventHandler(event, propHandlerArgs);
            if (event.isPropagationStopped()) {
                return result;
            }
        }
        if ((newResult = this.executeEventListeners(false, event, args)) != null) {
            result = newResult;
        }
        return result;
    }

    public ScriptResult executeCapturingListeners(Event event, Object[] args) {
        return this.executeEventListeners(true, event, args);
    }

    public Function getEventHandler(String eventName) {
        Object handler = this.getEventHandlerProp(eventName.toLowerCase(Locale.ROOT));
        if (handler instanceof Function) {
            return (Function)handler;
        }
        return null;
    }

    public boolean hasEventHandlers(String eventName) {
        Handlers h = this.eventHandlers_.get(eventName);
        return h != null && (h.handler_ instanceof Function || !h.bubblingHandlers_.isEmpty() || !h.capturingHandlers_.isEmpty());
    }

    public ScriptResult executeListeners(Event event, Object[] args, Object[] propHandlerArgs) {
        event.setEventPhase((short)1);
        ScriptResult result = this.executeEventListeners(true, event, args);
        if (event.isPropagationStopped()) {
            return result;
        }
        event.setEventPhase((short)2);
        ScriptResult newResult = this.executeEventHandler(event, propHandlerArgs);
        if (newResult != null) {
            result = newResult;
        }
        if (event.isPropagationStopped()) {
            return result;
        }
        event.setEventPhase((short)3);
        newResult = this.executeEventListeners(false, event, args);
        if (newResult != null) {
            result = newResult;
        }
        return result;
    }

    public void copyFrom(EventListenersContainer eventListenersContainer) {
        for (Map.Entry<String, Handlers> entry : eventListenersContainer.eventHandlers_.entrySet()) {
            Handlers handlers = entry.getValue().clone();
            this.eventHandlers_.put(entry.getKey(), handlers);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[node=" + this.jsNode_ + " handlers=" + this.eventHandlers_.keySet() + "]";
    }

    static class Handlers
    implements Serializable {
        private List<Scriptable> capturingHandlers_;
        private List<Scriptable> bubblingHandlers_;
        private Object handler_;

        Handlers() {
            this.capturingHandlers_ = Collections.unmodifiableList(new ArrayList());
            this.bubblingHandlers_ = Collections.unmodifiableList(new ArrayList());
        }

        private Handlers(List<Scriptable> capturingHandlers, List<Scriptable> bubblingHandlers, Object handler) {
            this.capturingHandlers_ = Collections.unmodifiableList(new ArrayList<Scriptable>(capturingHandlers));
            this.bubblingHandlers_ = Collections.unmodifiableList(new ArrayList<Scriptable>(bubblingHandlers));
            this.handler_ = handler;
        }

        private List<Scriptable> getHandlers(boolean useCapture) {
            if (useCapture) {
                return this.capturingHandlers_;
            }
            return this.bubblingHandlers_;
        }

        private synchronized boolean addListener(Scriptable listener, boolean useCapture) {
            List<Scriptable> listeners = this.getHandlers(useCapture);
            if (listeners.contains(listener)) {
                return false;
            }
            List<Object> newListeners = new ArrayList<Scriptable>(listeners.size() + 1);
            newListeners.addAll(listeners);
            newListeners.add(listener);
            newListeners = Collections.unmodifiableList(newListeners);
            if (useCapture) {
                this.capturingHandlers_ = newListeners;
            } else {
                this.bubblingHandlers_ = newListeners;
            }
            return true;
        }

        private synchronized void removeListener(Scriptable listener, boolean useCapture) {
            List<Scriptable> listeners = this.getHandlers(useCapture);
            int idx = listeners.indexOf(listener);
            if (idx < 0) {
                return;
            }
            List<Scriptable> newListeners = new ArrayList<Scriptable>(listeners);
            newListeners.remove(idx);
            newListeners = Collections.unmodifiableList(newListeners);
            if (useCapture) {
                this.capturingHandlers_ = newListeners;
            } else {
                this.bubblingHandlers_ = newListeners;
            }
        }

        protected Handlers clone() {
            return new Handlers(this.capturingHandlers_, this.bubblingHandlers_, this.handler_);
        }
    }
}

