/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cache.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sourceforge.pmd.PMDVersion;
import net.sourceforge.pmd.benchmark.TimeTracker;
import net.sourceforge.pmd.benchmark.TimedOperation;
import net.sourceforge.pmd.benchmark.TimedOperationCategory;
import net.sourceforge.pmd.cache.internal.AbstractAnalysisCache;
import net.sourceforge.pmd.cache.internal.AnalysisResult;
import net.sourceforge.pmd.cache.internal.CachedRuleViolation;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.rule.internal.RuleSets;
import net.sourceforge.pmd.reporting.RuleViolation;

public class FileAnalysisCache
extends AbstractAnalysisCache {
    private final File cacheFile;

    public FileAnalysisCache(File cache) {
        this.cacheFile = cache;
    }

    @Override
    public void checkValidity(RuleSets ruleSets, ClassLoader auxclassPathClassLoader, Collection<? extends TextFile> files) {
        this.loadFromFile(this.cacheFile, files);
        super.checkValidity(ruleSets, auxclassPathClassLoader, files);
    }

    private void loadFromFile(File cacheFile, Collection<? extends TextFile> files) {
        block21: {
            Map<String, FileId> idMap = files.stream().map(TextFile::getFileId).collect(Collectors.toMap(FileId::getUriString, id -> id));
            try (TimedOperation ignored = TimeTracker.startOperation(TimedOperationCategory.ANALYSIS_CACHE, "load");){
                if (this.cacheExists()) {
                    try (DataInputStream inputStream = new DataInputStream(new BufferedInputStream(Files.newInputStream(cacheFile.toPath(), new OpenOption[0])));){
                        String cacheVersion = inputStream.readUTF();
                        if (PMDVersion.VERSION.equals(cacheVersion)) {
                            this.rulesetChecksum = inputStream.readLong();
                            this.auxClassPathChecksum = inputStream.readLong();
                            this.executionClassPathChecksum = inputStream.readLong();
                            while (inputStream.available() > 0) {
                                String filePathId = inputStream.readUTF();
                                FileId fileId = idMap.get(filePathId);
                                if (fileId == null) {
                                    LOG.debug("File {} is in the cache but is not part of the analysis", (Object)filePathId);
                                    fileId = FileId.fromURI(filePathId);
                                }
                                long checksum = inputStream.readLong();
                                int countViolations = inputStream.readInt();
                                ArrayList<RuleViolation> violations = new ArrayList<RuleViolation>(countViolations);
                                for (int i = 0; i < countViolations; ++i) {
                                    violations.add(CachedRuleViolation.loadFromStream(inputStream, fileId, this.ruleMapper));
                                }
                                this.fileResultsCache.put(fileId, new AnalysisResult(checksum, violations));
                            }
                            LOG.debug("Analysis cache loaded from {}", (Object)cacheFile);
                        } else {
                            LOG.debug("Analysis cache invalidated, PMD version changed.");
                        }
                        break block21;
                    }
                    catch (EOFException e) {
                        LOG.warn("Cache file {} is malformed, will not be used for current analysis", (Object)cacheFile.getPath());
                    }
                    catch (IOException e) {
                        LOG.error("Could not load analysis cache from file: {}", (Object)e.getMessage());
                    }
                    break block21;
                }
                if (cacheFile.isDirectory()) {
                    LOG.error("The configured cache location must be the path to a file, but is a directory.");
                }
            }
        }
    }

    @Override
    public void persist() {
        try (TimedOperation ignored = TimeTracker.startOperation(TimedOperationCategory.ANALYSIS_CACHE, "persist");){
            File parentFile;
            boolean cacheFileShouldBeCreated;
            if (this.cacheFile.isDirectory()) {
                LOG.error("Cannot persist the cache, the given path points to a directory.");
                return;
            }
            boolean bl = cacheFileShouldBeCreated = !this.cacheFile.exists();
            if (cacheFileShouldBeCreated && (parentFile = this.cacheFile.getAbsoluteFile().getParentFile()) != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            try (DataOutputStream outputStream = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(this.cacheFile.toPath(), new OpenOption[0])));){
                outputStream.writeUTF(this.pmdVersion);
                outputStream.writeLong(this.rulesetChecksum);
                outputStream.writeLong(this.auxClassPathChecksum);
                outputStream.writeLong(this.executionClassPathChecksum);
                for (Map.Entry resultEntry : this.updatedResultsCache.entrySet()) {
                    List<RuleViolation> violations = ((AnalysisResult)resultEntry.getValue()).getViolations();
                    outputStream.writeUTF(((FileId)resultEntry.getKey()).getUriString());
                    outputStream.writeLong(((AnalysisResult)resultEntry.getValue()).getFileChecksum());
                    outputStream.writeInt(violations.size());
                    for (RuleViolation rv : violations) {
                        CachedRuleViolation.storeToStream(outputStream, rv);
                    }
                }
                if (cacheFileShouldBeCreated) {
                    LOG.debug("Analysis cache created");
                } else {
                    LOG.debug("Analysis cache updated");
                }
            }
            catch (IOException e) {
                LOG.error("Could not persist analysis cache to file: {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    protected boolean cacheExists() {
        return this.cacheFile.exists() && this.cacheFile.isFile() && this.cacheFile.length() > 0L;
    }
}

