/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.cpd.CpdLexer;
import net.sourceforge.pmd.cpd.TokenFactory;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class AnyCpdLexer
implements CpdLexer {
    private static final Pattern DEFAULT_PATTERN = AnyCpdLexer.makePattern("");
    private final Pattern pattern;
    private final String commentStart;

    private static Pattern makePattern(String singleLineCommentStart) {
        return Pattern.compile("\\w++" + AnyCpdLexer.eolCommentFragment(singleLineCommentStart) + "|[^\"'\\s]|\"(?:[^\"\\\\]++|\\\\.)*+\"|'(?:[^'\\\\]++|\\\\.)*+'|\n");
    }

    public AnyCpdLexer() {
        this(DEFAULT_PATTERN, "");
    }

    public AnyCpdLexer(String eolCommentStart) {
        this(AnyCpdLexer.makePattern(eolCommentStart), eolCommentStart);
    }

    private AnyCpdLexer(Pattern pattern, String commentStart) {
        this.pattern = pattern;
        this.commentStart = commentStart;
    }

    private static String eolCommentFragment(String start) {
        if (StringUtils.isBlank((CharSequence)start)) {
            return "";
        }
        return "|(?:" + Pattern.quote(start) + "[^\n]*+)";
    }

    @Override
    public void tokenize(TextDocument document, TokenFactory tokens) {
        Chars text = document.getText();
        Matcher matcher = this.pattern.matcher(text);
        int lineNo = 1;
        int lastLineStart = 0;
        while (matcher.find()) {
            String image = matcher.group();
            if (this.isComment(image)) continue;
            if (StringUtils.isWhitespace((CharSequence)image)) {
                ++lineNo;
                lastLineStart = matcher.end();
                continue;
            }
            int bline = lineNo;
            int bcol = 1 + matcher.start() - lastLineStart;
            int ecol = StringUtil.columnNumberAt(image, image.length());
            if (ecol == image.length() + 1) {
                ecol = bcol + image.length();
            } else {
                lineNo += StringUtil.lineNumberAt(image, image.length()) - 1;
                lastLineStart = matcher.start() + image.length() - ecol + 1;
            }
            tokens.recordToken(image, bline, bcol, lineNo, ecol);
        }
    }

    private boolean isComment(String tok) {
        return !this.commentStart.isEmpty() && tok.startsWith(this.commentStart);
    }
}

