/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.internal.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class FileUtil {
    private FileUtil() {
    }

    public static String getFileNameWithoutExtension(String fileName) {
        String name = fileName;
        int index = fileName.lastIndexOf(46);
        if (index != -1) {
            name = fileName.substring(0, index);
        }
        return name;
    }

    public static String normalizeFilename(String fileName) {
        if (fileName != null && File.separatorChar == '\\') {
            return fileName.toLowerCase(Locale.ROOT);
        }
        return fileName;
    }

    public static @NonNull Path toExistingPath(String root) throws FileNotFoundException {
        Path file = Paths.get(root, new String[0]);
        if (!Files.exists(file, new LinkOption[0])) {
            throw new FileNotFoundException(root);
        }
        return file;
    }

    public static boolean findPatternInFile(File file, String pattern) {
        Pattern regexp = Pattern.compile(pattern);
        Matcher matcher = regexp.matcher("");
        try {
            for (String line : Files.readAllLines(file.toPath(), StandardCharsets.UTF_8)) {
                matcher.reset(line);
                if (!matcher.find()) continue;
                return true;
            }
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public static List<Path> readFilelistEntries(Path filelist) throws IOException {
        return Files.readAllLines(filelist).stream().flatMap(it -> Arrays.stream(it.split(","))).map(String::trim).filter(StringUtils::isNotBlank).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
    }
}

