/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.impl.javacc;

import java.io.EOFException;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccTokenDocument;
import net.sourceforge.pmd.lang.ast.impl.javacc.MalformedSourceException;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextRegion;

public final class CharStream {
    private final JavaccTokenDocument tokenDoc;
    private final TextDocument textDoc;
    private final Chars chars;
    private final boolean useMarkSuffix;
    private int curOffset;
    private int markOffset;

    private CharStream(JavaccTokenDocument tokenDoc) {
        this.tokenDoc = tokenDoc;
        this.textDoc = tokenDoc.getTextDocument();
        this.chars = this.textDoc.getText();
        this.useMarkSuffix = tokenDoc.useMarkSuffix();
    }

    public static CharStream create(TextDocument doc, JavaccTokenDocument.TokenDocumentBehavior behavior) throws MalformedSourceException {
        TextDocument translated = behavior.translate(doc);
        return new CharStream(new JavaccTokenDocument(translated, behavior));
    }

    public static CharStream create(TextDocument doc) throws MalformedSourceException {
        return CharStream.create(doc, JavaccTokenDocument.TokenDocumentBehavior.DEFAULT);
    }

    public char readChar() throws EOFException {
        if (this.curOffset == this.chars.length()) {
            throw new EOFException();
        }
        return this.chars.charAt(this.curOffset++);
    }

    public char markTokenStart() throws EOFException {
        this.markOffset = this.curOffset;
        return this.readChar();
    }

    public String getTokenImage() {
        return this.getTokenImageCs().toString();
    }

    public Chars getTokenImageCs() {
        assert (this.markOffset >= 0);
        return this.chars.slice(this.markOffset, this.markLen());
    }

    private int markLen() {
        return this.curOffset - this.markOffset;
    }

    public void appendSuffix(StringBuilder sb, int len) {
        if (this.useMarkSuffix) {
            assert (len <= this.markLen()) : "Suffix is greater than the mark length? " + len + " > " + this.markLen();
            this.chars.appendChars(sb, this.curOffset - len, len);
        }
    }

    public void backup(int amount) {
        if (amount > this.markLen()) {
            throw new IllegalArgumentException();
        }
        this.curOffset -= amount;
    }

    public int getEndColumn() {
        return this.endLocation().getEndColumn();
    }

    public int getEndLine() {
        return this.endLocation().getEndLine();
    }

    private FileLocation endLocation() {
        return this.textDoc.toLocation(TextRegion.caretAt(this.getEndOffset()));
    }

    public int getStartOffset() {
        return this.markOffset;
    }

    public int getEndOffset() {
        return this.curOffset;
    }

    public JavaccTokenDocument getTokenDocument() {
        return this.tokenDoc;
    }
}

