/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.ReadOnlyFileException;
import net.sourceforge.pmd.lang.document.TextFileBuilder;
import net.sourceforge.pmd.lang.document.TextFileContent;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface TextFile
extends Closeable {
    public @NonNull LanguageVersion getLanguageVersion();

    public FileId getFileId();

    default public boolean isReadOnly() {
        return true;
    }

    default public void writeContents(TextFileContent content) throws IOException {
        throw new ReadOnlyFileException(this);
    }

    public TextFileContent readContents() throws IOException;

    @Override
    public void close() throws IOException;

    public boolean equals(Object var1);

    public static TextFile forPath(Path path, Charset charset, LanguageVersion languageVersion) {
        return TextFile.builderForPath(path, charset, languageVersion).build();
    }

    public static TextFileBuilder builderForPath(Path path, Charset charset, LanguageVersion languageVersion) {
        return new TextFileBuilder.ForNio(languageVersion, path, charset);
    }

    public static TextFile forCharSeq(CharSequence charseq, FileId fileId, LanguageVersion languageVersion) {
        return TextFile.builderForCharSeq(charseq, fileId, languageVersion).build();
    }

    public static TextFileBuilder builderForCharSeq(CharSequence charseq, FileId fileId, LanguageVersion languageVersion) {
        return new TextFileBuilder.ForCharSeq(charseq, fileId, languageVersion);
    }

    public static TextFile forReader(Reader reader, FileId fileId, LanguageVersion languageVersion) {
        return TextFile.builderForReader(reader, fileId, languageVersion).build();
    }

    public static TextFileBuilder builderForReader(Reader reader, FileId fileId, LanguageVersion languageVersion) {
        return new TextFileBuilder.ForReader(languageVersion, reader, fileId);
    }
}

