/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.renderers.AbstractIncrementingRenderer;
import net.sourceforge.pmd.renderers.CSVWriter;
import net.sourceforge.pmd.renderers.ColumnDescriptor;
import net.sourceforge.pmd.reporting.RuleViolation;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CSVRenderer
extends AbstractIncrementingRenderer {
    private final String separator;
    private final String cr;
    private CSVWriter<RuleViolation> csvWriter;
    private static final String DEFAULT_SEPARATOR = ",";
    private static final Map<String, PropertyDescriptor<Boolean>> PROPERTY_DESCRIPTORS_BY_ID = new HashMap<String, PropertyDescriptor<Boolean>>();
    public static final String NAME = "csv";
    private final ColumnDescriptor<RuleViolation>[] allColumns = new ColumnDescriptor[]{CSVRenderer.newColDescriptor("problem", "Problem", (idx, rv, cr) -> Integer.toString(idx)), CSVRenderer.newColDescriptor("package", "Package", (idx, rv, cr) -> rv.getAdditionalInfo().getOrDefault("packageName", "")), CSVRenderer.newColDescriptor("file", "File", (idx, rv, cr) -> this.determineFileName(rv.getFileId())), CSVRenderer.newColDescriptor("priority", "Priority", (idx, rv, cr) -> Integer.toString(rv.getRule().getPriority().getPriority())), CSVRenderer.newColDescriptor("line", "Line", (idx, rv, cr) -> Integer.toString(rv.getBeginLine())), CSVRenderer.newColDescriptor("desc", "Description", (idx, rv, cr) -> StringUtils.replaceChars((String)rv.getDescription(), (char)'\"', (char)'\'')), CSVRenderer.newColDescriptor("ruleSet", "Rule set", (idx, rv, cr) -> rv.getRule().getRuleSetName()), CSVRenderer.newColDescriptor("rule", "Rule", (idx, rv, cr) -> rv.getRule().getName())};

    private static @NonNull ColumnDescriptor<RuleViolation> newColDescriptor(String id, String title, ColumnDescriptor.Accessor<RuleViolation> accessor) {
        return new ColumnDescriptor<RuleViolation>(id, title, accessor);
    }

    public CSVRenderer(ColumnDescriptor<RuleViolation>[] columns, String theSeparator, String theCR) {
        super(NAME, "Comma-separated values tabular format.");
        this.separator = theSeparator;
        this.cr = theCR;
        for (ColumnDescriptor<RuleViolation> desc : columns) {
            this.definePropertyDescriptor(CSVRenderer.booleanPropertyFor(desc.id, desc.title));
        }
    }

    public CSVRenderer() {
        super(NAME, "Comma-separated values tabular format.");
        this.separator = DEFAULT_SEPARATOR;
        this.cr = System.lineSeparator();
        for (ColumnDescriptor<RuleViolation> desc : this.allColumns) {
            this.definePropertyDescriptor(CSVRenderer.booleanPropertyFor(desc.id, desc.title));
        }
    }

    private static PropertyDescriptor<Boolean> booleanPropertyFor(String id, String label) {
        PropertyDescriptor prop = PROPERTY_DESCRIPTORS_BY_ID.get(id);
        if (prop != null) {
            return prop;
        }
        prop = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty(id).defaultValue(true)).desc("Include " + label + " column")).build();
        PROPERTY_DESCRIPTORS_BY_ID.put(id, prop);
        return prop;
    }

    private List<ColumnDescriptor<RuleViolation>> activeColumns() {
        ArrayList<ColumnDescriptor<RuleViolation>> actives = new ArrayList<ColumnDescriptor<RuleViolation>>();
        for (ColumnDescriptor<RuleViolation> desc : this.allColumns) {
            PropertyDescriptor<Boolean> prop = CSVRenderer.booleanPropertyFor(desc.id, null);
            if (!this.getProperty(prop).booleanValue()) continue;
            actives.add(desc);
        }
        return actives;
    }

    private CSVWriter<RuleViolation> csvWriter() {
        if (this.csvWriter != null) {
            return this.csvWriter;
        }
        this.csvWriter = new CSVWriter(this.activeColumns(), this.separator, this.cr);
        return this.csvWriter;
    }

    @Override
    public void start() throws IOException {
        this.csvWriter().writeTitles(this.getWriter());
    }

    @Override
    public String defaultFileExtension() {
        return NAME;
    }

    @Override
    public void renderFileViolations(Iterator<RuleViolation> violations) throws IOException {
        this.csvWriter().writeData(this.getWriter(), violations);
    }

    @Override
    public String dysfunctionReason() {
        return this.activeColumns().isEmpty() ? "No columns selected" : null;
    }
}

