/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.reporting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.pmd.internal.util.IOUtil;
import net.sourceforge.pmd.reporting.NoopFileListener;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;
import net.sourceforge.pmd.util.AssertionUtil;

public interface FileAnalysisListener
extends AutoCloseable {
    public void onRuleViolation(RuleViolation var1);

    default public void onSuppressedRuleViolation(Report.SuppressedViolation violation) {
    }

    default public void onError(Report.ProcessingError error) {
    }

    @Override
    default public void close() throws Exception {
    }

    public static FileAnalysisListener noop() {
        return NoopFileListener.INSTANCE;
    }

    public static FileAnalysisListener tee(Collection<? extends FileAnalysisListener> listeners) {
        AssertionUtil.requireParamNotNull("Listeners", listeners);
        AssertionUtil.requireNotEmpty("Listeners", listeners);
        AssertionUtil.requireContainsNoNullValue("Listeners", listeners);
        ArrayList<? extends FileAnalysisListener> list = new ArrayList<FileAnalysisListener>(listeners);
        list.removeIf(it -> it == NoopFileListener.INSTANCE);
        if (list.isEmpty()) {
            return FileAnalysisListener.noop();
        }
        if (list.size() == 1) {
            return (FileAnalysisListener)list.iterator().next();
        }
        class TeeListener
        implements FileAnalysisListener {
            final /* synthetic */ List val$list;

            TeeListener(List list) {
                this.val$list = list;
            }

            @Override
            public void onRuleViolation(RuleViolation violation) {
                for (FileAnalysisListener it : this.val$list) {
                    it.onRuleViolation(violation);
                }
            }

            @Override
            public void onSuppressedRuleViolation(Report.SuppressedViolation violation) {
                for (FileAnalysisListener it : this.val$list) {
                    it.onSuppressedRuleViolation(violation);
                }
            }

            @Override
            public void onError(Report.ProcessingError error) {
                for (FileAnalysisListener it : this.val$list) {
                    it.onError(error);
                }
            }

            @Override
            public void close() throws Exception {
                Exception composed = IOUtil.closeAll(this.val$list);
                if (composed != null) {
                    throw composed;
                }
            }

            public String toString() {
                return "Tee" + this.val$list;
            }
        }
        return new TeeListener(list);
    }
}

