/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.reporting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.pmd.internal.util.IOUtil;
import net.sourceforge.pmd.reporting.FileNameRenderer;
import net.sourceforge.pmd.reporting.NoopListenerInitializer;
import net.sourceforge.pmd.util.AssertionUtil;

public interface ListenerInitializer
extends AutoCloseable {
    default public void setNumberOfFilesToAnalyze(int totalFiles) {
    }

    default public void setFileNameRenderer(FileNameRenderer fileNameRenderer) {
    }

    @Override
    default public void close() throws Exception {
    }

    public static ListenerInitializer noop() {
        return NoopListenerInitializer.INSTANCE;
    }

    public static ListenerInitializer tee(Collection<? extends ListenerInitializer> listeners) {
        AssertionUtil.requireParamNotNull("Listeners", listeners);
        AssertionUtil.requireNotEmpty("Listeners", listeners);
        AssertionUtil.requireContainsNoNullValue("Listeners", listeners);
        ArrayList<? extends ListenerInitializer> list = new ArrayList<ListenerInitializer>(listeners);
        list.removeIf(it -> it == NoopListenerInitializer.INSTANCE);
        if (list.isEmpty()) {
            return ListenerInitializer.noop();
        }
        if (list.size() == 1) {
            return (ListenerInitializer)list.iterator().next();
        }
        class TeeListener
        implements ListenerInitializer {
            final /* synthetic */ List val$list;

            TeeListener(List list) {
                this.val$list = list;
            }

            @Override
            public void setNumberOfFilesToAnalyze(int totalFiles) {
                for (ListenerInitializer initializer : this.val$list) {
                    initializer.setNumberOfFilesToAnalyze(totalFiles);
                }
            }

            @Override
            public void setFileNameRenderer(FileNameRenderer fileNameRenderer) {
                for (ListenerInitializer initializer : this.val$list) {
                    initializer.setFileNameRenderer(fileNameRenderer);
                }
            }

            @Override
            public void close() throws Exception {
                Exception composed = IOUtil.closeAll(this.val$list);
                if (composed != null) {
                    throw composed;
                }
            }

            public String toString() {
                return "Tee" + this.val$list;
            }
        }
        return new TeeListener(list);
    }
}

