/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.util.concurrent.locks.LockSupport;
import org.agrona.concurrent.BackoffIdleStrategyData;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.hints.ThreadHints;

public final class BackoffIdleStrategy
extends BackoffIdleStrategyData
implements IdleStrategy {
    long pad01;
    long pad02;
    long pad03;
    long pad04;
    long pad05;
    long pad06;
    long pad07;

    public BackoffIdleStrategy(long maxSpins, long maxYields, long minParkPeriodNs, long maxParkPeriodNs) {
        super(maxSpins, maxYields, minParkPeriodNs, maxParkPeriodNs);
        this.state = BackoffIdleStrategyData.State.NOT_IDLE;
    }

    @Override
    public void idle(int workCount) {
        if (workCount > 0) {
            this.reset();
        } else {
            this.idle();
        }
    }

    @Override
    public void idle() {
        switch (this.state) {
            case NOT_IDLE: {
                this.state = BackoffIdleStrategyData.State.SPINNING;
                ++this.spins;
                break;
            }
            case SPINNING: {
                ThreadHints.onSpinWait();
                if (++this.spins <= this.maxSpins) break;
                this.state = BackoffIdleStrategyData.State.YIELDING;
                this.yields = 0L;
                break;
            }
            case YIELDING: {
                if (++this.yields > this.maxYields) {
                    this.state = BackoffIdleStrategyData.State.PARKING;
                    this.parkPeriodNs = this.minParkPeriodNs;
                    break;
                }
                Thread.yield();
                break;
            }
            case PARKING: {
                LockSupport.parkNanos(this.parkPeriodNs);
                this.parkPeriodNs = Math.min(this.parkPeriodNs << 1, this.maxParkPeriodNs);
            }
        }
    }

    @Override
    public void reset() {
        this.spins = 0L;
        this.yields = 0L;
        this.state = BackoffIdleStrategyData.State.NOT_IDLE;
    }
}

