/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.nio;

import java.nio.channels.SelectionKey;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.ToIntFunction;
import org.agrona.BitUtil;

public class NioSelectedKeySet
extends AbstractSet<SelectionKey> {
    private static final int INITIAL_CAPACITY = 16;
    private SelectionKey[] keys;
    private int size = 0;

    public NioSelectedKeySet() {
        this(16);
    }

    public NioSelectedKeySet(int initialCapacity) {
        this.keys = new SelectionKey[BitUtil.findNextPositivePowerOfTwo(initialCapacity)];
    }

    @Override
    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.keys.length;
    }

    @Override
    public boolean add(SelectionKey selectionKey) {
        if (null == selectionKey) {
            return false;
        }
        this.ensureCapacity(this.size + 1);
        this.keys[this.size++] = selectionKey;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return false;
    }

    public SelectionKey[] keys() {
        return this.keys;
    }

    public void reset() {
        this.size = 0;
    }

    public int forEach(ToIntFunction<SelectionKey> function) {
        int handledFrames = 0;
        SelectionKey[] keys = this.keys;
        for (int i = this.size - 1; i >= 0; --i) {
            handledFrames += function.applyAsInt(keys[i]);
        }
        this.size = 0;
        return handledFrames;
    }

    @Override
    public Iterator<SelectionKey> iterator() {
        throw new UnsupportedOperationException();
    }

    private void ensureCapacity(int requiredCapacity) {
        if (requiredCapacity < 0) {
            String s = String.format("Insufficient capacity: length=%d required=%d", this.keys.length, requiredCapacity);
            throw new IllegalStateException(s);
        }
        if (requiredCapacity > this.keys.length) {
            int newCapacity = BitUtil.findNextPositivePowerOfTwo(requiredCapacity);
            this.keys = Arrays.copyOf(this.keys, newCapacity);
        }
    }
}

