package org.apache.camel.impl.converter;

import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.TypeConverterSupport;

@SuppressWarnings("unchecked")
public class CoreStaticTypeConverterLoader implements TypeConverterLoader {

    static abstract class SimpleTypeConverter extends TypeConverterSupport {
        private final boolean allowNull;

        public SimpleTypeConverter(boolean allowNull) {
            this.allowNull = allowNull;
        }

        @Override
        public boolean allowNull() {
            return allowNull;
        }

        @Override
        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
            try {
                return (T) doConvert(exchange, value);
            } catch (TypeConversionException e) {
                throw e;
            } catch (Exception e) {
                throw new TypeConversionException(value, type, e);
            }
        }
        protected abstract Object doConvert(Exchange exchange, Object value) throws Exception;
    };

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        registry.addTypeConverter(boolean.class, java.lang.Object.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.ObjectConverter.toBool(value);
            }
        });
        registry.addTypeConverter(byte[].class, java.io.BufferedReader.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toByteArray((java.io.BufferedReader) value, exchange);
            }
        });
        registry.addTypeConverter(byte[].class, java.io.ByteArrayOutputStream.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toByteArray((java.io.ByteArrayOutputStream) value);
            }
        });
        registry.addTypeConverter(byte[].class, java.io.File.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toByteArray((java.io.File) value);
            }
        });
        registry.addTypeConverter(byte[].class, java.io.InputStream.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toBytes((java.io.InputStream) value);
            }
        });
        registry.addTypeConverter(byte[].class, java.io.Reader.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toByteArray((java.io.Reader) value, exchange);
            }
        });
        registry.addTypeConverter(byte[].class, java.lang.String.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toByteArray((java.lang.String) value, exchange);
            }
        });
        registry.addTypeConverter(byte[].class, java.nio.ByteBuffer.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.NIOConverter.toByteArray((java.nio.ByteBuffer) value);
            }
        });
        registry.addTypeConverter(byte[].class, javax.xml.transform.Source.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toByteArray((javax.xml.transform.Source) value, exchange);
            }
        });
        registry.addTypeConverter(byte[].class, org.apache.camel.StreamCache.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.stream.StreamCacheConverter.convertToByteArray((org.apache.camel.StreamCache) value, exchange);
            }
        });
        registry.addTypeConverter(byte[].class, org.w3c.dom.NodeList.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getDomConverter().toByteArray((org.w3c.dom.NodeList) value, exchange);
            }
        });
        registry.addTypeConverter(char.class, java.lang.String.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.ObjectConverter.toChar((java.lang.String) value);
            }
        });
        registry.addTypeConverter(char[].class, java.lang.String.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.ObjectConverter.toCharArray((java.lang.String) value);
            }
        });
        registry.addTypeConverter(java.io.BufferedReader.class, java.io.File.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toReader((java.io.File) value, exchange);
            }
        });
        registry.addTypeConverter(java.io.BufferedWriter.class, java.io.File.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toWriter((java.io.File) value, exchange);
            }
        });
        registry.addTypeConverter(java.io.File.class, java.lang.String.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toFile((java.lang.String) value);
            }
        });
        registry.addTypeConverter(java.io.InputStream.class, byte[].class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toInputStream((byte[]) value);
            }
        });
        registry.addTypeConverter(java.io.InputStream.class, java.io.BufferedReader.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toInputStream((java.io.BufferedReader) value, exchange);
            }
        });
        registry.addTypeConverter(java.io.InputStream.class, java.io.ByteArrayOutputStream.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toInputStream((java.io.ByteArrayOutputStream) value);
            }
        });
        registry.addTypeConverter(java.io.InputStream.class, java.io.File.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toInputStream((java.io.File) value);
            }
        });
        registry.addTypeConverter(java.io.InputStream.class, java.lang.String.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toInputStream((java.lang.String) value, exchange);
            }
        });
        registry.addTypeConverter(java.io.InputStream.class, java.lang.StringBuffer.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toInputStream((java.lang.StringBuffer) value, exchange);
            }
        });
        registry.addTypeConverter(java.io.InputStream.class, java.lang.StringBuilder.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toInputStream((java.lang.StringBuilder) value, exchange);
            }
        });
        registry.addTypeConverter(java.io.InputStream.class, java.net.URL.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toInputStream((java.net.URL) value);
            }
        });
        registry.addTypeConverter(java.io.InputStream.class, java.nio.ByteBuffer.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.NIOConverter.toInputStream((java.nio.ByteBuffer) value);
            }
        });
        registry.addTypeConverter(java.io.InputStream.class, javax.xml.stream.XMLStreamReader.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getStaxConverter().createInputStream((javax.xml.stream.XMLStreamReader) value, exchange);
            }
        });
        registry.addTypeConverter(java.io.InputStream.class, javax.xml.transform.dom.DOMSource.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toInputStream((javax.xml.transform.dom.DOMSource) value, exchange);
            }
        });
        registry.addTypeConverter(java.io.InputStream.class, javax.xml.transform.stream.StreamSource.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.jaxp.StreamSourceConverter.toInputStream((javax.xml.transform.stream.StreamSource) value);
            }
        });
        registry.addTypeConverter(java.io.InputStream.class, org.apache.camel.component.file.GenericFile.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.component.file.GenericFileConverter.genericFileToInputStream((org.apache.camel.component.file.GenericFile) value, exchange);
            }
        });
        registry.addTypeConverter(java.io.InputStream.class, org.w3c.dom.Document.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toInputStream((org.w3c.dom.Document) value, exchange);
            }
        });
        registry.addTypeConverter(java.io.InputStream.class, org.w3c.dom.NodeList.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getDomConverter().toInputStream((org.w3c.dom.NodeList) value, exchange);
            }
        });
        registry.addTypeConverter(java.io.ObjectInput.class, java.io.InputStream.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toObjectInput((java.io.InputStream) value, exchange);
            }
        });
        registry.addTypeConverter(java.io.ObjectOutput.class, java.io.OutputStream.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toObjectOutput((java.io.OutputStream) value);
            }
        });
        registry.addTypeConverter(java.io.OutputStream.class, java.io.File.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toOutputStream((java.io.File) value);
            }
        });
        registry.addTypeConverter(java.io.Reader.class, byte[].class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toReader((byte[]) value, exchange);
            }
        });
        registry.addTypeConverter(java.io.Reader.class, java.io.InputStream.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toReader((java.io.InputStream) value, exchange);
            }
        });
        registry.addTypeConverter(java.io.Reader.class, javax.xml.stream.XMLStreamReader.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getStaxConverter().createReader((javax.xml.stream.XMLStreamReader) value, exchange);
            }
        });
        registry.addTypeConverter(java.io.Reader.class, javax.xml.transform.stream.StreamSource.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.jaxp.StreamSourceConverter.toReader((javax.xml.transform.stream.StreamSource) value);
            }
        });
        registry.addTypeConverter(java.io.Reader.class, javax.xml.transform.Source.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toReaderFromSource((javax.xml.transform.Source) value, exchange);
            }
        });
        registry.addTypeConverter(java.io.Serializable.class, org.apache.camel.StreamCache.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.stream.StreamCacheConverter.convertToSerializable((org.apache.camel.StreamCache) value, exchange);
            }
        });
        registry.addTypeConverter(java.io.Serializable.class, org.apache.camel.component.file.GenericFile.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.component.file.GenericFileConverter.genericFileToSerializable((org.apache.camel.component.file.GenericFile) value, exchange);
            }
        });
        registry.addTypeConverter(java.io.StringReader.class, java.lang.String.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toReader((java.lang.String) value);
            }
        });
        registry.addTypeConverter(java.io.Writer.class, java.io.OutputStream.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toWriter((java.io.OutputStream) value, exchange);
            }
        });
        registry.addTypeConverter(java.lang.Boolean.class, java.lang.String.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.ObjectConverter.toBoolean((java.lang.String) value);
            }
        });
        registry.addTypeConverter(java.lang.Boolean.class, org.w3c.dom.NodeList.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toBoolean((org.w3c.dom.NodeList) value);
            }
        });
        registry.addTypeConverter(java.lang.Boolean.class, java.lang.Object.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.ObjectConverter.toBoolean(value);
            }
        });
        registry.addTypeConverter(java.lang.Byte.class, java.lang.Object.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.ObjectConverter.toByte(value);
            }
        });
        registry.addTypeConverter(java.lang.CharSequence.class, java.net.URI.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.impl.converter.UriTypeConverter.toCharSequence((java.net.URI) value);
            }
        });
        registry.addTypeConverter(java.lang.Character.class, java.lang.String.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.ObjectConverter.toCharacter((java.lang.String) value);
            }
        });
        registry.addTypeConverter(java.lang.Class.class, java.lang.Object.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.ObjectConverter.toClass(value, exchange);
            }
        });
        registry.addTypeConverter(java.lang.Double.class, java.lang.String.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.ObjectConverter.toDouble((java.lang.String) value);
            }
        });
        registry.addTypeConverter(java.lang.Double.class, java.lang.Object.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.ObjectConverter.toDouble(value);
            }
        });
        registry.addTypeConverter(java.lang.Float.class, java.lang.String.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.ObjectConverter.toFloat((java.lang.String) value);
            }
        });
        registry.addTypeConverter(java.lang.Float.class, java.lang.Object.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.ObjectConverter.toFloat(value);
            }
        });
        registry.addTypeConverter(java.lang.Integer.class, java.lang.String.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.ObjectConverter.toInteger((java.lang.String) value);
            }
        });
        registry.addTypeConverter(java.lang.Integer.class, org.w3c.dom.NodeList.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.jaxp.DomConverter.toInteger((org.w3c.dom.NodeList) value);
            }
        });
        registry.addTypeConverter(java.lang.Integer.class, java.lang.Object.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.ObjectConverter.toInteger(value);
            }
        });
        registry.addTypeConverter(java.lang.Iterable.class, java.lang.Object.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.ObjectConverter.iterable(value);
            }
        });
        registry.addTypeConverter(java.lang.Long.class, java.lang.String.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.ObjectConverter.toLong((java.lang.String) value);
            }
        });
        registry.addTypeConverter(java.lang.Long.class, java.sql.Timestamp.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.SQLConverter.toLong((java.sql.Timestamp) value);
            }
        });
        registry.addTypeConverter(java.lang.Long.class, java.util.Date.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.DateTimeConverter.toLong((java.util.Date) value);
            }
        });
        registry.addTypeConverter(java.lang.Long.class, org.w3c.dom.NodeList.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.jaxp.DomConverter.toLong((org.w3c.dom.NodeList) value);
            }
        });
        registry.addTypeConverter(java.lang.Long.class, java.lang.Object.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.ObjectConverter.toLong(value);
            }
        });
        registry.addTypeConverter(java.lang.Object[].class, java.util.Collection.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.CollectionConverter.toArray((java.util.Collection) value);
            }
        });
        registry.addTypeConverter(java.lang.Short.class, java.lang.Object.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.ObjectConverter.toShort(value);
            }
        });
        registry.addTypeConverter(java.lang.String.class, byte[].class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toString((byte[]) value, exchange);
            }
        });
        registry.addTypeConverter(java.lang.String.class, char[].class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.ObjectConverter.fromCharArray((char[]) value);
            }
        });
        registry.addTypeConverter(java.lang.String.class, java.io.BufferedReader.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toString((java.io.BufferedReader) value);
            }
        });
        registry.addTypeConverter(java.lang.String.class, java.io.ByteArrayOutputStream.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toString((java.io.ByteArrayOutputStream) value, exchange);
            }
        });
        registry.addTypeConverter(java.lang.String.class, java.io.File.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toString((java.io.File) value, exchange);
            }
        });
        registry.addTypeConverter(java.lang.String.class, java.io.InputStream.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toString((java.io.InputStream) value, exchange);
            }
        });
        registry.addTypeConverter(java.lang.String.class, java.io.Reader.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toString((java.io.Reader) value);
            }
        });
        registry.addTypeConverter(java.lang.String.class, java.lang.Boolean.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.ObjectConverter.toString((java.lang.Boolean) value);
            }
        });
        registry.addTypeConverter(java.lang.String.class, java.lang.Integer.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.ObjectConverter.toString((java.lang.Integer) value);
            }
        });
        registry.addTypeConverter(java.lang.String.class, java.lang.Long.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.ObjectConverter.toString((java.lang.Long) value);
            }
        });
        registry.addTypeConverter(java.lang.String.class, java.lang.StringBuffer.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.ObjectConverter.toString((java.lang.StringBuffer) value);
            }
        });
        registry.addTypeConverter(java.lang.String.class, java.lang.StringBuilder.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.ObjectConverter.toString((java.lang.StringBuilder) value);
            }
        });
        registry.addTypeConverter(java.lang.String.class, java.net.URL.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toString((java.net.URL) value, exchange);
            }
        });
        registry.addTypeConverter(java.lang.String.class, java.nio.ByteBuffer.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.NIOConverter.toString((java.nio.ByteBuffer) value, exchange);
            }
        });
        registry.addTypeConverter(java.lang.String.class, java.time.Duration.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.DurationConverter.toString((java.time.Duration) value);
            }
        });
        registry.addTypeConverter(java.lang.String.class, javax.xml.transform.Source.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toString((javax.xml.transform.Source) value, exchange);
            }
        });
        registry.addTypeConverter(java.lang.String.class, org.apache.camel.component.file.GenericFile.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.component.file.GenericFileConverter.genericFileToString((org.apache.camel.component.file.GenericFile) value, exchange);
            }
        });
        registry.addTypeConverter(java.lang.String.class, org.w3c.dom.Node.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toString((org.w3c.dom.Node) value, exchange);
            }
        });
        registry.addTypeConverter(java.lang.String.class, org.w3c.dom.NodeList.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getDomConverter().toString((org.w3c.dom.NodeList) value, exchange);
            }
        });
        registry.addTypeConverter(java.math.BigInteger.class, java.lang.Object.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.ObjectConverter.toBigInteger(value);
            }
        });
        registry.addTypeConverter(java.net.URI.class, java.lang.CharSequence.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.impl.converter.UriTypeConverter.toUri((java.lang.CharSequence) value);
            }
        });
        registry.addTypeConverter(java.nio.ByteBuffer.class, byte[].class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.NIOConverter.toByteBuffer((byte[]) value);
            }
        });
        registry.addTypeConverter(java.nio.ByteBuffer.class, java.io.File.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.NIOConverter.toByteBuffer((java.io.File) value);
            }
        });
        registry.addTypeConverter(java.nio.ByteBuffer.class, java.io.InputStream.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.covertToByteBuffer((java.io.InputStream) value);
            }
        });
        registry.addTypeConverter(java.nio.ByteBuffer.class, java.lang.Double.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.NIOConverter.toByteBuffer((java.lang.Double) value);
            }
        });
        registry.addTypeConverter(java.nio.ByteBuffer.class, java.lang.Float.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.NIOConverter.toByteBuffer((java.lang.Float) value);
            }
        });
        registry.addTypeConverter(java.nio.ByteBuffer.class, java.lang.Integer.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.NIOConverter.toByteBuffer((java.lang.Integer) value);
            }
        });
        registry.addTypeConverter(java.nio.ByteBuffer.class, java.lang.Long.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.NIOConverter.toByteBuffer((java.lang.Long) value);
            }
        });
        registry.addTypeConverter(java.nio.ByteBuffer.class, java.lang.Short.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.NIOConverter.toByteBuffer((java.lang.Short) value);
            }
        });
        registry.addTypeConverter(java.nio.ByteBuffer.class, java.lang.String.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.NIOConverter.toByteBuffer((java.lang.String) value, exchange);
            }
        });
        registry.addTypeConverter(java.nio.ByteBuffer.class, org.apache.camel.StreamCache.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.stream.StreamCacheConverter.convertToByteBuffer((org.apache.camel.StreamCache) value, exchange);
            }
        });
        registry.addTypeConverter(java.sql.Timestamp.class, java.lang.Long.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.SQLConverter.toTimestamp((java.lang.Long) value);
            }
        });
        registry.addTypeConverter(java.time.Duration.class, java.lang.String.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.DurationConverter.toDuration((java.lang.String) value);
            }
        });
        registry.addTypeConverter(java.util.ArrayList.class, java.util.Iterator.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.CollectionConverter.toArrayList((java.util.Iterator) value);
            }
        });
        registry.addTypeConverter(java.util.Date.class, java.lang.Long.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.DateTimeConverter.toDate((java.lang.Long) value);
            }
        });
        registry.addTypeConverter(java.util.HashMap.class, java.util.Map.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.CollectionConverter.toHashMap((java.util.Map) value);
            }
        });
        registry.addTypeConverter(java.util.Hashtable.class, java.util.Map.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.CollectionConverter.toHashtable((java.util.Map) value);
            }
        });
        registry.addTypeConverter(java.util.Iterator.class, java.lang.Object.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.ObjectConverter.iterator(value);
            }
        });
        registry.addTypeConverter(java.util.List.class, java.lang.Iterable.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.CollectionConverter.toList((java.lang.Iterable) value);
            }
        });
        registry.addTypeConverter(java.util.List.class, java.lang.Object[].class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.CollectionConverter.toList((java.lang.Object[]) value);
            }
        });
        registry.addTypeConverter(java.util.List.class, java.util.Collection.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.CollectionConverter.toList((java.util.Collection) value);
            }
        });
        registry.addTypeConverter(java.util.List.class, org.w3c.dom.NodeList.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.jaxp.DomConverter.toList((org.w3c.dom.NodeList) value);
            }
        });
        registry.addTypeConverter(java.util.Properties.class, java.io.File.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toProperties((java.io.File) value);
            }
        });
        registry.addTypeConverter(java.util.Properties.class, java.io.InputStream.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toProperties((java.io.InputStream) value);
            }
        });
        registry.addTypeConverter(java.util.Properties.class, java.io.Reader.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.IOConverter.toProperties((java.io.Reader) value);
            }
        });
        registry.addTypeConverter(java.util.Properties.class, java.util.Map.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.CollectionConverter.toProperties((java.util.Map) value);
            }
        });
        registry.addTypeConverter(java.util.Set.class, java.lang.Object[].class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.CollectionConverter.toSet((java.lang.Object[]) value);
            }
        });
        registry.addTypeConverter(java.util.Set.class, java.util.Collection.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.CollectionConverter.toSet((java.util.Collection) value);
            }
        });
        registry.addTypeConverter(java.util.Set.class, java.util.Map.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.CollectionConverter.toSet((java.util.Map) value);
            }
        });
        registry.addTypeConverter(java.util.TimeZone.class, java.lang.String.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.DateTimeConverter.toTimeZone((java.lang.String) value);
            }
        });
        registry.addTypeConverter(javax.activation.DataHandler.class, org.apache.camel.Attachment.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.AttachmentConverter.toDataHandler((org.apache.camel.Attachment) value);
            }
        });
        registry.addTypeConverter(javax.xml.stream.XMLEventReader.class, java.io.File.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getStaxConverter().createXMLEventReader((java.io.File) value, exchange);
            }
        });
        registry.addTypeConverter(javax.xml.stream.XMLEventReader.class, java.io.InputStream.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getStaxConverter().createXMLEventReader((java.io.InputStream) value, exchange);
            }
        });
        registry.addTypeConverter(javax.xml.stream.XMLEventReader.class, java.io.Reader.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getStaxConverter().createXMLEventReader((java.io.Reader) value);
            }
        });
        registry.addTypeConverter(javax.xml.stream.XMLEventReader.class, javax.xml.stream.XMLStreamReader.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getStaxConverter().createXMLEventReader((javax.xml.stream.XMLStreamReader) value);
            }
        });
        registry.addTypeConverter(javax.xml.stream.XMLEventReader.class, javax.xml.transform.Source.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getStaxConverter().createXMLEventReader((javax.xml.transform.Source) value);
            }
        });
        registry.addTypeConverter(javax.xml.stream.XMLEventWriter.class, java.io.OutputStream.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getStaxConverter().createXMLEventWriter((java.io.OutputStream) value, exchange);
            }
        });
        registry.addTypeConverter(javax.xml.stream.XMLEventWriter.class, java.io.Writer.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getStaxConverter().createXMLEventWriter((java.io.Writer) value);
            }
        });
        registry.addTypeConverter(javax.xml.stream.XMLEventWriter.class, javax.xml.transform.Result.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getStaxConverter().createXMLEventWriter((javax.xml.transform.Result) value);
            }
        });
        registry.addTypeConverter(javax.xml.stream.XMLStreamReader.class, java.io.File.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getStaxConverter().createXMLStreamReader((java.io.File) value, exchange);
            }
        });
        registry.addTypeConverter(javax.xml.stream.XMLStreamReader.class, java.io.InputStream.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getStaxConverter().createXMLStreamReader((java.io.InputStream) value, exchange);
            }
        });
        registry.addTypeConverter(javax.xml.stream.XMLStreamReader.class, java.io.Reader.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getStaxConverter().createXMLStreamReader((java.io.Reader) value);
            }
        });
        registry.addTypeConverter(javax.xml.stream.XMLStreamReader.class, java.lang.String.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getStaxConverter().createXMLStreamReader((java.lang.String) value);
            }
        });
        registry.addTypeConverter(javax.xml.stream.XMLStreamReader.class, javax.xml.transform.Source.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getStaxConverter().createXMLStreamReader((javax.xml.transform.Source) value);
            }
        });
        registry.addTypeConverter(javax.xml.stream.XMLStreamWriter.class, java.io.OutputStream.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getStaxConverter().createXMLStreamWriter((java.io.OutputStream) value, exchange);
            }
        });
        registry.addTypeConverter(javax.xml.stream.XMLStreamWriter.class, java.io.Writer.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getStaxConverter().createXMLStreamWriter((java.io.Writer) value);
            }
        });
        registry.addTypeConverter(javax.xml.stream.XMLStreamWriter.class, javax.xml.transform.Result.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getStaxConverter().createXMLStreamWriter((javax.xml.transform.Result) value);
            }
        });
        registry.addTypeConverter(javax.xml.transform.Source.class, java.lang.String.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toSource((java.lang.String) value);
            }
        });
        registry.addTypeConverter(javax.xml.transform.dom.DOMSource.class, byte[].class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toDOMSource((byte[]) value);
            }
        });
        registry.addTypeConverter(javax.xml.transform.dom.DOMSource.class, java.io.File.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toDOMSource((java.io.File) value, exchange);
            }
        });
        registry.addTypeConverter(javax.xml.transform.dom.DOMSource.class, java.io.InputStream.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toDOMSource((java.io.InputStream) value, exchange);
            }
        });
        registry.addTypeConverter(javax.xml.transform.dom.DOMSource.class, java.lang.String.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toDOMSource((java.lang.String) value);
            }
        });
        registry.addTypeConverter(javax.xml.transform.dom.DOMSource.class, javax.xml.transform.sax.SAXSource.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toDOMSourceFromSAX((javax.xml.transform.sax.SAXSource) value);
            }
        });
        registry.addTypeConverter(javax.xml.transform.dom.DOMSource.class, javax.xml.transform.stax.StAXSource.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toDOMSourceFromStAX((javax.xml.transform.stax.StAXSource) value);
            }
        });
        registry.addTypeConverter(javax.xml.transform.dom.DOMSource.class, javax.xml.transform.stream.StreamSource.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toDOMSourceFromStream((javax.xml.transform.stream.StreamSource) value, exchange);
            }
        });
        registry.addTypeConverter(javax.xml.transform.dom.DOMSource.class, javax.xml.transform.Source.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toDOMSource((javax.xml.transform.Source) value, exchange);
            }
        });
        registry.addTypeConverter(javax.xml.transform.dom.DOMSource.class, org.w3c.dom.Document.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toDOMSource((org.w3c.dom.Document) value);
            }
        });
        registry.addTypeConverter(javax.xml.transform.dom.DOMSource.class, org.w3c.dom.Node.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toDOMSource((org.w3c.dom.Node) value);
            }
        });
        registry.addTypeConverter(javax.xml.transform.sax.SAXSource.class, byte[].class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toSAXSource((byte[]) value, exchange);
            }
        });
        registry.addTypeConverter(javax.xml.transform.sax.SAXSource.class, java.io.File.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toSAXSource((java.io.File) value, exchange);
            }
        });
        registry.addTypeConverter(javax.xml.transform.sax.SAXSource.class, java.io.InputStream.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toSAXSource((java.io.InputStream) value, exchange);
            }
        });
        registry.addTypeConverter(javax.xml.transform.sax.SAXSource.class, java.lang.String.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toSAXSource((java.lang.String) value, exchange);
            }
        });
        registry.addTypeConverter(javax.xml.transform.sax.SAXSource.class, javax.xml.transform.dom.DOMSource.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toSAXSourceFromDOM((javax.xml.transform.dom.DOMSource) value, exchange);
            }
        });
        registry.addTypeConverter(javax.xml.transform.sax.SAXSource.class, javax.xml.transform.stax.StAXSource.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toSAXSourceFromStAX((javax.xml.transform.stax.StAXSource) value, exchange);
            }
        });
        registry.addTypeConverter(javax.xml.transform.sax.SAXSource.class, javax.xml.transform.stream.StreamSource.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toSAXSourceFromStream((javax.xml.transform.stream.StreamSource) value, exchange);
            }
        });
        registry.addTypeConverter(javax.xml.transform.sax.SAXSource.class, javax.xml.transform.Source.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toSAXSource((javax.xml.transform.Source) value, exchange);
            }
        });
        registry.addTypeConverter(javax.xml.transform.stax.StAXSource.class, byte[].class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toStAXSource((byte[]) value, exchange);
            }
        });
        registry.addTypeConverter(javax.xml.transform.stax.StAXSource.class, java.io.File.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toStAXSource((java.io.File) value, exchange);
            }
        });
        registry.addTypeConverter(javax.xml.transform.stax.StAXSource.class, java.io.InputStream.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toStAXSource((java.io.InputStream) value, exchange);
            }
        });
        registry.addTypeConverter(javax.xml.transform.stax.StAXSource.class, java.lang.String.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toStAXSource((java.lang.String) value, exchange);
            }
        });
        registry.addTypeConverter(javax.xml.transform.stream.StreamSource.class, byte[].class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toStreamSource((byte[]) value, exchange);
            }
        });
        registry.addTypeConverter(javax.xml.transform.stream.StreamSource.class, java.io.File.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toStreamSource((java.io.File) value);
            }
        });
        registry.addTypeConverter(javax.xml.transform.stream.StreamSource.class, java.io.InputStream.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toStreamSource((java.io.InputStream) value);
            }
        });
        registry.addTypeConverter(javax.xml.transform.stream.StreamSource.class, java.io.Reader.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toStreamSource((java.io.Reader) value);
            }
        });
        registry.addTypeConverter(javax.xml.transform.stream.StreamSource.class, java.nio.ByteBuffer.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toStreamSource((java.nio.ByteBuffer) value, exchange);
            }
        });
        registry.addTypeConverter(javax.xml.transform.stream.StreamSource.class, javax.xml.transform.dom.DOMSource.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toStreamSourceFromDOM((javax.xml.transform.dom.DOMSource) value, exchange);
            }
        });
        registry.addTypeConverter(javax.xml.transform.stream.StreamSource.class, javax.xml.transform.sax.SAXSource.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toStreamSourceFromSAX((javax.xml.transform.sax.SAXSource) value, exchange);
            }
        });
        registry.addTypeConverter(javax.xml.transform.stream.StreamSource.class, javax.xml.transform.stax.StAXSource.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toStreamSourceFromStAX((javax.xml.transform.stax.StAXSource) value, exchange);
            }
        });
        registry.addTypeConverter(javax.xml.transform.stream.StreamSource.class, javax.xml.transform.Source.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toStreamSource((javax.xml.transform.Source) value, exchange);
            }
        });
        registry.addTypeConverter(long.class, java.lang.String.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.TimePatternConverter.toMilliSeconds((java.lang.String) value);
            }
        });
        registry.addTypeConverter(long.class, java.time.Duration.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.DurationConverter.toMilliSeconds((java.time.Duration) value);
            }
        });
        registry.addTypeConverter(org.apache.camel.BytesSource.class, byte[].class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toBytesSource((byte[]) value);
            }
        });
        registry.addTypeConverter(org.apache.camel.Processor.class, org.apache.camel.Expression.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.CamelConverter.toProcessor((org.apache.camel.Expression) value);
            }
        });
        registry.addTypeConverter(org.apache.camel.Processor.class, org.apache.camel.Predicate.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.CamelConverter.toProcessor((org.apache.camel.Predicate) value);
            }
        });
        registry.addTypeConverter(org.apache.camel.StreamCache.class, java.io.ByteArrayInputStream.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.stream.StreamCacheConverter.convertToStreamCache((java.io.ByteArrayInputStream) value, exchange);
            }
        });
        registry.addTypeConverter(org.apache.camel.StreamCache.class, java.io.InputStream.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.stream.StreamCacheConverter.convertToStreamCache((java.io.InputStream) value, exchange);
            }
        });
        registry.addTypeConverter(org.apache.camel.StreamCache.class, java.io.Reader.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.stream.StreamCacheConverter.convertToStreamCache((java.io.Reader) value, exchange);
            }
        });
        registry.addTypeConverter(org.apache.camel.StreamCache.class, javax.xml.transform.sax.SAXSource.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.stream.StreamCacheConverter.convertToStreamCache((javax.xml.transform.sax.SAXSource) value, exchange);
            }
        });
        registry.addTypeConverter(org.apache.camel.StreamCache.class, org.apache.camel.BytesSource.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.stream.StreamCacheConverter.convertToStreamCache((org.apache.camel.BytesSource) value);
            }
        });
        registry.addTypeConverter(org.apache.camel.StreamCache.class, org.apache.camel.StringSource.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.stream.StreamCacheConverter.convertToStreamCache((org.apache.camel.StringSource) value);
            }
        });
        registry.addTypeConverter(org.apache.camel.StreamCache.class, javax.xml.transform.stream.StreamSource.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.stream.StreamCacheConverter.convertToStreamCache((javax.xml.transform.stream.StreamSource) value, exchange);
            }
        });
        registry.addTypeConverter(org.apache.camel.StreamCache.class, org.apache.camel.converter.stream.CachedOutputStream.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.converter.stream.StreamCacheConverter.convertToStreamCache((org.apache.camel.converter.stream.CachedOutputStream) value, exchange);
            }
        });
        registry.addTypeConverter(org.apache.camel.StringSource.class, java.lang.String.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toStringSource((java.lang.String) value);
            }
        });
        registry.addTypeConverter(org.w3c.dom.Document.class, byte[].class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toDOMDocument((byte[]) value, exchange);
            }
        });
        registry.addTypeConverter(org.w3c.dom.Document.class, java.io.File.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toDOMDocument((java.io.File) value, exchange);
            }
        });
        registry.addTypeConverter(org.w3c.dom.Document.class, java.io.InputStream.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toDOMDocument((java.io.InputStream) value, exchange);
            }
        });
        registry.addTypeConverter(org.w3c.dom.Document.class, java.io.Reader.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toDOMDocument((java.io.Reader) value, exchange);
            }
        });
        registry.addTypeConverter(org.w3c.dom.Document.class, java.lang.String.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toDOMDocument((java.lang.String) value, exchange);
            }
        });
        registry.addTypeConverter(org.w3c.dom.Document.class, javax.xml.transform.Source.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toDOMDocument((javax.xml.transform.Source) value);
            }
        });
        registry.addTypeConverter(org.w3c.dom.Document.class, org.w3c.dom.Node.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toDOMDocument((org.w3c.dom.Node) value);
            }
        });
        registry.addTypeConverter(org.w3c.dom.Document.class, org.w3c.dom.NodeList.class, new SimpleTypeConverter(true) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toDOMDocumentFromSingleNodeList((org.w3c.dom.NodeList) value);
            }
        });
        registry.addTypeConverter(org.w3c.dom.Document.class, org.xml.sax.InputSource.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toDOMDocument((org.xml.sax.InputSource) value, exchange);
            }
        });
        registry.addTypeConverter(org.w3c.dom.Element.class, javax.xml.transform.Source.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toDOMElement((javax.xml.transform.Source) value);
            }
        });
        registry.addTypeConverter(org.w3c.dom.Element.class, org.w3c.dom.Node.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toDOMElement((org.w3c.dom.Node) value);
            }
        });
        registry.addTypeConverter(org.w3c.dom.Node.class, javax.xml.transform.sax.SAXSource.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toDOMNodeFromSAX((javax.xml.transform.sax.SAXSource) value);
            }
        });
        registry.addTypeConverter(org.w3c.dom.Node.class, javax.xml.transform.stax.StAXSource.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toDOMNodeFromStAX((javax.xml.transform.stax.StAXSource) value);
            }
        });
        registry.addTypeConverter(org.w3c.dom.Node.class, javax.xml.transform.Source.class, new SimpleTypeConverter(true) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toDOMNode((javax.xml.transform.Source) value);
            }
        });
        registry.addTypeConverter(org.w3c.dom.Node.class, org.w3c.dom.NodeList.class, new SimpleTypeConverter(true) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toDOMNodeFromSingleNodeList((org.w3c.dom.NodeList) value);
            }
        });
        registry.addTypeConverter(org.xml.sax.InputSource.class, java.io.File.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toInputSource((java.io.File) value, exchange);
            }
        });
        registry.addTypeConverter(org.xml.sax.InputSource.class, java.io.InputStream.class, new SimpleTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return getXmlConverter().toInputSource((java.io.InputStream) value, exchange);
            }
        });
        registry.addFallbackTypeConverter(new TypeConverterSupport() {
            @Override
            public boolean allowNull() {
                return false;
            }
            @Override
            public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
                try {
                    return (T) org.apache.camel.component.bean.BeanConverter.convertTo(type, exchange, value, registry);
                } catch (TypeConversionException e) {
                    throw e;
                } catch (Exception e) {
                    throw new TypeConversionException(value, type, e);
                }
            }
        }, false);
        registry.addFallbackTypeConverter(new TypeConverterSupport() {
            @Override
            public boolean allowNull() {
                return false;
            }
            @Override
            public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
                try {
                    return (T) org.apache.camel.component.file.GenericFileConverter.convertTo(type, exchange, value, registry);
                } catch (TypeConversionException e) {
                    throw e;
                } catch (Exception e) {
                    throw new TypeConversionException(value, type, e);
                }
            }
        }, false);

    }

    private volatile org.apache.camel.converter.jaxp.XmlConverter xmlConverter;
    private org.apache.camel.converter.jaxp.XmlConverter getXmlConverter() {
        if (xmlConverter == null) {
            synchronized (this) {
                if (xmlConverter == null) {
                    xmlConverter = new org.apache.camel.converter.jaxp.XmlConverter();
                }
            }
        }
        return xmlConverter;
    }
    private volatile org.apache.camel.converter.jaxp.DomConverter domConverter;
    private org.apache.camel.converter.jaxp.DomConverter getDomConverter() {
        if (domConverter == null) {
            synchronized (this) {
                if (domConverter == null) {
                    domConverter = new org.apache.camel.converter.jaxp.DomConverter();
                }
            }
        }
        return domConverter;
    }
    private volatile org.apache.camel.converter.jaxp.StaxConverter staxConverter;
    private org.apache.camel.converter.jaxp.StaxConverter getStaxConverter() {
        if (staxConverter == null) {
            synchronized (this) {
                if (staxConverter == null) {
                    staxConverter = new org.apache.camel.converter.jaxp.StaxConverter();
                }
            }
        }
        return staxConverter;
    }
}
