/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.spi.ExpressionResultTypeAware;
import org.apache.camel.spi.Language;

public class SimpleBuilder
implements Predicate,
Expression,
ExpressionResultTypeAware {
    private String text;
    private Class<?> resultType;
    private Language simple;
    private volatile Expression expression;
    private volatile Predicate predicate;

    public SimpleBuilder(String text) {
        this.text = text;
    }

    public static SimpleBuilder simple(String text) {
        return new SimpleBuilder(text);
    }

    public static SimpleBuilder simple(String text, Class<?> resultType) {
        SimpleBuilder answer = SimpleBuilder.simple(text);
        answer.setResultType(resultType);
        return answer;
    }

    public static SimpleBuilder simpleF(String formatText, Object ... values) {
        return SimpleBuilder.simple(String.format(formatText, values));
    }

    public static SimpleBuilder simpleF(String formatText, Class<?> resultType, Object ... values) {
        return SimpleBuilder.simple(String.format(formatText, values), resultType);
    }

    public String getText() {
        return this.text;
    }

    public String getExpressionText() {
        return this.getText();
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public SimpleBuilder resultType(Class<?> resultType) {
        this.setResultType(resultType);
        return this;
    }

    public String toString() {
        return this.text;
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        if (this.expression == null) {
            if (this.simple == null) {
                this.init(exchange.getContext());
            }
            if (this.resultType != null) {
                Object[] properties = new Object[2];
                properties[0] = this.resultType;
                this.expression = this.simple.createExpression(this.text, properties);
            } else {
                this.expression = this.simple.createExpression(this.text);
            }
            this.expression.init(exchange.getContext());
        }
        return (T)this.expression.evaluate(exchange, type);
    }

    public boolean matches(Exchange exchange) {
        if (this.predicate == null) {
            if (this.simple == null) {
                this.init(exchange.getContext());
            }
            this.predicate = this.simple.createPredicate(this.text);
            this.predicate.init(exchange.getContext());
        }
        return this.predicate.matches(exchange);
    }

    public void init(CamelContext context) {
        this.simple = context.resolveLanguage("simple");
        this.text = context.resolvePropertyPlaceholders(this.text);
    }
}

