/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.SecurityDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="rest,security,configuration", title="Rest Security Requirements")
@XmlRootElement(name="securityRequirements")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RestSecuritiesRequirement {
    @XmlTransient
    RestDefinition rest;
    @XmlTransient
    Map<String, SecurityDefinition> itemsMap = new HashMap<String, SecurityDefinition>();
    @XmlElements(value={@XmlElement(name="securityRequirement", type=SecurityDefinition.class)})
    List<SecurityDefinition> securityRequirements = new ArrayList<SecurityDefinition>();

    public RestSecuritiesRequirement() {
    }

    public RestSecuritiesRequirement(RestDefinition rest) {
        this.rest = rest;
    }

    public RestDefinition securityRequirement(String key) {
        return this.securityRequirement(key, null);
    }

    public RestDefinition securityRequirement(String key, String scopes) {
        SecurityDefinition requirement = this.itemsMap.get(key);
        if (requirement == null) {
            requirement = new SecurityDefinition();
        }
        requirement.setKey(key);
        requirement.setScopes(scopes);
        this.itemsMap.put(key, requirement);
        this.securityRequirements = new ArrayList<SecurityDefinition>(this.itemsMap.values());
        return this.rest;
    }

    public Collection<SecurityDefinition> securityRequirements() {
        return new ArrayList<SecurityDefinition>(this.securityRequirements);
    }

    public List<SecurityDefinition> getSecurityRequirements() {
        return this.securityRequirements;
    }

    public void setSecurityRequirements(Collection<SecurityDefinition> securityRequirements) {
        this.itemsMap = securityRequirements.stream().collect(Collectors.toMap(SecurityDefinition::getKey, Function.identity(), (u, v) -> u));
        this.securityRequirements = new ArrayList<SecurityDefinition>(this.itemsMap.values());
    }
}

