/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ThrowExceptionDefinition;
import org.apache.camel.processor.ThrowExceptionProcessor;
import org.apache.camel.reifier.ProcessorReifier;

public class ThrowExceptionReifier
extends ProcessorReifier<ThrowExceptionDefinition> {
    public ThrowExceptionReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (ThrowExceptionDefinition)definition);
    }

    @Override
    public Processor createProcessor() {
        Class exceptionClass;
        Exception exception = ((ThrowExceptionDefinition)this.definition).getException();
        String ref = this.parseString(((ThrowExceptionDefinition)this.definition).getRef());
        if (exception == null && ref != null) {
            exception = this.lookup(ref, Exception.class);
        }
        if ((exceptionClass = ((ThrowExceptionDefinition)this.definition).getExceptionClass()) == null && ((ThrowExceptionDefinition)this.definition).getExceptionType() != null) {
            exceptionClass = this.parse(Class.class, ((ThrowExceptionDefinition)this.definition).getExceptionType());
        }
        if (exception == null && exceptionClass == null) {
            throw new IllegalArgumentException("exception/ref or exceptionClass/exceptionType must be configured on: " + this);
        }
        return new ThrowExceptionProcessor(exception, exceptionClass, this.parseString(((ThrowExceptionDefinition)this.definition).getMessage()));
    }
}

