/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.dsmlv2.response;

import org.apache.directory.api.dsmlv2.ParserUtils;
import org.apache.directory.api.dsmlv2.response.AbstractResponseDsml;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.ldap.model.message.SearchResultEntry;
import org.apache.directory.api.ldap.model.message.SearchResultEntryImpl;
import org.apache.directory.api.ldap.model.name.Dn;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.tree.DefaultElement;

public class SearchResultEntryDsml
extends AbstractResponseDsml<SearchResultEntry>
implements SearchResultEntry {
    private static final String SEARCH_RESULT_ENTRY_TAG = "searchResultEntry";
    private Attribute currentAttribute;

    public SearchResultEntryDsml(LdapApiService codec) {
        super(codec, new SearchResultEntryImpl());
    }

    public SearchResultEntryDsml(LdapApiService codec, SearchResultEntry ldapMessage) {
        super(codec, ldapMessage);
    }

    public Attribute getCurrentAttribute() {
        return this.currentAttribute;
    }

    public void addAttribute(String type) throws LdapException {
        this.currentAttribute = new DefaultAttribute(type);
        ((SearchResultEntry)this.getDecorated()).getEntry().put(new Attribute[]{this.currentAttribute});
    }

    public void addAttributeValue(Object value) throws LdapException {
        if (value instanceof String) {
            this.currentAttribute.add(new String[]{(String)value});
        } else {
            this.currentAttribute.add((byte[][])new byte[][]{(byte[])value});
        }
    }

    @Override
    public MessageTypeEnum getType() {
        return ((SearchResultEntry)this.getDecorated()).getType();
    }

    @Override
    public Element toDsml(Element root) {
        Object element = root != null ? root.addElement(SEARCH_RESULT_ENTRY_TAG) : new DefaultElement(SEARCH_RESULT_ENTRY_TAG);
        SearchResultEntry searchResultEntry = (SearchResultEntry)this.getDecorated();
        element.addAttribute("dn", searchResultEntry.getObjectName().getName());
        Entry entry = searchResultEntry.getEntry();
        for (Attribute attribute : entry) {
            Element attributeElement = element.addElement("attr");
            attributeElement.addAttribute("name", attribute.getUpId());
            for (Value value : attribute) {
                if (ParserUtils.needsBase64Encoding(value.getString())) {
                    Namespace xsdNamespace = new Namespace("xsd", "http://www.w3.org/2001/XMLSchema");
                    Namespace xsiNamespace = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                    Document doc = attributeElement.getDocument();
                    if (doc != null) {
                        Element docRoot = doc.getRootElement();
                        docRoot.add(xsdNamespace);
                        docRoot.add(xsiNamespace);
                    }
                    Element valueElement = attributeElement.addElement("value").addText(ParserUtils.base64Encode(value.getString()));
                    valueElement.addAttribute(new QName("type", xsiNamespace), "xsd:base64Binary");
                    continue;
                }
                attributeElement.addElement("value").addText(value.getString());
            }
        }
        return element;
    }

    public Dn getObjectName() {
        return ((SearchResultEntry)this.getDecorated()).getObjectName();
    }

    public void setObjectName(Dn objectName) {
        ((SearchResultEntry)this.getDecorated()).setObjectName(objectName);
    }

    public Entry getEntry() {
        return ((SearchResultEntry)this.getDecorated()).getEntry();
    }

    public void setEntry(Entry entry) {
        ((SearchResultEntry)this.getDecorated()).setEntry(entry);
    }
}

