/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.bind;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.ldap.model.message.BindRequestImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitBindRequest
extends GrammarAction<LdapMessageContainer<BindRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitBindRequest.class);

    public InitBindRequest() {
        super("Init BindRequest");
    }

    public void action(LdapMessageContainer<BindRequest> container) throws DecoderException {
        BindRequestImpl bindRequest = new BindRequestImpl();
        bindRequest.setMessageId(container.getMessageId());
        container.setMessage((BindRequest)bindRequest);
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err((I18n)I18n.ERR_05144_NULL_BIND_REQUEST, (Object[])new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
    }
}

