/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.Reference;
import org.apache.felix.scr.ScrInfo;
import org.apache.felix.scr.ScrService;
import org.apache.felix.scr.impl.ComponentRegistry;
import org.apache.felix.scr.impl.ScrShellCommand;
import org.apache.felix.scr.impl.config.ScrConfiguration;
import org.apache.felix.shell.Command;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ScrCommand
implements ScrInfo {
    private final BundleContext bundleContext;
    private final ScrService scrService;
    private final ScrConfiguration scrConfiguration;
    private ServiceRegistration reg;

    static ScrCommand register(BundleContext bundleContext, ScrService scrService, ScrConfiguration scrConfiguration) {
        ScrCommand cmd = new ScrCommand(bundleContext, scrService, scrConfiguration);
        try {
            String scrGogoCommandClassName = "org.apache.felix.scr.impl.ScrGogoCommand";
            Class<?> scrGogoCommandClass = scrService.getClass().getClassLoader().loadClass("org.apache.felix.scr.impl.ScrGogoCommand");
            Constructor<?> c = scrGogoCommandClass.getConstructor(ScrCommand.class);
            Object gogoCmd = c.newInstance(cmd);
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            props.put("osgi.command.scope", "scr");
            props.put("osgi.command.function", new String[]{"config", "disable", "enable", "info", "list"});
            props.put("service.description", "SCR Gogo Shell Support");
            props.put("service.vendor", "The Apache Software Foundation");
            bundleContext.registerService("org.apache.felix.scr.impl.ScrGogoCommand", gogoCmd, props);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("service.description", "SCR Legacy Shell Support");
            props.put("service.vendor", "The Apache Software Foundation");
            bundleContext.registerService(Command.class.getName(), (Object)new ScrShellCommand(cmd), props);
        }
        catch (Throwable th) {
            // empty catch block
        }
        return cmd;
    }

    private ScrCommand(BundleContext bundleContext, ScrService scrService, ScrConfiguration scrConfiguration) {
        this.bundleContext = bundleContext;
        this.scrService = scrService;
        this.scrConfiguration = scrConfiguration;
    }

    public void update(boolean infoAsService) {
        if (infoAsService) {
            if (this.reg == null) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put("service.description", "SCR Info service");
                props.put("service.vendor", "The Apache Software Foundation");
                this.reg = this.bundleContext.registerService(ScrInfo.class, (Object)this, props);
            }
        } else if (this.reg != null) {
            this.reg.unregister();
            this.reg = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void list(String bundleIdentifier, PrintWriter out) {
        Component[] components;
        if (bundleIdentifier != null) {
            Bundle bundle = null;
            try {
                long bundleId = Long.parseLong(bundleIdentifier);
                bundle = this.bundleContext.getBundle(bundleId);
            }
            catch (NumberFormatException nfe) {
                Bundle[] bundles = this.bundleContext.getBundles();
                for (int i = 0; i < bundles.length; ++i) {
                    if (!bundleIdentifier.equals(bundles[i].getSymbolicName())) continue;
                    bundle = bundles[i];
                    break;
                }
            }
            if (bundle == null) {
                throw new IllegalArgumentException("Missing bundle with ID " + bundleIdentifier);
            }
            if (!ComponentRegistry.isBundleActive(bundle)) {
                out.println("Bundle " + bundleIdentifier + " is not active");
                return;
            }
            components = this.scrService.getComponents(bundle);
            if (components == null) {
                out.println("Bundle " + bundleIdentifier + " declares no components");
                return;
            }
        } else {
            components = this.scrService.getComponents();
            if (components == null) {
                out.println("No components registered");
                return;
            }
        }
        Arrays.sort(components, new Comparator<Component>(){

            @Override
            public int compare(Component c1, Component c2) {
                return Long.signum(c1.getId() - c2.getId());
            }
        });
        out.println(" Id   State BundleId Name");
        Component[] arr$ = components;
        int len$ = arr$.length;
        int i$ = 0;
        while (true) {
            if (i$ >= len$) {
                out.flush();
                return;
            }
            Component component = arr$[i$];
            out.println(String.format("[%1$4d] [%2$s] [%3$4d] %4$s", component.getId(), this.toStateString(component.getState()), component.getBundle().getBundleId(), component.getName()));
            ++i$;
        }
    }

    public void info(String componentId, PrintWriter out) {
        Component[] components = this.getComponentFromArg(componentId);
        if (components == null) {
            return;
        }
        Arrays.sort(components, new Comparator<Component>(){

            @Override
            public int compare(Component c1, Component c2) {
                long bundleId2;
                long bundleId1 = c1.getBundle().getBundleId();
                int result = Long.signum(bundleId1 - (bundleId2 = c2.getBundle().getBundleId()));
                if (result == 0) {
                    result = Long.signum(c1.getId() - c2.getId());
                }
                return result;
            }
        });
        long bundleId = -1L;
        for (Component component : components) {
            Dictionary props;
            Reference[] refs;
            String[] services;
            if (components.length > 1) {
                if (component.getBundle().getBundleId() != bundleId) {
                    if (bundleId != -1L) {
                        out.println();
                        out.println();
                    }
                    bundleId = component.getBundle().getBundleId();
                    out.println(String.format("*** Bundle: %1$s (%2$d)", component.getBundle().getSymbolicName(), bundleId));
                }
                out.println();
            }
            out.print("ID: ");
            out.println(component.getId());
            out.print("Name: ");
            out.println(component.getName());
            out.print("Bundle: ");
            out.println(component.getBundle().getSymbolicName() + " (" + component.getBundle().getBundleId() + ")");
            out.print("State: ");
            out.println(this.toStateString(component.getState()));
            out.print("Default State: ");
            out.println(component.isDefaultEnabled() ? "enabled" : "disabled");
            out.print("Activation: ");
            out.println(component.isImmediate() ? "immediate" : "delayed");
            out.print("Configuration Policy: ");
            out.println(component.getConfigurationPolicy());
            out.print("Activate Method: ");
            out.print(component.getActivate());
            if (component.isActivateDeclared()) {
                out.print(" (declared in the descriptor)");
            }
            out.println();
            out.print("Deactivate Method: ");
            out.print(component.getDeactivate());
            if (component.isDeactivateDeclared()) {
                out.print(" (declared in the descriptor)");
            }
            out.println();
            out.print("Modified Method: ");
            if (component.getModified() != null) {
                out.print(component.getModified());
            } else {
                out.print("-");
            }
            out.println();
            out.print("Configuration Pid: ");
            out.print(component.getConfigurationPid());
            if (component.isConfigurationPidDeclared()) {
                out.print(" (declared in the descriptor)");
            }
            out.println();
            if (component.getFactory() != null) {
                out.print("Factory: ");
                out.println(component.getFactory());
            }
            if ((services = component.getServices()) != null) {
                out.print("Services: ");
                out.println(services[0]);
                for (int i = 1; i < services.length; ++i) {
                    out.print("          ");
                    out.println(services[i]);
                }
                out.print("Service Type: ");
                out.println(component.isServiceFactory() ? "service factory" : "service");
            }
            if ((refs = component.getReferences()) != null) {
                for (Reference ref : refs) {
                    out.print("Reference: ");
                    out.println(ref.getName());
                    out.print("    Satisfied: ");
                    out.println(ref.isSatisfied() ? "satisfied" : "unsatisfied");
                    out.print("    Service Name: ");
                    out.println(ref.getServiceName());
                    if (ref.getTarget() != null) {
                        out.print("    Target Filter: ");
                        out.println(ref.getTarget());
                    }
                    out.print("    Multiple: ");
                    out.println(ref.isMultiple() ? "multiple" : "single");
                    out.print("    Optional: ");
                    out.println(ref.isOptional() ? "optional" : "mandatory");
                    out.print("    Policy: ");
                    out.println(ref.isStatic() ? "static" : "dynamic");
                    out.print("    Policy option: ");
                    out.println(ref.isReluctant() ? "reluctant" : "greedy");
                    ServiceReference[] serviceRefs = ref.getServiceReferences();
                    if (serviceRefs != null) {
                        out.print("    Bound to:");
                        for (int k = 0; k < serviceRefs.length; ++k) {
                            out.print("        ");
                            out.println(serviceRefs[k]);
                        }
                        continue;
                    }
                    out.println("    (unbound)");
                }
            }
            if ((props = component.getProperties()) == null) continue;
            out.println("Properties:");
            TreeSet keys = new TreeSet(Collections.list(props.keys()));
            for (Object key : keys) {
                out.print("    ");
                out.print(key);
                out.print(" = ");
                Object prop = props.get(key);
                if (prop.getClass().isArray()) {
                    prop = Arrays.asList((Object[])prop);
                }
                out.print(prop);
                out.println();
            }
        }
        out.flush();
    }

    void change(String componentIdentifier, PrintWriter out, boolean enable) {
        Component[] components = this.getComponentFromArg(componentIdentifier);
        ArrayList<String> disposed = new ArrayList<String>();
        if (components == null) {
            return;
        }
        for (Component component : components) {
            if (component.getState() == 256) {
                disposed.add(component.getName());
                continue;
            }
            if (enable) {
                if (component.getState() == 1) {
                    component.enable();
                    out.println("Component " + component.getName() + " enabled");
                    continue;
                }
                out.println("Component " + component.getName() + " already enabled");
                continue;
            }
            if (component.getState() != 1) {
                component.disable();
                out.println("Component " + component.getName() + " disabled");
                continue;
            }
            out.println("Component " + component.getName() + " already disabled");
        }
        out.flush();
        if (!disposed.isEmpty()) {
            throw new IllegalArgumentException("Components " + disposed + " already disposed, cannot change state");
        }
    }

    public void config(PrintWriter out) {
        out.print("Log Level: ");
        out.println(this.scrConfiguration.getLogLevel());
        out.print("Component Factory with Factory Configuration: ");
        out.println(this.scrConfiguration.isFactoryEnabled() ? "Supported" : "Unsupported");
        out.print("Keep instances with no references: ");
        out.println(this.scrConfiguration.keepInstances() ? "Supported" : "Unsupported");
        out.print("Lock timeount milliseconds: ");
        out.println(this.scrConfiguration.lockTimeout());
        out.print("Info Service registered: ");
        out.println(this.scrConfiguration.infoAsService() ? "Supported" : "Unsupported");
    }

    private String toStateString(int state) {
        switch (state) {
            case 1: {
                return "disabled    ";
            }
            case 512: {
                return "enabling    ";
            }
            case 2: {
                return "enabled     ";
            }
            case 4: {
                return "unsatisfied ";
            }
            case 8: {
                return "activating  ";
            }
            case 16: {
                return "active      ";
            }
            case 32: {
                return "registered  ";
            }
            case 64: {
                return "factory     ";
            }
            case 128: {
                return "deactivating";
            }
            case 1024: {
                return "disabling   ";
            }
            case 2048: {
                return "disposing   ";
            }
            case 256: {
                return "disposed    ";
            }
        }
        return "unkown: " + state;
    }

    private Component[] getComponentFromArg(String componentIdentifier) {
        Component[] components = null;
        if (componentIdentifier != null) {
            try {
                long componentId = Long.parseLong(componentIdentifier);
                Component component = this.scrService.getComponent(componentId);
                if (component == null) {
                    throw new IllegalArgumentException("Missing Component with ID " + componentId);
                }
                return new Component[]{component};
            }
            catch (NumberFormatException nfe) {
                components = this.scrService.getComponents(componentIdentifier);
            }
        }
        if (components == null) {
            components = this.scrService.getComponents();
            if (componentIdentifier != null) {
                ArrayList<Component> cs = new ArrayList<Component>(components.length);
                Pattern p = Pattern.compile(componentIdentifier);
                for (Component component : components) {
                    if (!p.matcher(component.getName()).matches()) continue;
                    cs.add(component);
                }
                if (cs.isEmpty()) {
                    throw new IllegalArgumentException("No Component with ID or matching " + componentIdentifier);
                }
                components = cs.toArray(new Component[cs.size()]);
            }
        }
        return components;
    }
}

