/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.AbstractVersionEnforcer;
import org.codehaus.plexus.util.StringUtils;

public class RequireJavaVersion
extends AbstractVersionEnforcer {
    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        String javaVersion = SystemUtils.JAVA_VERSION;
        Log log = helper.getLog();
        log.debug((CharSequence)("Detected Java String: '" + javaVersion + "'"));
        javaVersion = RequireJavaVersion.normalizeJDKVersion(javaVersion);
        log.debug((CharSequence)("Normalized Java String: '" + javaVersion + "'"));
        DefaultArtifactVersion detectedJdkVersion = new DefaultArtifactVersion(javaVersion);
        log.debug((CharSequence)("Parsed Version: Major: " + detectedJdkVersion.getMajorVersion() + " Minor: " + detectedJdkVersion.getMinorVersion() + " Incremental: " + detectedJdkVersion.getIncrementalVersion() + " Build: " + detectedJdkVersion.getBuildNumber() + " Qualifier: " + detectedJdkVersion.getQualifier()));
        this.enforceVersion(helper.getLog(), "JDK", this.getVersion(), (ArtifactVersion)detectedJdkVersion);
    }

    public static String normalizeJDKVersion(String theJdkVersion) {
        theJdkVersion = theJdkVersion.replaceAll("_|-", ".");
        String[] tokenArray = StringUtils.split((String)theJdkVersion, (String)".");
        List<String> tokens = Arrays.asList(tokenArray);
        StringBuffer buffer = new StringBuffer(theJdkVersion.length());
        Iterator<String> iter = tokens.iterator();
        for (int i = 0; i < tokens.size() && i < 4; ++i) {
            String section = iter.next();
            if (!StringUtils.isNotEmpty((String)(section = section.replaceAll("[^0-9]", "")))) continue;
            buffer.append(Integer.parseInt(section));
            if (i != 2) {
                buffer.append('.');
                continue;
            }
            buffer.append('-');
        }
        String version = buffer.toString();
        version = StringUtils.stripEnd((String)version, (String)"-");
        return StringUtils.stripEnd((String)version, (String)".");
    }
}

